# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import meta as _meta

__all__ = [
    'AuditAnnotation',
    'AuditAnnotationPatch',
    'ExpressionWarning',
    'ExpressionWarningPatch',
    'MatchCondition',
    'MatchConditionPatch',
    'MatchResources',
    'MatchResourcesPatch',
    'MutatingWebhook',
    'MutatingWebhookConfiguration',
    'MutatingWebhookPatch',
    'NamedRuleWithOperations',
    'NamedRuleWithOperationsPatch',
    'ParamKind',
    'ParamKindPatch',
    'ParamRef',
    'ParamRefPatch',
    'RuleWithOperations',
    'RuleWithOperationsPatch',
    'ServiceReference',
    'ServiceReferencePatch',
    'TypeChecking',
    'TypeCheckingPatch',
    'ValidatingAdmissionPolicy',
    'ValidatingAdmissionPolicyBinding',
    'ValidatingAdmissionPolicyBindingSpec',
    'ValidatingAdmissionPolicyBindingSpecPatch',
    'ValidatingAdmissionPolicySpec',
    'ValidatingAdmissionPolicySpecPatch',
    'ValidatingAdmissionPolicyStatus',
    'ValidatingAdmissionPolicyStatusPatch',
    'ValidatingWebhook',
    'ValidatingWebhookConfiguration',
    'ValidatingWebhookPatch',
    'Validation',
    'ValidationPatch',
    'Variable',
    'VariablePatch',
    'WebhookClientConfig',
    'WebhookClientConfigPatch',
]

@pulumi.output_type
class AuditAnnotation(dict):
    """
    AuditAnnotation describes how to produce an audit annotation for an API request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueExpression":
            suggest = "value_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditAnnotation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditAnnotation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditAnnotation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 value_expression: str):
        """
        AuditAnnotation describes how to produce an audit annotation for an API request.
        :param str key: key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.
               
               The key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: "{ValidatingAdmissionPolicy name}/{key}".
               
               If an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.
               
               Required.
        :param str value_expression: valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.
               
               If multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.
               
               Required.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value_expression", value_expression)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.

        The key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: "{ValidatingAdmissionPolicy name}/{key}".

        If an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.

        Required.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="valueExpression")
    def value_expression(self) -> str:
        """
        valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.

        If multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.

        Required.
        """
        return pulumi.get(self, "value_expression")


@pulumi.output_type
class AuditAnnotationPatch(dict):
    """
    AuditAnnotation describes how to produce an audit annotation for an API request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueExpression":
            suggest = "value_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditAnnotationPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditAnnotationPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditAnnotationPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value_expression: Optional[str] = None):
        """
        AuditAnnotation describes how to produce an audit annotation for an API request.
        :param str key: key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.
               
               The key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: "{ValidatingAdmissionPolicy name}/{key}".
               
               If an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.
               
               Required.
        :param str value_expression: valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.
               
               If multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.
               
               Required.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value_expression is not None:
            pulumi.set(__self__, "value_expression", value_expression)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.

        The key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: "{ValidatingAdmissionPolicy name}/{key}".

        If an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.

        Required.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="valueExpression")
    def value_expression(self) -> Optional[str]:
        """
        valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.

        If multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.

        Required.
        """
        return pulumi.get(self, "value_expression")


@pulumi.output_type
class ExpressionWarning(dict):
    """
    ExpressionWarning is a warning information that targets a specific expression.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldRef":
            suggest = "field_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressionWarning. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressionWarning.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressionWarning.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_ref: str,
                 warning: str):
        """
        ExpressionWarning is a warning information that targets a specific expression.
        :param str field_ref: The path to the field that refers the expression. For example, the reference to the expression of the first item of validations is "spec.validations[0].expression"
        :param str warning: The content of type checking information in a human-readable form. Each line of the warning contains the type that the expression is checked against, followed by the type check error from the compiler.
        """
        pulumi.set(__self__, "field_ref", field_ref)
        pulumi.set(__self__, "warning", warning)

    @property
    @pulumi.getter(name="fieldRef")
    def field_ref(self) -> str:
        """
        The path to the field that refers the expression. For example, the reference to the expression of the first item of validations is "spec.validations[0].expression"
        """
        return pulumi.get(self, "field_ref")

    @property
    @pulumi.getter
    def warning(self) -> str:
        """
        The content of type checking information in a human-readable form. Each line of the warning contains the type that the expression is checked against, followed by the type check error from the compiler.
        """
        return pulumi.get(self, "warning")


@pulumi.output_type
class ExpressionWarningPatch(dict):
    """
    ExpressionWarning is a warning information that targets a specific expression.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldRef":
            suggest = "field_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressionWarningPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressionWarningPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressionWarningPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_ref: Optional[str] = None,
                 warning: Optional[str] = None):
        """
        ExpressionWarning is a warning information that targets a specific expression.
        :param str field_ref: The path to the field that refers the expression. For example, the reference to the expression of the first item of validations is "spec.validations[0].expression"
        :param str warning: The content of type checking information in a human-readable form. Each line of the warning contains the type that the expression is checked against, followed by the type check error from the compiler.
        """
        if field_ref is not None:
            pulumi.set(__self__, "field_ref", field_ref)
        if warning is not None:
            pulumi.set(__self__, "warning", warning)

    @property
    @pulumi.getter(name="fieldRef")
    def field_ref(self) -> Optional[str]:
        """
        The path to the field that refers the expression. For example, the reference to the expression of the first item of validations is "spec.validations[0].expression"
        """
        return pulumi.get(self, "field_ref")

    @property
    @pulumi.getter
    def warning(self) -> Optional[str]:
        """
        The content of type checking information in a human-readable form. Each line of the warning contains the type that the expression is checked against, followed by the type check error from the compiler.
        """
        return pulumi.get(self, "warning")


@pulumi.output_type
class MatchCondition(dict):
    """
    MatchCondition represents a condition which must be fulfilled for a request to be sent to a webhook.
    """
    def __init__(__self__, *,
                 expression: str,
                 name: str):
        """
        MatchCondition represents a condition which must be fulfilled for a request to be sent to a webhook.
        :param str expression: Expression represents the expression which will be evaluated by CEL. Must evaluate to bool. CEL expressions have access to the contents of the AdmissionRequest and Authorizer, organized into CEL variables:
               
               'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request(/pkg/apis/admission/types.go#AdmissionRequest). 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
                 See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
               'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
                 request resource.
               Documentation on CEL: https://kubernetes.io/docs/reference/using-api/cel/
               
               Required.
        :param str name: Name is an identifier for this match condition, used for strategic merging of MatchConditions, as well as providing an identifier for logging purposes. A good name should be descriptive of the associated expression. Name must be a qualified name consisting of alphanumeric characters, '-', '_' or '.', and must start and end with an alphanumeric character (e.g. 'MyName',  or 'my.name',  or '123-abc', regex used for validation is '([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]') with an optional DNS subdomain prefix and '/' (e.g. 'example.com/MyName')
               
               Required.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Expression represents the expression which will be evaluated by CEL. Must evaluate to bool. CEL expressions have access to the contents of the AdmissionRequest and Authorizer, organized into CEL variables:

        'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request(/pkg/apis/admission/types.go#AdmissionRequest). 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
          See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
        'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
          request resource.
        Documentation on CEL: https://kubernetes.io/docs/reference/using-api/cel/

        Required.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name is an identifier for this match condition, used for strategic merging of MatchConditions, as well as providing an identifier for logging purposes. A good name should be descriptive of the associated expression. Name must be a qualified name consisting of alphanumeric characters, '-', '_' or '.', and must start and end with an alphanumeric character (e.g. 'MyName',  or 'my.name',  or '123-abc', regex used for validation is '([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]') with an optional DNS subdomain prefix and '/' (e.g. 'example.com/MyName')

        Required.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class MatchConditionPatch(dict):
    """
    MatchCondition represents a condition which must be fulfilled for a request to be sent to a webhook.
    """
    def __init__(__self__, *,
                 expression: Optional[str] = None,
                 name: Optional[str] = None):
        """
        MatchCondition represents a condition which must be fulfilled for a request to be sent to a webhook.
        :param str expression: Expression represents the expression which will be evaluated by CEL. Must evaluate to bool. CEL expressions have access to the contents of the AdmissionRequest and Authorizer, organized into CEL variables:
               
               'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request(/pkg/apis/admission/types.go#AdmissionRequest). 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
                 See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
               'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
                 request resource.
               Documentation on CEL: https://kubernetes.io/docs/reference/using-api/cel/
               
               Required.
        :param str name: Name is an identifier for this match condition, used for strategic merging of MatchConditions, as well as providing an identifier for logging purposes. A good name should be descriptive of the associated expression. Name must be a qualified name consisting of alphanumeric characters, '-', '_' or '.', and must start and end with an alphanumeric character (e.g. 'MyName',  or 'my.name',  or '123-abc', regex used for validation is '([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]') with an optional DNS subdomain prefix and '/' (e.g. 'example.com/MyName')
               
               Required.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        Expression represents the expression which will be evaluated by CEL. Must evaluate to bool. CEL expressions have access to the contents of the AdmissionRequest and Authorizer, organized into CEL variables:

        'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request(/pkg/apis/admission/types.go#AdmissionRequest). 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
          See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
        'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
          request resource.
        Documentation on CEL: https://kubernetes.io/docs/reference/using-api/cel/

        Required.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name is an identifier for this match condition, used for strategic merging of MatchConditions, as well as providing an identifier for logging purposes. A good name should be descriptive of the associated expression. Name must be a qualified name consisting of alphanumeric characters, '-', '_' or '.', and must start and end with an alphanumeric character (e.g. 'MyName',  or 'my.name',  or '123-abc', regex used for validation is '([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]') with an optional DNS subdomain prefix and '/' (e.g. 'example.com/MyName')

        Required.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class MatchResources(dict):
    """
    MatchResources decides whether to run the admission control policy on an object based on whether it meets the match criteria. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeResourceRules":
            suggest = "exclude_resource_rules"
        elif key == "matchPolicy":
            suggest = "match_policy"
        elif key == "namespaceSelector":
            suggest = "namespace_selector"
        elif key == "objectSelector":
            suggest = "object_selector"
        elif key == "resourceRules":
            suggest = "resource_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MatchResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MatchResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MatchResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_resource_rules: Optional[Sequence['outputs.NamedRuleWithOperations']] = None,
                 match_policy: Optional[str] = None,
                 namespace_selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 object_selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 resource_rules: Optional[Sequence['outputs.NamedRuleWithOperations']] = None):
        """
        MatchResources decides whether to run the admission control policy on an object based on whether it meets the match criteria. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
        :param Sequence['NamedRuleWithOperationsArgs'] exclude_resource_rules: ExcludeResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
        :param str match_policy: matchPolicy defines how the "MatchResources" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".
               
               - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the ValidatingAdmissionPolicy.
               
               - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the ValidatingAdmissionPolicy.
               
               Defaults to "Equivalent"
        :param '_meta.v1.LabelSelectorArgs' namespace_selector: NamespaceSelector decides whether to run the admission control policy on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the policy.
               
               For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
                 "matchExpressions": [
                   {
                     "key": "runlevel",
                     "operator": "NotIn",
                     "values": [
                       "0",
                       "1"
                     ]
                   }
                 ]
               }
               
               If instead you want to only run the policy on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
                 "matchExpressions": [
                   {
                     "key": "environment",
                     "operator": "In",
                     "values": [
                       "prod",
                       "staging"
                     ]
                   }
                 ]
               }
               
               See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.
               
               Default to the empty LabelSelector, which matches everything.
        :param '_meta.v1.LabelSelectorArgs' object_selector: ObjectSelector decides whether to run the validation based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the cel validation, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
        :param Sequence['NamedRuleWithOperationsArgs'] resource_rules: ResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy matches. The policy cares about an operation if it matches _any_ Rule.
        """
        if exclude_resource_rules is not None:
            pulumi.set(__self__, "exclude_resource_rules", exclude_resource_rules)
        if match_policy is not None:
            pulumi.set(__self__, "match_policy", match_policy)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if object_selector is not None:
            pulumi.set(__self__, "object_selector", object_selector)
        if resource_rules is not None:
            pulumi.set(__self__, "resource_rules", resource_rules)

    @property
    @pulumi.getter(name="excludeResourceRules")
    def exclude_resource_rules(self) -> Optional[Sequence['outputs.NamedRuleWithOperations']]:
        """
        ExcludeResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
        """
        return pulumi.get(self, "exclude_resource_rules")

    @property
    @pulumi.getter(name="matchPolicy")
    def match_policy(self) -> Optional[str]:
        """
        matchPolicy defines how the "MatchResources" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".

        - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the ValidatingAdmissionPolicy.

        - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the ValidatingAdmissionPolicy.

        Defaults to "Equivalent"
        """
        return pulumi.get(self, "match_policy")

    @property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        NamespaceSelector decides whether to run the admission control policy on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the policy.

        For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
          "matchExpressions": [
            {
              "key": "runlevel",
              "operator": "NotIn",
              "values": [
                "0",
                "1"
              ]
            }
          ]
        }

        If instead you want to only run the policy on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
          "matchExpressions": [
            {
              "key": "environment",
              "operator": "In",
              "values": [
                "prod",
                "staging"
              ]
            }
          ]
        }

        See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.

        Default to the empty LabelSelector, which matches everything.
        """
        return pulumi.get(self, "namespace_selector")

    @property
    @pulumi.getter(name="objectSelector")
    def object_selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        ObjectSelector decides whether to run the validation based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the cel validation, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
        """
        return pulumi.get(self, "object_selector")

    @property
    @pulumi.getter(name="resourceRules")
    def resource_rules(self) -> Optional[Sequence['outputs.NamedRuleWithOperations']]:
        """
        ResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy matches. The policy cares about an operation if it matches _any_ Rule.
        """
        return pulumi.get(self, "resource_rules")


@pulumi.output_type
class MatchResourcesPatch(dict):
    """
    MatchResources decides whether to run the admission control policy on an object based on whether it meets the match criteria. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeResourceRules":
            suggest = "exclude_resource_rules"
        elif key == "matchPolicy":
            suggest = "match_policy"
        elif key == "namespaceSelector":
            suggest = "namespace_selector"
        elif key == "objectSelector":
            suggest = "object_selector"
        elif key == "resourceRules":
            suggest = "resource_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MatchResourcesPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MatchResourcesPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MatchResourcesPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_resource_rules: Optional[Sequence['outputs.NamedRuleWithOperationsPatch']] = None,
                 match_policy: Optional[str] = None,
                 namespace_selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 object_selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 resource_rules: Optional[Sequence['outputs.NamedRuleWithOperationsPatch']] = None):
        """
        MatchResources decides whether to run the admission control policy on an object based on whether it meets the match criteria. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
        :param Sequence['NamedRuleWithOperationsPatchArgs'] exclude_resource_rules: ExcludeResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
        :param str match_policy: matchPolicy defines how the "MatchResources" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".
               
               - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the ValidatingAdmissionPolicy.
               
               - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the ValidatingAdmissionPolicy.
               
               Defaults to "Equivalent"
        :param '_meta.v1.LabelSelectorPatchArgs' namespace_selector: NamespaceSelector decides whether to run the admission control policy on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the policy.
               
               For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
                 "matchExpressions": [
                   {
                     "key": "runlevel",
                     "operator": "NotIn",
                     "values": [
                       "0",
                       "1"
                     ]
                   }
                 ]
               }
               
               If instead you want to only run the policy on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
                 "matchExpressions": [
                   {
                     "key": "environment",
                     "operator": "In",
                     "values": [
                       "prod",
                       "staging"
                     ]
                   }
                 ]
               }
               
               See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.
               
               Default to the empty LabelSelector, which matches everything.
        :param '_meta.v1.LabelSelectorPatchArgs' object_selector: ObjectSelector decides whether to run the validation based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the cel validation, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
        :param Sequence['NamedRuleWithOperationsPatchArgs'] resource_rules: ResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy matches. The policy cares about an operation if it matches _any_ Rule.
        """
        if exclude_resource_rules is not None:
            pulumi.set(__self__, "exclude_resource_rules", exclude_resource_rules)
        if match_policy is not None:
            pulumi.set(__self__, "match_policy", match_policy)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if object_selector is not None:
            pulumi.set(__self__, "object_selector", object_selector)
        if resource_rules is not None:
            pulumi.set(__self__, "resource_rules", resource_rules)

    @property
    @pulumi.getter(name="excludeResourceRules")
    def exclude_resource_rules(self) -> Optional[Sequence['outputs.NamedRuleWithOperationsPatch']]:
        """
        ExcludeResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
        """
        return pulumi.get(self, "exclude_resource_rules")

    @property
    @pulumi.getter(name="matchPolicy")
    def match_policy(self) -> Optional[str]:
        """
        matchPolicy defines how the "MatchResources" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".

        - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the ValidatingAdmissionPolicy.

        - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the ValidatingAdmissionPolicy.

        Defaults to "Equivalent"
        """
        return pulumi.get(self, "match_policy")

    @property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        NamespaceSelector decides whether to run the admission control policy on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the policy.

        For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
          "matchExpressions": [
            {
              "key": "runlevel",
              "operator": "NotIn",
              "values": [
                "0",
                "1"
              ]
            }
          ]
        }

        If instead you want to only run the policy on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
          "matchExpressions": [
            {
              "key": "environment",
              "operator": "In",
              "values": [
                "prod",
                "staging"
              ]
            }
          ]
        }

        See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.

        Default to the empty LabelSelector, which matches everything.
        """
        return pulumi.get(self, "namespace_selector")

    @property
    @pulumi.getter(name="objectSelector")
    def object_selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        ObjectSelector decides whether to run the validation based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the cel validation, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
        """
        return pulumi.get(self, "object_selector")

    @property
    @pulumi.getter(name="resourceRules")
    def resource_rules(self) -> Optional[Sequence['outputs.NamedRuleWithOperationsPatch']]:
        """
        ResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy matches. The policy cares about an operation if it matches _any_ Rule.
        """
        return pulumi.get(self, "resource_rules")


@pulumi.output_type
class MutatingWebhook(dict):
    """
    MutatingWebhook describes an admission webhook and the resources and operations it applies to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientConfig":
            suggest = "client_config"
        elif key == "admissionReviewVersions":
            suggest = "admission_review_versions"
        elif key == "failurePolicy":
            suggest = "failure_policy"
        elif key == "matchPolicy":
            suggest = "match_policy"
        elif key == "namespaceSelector":
            suggest = "namespace_selector"
        elif key == "objectSelector":
            suggest = "object_selector"
        elif key == "reinvocationPolicy":
            suggest = "reinvocation_policy"
        elif key == "sideEffects":
            suggest = "side_effects"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MutatingWebhook. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MutatingWebhook.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MutatingWebhook.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_config: 'outputs.WebhookClientConfig',
                 name: str,
                 admission_review_versions: Optional[Sequence[str]] = None,
                 failure_policy: Optional[str] = None,
                 match_policy: Optional[str] = None,
                 namespace_selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 object_selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 reinvocation_policy: Optional[str] = None,
                 rules: Optional[Sequence['outputs.RuleWithOperations']] = None,
                 side_effects: Optional[str] = None,
                 timeout_seconds: Optional[int] = None):
        """
        MutatingWebhook describes an admission webhook and the resources and operations it applies to.
        :param 'WebhookClientConfigArgs' client_config: ClientConfig defines how to communicate with the hook. Required
        :param str name: The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where "imagepolicy" is the name of the webhook, and kubernetes.io is the name of the organization. Required.
        :param Sequence[str] admission_review_versions: AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy. Default to `['v1beta1']`.
        :param str failure_policy: FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.
        :param str match_policy: matchPolicy defines how the "rules" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".
               
               - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.
               
               - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.
               
               Defaults to "Exact"
        :param '_meta.v1.LabelSelectorArgs' namespace_selector: NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.
               
               For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
                 "matchExpressions": [
                   {
                     "key": "runlevel",
                     "operator": "NotIn",
                     "values": [
                       "0",
                       "1"
                     ]
                   }
                 ]
               }
               
               If instead you want to only run the webhook on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
                 "matchExpressions": [
                   {
                     "key": "environment",
                     "operator": "In",
                     "values": [
                       "prod",
                       "staging"
                     ]
                   }
                 ]
               }
               
               See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.
               
               Default to the empty LabelSelector, which matches everything.
        :param '_meta.v1.LabelSelectorArgs' object_selector: ObjectSelector decides whether to run the webhook based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
        :param str reinvocation_policy: reinvocationPolicy indicates whether this webhook should be called multiple times as part of a single admission evaluation. Allowed values are "Never" and "IfNeeded".
               
               Never: the webhook will not be called more than once in a single admission evaluation.
               
               IfNeeded: the webhook will be called at least one additional time as part of the admission evaluation if the object being admitted is modified by other admission plugins after the initial webhook call. Webhooks that specify this option *must* be idempotent, able to process objects they previously admitted. Note: * the number of additional invocations is not guaranteed to be exactly one. * if additional invocations result in further modifications to the object, webhooks are not guaranteed to be invoked again. * webhooks that use this option may be reordered to minimize the number of additional invocations. * to validate an object after all mutations are guaranteed complete, use a validating admission webhook instead.
               
               Defaults to "Never".
        :param Sequence['RuleWithOperationsArgs'] rules: Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.
        :param str side_effects: SideEffects states whether this webhook has side effects. Acceptable values are: Unknown, None, Some, NoneOnDryRun Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission change and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some. Defaults to Unknown.
        :param int timeout_seconds: TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 30 seconds.
        """
        pulumi.set(__self__, "client_config", client_config)
        pulumi.set(__self__, "name", name)
        if admission_review_versions is not None:
            pulumi.set(__self__, "admission_review_versions", admission_review_versions)
        if failure_policy is not None:
            pulumi.set(__self__, "failure_policy", failure_policy)
        if match_policy is not None:
            pulumi.set(__self__, "match_policy", match_policy)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if object_selector is not None:
            pulumi.set(__self__, "object_selector", object_selector)
        if reinvocation_policy is not None:
            pulumi.set(__self__, "reinvocation_policy", reinvocation_policy)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if side_effects is not None:
            pulumi.set(__self__, "side_effects", side_effects)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="clientConfig")
    def client_config(self) -> 'outputs.WebhookClientConfig':
        """
        ClientConfig defines how to communicate with the hook. Required
        """
        return pulumi.get(self, "client_config")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where "imagepolicy" is the name of the webhook, and kubernetes.io is the name of the organization. Required.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="admissionReviewVersions")
    def admission_review_versions(self) -> Optional[Sequence[str]]:
        """
        AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy. Default to `['v1beta1']`.
        """
        return pulumi.get(self, "admission_review_versions")

    @property
    @pulumi.getter(name="failurePolicy")
    def failure_policy(self) -> Optional[str]:
        """
        FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.
        """
        return pulumi.get(self, "failure_policy")

    @property
    @pulumi.getter(name="matchPolicy")
    def match_policy(self) -> Optional[str]:
        """
        matchPolicy defines how the "rules" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".

        - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.

        - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.

        Defaults to "Exact"
        """
        return pulumi.get(self, "match_policy")

    @property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.

        For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
          "matchExpressions": [
            {
              "key": "runlevel",
              "operator": "NotIn",
              "values": [
                "0",
                "1"
              ]
            }
          ]
        }

        If instead you want to only run the webhook on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
          "matchExpressions": [
            {
              "key": "environment",
              "operator": "In",
              "values": [
                "prod",
                "staging"
              ]
            }
          ]
        }

        See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.

        Default to the empty LabelSelector, which matches everything.
        """
        return pulumi.get(self, "namespace_selector")

    @property
    @pulumi.getter(name="objectSelector")
    def object_selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        ObjectSelector decides whether to run the webhook based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
        """
        return pulumi.get(self, "object_selector")

    @property
    @pulumi.getter(name="reinvocationPolicy")
    def reinvocation_policy(self) -> Optional[str]:
        """
        reinvocationPolicy indicates whether this webhook should be called multiple times as part of a single admission evaluation. Allowed values are "Never" and "IfNeeded".

        Never: the webhook will not be called more than once in a single admission evaluation.

        IfNeeded: the webhook will be called at least one additional time as part of the admission evaluation if the object being admitted is modified by other admission plugins after the initial webhook call. Webhooks that specify this option *must* be idempotent, able to process objects they previously admitted. Note: * the number of additional invocations is not guaranteed to be exactly one. * if additional invocations result in further modifications to the object, webhooks are not guaranteed to be invoked again. * webhooks that use this option may be reordered to minimize the number of additional invocations. * to validate an object after all mutations are guaranteed complete, use a validating admission webhook instead.

        Defaults to "Never".
        """
        return pulumi.get(self, "reinvocation_policy")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.RuleWithOperations']]:
        """
        Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="sideEffects")
    def side_effects(self) -> Optional[str]:
        """
        SideEffects states whether this webhook has side effects. Acceptable values are: Unknown, None, Some, NoneOnDryRun Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission change and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some. Defaults to Unknown.
        """
        return pulumi.get(self, "side_effects")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 30 seconds.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class MutatingWebhookConfiguration(dict):
    """
    MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object. Deprecated in v1.16, planned for removal in v1.19. Use admissionregistration.k8s.io/v1 MutatingWebhookConfiguration instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MutatingWebhookConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MutatingWebhookConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MutatingWebhookConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 webhooks: Optional[Sequence['outputs.MutatingWebhook']] = None):
        """
        MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object. Deprecated in v1.16, planned for removal in v1.19. Use admissionregistration.k8s.io/v1 MutatingWebhookConfiguration instead.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        :param Sequence['MutatingWebhookArgs'] webhooks: Webhooks is a list of webhooks and the affected resources and operations.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'admissionregistration.k8s.io/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'MutatingWebhookConfiguration')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if webhooks is not None:
            pulumi.set(__self__, "webhooks", webhooks)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def webhooks(self) -> Optional[Sequence['outputs.MutatingWebhook']]:
        """
        Webhooks is a list of webhooks and the affected resources and operations.
        """
        return pulumi.get(self, "webhooks")


@pulumi.output_type
class MutatingWebhookPatch(dict):
    """
    MutatingWebhook describes an admission webhook and the resources and operations it applies to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "admissionReviewVersions":
            suggest = "admission_review_versions"
        elif key == "clientConfig":
            suggest = "client_config"
        elif key == "failurePolicy":
            suggest = "failure_policy"
        elif key == "matchPolicy":
            suggest = "match_policy"
        elif key == "namespaceSelector":
            suggest = "namespace_selector"
        elif key == "objectSelector":
            suggest = "object_selector"
        elif key == "reinvocationPolicy":
            suggest = "reinvocation_policy"
        elif key == "sideEffects":
            suggest = "side_effects"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MutatingWebhookPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MutatingWebhookPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MutatingWebhookPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admission_review_versions: Optional[Sequence[str]] = None,
                 client_config: Optional['outputs.WebhookClientConfigPatch'] = None,
                 failure_policy: Optional[str] = None,
                 match_policy: Optional[str] = None,
                 name: Optional[str] = None,
                 namespace_selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 object_selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 reinvocation_policy: Optional[str] = None,
                 rules: Optional[Sequence['outputs.RuleWithOperationsPatch']] = None,
                 side_effects: Optional[str] = None,
                 timeout_seconds: Optional[int] = None):
        """
        MutatingWebhook describes an admission webhook and the resources and operations it applies to.
        :param Sequence[str] admission_review_versions: AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy. Default to `['v1beta1']`.
        :param 'WebhookClientConfigPatchArgs' client_config: ClientConfig defines how to communicate with the hook. Required
        :param str failure_policy: FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.
        :param str match_policy: matchPolicy defines how the "rules" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".
               
               - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.
               
               - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.
               
               Defaults to "Exact"
        :param str name: The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where "imagepolicy" is the name of the webhook, and kubernetes.io is the name of the organization. Required.
        :param '_meta.v1.LabelSelectorPatchArgs' namespace_selector: NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.
               
               For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
                 "matchExpressions": [
                   {
                     "key": "runlevel",
                     "operator": "NotIn",
                     "values": [
                       "0",
                       "1"
                     ]
                   }
                 ]
               }
               
               If instead you want to only run the webhook on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
                 "matchExpressions": [
                   {
                     "key": "environment",
                     "operator": "In",
                     "values": [
                       "prod",
                       "staging"
                     ]
                   }
                 ]
               }
               
               See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.
               
               Default to the empty LabelSelector, which matches everything.
        :param '_meta.v1.LabelSelectorPatchArgs' object_selector: ObjectSelector decides whether to run the webhook based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
        :param str reinvocation_policy: reinvocationPolicy indicates whether this webhook should be called multiple times as part of a single admission evaluation. Allowed values are "Never" and "IfNeeded".
               
               Never: the webhook will not be called more than once in a single admission evaluation.
               
               IfNeeded: the webhook will be called at least one additional time as part of the admission evaluation if the object being admitted is modified by other admission plugins after the initial webhook call. Webhooks that specify this option *must* be idempotent, able to process objects they previously admitted. Note: * the number of additional invocations is not guaranteed to be exactly one. * if additional invocations result in further modifications to the object, webhooks are not guaranteed to be invoked again. * webhooks that use this option may be reordered to minimize the number of additional invocations. * to validate an object after all mutations are guaranteed complete, use a validating admission webhook instead.
               
               Defaults to "Never".
        :param Sequence['RuleWithOperationsPatchArgs'] rules: Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.
        :param str side_effects: SideEffects states whether this webhook has side effects. Acceptable values are: Unknown, None, Some, NoneOnDryRun Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission change and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some. Defaults to Unknown.
        :param int timeout_seconds: TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 30 seconds.
        """
        if admission_review_versions is not None:
            pulumi.set(__self__, "admission_review_versions", admission_review_versions)
        if client_config is not None:
            pulumi.set(__self__, "client_config", client_config)
        if failure_policy is not None:
            pulumi.set(__self__, "failure_policy", failure_policy)
        if match_policy is not None:
            pulumi.set(__self__, "match_policy", match_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if object_selector is not None:
            pulumi.set(__self__, "object_selector", object_selector)
        if reinvocation_policy is not None:
            pulumi.set(__self__, "reinvocation_policy", reinvocation_policy)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if side_effects is not None:
            pulumi.set(__self__, "side_effects", side_effects)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="admissionReviewVersions")
    def admission_review_versions(self) -> Optional[Sequence[str]]:
        """
        AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy. Default to `['v1beta1']`.
        """
        return pulumi.get(self, "admission_review_versions")

    @property
    @pulumi.getter(name="clientConfig")
    def client_config(self) -> Optional['outputs.WebhookClientConfigPatch']:
        """
        ClientConfig defines how to communicate with the hook. Required
        """
        return pulumi.get(self, "client_config")

    @property
    @pulumi.getter(name="failurePolicy")
    def failure_policy(self) -> Optional[str]:
        """
        FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.
        """
        return pulumi.get(self, "failure_policy")

    @property
    @pulumi.getter(name="matchPolicy")
    def match_policy(self) -> Optional[str]:
        """
        matchPolicy defines how the "rules" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".

        - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.

        - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.

        Defaults to "Exact"
        """
        return pulumi.get(self, "match_policy")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where "imagepolicy" is the name of the webhook, and kubernetes.io is the name of the organization. Required.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.

        For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
          "matchExpressions": [
            {
              "key": "runlevel",
              "operator": "NotIn",
              "values": [
                "0",
                "1"
              ]
            }
          ]
        }

        If instead you want to only run the webhook on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
          "matchExpressions": [
            {
              "key": "environment",
              "operator": "In",
              "values": [
                "prod",
                "staging"
              ]
            }
          ]
        }

        See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.

        Default to the empty LabelSelector, which matches everything.
        """
        return pulumi.get(self, "namespace_selector")

    @property
    @pulumi.getter(name="objectSelector")
    def object_selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        ObjectSelector decides whether to run the webhook based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
        """
        return pulumi.get(self, "object_selector")

    @property
    @pulumi.getter(name="reinvocationPolicy")
    def reinvocation_policy(self) -> Optional[str]:
        """
        reinvocationPolicy indicates whether this webhook should be called multiple times as part of a single admission evaluation. Allowed values are "Never" and "IfNeeded".

        Never: the webhook will not be called more than once in a single admission evaluation.

        IfNeeded: the webhook will be called at least one additional time as part of the admission evaluation if the object being admitted is modified by other admission plugins after the initial webhook call. Webhooks that specify this option *must* be idempotent, able to process objects they previously admitted. Note: * the number of additional invocations is not guaranteed to be exactly one. * if additional invocations result in further modifications to the object, webhooks are not guaranteed to be invoked again. * webhooks that use this option may be reordered to minimize the number of additional invocations. * to validate an object after all mutations are guaranteed complete, use a validating admission webhook instead.

        Defaults to "Never".
        """
        return pulumi.get(self, "reinvocation_policy")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.RuleWithOperationsPatch']]:
        """
        Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="sideEffects")
    def side_effects(self) -> Optional[str]:
        """
        SideEffects states whether this webhook has side effects. Acceptable values are: Unknown, None, Some, NoneOnDryRun Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission change and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some. Defaults to Unknown.
        """
        return pulumi.get(self, "side_effects")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 30 seconds.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class NamedRuleWithOperations(dict):
    """
    NamedRuleWithOperations is a tuple of Operations and Resources with ResourceNames.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroups":
            suggest = "api_groups"
        elif key == "apiVersions":
            suggest = "api_versions"
        elif key == "resourceNames":
            suggest = "resource_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamedRuleWithOperations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamedRuleWithOperations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamedRuleWithOperations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_groups: Optional[Sequence[str]] = None,
                 api_versions: Optional[Sequence[str]] = None,
                 operations: Optional[Sequence[str]] = None,
                 resource_names: Optional[Sequence[str]] = None,
                 resources: Optional[Sequence[str]] = None,
                 scope: Optional[str] = None):
        """
        NamedRuleWithOperations is a tuple of Operations and Resources with ResourceNames.
        :param Sequence[str] api_groups: APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[str] api_versions: APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[str] operations: Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[str] resource_names: ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.
        :param Sequence[str] resources: Resources is a list of resources this rule applies to.
               
               For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.
               
               If wildcard is present, the validation rule will ensure resources do not overlap with each other.
               
               Depending on the enclosing object, subresources might not be allowed. Required.
        :param str scope: scope specifies the scope of this rule. Valid values are "Cluster", "Namespaced", and "*" "Cluster" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. "Namespaced" means that only namespaced resources will match this rule. "*" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is "*".
        """
        if api_groups is not None:
            pulumi.set(__self__, "api_groups", api_groups)
        if api_versions is not None:
            pulumi.set(__self__, "api_versions", api_versions)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if resource_names is not None:
            pulumi.set(__self__, "resource_names", resource_names)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="apiGroups")
    def api_groups(self) -> Optional[Sequence[str]]:
        """
        APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "api_groups")

    @property
    @pulumi.getter(name="apiVersions")
    def api_versions(self) -> Optional[Sequence[str]]:
        """
        APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "api_versions")

    @property
    @pulumi.getter
    def operations(self) -> Optional[Sequence[str]]:
        """
        Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> Optional[Sequence[str]]:
        """
        ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.
        """
        return pulumi.get(self, "resource_names")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        Resources is a list of resources this rule applies to.

        For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.

        If wildcard is present, the validation rule will ensure resources do not overlap with each other.

        Depending on the enclosing object, subresources might not be allowed. Required.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        scope specifies the scope of this rule. Valid values are "Cluster", "Namespaced", and "*" "Cluster" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. "Namespaced" means that only namespaced resources will match this rule. "*" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is "*".
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class NamedRuleWithOperationsPatch(dict):
    """
    NamedRuleWithOperations is a tuple of Operations and Resources with ResourceNames.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroups":
            suggest = "api_groups"
        elif key == "apiVersions":
            suggest = "api_versions"
        elif key == "resourceNames":
            suggest = "resource_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamedRuleWithOperationsPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamedRuleWithOperationsPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamedRuleWithOperationsPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_groups: Optional[Sequence[str]] = None,
                 api_versions: Optional[Sequence[str]] = None,
                 operations: Optional[Sequence[str]] = None,
                 resource_names: Optional[Sequence[str]] = None,
                 resources: Optional[Sequence[str]] = None,
                 scope: Optional[str] = None):
        """
        NamedRuleWithOperations is a tuple of Operations and Resources with ResourceNames.
        :param Sequence[str] api_groups: APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[str] api_versions: APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[str] operations: Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[str] resource_names: ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.
        :param Sequence[str] resources: Resources is a list of resources this rule applies to.
               
               For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.
               
               If wildcard is present, the validation rule will ensure resources do not overlap with each other.
               
               Depending on the enclosing object, subresources might not be allowed. Required.
        :param str scope: scope specifies the scope of this rule. Valid values are "Cluster", "Namespaced", and "*" "Cluster" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. "Namespaced" means that only namespaced resources will match this rule. "*" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is "*".
        """
        if api_groups is not None:
            pulumi.set(__self__, "api_groups", api_groups)
        if api_versions is not None:
            pulumi.set(__self__, "api_versions", api_versions)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if resource_names is not None:
            pulumi.set(__self__, "resource_names", resource_names)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="apiGroups")
    def api_groups(self) -> Optional[Sequence[str]]:
        """
        APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "api_groups")

    @property
    @pulumi.getter(name="apiVersions")
    def api_versions(self) -> Optional[Sequence[str]]:
        """
        APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "api_versions")

    @property
    @pulumi.getter
    def operations(self) -> Optional[Sequence[str]]:
        """
        Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> Optional[Sequence[str]]:
        """
        ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.
        """
        return pulumi.get(self, "resource_names")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        Resources is a list of resources this rule applies to.

        For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.

        If wildcard is present, the validation rule will ensure resources do not overlap with each other.

        Depending on the enclosing object, subresources might not be allowed. Required.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        scope specifies the scope of this rule. Valid values are "Cluster", "Namespaced", and "*" "Cluster" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. "Namespaced" means that only namespaced resources will match this rule. "*" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is "*".
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class ParamKind(dict):
    """
    ParamKind is a tuple of Group Kind and Version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParamKind. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParamKind.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParamKind.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None):
        """
        ParamKind is a tuple of Group Kind and Version.
        :param str api_version: APIVersion is the API group version the resources belong to. In format of "group/version". Required.
        :param str kind: Kind is the API kind the resources belong to. Required.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion is the API group version the resources belong to. In format of "group/version". Required.
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is the API kind the resources belong to. Required.
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class ParamKindPatch(dict):
    """
    ParamKind is a tuple of Group Kind and Version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParamKindPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParamKindPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParamKindPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None):
        """
        ParamKind is a tuple of Group Kind and Version.
        :param str api_version: APIVersion is the API group version the resources belong to. In format of "group/version". Required.
        :param str kind: Kind is the API kind the resources belong to. Required.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion is the API group version the resources belong to. In format of "group/version". Required.
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is the API kind the resources belong to. Required.
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class ParamRef(dict):
    """
    ParamRef describes how to locate the params to be used as input to expressions of rules applied by a policy binding.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterNotFoundAction":
            suggest = "parameter_not_found_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParamRef. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParamRef.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParamRef.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 namespace: Optional[str] = None,
                 parameter_not_found_action: Optional[str] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelector'] = None):
        """
        ParamRef describes how to locate the params to be used as input to expressions of rules applied by a policy binding.
        :param str name: name is the name of the resource being referenced.
               
               One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
               
               A single parameter used for all admission requests can be configured by setting the `name` field, leaving `selector` blank, and setting namespace if `paramKind` is namespace-scoped.
        :param str namespace: namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.
               
               A per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.
               
               - If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.
               
               - If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.
        :param str parameter_not_found_action: `parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.
               
               Allowed values are `Allow` or `Deny`
               
               Required
        :param '_meta.v1.LabelSelectorArgs' selector: selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.
               
               If multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.
               
               One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if parameter_not_found_action is not None:
            pulumi.set(__self__, "parameter_not_found_action", parameter_not_found_action)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        name is the name of the resource being referenced.

        One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.

        A single parameter used for all admission requests can be configured by setting the `name` field, leaving `selector` blank, and setting namespace if `paramKind` is namespace-scoped.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.

        A per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.

        - If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.

        - If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="parameterNotFoundAction")
    def parameter_not_found_action(self) -> Optional[str]:
        """
        `parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.

        Allowed values are `Allow` or `Deny`

        Required
        """
        return pulumi.get(self, "parameter_not_found_action")

    @property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.

        If multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.

        One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class ParamRefPatch(dict):
    """
    ParamRef describes how to locate the params to be used as input to expressions of rules applied by a policy binding.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterNotFoundAction":
            suggest = "parameter_not_found_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParamRefPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParamRefPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParamRefPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 namespace: Optional[str] = None,
                 parameter_not_found_action: Optional[str] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None):
        """
        ParamRef describes how to locate the params to be used as input to expressions of rules applied by a policy binding.
        :param str name: name is the name of the resource being referenced.
               
               One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
               
               A single parameter used for all admission requests can be configured by setting the `name` field, leaving `selector` blank, and setting namespace if `paramKind` is namespace-scoped.
        :param str namespace: namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.
               
               A per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.
               
               - If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.
               
               - If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.
        :param str parameter_not_found_action: `parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.
               
               Allowed values are `Allow` or `Deny`
               
               Required
        :param '_meta.v1.LabelSelectorPatchArgs' selector: selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.
               
               If multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.
               
               One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if parameter_not_found_action is not None:
            pulumi.set(__self__, "parameter_not_found_action", parameter_not_found_action)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        name is the name of the resource being referenced.

        One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.

        A single parameter used for all admission requests can be configured by setting the `name` field, leaving `selector` blank, and setting namespace if `paramKind` is namespace-scoped.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.

        A per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.

        - If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.

        - If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="parameterNotFoundAction")
    def parameter_not_found_action(self) -> Optional[str]:
        """
        `parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.

        Allowed values are `Allow` or `Deny`

        Required
        """
        return pulumi.get(self, "parameter_not_found_action")

    @property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.

        If multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.

        One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class RuleWithOperations(dict):
    """
    RuleWithOperations is a tuple of Operations and Resources. It is recommended to make sure that all the tuple expansions are valid.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroups":
            suggest = "api_groups"
        elif key == "apiVersions":
            suggest = "api_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleWithOperations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleWithOperations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleWithOperations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_groups: Optional[Sequence[str]] = None,
                 api_versions: Optional[Sequence[str]] = None,
                 operations: Optional[Sequence[str]] = None,
                 resources: Optional[Sequence[str]] = None,
                 scope: Optional[str] = None):
        """
        RuleWithOperations is a tuple of Operations and Resources. It is recommended to make sure that all the tuple expansions are valid.
        :param Sequence[str] api_groups: APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[str] api_versions: APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[str] operations: Operations is the operations the admission hook cares about - CREATE, UPDATE, or * for all operations. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[str] resources: Resources is a list of resources this rule applies to.
               
               For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.
               
               If wildcard is present, the validation rule will ensure resources do not overlap with each other.
               
               Depending on the enclosing object, subresources might not be allowed. Required.
        :param str scope: scope specifies the scope of this rule. Valid values are "Cluster", "Namespaced", and "*" "Cluster" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. "Namespaced" means that only namespaced resources will match this rule. "*" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is "*".
        """
        if api_groups is not None:
            pulumi.set(__self__, "api_groups", api_groups)
        if api_versions is not None:
            pulumi.set(__self__, "api_versions", api_versions)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="apiGroups")
    def api_groups(self) -> Optional[Sequence[str]]:
        """
        APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "api_groups")

    @property
    @pulumi.getter(name="apiVersions")
    def api_versions(self) -> Optional[Sequence[str]]:
        """
        APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "api_versions")

    @property
    @pulumi.getter
    def operations(self) -> Optional[Sequence[str]]:
        """
        Operations is the operations the admission hook cares about - CREATE, UPDATE, or * for all operations. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        Resources is a list of resources this rule applies to.

        For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.

        If wildcard is present, the validation rule will ensure resources do not overlap with each other.

        Depending on the enclosing object, subresources might not be allowed. Required.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        scope specifies the scope of this rule. Valid values are "Cluster", "Namespaced", and "*" "Cluster" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. "Namespaced" means that only namespaced resources will match this rule. "*" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is "*".
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class RuleWithOperationsPatch(dict):
    """
    RuleWithOperations is a tuple of Operations and Resources. It is recommended to make sure that all the tuple expansions are valid.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroups":
            suggest = "api_groups"
        elif key == "apiVersions":
            suggest = "api_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleWithOperationsPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleWithOperationsPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleWithOperationsPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_groups: Optional[Sequence[str]] = None,
                 api_versions: Optional[Sequence[str]] = None,
                 operations: Optional[Sequence[str]] = None,
                 resources: Optional[Sequence[str]] = None,
                 scope: Optional[str] = None):
        """
        RuleWithOperations is a tuple of Operations and Resources. It is recommended to make sure that all the tuple expansions are valid.
        :param Sequence[str] api_groups: APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[str] api_versions: APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[str] operations: Operations is the operations the admission hook cares about - CREATE, UPDATE, or * for all operations. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[str] resources: Resources is a list of resources this rule applies to.
               
               For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.
               
               If wildcard is present, the validation rule will ensure resources do not overlap with each other.
               
               Depending on the enclosing object, subresources might not be allowed. Required.
        :param str scope: scope specifies the scope of this rule. Valid values are "Cluster", "Namespaced", and "*" "Cluster" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. "Namespaced" means that only namespaced resources will match this rule. "*" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is "*".
        """
        if api_groups is not None:
            pulumi.set(__self__, "api_groups", api_groups)
        if api_versions is not None:
            pulumi.set(__self__, "api_versions", api_versions)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="apiGroups")
    def api_groups(self) -> Optional[Sequence[str]]:
        """
        APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "api_groups")

    @property
    @pulumi.getter(name="apiVersions")
    def api_versions(self) -> Optional[Sequence[str]]:
        """
        APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "api_versions")

    @property
    @pulumi.getter
    def operations(self) -> Optional[Sequence[str]]:
        """
        Operations is the operations the admission hook cares about - CREATE, UPDATE, or * for all operations. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        Resources is a list of resources this rule applies to.

        For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.

        If wildcard is present, the validation rule will ensure resources do not overlap with each other.

        Depending on the enclosing object, subresources might not be allowed. Required.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        scope specifies the scope of this rule. Valid values are "Cluster", "Namespaced", and "*" "Cluster" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. "Namespaced" means that only namespaced resources will match this rule. "*" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is "*".
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class ServiceReference(dict):
    """
    ServiceReference holds a reference to Service.legacy.k8s.io
    """
    def __init__(__self__, *,
                 name: str,
                 namespace: str,
                 path: Optional[str] = None,
                 port: Optional[int] = None):
        """
        ServiceReference holds a reference to Service.legacy.k8s.io
        :param str name: `name` is the name of the service. Required
        :param str namespace: `namespace` is the namespace of the service. Required
        :param str path: `path` is an optional URL path which will be sent in any request to this service.
        :param int port: If specified, the port on the service that hosting webhook. Default to 443 for backward compatibility. `port` should be a valid port number (1-65535, inclusive).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `name` is the name of the service. Required
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        `namespace` is the namespace of the service. Required
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        `path` is an optional URL path which will be sent in any request to this service.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        If specified, the port on the service that hosting webhook. Default to 443 for backward compatibility. `port` should be a valid port number (1-65535, inclusive).
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceReferencePatch(dict):
    """
    ServiceReference holds a reference to Service.legacy.k8s.io
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 namespace: Optional[str] = None,
                 path: Optional[str] = None,
                 port: Optional[int] = None):
        """
        ServiceReference holds a reference to Service.legacy.k8s.io
        :param str name: `name` is the name of the service. Required
        :param str namespace: `namespace` is the namespace of the service. Required
        :param str path: `path` is an optional URL path which will be sent in any request to this service.
        :param int port: If specified, the port on the service that hosting webhook. Default to 443 for backward compatibility. `port` should be a valid port number (1-65535, inclusive).
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        `name` is the name of the service. Required
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        `namespace` is the namespace of the service. Required
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        `path` is an optional URL path which will be sent in any request to this service.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        If specified, the port on the service that hosting webhook. Default to 443 for backward compatibility. `port` should be a valid port number (1-65535, inclusive).
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class TypeChecking(dict):
    """
    TypeChecking contains results of type checking the expressions in the ValidatingAdmissionPolicy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expressionWarnings":
            suggest = "expression_warnings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TypeChecking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TypeChecking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TypeChecking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expression_warnings: Optional[Sequence['outputs.ExpressionWarning']] = None):
        """
        TypeChecking contains results of type checking the expressions in the ValidatingAdmissionPolicy
        :param Sequence['ExpressionWarningArgs'] expression_warnings: The type checking warnings for each expression.
        """
        if expression_warnings is not None:
            pulumi.set(__self__, "expression_warnings", expression_warnings)

    @property
    @pulumi.getter(name="expressionWarnings")
    def expression_warnings(self) -> Optional[Sequence['outputs.ExpressionWarning']]:
        """
        The type checking warnings for each expression.
        """
        return pulumi.get(self, "expression_warnings")


@pulumi.output_type
class TypeCheckingPatch(dict):
    """
    TypeChecking contains results of type checking the expressions in the ValidatingAdmissionPolicy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expressionWarnings":
            suggest = "expression_warnings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TypeCheckingPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TypeCheckingPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TypeCheckingPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expression_warnings: Optional[Sequence['outputs.ExpressionWarningPatch']] = None):
        """
        TypeChecking contains results of type checking the expressions in the ValidatingAdmissionPolicy
        :param Sequence['ExpressionWarningPatchArgs'] expression_warnings: The type checking warnings for each expression.
        """
        if expression_warnings is not None:
            pulumi.set(__self__, "expression_warnings", expression_warnings)

    @property
    @pulumi.getter(name="expressionWarnings")
    def expression_warnings(self) -> Optional[Sequence['outputs.ExpressionWarningPatch']]:
        """
        The type checking warnings for each expression.
        """
        return pulumi.get(self, "expression_warnings")


@pulumi.output_type
class ValidatingAdmissionPolicy(dict):
    """
    ValidatingAdmissionPolicy describes the definition of an admission validation policy that accepts or rejects an object without changing it.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingAdmissionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingAdmissionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingAdmissionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.ValidatingAdmissionPolicySpec'] = None,
                 status: Optional['outputs.ValidatingAdmissionPolicyStatus'] = None):
        """
        ValidatingAdmissionPolicy describes the definition of an admission validation policy that accepts or rejects an object without changing it.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        :param 'ValidatingAdmissionPolicySpecArgs' spec: Specification of the desired behavior of the ValidatingAdmissionPolicy.
        :param 'ValidatingAdmissionPolicyStatusArgs' status: The status of the ValidatingAdmissionPolicy, including warnings that are useful to determine if the policy behaves in the expected way. Populated by the system. Read-only.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'admissionregistration.k8s.io/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ValidatingAdmissionPolicy')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.ValidatingAdmissionPolicySpec']:
        """
        Specification of the desired behavior of the ValidatingAdmissionPolicy.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.ValidatingAdmissionPolicyStatus']:
        """
        The status of the ValidatingAdmissionPolicy, including warnings that are useful to determine if the policy behaves in the expected way. Populated by the system. Read-only.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ValidatingAdmissionPolicyBinding(dict):
    """
    ValidatingAdmissionPolicyBinding binds the ValidatingAdmissionPolicy with paramerized resources. ValidatingAdmissionPolicyBinding and parameter CRDs together define how cluster administrators configure policies for clusters.

    For a given admission request, each binding will cause its policy to be evaluated N times, where N is 1 for policies/bindings that don't use params, otherwise N is the number of parameters selected by the binding.

    The CEL expressions of a policy must have a computed CEL cost below the maximum CEL budget. Each evaluation of the policy is given an independent CEL cost budget. Adding/removing policies, bindings, or params can not affect whether a given (policy, binding, param) combination is within its own CEL budget.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingAdmissionPolicyBinding. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingAdmissionPolicyBinding.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingAdmissionPolicyBinding.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.ValidatingAdmissionPolicyBindingSpec'] = None):
        """
        ValidatingAdmissionPolicyBinding binds the ValidatingAdmissionPolicy with paramerized resources. ValidatingAdmissionPolicyBinding and parameter CRDs together define how cluster administrators configure policies for clusters.

        For a given admission request, each binding will cause its policy to be evaluated N times, where N is 1 for policies/bindings that don't use params, otherwise N is the number of parameters selected by the binding.

        The CEL expressions of a policy must have a computed CEL cost below the maximum CEL budget. Each evaluation of the policy is given an independent CEL cost budget. Adding/removing policies, bindings, or params can not affect whether a given (policy, binding, param) combination is within its own CEL budget.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        :param 'ValidatingAdmissionPolicyBindingSpecArgs' spec: Specification of the desired behavior of the ValidatingAdmissionPolicyBinding.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'admissionregistration.k8s.io/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ValidatingAdmissionPolicyBinding')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.ValidatingAdmissionPolicyBindingSpec']:
        """
        Specification of the desired behavior of the ValidatingAdmissionPolicyBinding.
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class ValidatingAdmissionPolicyBindingSpec(dict):
    """
    ValidatingAdmissionPolicyBindingSpec is the specification of the ValidatingAdmissionPolicyBinding.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchResources":
            suggest = "match_resources"
        elif key == "paramRef":
            suggest = "param_ref"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "validationActions":
            suggest = "validation_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingAdmissionPolicyBindingSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingAdmissionPolicyBindingSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingAdmissionPolicyBindingSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_resources: Optional['outputs.MatchResources'] = None,
                 param_ref: Optional['outputs.ParamRef'] = None,
                 policy_name: Optional[str] = None,
                 validation_actions: Optional[Sequence[str]] = None):
        """
        ValidatingAdmissionPolicyBindingSpec is the specification of the ValidatingAdmissionPolicyBinding.
        :param 'MatchResourcesArgs' match_resources: MatchResources declares what resources match this binding and will be validated by it. Note that this is intersected with the policy's matchConstraints, so only requests that are matched by the policy can be selected by this. If this is unset, all resources matched by the policy are validated by this binding When resourceRules is unset, it does not constrain resource matching. If a resource is matched by the other fields of this object, it will be validated. Note that this is differs from ValidatingAdmissionPolicy matchConstraints, where resourceRules are required.
        :param 'ParamRefArgs' param_ref: paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in ParamKind of the bound ValidatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the ValidatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.
        :param str policy_name: PolicyName references a ValidatingAdmissionPolicy name which the ValidatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.
        :param Sequence[str] validation_actions: validationActions declares how Validations of the referenced ValidatingAdmissionPolicy are enforced. If a validation evaluates to false it is always enforced according to these actions.
               
               Failures defined by the ValidatingAdmissionPolicy's FailurePolicy are enforced according to these actions only if the FailurePolicy is set to Fail, otherwise the failures are ignored. This includes compilation errors, runtime errors and misconfigurations of the policy.
               
               validationActions is declared as a set of action values. Order does not matter. validationActions may not contain duplicates of the same action.
               
               The supported actions values are:
               
               "Deny" specifies that a validation failure results in a denied request.
               
               "Warn" specifies that a validation failure is reported to the request client in HTTP Warning headers, with a warning code of 299. Warnings can be sent both for allowed or denied admission responses.
               
               "Audit" specifies that a validation failure is included in the published audit event for the request. The audit event will contain a `validation.policy.admission.k8s.io/validation_failure` audit annotation with a value containing the details of the validation failures, formatted as a JSON list of objects, each with the following fields: - message: The validation failure message string - policy: The resource name of the ValidatingAdmissionPolicy - binding: The resource name of the ValidatingAdmissionPolicyBinding - expressionIndex: The index of the failed validations in the ValidatingAdmissionPolicy - validationActions: The enforcement actions enacted for the validation failure Example audit annotation: `"validation.policy.admission.k8s.io/validation_failure": "[{"message": "Invalid value", {"policy": "policy.example.com", {"binding": "policybinding.example.com", {"expressionIndex": "1", {"validationActions": ["Audit"]}]"`
               
               Clients should expect to handle additional values by ignoring any values not recognized.
               
               "Deny" and "Warn" may not be used together since this combination needlessly duplicates the validation failure both in the API response body and the HTTP warning headers.
               
               Required.
        """
        if match_resources is not None:
            pulumi.set(__self__, "match_resources", match_resources)
        if param_ref is not None:
            pulumi.set(__self__, "param_ref", param_ref)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if validation_actions is not None:
            pulumi.set(__self__, "validation_actions", validation_actions)

    @property
    @pulumi.getter(name="matchResources")
    def match_resources(self) -> Optional['outputs.MatchResources']:
        """
        MatchResources declares what resources match this binding and will be validated by it. Note that this is intersected with the policy's matchConstraints, so only requests that are matched by the policy can be selected by this. If this is unset, all resources matched by the policy are validated by this binding When resourceRules is unset, it does not constrain resource matching. If a resource is matched by the other fields of this object, it will be validated. Note that this is differs from ValidatingAdmissionPolicy matchConstraints, where resourceRules are required.
        """
        return pulumi.get(self, "match_resources")

    @property
    @pulumi.getter(name="paramRef")
    def param_ref(self) -> Optional['outputs.ParamRef']:
        """
        paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in ParamKind of the bound ValidatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the ValidatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.
        """
        return pulumi.get(self, "param_ref")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        PolicyName references a ValidatingAdmissionPolicy name which the ValidatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="validationActions")
    def validation_actions(self) -> Optional[Sequence[str]]:
        """
        validationActions declares how Validations of the referenced ValidatingAdmissionPolicy are enforced. If a validation evaluates to false it is always enforced according to these actions.

        Failures defined by the ValidatingAdmissionPolicy's FailurePolicy are enforced according to these actions only if the FailurePolicy is set to Fail, otherwise the failures are ignored. This includes compilation errors, runtime errors and misconfigurations of the policy.

        validationActions is declared as a set of action values. Order does not matter. validationActions may not contain duplicates of the same action.

        The supported actions values are:

        "Deny" specifies that a validation failure results in a denied request.

        "Warn" specifies that a validation failure is reported to the request client in HTTP Warning headers, with a warning code of 299. Warnings can be sent both for allowed or denied admission responses.

        "Audit" specifies that a validation failure is included in the published audit event for the request. The audit event will contain a `validation.policy.admission.k8s.io/validation_failure` audit annotation with a value containing the details of the validation failures, formatted as a JSON list of objects, each with the following fields: - message: The validation failure message string - policy: The resource name of the ValidatingAdmissionPolicy - binding: The resource name of the ValidatingAdmissionPolicyBinding - expressionIndex: The index of the failed validations in the ValidatingAdmissionPolicy - validationActions: The enforcement actions enacted for the validation failure Example audit annotation: `"validation.policy.admission.k8s.io/validation_failure": "[{"message": "Invalid value", {"policy": "policy.example.com", {"binding": "policybinding.example.com", {"expressionIndex": "1", {"validationActions": ["Audit"]}]"`

        Clients should expect to handle additional values by ignoring any values not recognized.

        "Deny" and "Warn" may not be used together since this combination needlessly duplicates the validation failure both in the API response body and the HTTP warning headers.

        Required.
        """
        return pulumi.get(self, "validation_actions")


@pulumi.output_type
class ValidatingAdmissionPolicyBindingSpecPatch(dict):
    """
    ValidatingAdmissionPolicyBindingSpec is the specification of the ValidatingAdmissionPolicyBinding.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchResources":
            suggest = "match_resources"
        elif key == "paramRef":
            suggest = "param_ref"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "validationActions":
            suggest = "validation_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingAdmissionPolicyBindingSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingAdmissionPolicyBindingSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingAdmissionPolicyBindingSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_resources: Optional['outputs.MatchResourcesPatch'] = None,
                 param_ref: Optional['outputs.ParamRefPatch'] = None,
                 policy_name: Optional[str] = None,
                 validation_actions: Optional[Sequence[str]] = None):
        """
        ValidatingAdmissionPolicyBindingSpec is the specification of the ValidatingAdmissionPolicyBinding.
        :param 'MatchResourcesPatchArgs' match_resources: MatchResources declares what resources match this binding and will be validated by it. Note that this is intersected with the policy's matchConstraints, so only requests that are matched by the policy can be selected by this. If this is unset, all resources matched by the policy are validated by this binding When resourceRules is unset, it does not constrain resource matching. If a resource is matched by the other fields of this object, it will be validated. Note that this is differs from ValidatingAdmissionPolicy matchConstraints, where resourceRules are required.
        :param 'ParamRefPatchArgs' param_ref: paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in ParamKind of the bound ValidatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the ValidatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.
        :param str policy_name: PolicyName references a ValidatingAdmissionPolicy name which the ValidatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.
        :param Sequence[str] validation_actions: validationActions declares how Validations of the referenced ValidatingAdmissionPolicy are enforced. If a validation evaluates to false it is always enforced according to these actions.
               
               Failures defined by the ValidatingAdmissionPolicy's FailurePolicy are enforced according to these actions only if the FailurePolicy is set to Fail, otherwise the failures are ignored. This includes compilation errors, runtime errors and misconfigurations of the policy.
               
               validationActions is declared as a set of action values. Order does not matter. validationActions may not contain duplicates of the same action.
               
               The supported actions values are:
               
               "Deny" specifies that a validation failure results in a denied request.
               
               "Warn" specifies that a validation failure is reported to the request client in HTTP Warning headers, with a warning code of 299. Warnings can be sent both for allowed or denied admission responses.
               
               "Audit" specifies that a validation failure is included in the published audit event for the request. The audit event will contain a `validation.policy.admission.k8s.io/validation_failure` audit annotation with a value containing the details of the validation failures, formatted as a JSON list of objects, each with the following fields: - message: The validation failure message string - policy: The resource name of the ValidatingAdmissionPolicy - binding: The resource name of the ValidatingAdmissionPolicyBinding - expressionIndex: The index of the failed validations in the ValidatingAdmissionPolicy - validationActions: The enforcement actions enacted for the validation failure Example audit annotation: `"validation.policy.admission.k8s.io/validation_failure": "[{"message": "Invalid value", {"policy": "policy.example.com", {"binding": "policybinding.example.com", {"expressionIndex": "1", {"validationActions": ["Audit"]}]"`
               
               Clients should expect to handle additional values by ignoring any values not recognized.
               
               "Deny" and "Warn" may not be used together since this combination needlessly duplicates the validation failure both in the API response body and the HTTP warning headers.
               
               Required.
        """
        if match_resources is not None:
            pulumi.set(__self__, "match_resources", match_resources)
        if param_ref is not None:
            pulumi.set(__self__, "param_ref", param_ref)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if validation_actions is not None:
            pulumi.set(__self__, "validation_actions", validation_actions)

    @property
    @pulumi.getter(name="matchResources")
    def match_resources(self) -> Optional['outputs.MatchResourcesPatch']:
        """
        MatchResources declares what resources match this binding and will be validated by it. Note that this is intersected with the policy's matchConstraints, so only requests that are matched by the policy can be selected by this. If this is unset, all resources matched by the policy are validated by this binding When resourceRules is unset, it does not constrain resource matching. If a resource is matched by the other fields of this object, it will be validated. Note that this is differs from ValidatingAdmissionPolicy matchConstraints, where resourceRules are required.
        """
        return pulumi.get(self, "match_resources")

    @property
    @pulumi.getter(name="paramRef")
    def param_ref(self) -> Optional['outputs.ParamRefPatch']:
        """
        paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in ParamKind of the bound ValidatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the ValidatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.
        """
        return pulumi.get(self, "param_ref")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        PolicyName references a ValidatingAdmissionPolicy name which the ValidatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="validationActions")
    def validation_actions(self) -> Optional[Sequence[str]]:
        """
        validationActions declares how Validations of the referenced ValidatingAdmissionPolicy are enforced. If a validation evaluates to false it is always enforced according to these actions.

        Failures defined by the ValidatingAdmissionPolicy's FailurePolicy are enforced according to these actions only if the FailurePolicy is set to Fail, otherwise the failures are ignored. This includes compilation errors, runtime errors and misconfigurations of the policy.

        validationActions is declared as a set of action values. Order does not matter. validationActions may not contain duplicates of the same action.

        The supported actions values are:

        "Deny" specifies that a validation failure results in a denied request.

        "Warn" specifies that a validation failure is reported to the request client in HTTP Warning headers, with a warning code of 299. Warnings can be sent both for allowed or denied admission responses.

        "Audit" specifies that a validation failure is included in the published audit event for the request. The audit event will contain a `validation.policy.admission.k8s.io/validation_failure` audit annotation with a value containing the details of the validation failures, formatted as a JSON list of objects, each with the following fields: - message: The validation failure message string - policy: The resource name of the ValidatingAdmissionPolicy - binding: The resource name of the ValidatingAdmissionPolicyBinding - expressionIndex: The index of the failed validations in the ValidatingAdmissionPolicy - validationActions: The enforcement actions enacted for the validation failure Example audit annotation: `"validation.policy.admission.k8s.io/validation_failure": "[{"message": "Invalid value", {"policy": "policy.example.com", {"binding": "policybinding.example.com", {"expressionIndex": "1", {"validationActions": ["Audit"]}]"`

        Clients should expect to handle additional values by ignoring any values not recognized.

        "Deny" and "Warn" may not be used together since this combination needlessly duplicates the validation failure both in the API response body and the HTTP warning headers.

        Required.
        """
        return pulumi.get(self, "validation_actions")


@pulumi.output_type
class ValidatingAdmissionPolicySpec(dict):
    """
    ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditAnnotations":
            suggest = "audit_annotations"
        elif key == "failurePolicy":
            suggest = "failure_policy"
        elif key == "matchConditions":
            suggest = "match_conditions"
        elif key == "matchConstraints":
            suggest = "match_constraints"
        elif key == "paramKind":
            suggest = "param_kind"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingAdmissionPolicySpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingAdmissionPolicySpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingAdmissionPolicySpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_annotations: Optional[Sequence['outputs.AuditAnnotation']] = None,
                 failure_policy: Optional[str] = None,
                 match_conditions: Optional[Sequence['outputs.MatchCondition']] = None,
                 match_constraints: Optional['outputs.MatchResources'] = None,
                 param_kind: Optional['outputs.ParamKind'] = None,
                 validations: Optional[Sequence['outputs.Validation']] = None,
                 variables: Optional[Sequence['outputs.Variable']] = None):
        """
        ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy.
        :param Sequence['AuditAnnotationArgs'] audit_annotations: auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required.
        :param str failure_policy: failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.
               
               A policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource.
               
               failurePolicy does not define how validations that evaluate to false are handled.
               
               When failurePolicy is set to Fail, ValidatingAdmissionPolicyBinding validationActions define how failures are enforced.
               
               Allowed values are Ignore or Fail. Defaults to Fail.
        :param Sequence['MatchConditionArgs'] match_conditions: MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.
               
               If a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.
               
               The exact matching logic is (in order):
                 1. If ANY matchCondition evaluates to FALSE, the policy is skipped.
                 2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.
                 3. If any matchCondition evaluates to an error (but none are FALSE):
                    - If failurePolicy=Fail, reject the request
                    - If failurePolicy=Ignore, the policy is skipped
        :param 'MatchResourcesArgs' match_constraints: MatchConstraints specifies what resources this policy is designed to validate. The AdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API ValidatingAdmissionPolicy cannot match ValidatingAdmissionPolicy and ValidatingAdmissionPolicyBinding. Required.
        :param 'ParamKindArgs' param_kind: ParamKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If ParamKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in ValidatingAdmissionPolicyBinding, the params variable will be null.
        :param Sequence['ValidationArgs'] validations: Validations contain CEL expressions which is used to apply the validation. Validations and AuditAnnotations may not both be empty; a minimum of one Validations or AuditAnnotations is required.
        :param Sequence['VariableArgs'] variables: Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.
               
               The expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic.
        """
        if audit_annotations is not None:
            pulumi.set(__self__, "audit_annotations", audit_annotations)
        if failure_policy is not None:
            pulumi.set(__self__, "failure_policy", failure_policy)
        if match_conditions is not None:
            pulumi.set(__self__, "match_conditions", match_conditions)
        if match_constraints is not None:
            pulumi.set(__self__, "match_constraints", match_constraints)
        if param_kind is not None:
            pulumi.set(__self__, "param_kind", param_kind)
        if validations is not None:
            pulumi.set(__self__, "validations", validations)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter(name="auditAnnotations")
    def audit_annotations(self) -> Optional[Sequence['outputs.AuditAnnotation']]:
        """
        auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required.
        """
        return pulumi.get(self, "audit_annotations")

    @property
    @pulumi.getter(name="failurePolicy")
    def failure_policy(self) -> Optional[str]:
        """
        failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.

        A policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource.

        failurePolicy does not define how validations that evaluate to false are handled.

        When failurePolicy is set to Fail, ValidatingAdmissionPolicyBinding validationActions define how failures are enforced.

        Allowed values are Ignore or Fail. Defaults to Fail.
        """
        return pulumi.get(self, "failure_policy")

    @property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> Optional[Sequence['outputs.MatchCondition']]:
        """
        MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.

        If a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.

        The exact matching logic is (in order):
          1. If ANY matchCondition evaluates to FALSE, the policy is skipped.
          2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.
          3. If any matchCondition evaluates to an error (but none are FALSE):
             - If failurePolicy=Fail, reject the request
             - If failurePolicy=Ignore, the policy is skipped
        """
        return pulumi.get(self, "match_conditions")

    @property
    @pulumi.getter(name="matchConstraints")
    def match_constraints(self) -> Optional['outputs.MatchResources']:
        """
        MatchConstraints specifies what resources this policy is designed to validate. The AdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API ValidatingAdmissionPolicy cannot match ValidatingAdmissionPolicy and ValidatingAdmissionPolicyBinding. Required.
        """
        return pulumi.get(self, "match_constraints")

    @property
    @pulumi.getter(name="paramKind")
    def param_kind(self) -> Optional['outputs.ParamKind']:
        """
        ParamKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If ParamKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in ValidatingAdmissionPolicyBinding, the params variable will be null.
        """
        return pulumi.get(self, "param_kind")

    @property
    @pulumi.getter
    def validations(self) -> Optional[Sequence['outputs.Validation']]:
        """
        Validations contain CEL expressions which is used to apply the validation. Validations and AuditAnnotations may not both be empty; a minimum of one Validations or AuditAnnotations is required.
        """
        return pulumi.get(self, "validations")

    @property
    @pulumi.getter
    def variables(self) -> Optional[Sequence['outputs.Variable']]:
        """
        Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.

        The expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class ValidatingAdmissionPolicySpecPatch(dict):
    """
    ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditAnnotations":
            suggest = "audit_annotations"
        elif key == "failurePolicy":
            suggest = "failure_policy"
        elif key == "matchConditions":
            suggest = "match_conditions"
        elif key == "matchConstraints":
            suggest = "match_constraints"
        elif key == "paramKind":
            suggest = "param_kind"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingAdmissionPolicySpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingAdmissionPolicySpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingAdmissionPolicySpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_annotations: Optional[Sequence['outputs.AuditAnnotationPatch']] = None,
                 failure_policy: Optional[str] = None,
                 match_conditions: Optional[Sequence['outputs.MatchConditionPatch']] = None,
                 match_constraints: Optional['outputs.MatchResourcesPatch'] = None,
                 param_kind: Optional['outputs.ParamKindPatch'] = None,
                 validations: Optional[Sequence['outputs.ValidationPatch']] = None,
                 variables: Optional[Sequence['outputs.VariablePatch']] = None):
        """
        ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy.
        :param Sequence['AuditAnnotationPatchArgs'] audit_annotations: auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required.
        :param str failure_policy: failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.
               
               A policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource.
               
               failurePolicy does not define how validations that evaluate to false are handled.
               
               When failurePolicy is set to Fail, ValidatingAdmissionPolicyBinding validationActions define how failures are enforced.
               
               Allowed values are Ignore or Fail. Defaults to Fail.
        :param Sequence['MatchConditionPatchArgs'] match_conditions: MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.
               
               If a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.
               
               The exact matching logic is (in order):
                 1. If ANY matchCondition evaluates to FALSE, the policy is skipped.
                 2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.
                 3. If any matchCondition evaluates to an error (but none are FALSE):
                    - If failurePolicy=Fail, reject the request
                    - If failurePolicy=Ignore, the policy is skipped
        :param 'MatchResourcesPatchArgs' match_constraints: MatchConstraints specifies what resources this policy is designed to validate. The AdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API ValidatingAdmissionPolicy cannot match ValidatingAdmissionPolicy and ValidatingAdmissionPolicyBinding. Required.
        :param 'ParamKindPatchArgs' param_kind: ParamKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If ParamKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in ValidatingAdmissionPolicyBinding, the params variable will be null.
        :param Sequence['ValidationPatchArgs'] validations: Validations contain CEL expressions which is used to apply the validation. Validations and AuditAnnotations may not both be empty; a minimum of one Validations or AuditAnnotations is required.
        :param Sequence['VariablePatchArgs'] variables: Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.
               
               The expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic.
        """
        if audit_annotations is not None:
            pulumi.set(__self__, "audit_annotations", audit_annotations)
        if failure_policy is not None:
            pulumi.set(__self__, "failure_policy", failure_policy)
        if match_conditions is not None:
            pulumi.set(__self__, "match_conditions", match_conditions)
        if match_constraints is not None:
            pulumi.set(__self__, "match_constraints", match_constraints)
        if param_kind is not None:
            pulumi.set(__self__, "param_kind", param_kind)
        if validations is not None:
            pulumi.set(__self__, "validations", validations)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter(name="auditAnnotations")
    def audit_annotations(self) -> Optional[Sequence['outputs.AuditAnnotationPatch']]:
        """
        auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required.
        """
        return pulumi.get(self, "audit_annotations")

    @property
    @pulumi.getter(name="failurePolicy")
    def failure_policy(self) -> Optional[str]:
        """
        failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.

        A policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource.

        failurePolicy does not define how validations that evaluate to false are handled.

        When failurePolicy is set to Fail, ValidatingAdmissionPolicyBinding validationActions define how failures are enforced.

        Allowed values are Ignore or Fail. Defaults to Fail.
        """
        return pulumi.get(self, "failure_policy")

    @property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> Optional[Sequence['outputs.MatchConditionPatch']]:
        """
        MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.

        If a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.

        The exact matching logic is (in order):
          1. If ANY matchCondition evaluates to FALSE, the policy is skipped.
          2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.
          3. If any matchCondition evaluates to an error (but none are FALSE):
             - If failurePolicy=Fail, reject the request
             - If failurePolicy=Ignore, the policy is skipped
        """
        return pulumi.get(self, "match_conditions")

    @property
    @pulumi.getter(name="matchConstraints")
    def match_constraints(self) -> Optional['outputs.MatchResourcesPatch']:
        """
        MatchConstraints specifies what resources this policy is designed to validate. The AdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API ValidatingAdmissionPolicy cannot match ValidatingAdmissionPolicy and ValidatingAdmissionPolicyBinding. Required.
        """
        return pulumi.get(self, "match_constraints")

    @property
    @pulumi.getter(name="paramKind")
    def param_kind(self) -> Optional['outputs.ParamKindPatch']:
        """
        ParamKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If ParamKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in ValidatingAdmissionPolicyBinding, the params variable will be null.
        """
        return pulumi.get(self, "param_kind")

    @property
    @pulumi.getter
    def validations(self) -> Optional[Sequence['outputs.ValidationPatch']]:
        """
        Validations contain CEL expressions which is used to apply the validation. Validations and AuditAnnotations may not both be empty; a minimum of one Validations or AuditAnnotations is required.
        """
        return pulumi.get(self, "validations")

    @property
    @pulumi.getter
    def variables(self) -> Optional[Sequence['outputs.VariablePatch']]:
        """
        Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.

        The expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class ValidatingAdmissionPolicyStatus(dict):
    """
    ValidatingAdmissionPolicyStatus represents the status of an admission validation policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "typeChecking":
            suggest = "type_checking"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingAdmissionPolicyStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingAdmissionPolicyStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingAdmissionPolicyStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Optional[Sequence['_meta.v1.outputs.Condition']] = None,
                 observed_generation: Optional[int] = None,
                 type_checking: Optional['outputs.TypeChecking'] = None):
        """
        ValidatingAdmissionPolicyStatus represents the status of an admission validation policy.
        :param Sequence['_meta.v1.ConditionArgs'] conditions: The conditions represent the latest available observations of a policy's current state.
        :param int observed_generation: The generation observed by the controller.
        :param 'TypeCheckingArgs' type_checking: The results of type checking for each expression. Presence of this field indicates the completion of the type checking.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if type_checking is not None:
            pulumi.set(__self__, "type_checking", type_checking)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['_meta.v1.outputs.Condition']]:
        """
        The conditions represent the latest available observations of a policy's current state.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[int]:
        """
        The generation observed by the controller.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter(name="typeChecking")
    def type_checking(self) -> Optional['outputs.TypeChecking']:
        """
        The results of type checking for each expression. Presence of this field indicates the completion of the type checking.
        """
        return pulumi.get(self, "type_checking")


@pulumi.output_type
class ValidatingAdmissionPolicyStatusPatch(dict):
    """
    ValidatingAdmissionPolicyStatus represents the status of an admission validation policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "typeChecking":
            suggest = "type_checking"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingAdmissionPolicyStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingAdmissionPolicyStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingAdmissionPolicyStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Optional[Sequence['_meta.v1.outputs.ConditionPatch']] = None,
                 observed_generation: Optional[int] = None,
                 type_checking: Optional['outputs.TypeCheckingPatch'] = None):
        """
        ValidatingAdmissionPolicyStatus represents the status of an admission validation policy.
        :param Sequence['_meta.v1.ConditionPatchArgs'] conditions: The conditions represent the latest available observations of a policy's current state.
        :param int observed_generation: The generation observed by the controller.
        :param 'TypeCheckingPatchArgs' type_checking: The results of type checking for each expression. Presence of this field indicates the completion of the type checking.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if type_checking is not None:
            pulumi.set(__self__, "type_checking", type_checking)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['_meta.v1.outputs.ConditionPatch']]:
        """
        The conditions represent the latest available observations of a policy's current state.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[int]:
        """
        The generation observed by the controller.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter(name="typeChecking")
    def type_checking(self) -> Optional['outputs.TypeCheckingPatch']:
        """
        The results of type checking for each expression. Presence of this field indicates the completion of the type checking.
        """
        return pulumi.get(self, "type_checking")


@pulumi.output_type
class ValidatingWebhook(dict):
    """
    ValidatingWebhook describes an admission webhook and the resources and operations it applies to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientConfig":
            suggest = "client_config"
        elif key == "admissionReviewVersions":
            suggest = "admission_review_versions"
        elif key == "failurePolicy":
            suggest = "failure_policy"
        elif key == "matchPolicy":
            suggest = "match_policy"
        elif key == "namespaceSelector":
            suggest = "namespace_selector"
        elif key == "objectSelector":
            suggest = "object_selector"
        elif key == "sideEffects":
            suggest = "side_effects"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingWebhook. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingWebhook.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingWebhook.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_config: 'outputs.WebhookClientConfig',
                 name: str,
                 admission_review_versions: Optional[Sequence[str]] = None,
                 failure_policy: Optional[str] = None,
                 match_policy: Optional[str] = None,
                 namespace_selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 object_selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 rules: Optional[Sequence['outputs.RuleWithOperations']] = None,
                 side_effects: Optional[str] = None,
                 timeout_seconds: Optional[int] = None):
        """
        ValidatingWebhook describes an admission webhook and the resources and operations it applies to.
        :param 'WebhookClientConfigArgs' client_config: ClientConfig defines how to communicate with the hook. Required
        :param str name: The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where "imagepolicy" is the name of the webhook, and kubernetes.io is the name of the organization. Required.
        :param Sequence[str] admission_review_versions: AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy. Default to `['v1beta1']`.
        :param str failure_policy: FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.
        :param str match_policy: matchPolicy defines how the "rules" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".
               
               - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.
               
               - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.
               
               Defaults to "Exact"
        :param '_meta.v1.LabelSelectorArgs' namespace_selector: NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.
               
               For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
                 "matchExpressions": [
                   {
                     "key": "runlevel",
                     "operator": "NotIn",
                     "values": [
                       "0",
                       "1"
                     ]
                   }
                 ]
               }
               
               If instead you want to only run the webhook on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
                 "matchExpressions": [
                   {
                     "key": "environment",
                     "operator": "In",
                     "values": [
                       "prod",
                       "staging"
                     ]
                   }
                 ]
               }
               
               See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels for more examples of label selectors.
               
               Default to the empty LabelSelector, which matches everything.
        :param '_meta.v1.LabelSelectorArgs' object_selector: ObjectSelector decides whether to run the webhook based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
        :param Sequence['RuleWithOperationsArgs'] rules: Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.
        :param str side_effects: SideEffects states whether this webhook has side effects. Acceptable values are: Unknown, None, Some, NoneOnDryRun Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission change and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some. Defaults to Unknown.
        :param int timeout_seconds: TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 30 seconds.
        """
        pulumi.set(__self__, "client_config", client_config)
        pulumi.set(__self__, "name", name)
        if admission_review_versions is not None:
            pulumi.set(__self__, "admission_review_versions", admission_review_versions)
        if failure_policy is not None:
            pulumi.set(__self__, "failure_policy", failure_policy)
        if match_policy is not None:
            pulumi.set(__self__, "match_policy", match_policy)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if object_selector is not None:
            pulumi.set(__self__, "object_selector", object_selector)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if side_effects is not None:
            pulumi.set(__self__, "side_effects", side_effects)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="clientConfig")
    def client_config(self) -> 'outputs.WebhookClientConfig':
        """
        ClientConfig defines how to communicate with the hook. Required
        """
        return pulumi.get(self, "client_config")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where "imagepolicy" is the name of the webhook, and kubernetes.io is the name of the organization. Required.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="admissionReviewVersions")
    def admission_review_versions(self) -> Optional[Sequence[str]]:
        """
        AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy. Default to `['v1beta1']`.
        """
        return pulumi.get(self, "admission_review_versions")

    @property
    @pulumi.getter(name="failurePolicy")
    def failure_policy(self) -> Optional[str]:
        """
        FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.
        """
        return pulumi.get(self, "failure_policy")

    @property
    @pulumi.getter(name="matchPolicy")
    def match_policy(self) -> Optional[str]:
        """
        matchPolicy defines how the "rules" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".

        - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.

        - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.

        Defaults to "Exact"
        """
        return pulumi.get(self, "match_policy")

    @property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.

        For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
          "matchExpressions": [
            {
              "key": "runlevel",
              "operator": "NotIn",
              "values": [
                "0",
                "1"
              ]
            }
          ]
        }

        If instead you want to only run the webhook on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
          "matchExpressions": [
            {
              "key": "environment",
              "operator": "In",
              "values": [
                "prod",
                "staging"
              ]
            }
          ]
        }

        See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels for more examples of label selectors.

        Default to the empty LabelSelector, which matches everything.
        """
        return pulumi.get(self, "namespace_selector")

    @property
    @pulumi.getter(name="objectSelector")
    def object_selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        ObjectSelector decides whether to run the webhook based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
        """
        return pulumi.get(self, "object_selector")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.RuleWithOperations']]:
        """
        Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="sideEffects")
    def side_effects(self) -> Optional[str]:
        """
        SideEffects states whether this webhook has side effects. Acceptable values are: Unknown, None, Some, NoneOnDryRun Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission change and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some. Defaults to Unknown.
        """
        return pulumi.get(self, "side_effects")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 30 seconds.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class ValidatingWebhookConfiguration(dict):
    """
    ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it. Deprecated in v1.16, planned for removal in v1.19. Use admissionregistration.k8s.io/v1 ValidatingWebhookConfiguration instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingWebhookConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingWebhookConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingWebhookConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 webhooks: Optional[Sequence['outputs.ValidatingWebhook']] = None):
        """
        ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it. Deprecated in v1.16, planned for removal in v1.19. Use admissionregistration.k8s.io/v1 ValidatingWebhookConfiguration instead.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        :param Sequence['ValidatingWebhookArgs'] webhooks: Webhooks is a list of webhooks and the affected resources and operations.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'admissionregistration.k8s.io/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ValidatingWebhookConfiguration')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if webhooks is not None:
            pulumi.set(__self__, "webhooks", webhooks)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def webhooks(self) -> Optional[Sequence['outputs.ValidatingWebhook']]:
        """
        Webhooks is a list of webhooks and the affected resources and operations.
        """
        return pulumi.get(self, "webhooks")


@pulumi.output_type
class ValidatingWebhookPatch(dict):
    """
    ValidatingWebhook describes an admission webhook and the resources and operations it applies to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "admissionReviewVersions":
            suggest = "admission_review_versions"
        elif key == "clientConfig":
            suggest = "client_config"
        elif key == "failurePolicy":
            suggest = "failure_policy"
        elif key == "matchPolicy":
            suggest = "match_policy"
        elif key == "namespaceSelector":
            suggest = "namespace_selector"
        elif key == "objectSelector":
            suggest = "object_selector"
        elif key == "sideEffects":
            suggest = "side_effects"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingWebhookPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingWebhookPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingWebhookPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admission_review_versions: Optional[Sequence[str]] = None,
                 client_config: Optional['outputs.WebhookClientConfigPatch'] = None,
                 failure_policy: Optional[str] = None,
                 match_policy: Optional[str] = None,
                 name: Optional[str] = None,
                 namespace_selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 object_selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 rules: Optional[Sequence['outputs.RuleWithOperationsPatch']] = None,
                 side_effects: Optional[str] = None,
                 timeout_seconds: Optional[int] = None):
        """
        ValidatingWebhook describes an admission webhook and the resources and operations it applies to.
        :param Sequence[str] admission_review_versions: AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy. Default to `['v1beta1']`.
        :param 'WebhookClientConfigPatchArgs' client_config: ClientConfig defines how to communicate with the hook. Required
        :param str failure_policy: FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.
        :param str match_policy: matchPolicy defines how the "rules" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".
               
               - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.
               
               - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.
               
               Defaults to "Exact"
        :param str name: The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where "imagepolicy" is the name of the webhook, and kubernetes.io is the name of the organization. Required.
        :param '_meta.v1.LabelSelectorPatchArgs' namespace_selector: NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.
               
               For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
                 "matchExpressions": [
                   {
                     "key": "runlevel",
                     "operator": "NotIn",
                     "values": [
                       "0",
                       "1"
                     ]
                   }
                 ]
               }
               
               If instead you want to only run the webhook on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
                 "matchExpressions": [
                   {
                     "key": "environment",
                     "operator": "In",
                     "values": [
                       "prod",
                       "staging"
                     ]
                   }
                 ]
               }
               
               See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels for more examples of label selectors.
               
               Default to the empty LabelSelector, which matches everything.
        :param '_meta.v1.LabelSelectorPatchArgs' object_selector: ObjectSelector decides whether to run the webhook based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
        :param Sequence['RuleWithOperationsPatchArgs'] rules: Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.
        :param str side_effects: SideEffects states whether this webhook has side effects. Acceptable values are: Unknown, None, Some, NoneOnDryRun Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission change and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some. Defaults to Unknown.
        :param int timeout_seconds: TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 30 seconds.
        """
        if admission_review_versions is not None:
            pulumi.set(__self__, "admission_review_versions", admission_review_versions)
        if client_config is not None:
            pulumi.set(__self__, "client_config", client_config)
        if failure_policy is not None:
            pulumi.set(__self__, "failure_policy", failure_policy)
        if match_policy is not None:
            pulumi.set(__self__, "match_policy", match_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if object_selector is not None:
            pulumi.set(__self__, "object_selector", object_selector)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if side_effects is not None:
            pulumi.set(__self__, "side_effects", side_effects)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="admissionReviewVersions")
    def admission_review_versions(self) -> Optional[Sequence[str]]:
        """
        AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy. Default to `['v1beta1']`.
        """
        return pulumi.get(self, "admission_review_versions")

    @property
    @pulumi.getter(name="clientConfig")
    def client_config(self) -> Optional['outputs.WebhookClientConfigPatch']:
        """
        ClientConfig defines how to communicate with the hook. Required
        """
        return pulumi.get(self, "client_config")

    @property
    @pulumi.getter(name="failurePolicy")
    def failure_policy(self) -> Optional[str]:
        """
        FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.
        """
        return pulumi.get(self, "failure_policy")

    @property
    @pulumi.getter(name="matchPolicy")
    def match_policy(self) -> Optional[str]:
        """
        matchPolicy defines how the "rules" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".

        - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.

        - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.

        Defaults to "Exact"
        """
        return pulumi.get(self, "match_policy")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where "imagepolicy" is the name of the webhook, and kubernetes.io is the name of the organization. Required.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.

        For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
          "matchExpressions": [
            {
              "key": "runlevel",
              "operator": "NotIn",
              "values": [
                "0",
                "1"
              ]
            }
          ]
        }

        If instead you want to only run the webhook on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
          "matchExpressions": [
            {
              "key": "environment",
              "operator": "In",
              "values": [
                "prod",
                "staging"
              ]
            }
          ]
        }

        See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels for more examples of label selectors.

        Default to the empty LabelSelector, which matches everything.
        """
        return pulumi.get(self, "namespace_selector")

    @property
    @pulumi.getter(name="objectSelector")
    def object_selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        ObjectSelector decides whether to run the webhook based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
        """
        return pulumi.get(self, "object_selector")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.RuleWithOperationsPatch']]:
        """
        Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="sideEffects")
    def side_effects(self) -> Optional[str]:
        """
        SideEffects states whether this webhook has side effects. Acceptable values are: Unknown, None, Some, NoneOnDryRun Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission change and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some. Defaults to Unknown.
        """
        return pulumi.get(self, "side_effects")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 30 seconds.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class Validation(dict):
    """
    Validation specifies the CEL expression which is used to apply the validation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageExpression":
            suggest = "message_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Validation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Validation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Validation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expression: str,
                 message: Optional[str] = None,
                 message_expression: Optional[str] = None,
                 reason: Optional[str] = None):
        """
        Validation specifies the CEL expression which is used to apply the validation.
        :param str expression: Expression represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec CEL expressions have access to the contents of the API request/response, organized into CEL variables as well as some other useful variables:
               
               - 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.
                 For example, a variable named 'foo' can be accessed as 'variables.foo'.
               - 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
                 See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
               - 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
                 request resource.
               
               The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.
               
               Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:
               	  "true", "false", "null", "in", "as", "break", "const", "continue", "else", "for", "function", "if",
               	  "import", "let", "loop", "package", "namespace", "return".
               Examples:
                 - Expression accessing a property named "namespace": {"Expression": "object.__namespace__ > 0"}
                 - Expression accessing a property named "x-prop": {"Expression": "object.x__dash__prop > 0"}
                 - Expression accessing a property named "redact__d": {"Expression": "object.redact__underscores__d > 0"}
               
               Equality on arrays with list type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:
                 - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and
                   non-intersecting elements in `Y` are appended, retaining their partial order.
                 - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values
                   are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with
                   non-intersecting keys are appended, retaining their partial order.
               Required.
        :param str message: Message represents the message displayed when validation fails. The message is required if the Expression contains line breaks. The message must not contain line breaks. If unset, the message is "failed rule: {Rule}". e.g. "must be a URL with the host matching spec.host" If the Expression contains line breaks. Message is required. The message must not contain line breaks. If unset, the message is "failed Expression: {Expression}".
        :param str message_expression: messageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a validation, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the `expression` except for 'authorizer' and 'authorizer.requestResource'. Example: "object.x must be less than max ("+string(params.max)+")"
        :param str reason: Reason represents a machine-readable description of why this validation failed. If this is the first validation in the list to fail, this reason, as well as the corresponding HTTP response code, are used in the HTTP response to the client. The currently supported reasons are: "Unauthorized", "Forbidden", "Invalid", "RequestEntityTooLarge". If not set, StatusReasonInvalid is used in the response to the client.
        """
        pulumi.set(__self__, "expression", expression)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if message_expression is not None:
            pulumi.set(__self__, "message_expression", message_expression)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Expression represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec CEL expressions have access to the contents of the API request/response, organized into CEL variables as well as some other useful variables:

        - 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.
          For example, a variable named 'foo' can be accessed as 'variables.foo'.
        - 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
          See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
        - 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
          request resource.

        The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.

        Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:
        	  "true", "false", "null", "in", "as", "break", "const", "continue", "else", "for", "function", "if",
        	  "import", "let", "loop", "package", "namespace", "return".
        Examples:
          - Expression accessing a property named "namespace": {"Expression": "object.__namespace__ > 0"}
          - Expression accessing a property named "x-prop": {"Expression": "object.x__dash__prop > 0"}
          - Expression accessing a property named "redact__d": {"Expression": "object.redact__underscores__d > 0"}

        Equality on arrays with list type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:
          - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and
            non-intersecting elements in `Y` are appended, retaining their partial order.
          - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values
            are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with
            non-intersecting keys are appended, retaining their partial order.
        Required.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Message represents the message displayed when validation fails. The message is required if the Expression contains line breaks. The message must not contain line breaks. If unset, the message is "failed rule: {Rule}". e.g. "must be a URL with the host matching spec.host" If the Expression contains line breaks. Message is required. The message must not contain line breaks. If unset, the message is "failed Expression: {Expression}".
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="messageExpression")
    def message_expression(self) -> Optional[str]:
        """
        messageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a validation, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the `expression` except for 'authorizer' and 'authorizer.requestResource'. Example: "object.x must be less than max ("+string(params.max)+")"
        """
        return pulumi.get(self, "message_expression")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        Reason represents a machine-readable description of why this validation failed. If this is the first validation in the list to fail, this reason, as well as the corresponding HTTP response code, are used in the HTTP response to the client. The currently supported reasons are: "Unauthorized", "Forbidden", "Invalid", "RequestEntityTooLarge". If not set, StatusReasonInvalid is used in the response to the client.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class ValidationPatch(dict):
    """
    Validation specifies the CEL expression which is used to apply the validation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageExpression":
            suggest = "message_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidationPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidationPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidationPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expression: Optional[str] = None,
                 message: Optional[str] = None,
                 message_expression: Optional[str] = None,
                 reason: Optional[str] = None):
        """
        Validation specifies the CEL expression which is used to apply the validation.
        :param str expression: Expression represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec CEL expressions have access to the contents of the API request/response, organized into CEL variables as well as some other useful variables:
               
               - 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.
                 For example, a variable named 'foo' can be accessed as 'variables.foo'.
               - 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
                 See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
               - 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
                 request resource.
               
               The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.
               
               Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:
               	  "true", "false", "null", "in", "as", "break", "const", "continue", "else", "for", "function", "if",
               	  "import", "let", "loop", "package", "namespace", "return".
               Examples:
                 - Expression accessing a property named "namespace": {"Expression": "object.__namespace__ > 0"}
                 - Expression accessing a property named "x-prop": {"Expression": "object.x__dash__prop > 0"}
                 - Expression accessing a property named "redact__d": {"Expression": "object.redact__underscores__d > 0"}
               
               Equality on arrays with list type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:
                 - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and
                   non-intersecting elements in `Y` are appended, retaining their partial order.
                 - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values
                   are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with
                   non-intersecting keys are appended, retaining their partial order.
               Required.
        :param str message: Message represents the message displayed when validation fails. The message is required if the Expression contains line breaks. The message must not contain line breaks. If unset, the message is "failed rule: {Rule}". e.g. "must be a URL with the host matching spec.host" If the Expression contains line breaks. Message is required. The message must not contain line breaks. If unset, the message is "failed Expression: {Expression}".
        :param str message_expression: messageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a validation, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the `expression` except for 'authorizer' and 'authorizer.requestResource'. Example: "object.x must be less than max ("+string(params.max)+")"
        :param str reason: Reason represents a machine-readable description of why this validation failed. If this is the first validation in the list to fail, this reason, as well as the corresponding HTTP response code, are used in the HTTP response to the client. The currently supported reasons are: "Unauthorized", "Forbidden", "Invalid", "RequestEntityTooLarge". If not set, StatusReasonInvalid is used in the response to the client.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if message_expression is not None:
            pulumi.set(__self__, "message_expression", message_expression)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        Expression represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec CEL expressions have access to the contents of the API request/response, organized into CEL variables as well as some other useful variables:

        - 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.
          For example, a variable named 'foo' can be accessed as 'variables.foo'.
        - 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
          See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
        - 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
          request resource.

        The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.

        Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:
        	  "true", "false", "null", "in", "as", "break", "const", "continue", "else", "for", "function", "if",
        	  "import", "let", "loop", "package", "namespace", "return".
        Examples:
          - Expression accessing a property named "namespace": {"Expression": "object.__namespace__ > 0"}
          - Expression accessing a property named "x-prop": {"Expression": "object.x__dash__prop > 0"}
          - Expression accessing a property named "redact__d": {"Expression": "object.redact__underscores__d > 0"}

        Equality on arrays with list type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:
          - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and
            non-intersecting elements in `Y` are appended, retaining their partial order.
          - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values
            are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with
            non-intersecting keys are appended, retaining their partial order.
        Required.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Message represents the message displayed when validation fails. The message is required if the Expression contains line breaks. The message must not contain line breaks. If unset, the message is "failed rule: {Rule}". e.g. "must be a URL with the host matching spec.host" If the Expression contains line breaks. Message is required. The message must not contain line breaks. If unset, the message is "failed Expression: {Expression}".
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="messageExpression")
    def message_expression(self) -> Optional[str]:
        """
        messageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a validation, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the `expression` except for 'authorizer' and 'authorizer.requestResource'. Example: "object.x must be less than max ("+string(params.max)+")"
        """
        return pulumi.get(self, "message_expression")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        Reason represents a machine-readable description of why this validation failed. If this is the first validation in the list to fail, this reason, as well as the corresponding HTTP response code, are used in the HTTP response to the client. The currently supported reasons are: "Unauthorized", "Forbidden", "Invalid", "RequestEntityTooLarge". If not set, StatusReasonInvalid is used in the response to the client.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class Variable(dict):
    """
    Variable is the definition of a variable that is used for composition. A variable is defined as a named expression.
    """
    def __init__(__self__, *,
                 expression: str,
                 name: str):
        """
        Variable is the definition of a variable that is used for composition. A variable is defined as a named expression.
        :param str expression: Expression is the expression that will be evaluated as the value of the variable. The CEL expression has access to the same identifiers as the CEL expressions in Validation.
        :param str name: Name is the name of the variable. The name must be a valid CEL identifier and unique among all variables. The variable can be accessed in other expressions through `variables` For example, if name is "foo", the variable will be available as `variables.foo`
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Expression is the expression that will be evaluated as the value of the variable. The CEL expression has access to the same identifiers as the CEL expressions in Validation.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name is the name of the variable. The name must be a valid CEL identifier and unique among all variables. The variable can be accessed in other expressions through `variables` For example, if name is "foo", the variable will be available as `variables.foo`
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class VariablePatch(dict):
    """
    Variable is the definition of a variable that is used for composition. A variable is defined as a named expression.
    """
    def __init__(__self__, *,
                 expression: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Variable is the definition of a variable that is used for composition. A variable is defined as a named expression.
        :param str expression: Expression is the expression that will be evaluated as the value of the variable. The CEL expression has access to the same identifiers as the CEL expressions in Validation.
        :param str name: Name is the name of the variable. The name must be a valid CEL identifier and unique among all variables. The variable can be accessed in other expressions through `variables` For example, if name is "foo", the variable will be available as `variables.foo`
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        Expression is the expression that will be evaluated as the value of the variable. The CEL expression has access to the same identifiers as the CEL expressions in Validation.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name is the name of the variable. The name must be a valid CEL identifier and unique among all variables. The variable can be accessed in other expressions through `variables` For example, if name is "foo", the variable will be available as `variables.foo`
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class WebhookClientConfig(dict):
    """
    WebhookClientConfig contains the information to make a TLS connection with the webhook
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caBundle":
            suggest = "ca_bundle"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookClientConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookClientConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookClientConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_bundle: Optional[str] = None,
                 service: Optional['outputs.ServiceReference'] = None,
                 url: Optional[str] = None):
        """
        WebhookClientConfig contains the information to make a TLS connection with the webhook
        :param str ca_bundle: `caBundle` is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.
        :param 'ServiceReferenceArgs' service: `service` is a reference to the service for this webhook. Either `service` or `url` must be specified.
               
               If the webhook is running within the cluster, then you should use `service`.
        :param str url: `url` gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.
               
               The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.
               
               Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.
               
               The scheme must be "https"; the URL must begin with "https://".
               
               A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.
               
               Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
        """
        if ca_bundle is not None:
            pulumi.set(__self__, "ca_bundle", ca_bundle)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="caBundle")
    def ca_bundle(self) -> Optional[str]:
        """
        `caBundle` is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.
        """
        return pulumi.get(self, "ca_bundle")

    @property
    @pulumi.getter
    def service(self) -> Optional['outputs.ServiceReference']:
        """
        `service` is a reference to the service for this webhook. Either `service` or `url` must be specified.

        If the webhook is running within the cluster, then you should use `service`.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        `url` gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.

        The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.

        Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.

        The scheme must be "https"; the URL must begin with "https://".

        A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.

        Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class WebhookClientConfigPatch(dict):
    """
    WebhookClientConfig contains the information to make a TLS connection with the webhook
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caBundle":
            suggest = "ca_bundle"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookClientConfigPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookClientConfigPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookClientConfigPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_bundle: Optional[str] = None,
                 service: Optional['outputs.ServiceReferencePatch'] = None,
                 url: Optional[str] = None):
        """
        WebhookClientConfig contains the information to make a TLS connection with the webhook
        :param str ca_bundle: `caBundle` is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.
        :param 'ServiceReferencePatchArgs' service: `service` is a reference to the service for this webhook. Either `service` or `url` must be specified.
               
               If the webhook is running within the cluster, then you should use `service`.
        :param str url: `url` gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.
               
               The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.
               
               Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.
               
               The scheme must be "https"; the URL must begin with "https://".
               
               A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.
               
               Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
        """
        if ca_bundle is not None:
            pulumi.set(__self__, "ca_bundle", ca_bundle)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="caBundle")
    def ca_bundle(self) -> Optional[str]:
        """
        `caBundle` is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.
        """
        return pulumi.get(self, "ca_bundle")

    @property
    @pulumi.getter
    def service(self) -> Optional['outputs.ServiceReferencePatch']:
        """
        `service` is a reference to the service for this webhook. Either `service` or `url` must be specified.

        If the webhook is running within the cluster, then you should use `service`.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        `url` gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.

        The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.

        Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.

        The scheme must be "https"; the URL must begin with "https://".

        A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.

        Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
        """
        return pulumi.get(self, "url")


