# *** WARNING: this file was generated by the Pulumi Kubernetes codegen tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
from typing import Any, Optional

import pulumi
import pulumi.runtime
from pulumi import ResourceOptions

from .. import meta as _meta
from .. import _utilities

__all__ = ['CustomResourcePatchArgs', 'CustomResourcePatch']

@pulumi.input_type
class CustomResourcePatchArgs:
    def __init__(__self__, *,
                 api_version: pulumi.Input[str],
                 kind: pulumi.Input[str],
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[Any] = None):
        """
        The set of arguments for constructing a CustomResourcePatch resource.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object metadata.
        :param Any spec: Specification of the CustomResourcePatch.
        """
        pulumi.set(__self__, "api_version", api_version)
        pulumi.set(__self__, "kind", kind)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Input[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[Any]:
        """
        Specification of the CustomResourcePatch.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[Any]):
        pulumi.set(self, "spec", value)

class CustomResourcePatch(pulumi.CustomResource):
    def __init__(self,
                 resource_name: str,
                 api_version: str,
                 kind: str,
                 spec: Optional[pulumi.Input[Any]] = None,
                 metadata: Optional[pulumi.Input[pulumi.InputType['_meta.v1.ObjectMetaArgs']]] = None,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 __name__=None,
                 __opts__=None):
        """
        CustomResourcePatch represents an instance of a CustomResourceDefinition (CRD). For example, the
        CoreOS Prometheus operator exposes a CRD `monitoring.coreos.com/ServiceMonitor`; to
        instantiate this as a Pulumi resource, one could call `new CustomResourcePatch`, passing the
        `ServiceMonitor` resource definition as an argument.

        :param str resource_name: _Unique_ name used to register this resource with Pulumi.
        :param str api_version: The API version of the apiExtensions.CustomResourcePatch we
               wish to select, as specified by the CustomResourceDefinition that defines it on the
               API server.
        :param str kind: The kind of the apiextensions.CustomResourcePatch we wish to select,
               as specified by the CustomResourceDefinition that defines it on the API server.
        :param Optional[pulumi.Input[Any]] spec: Specification of the CustomResourcePatch.
        :param Optional[pulumi.Input[pulumi.InputType['_meta.v1.ObjectMetaArgs']]] metadata: Standard object metadata;
               More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.
        :param Optional[pulumi.ResourceOptions] opts: A bag of options that control this
               resource's behavior.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(version=_utilities.get_version()))
        self._internal_init(resource_name, api_version=api_version, kind=kind, opts=opts, metadata=metadata, spec=spec)

    def _internal_init(__self__,
                 resource_name: str,
                 api_version: str,
                 kind: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 metadata: Optional[pulumi.Input[pulumi.InputType['_meta.v1.ObjectMetaArgs']]] = None,
                 spec: Optional[Any] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomResourcePatchArgs.__new__(CustomResourcePatchArgs)

            if api_version is None and not opts.urn:
                raise TypeError("Missing required property 'api_version'")
            __props__.__dict__["api_version"] = api_version
            if kind is None and not opts.urn:
                raise TypeError("Missing required property 'kind'")
            __props__.__dict__["kind"] = kind
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["spec"] = spec
        super(CustomResourcePatch, __self__).__init__(
            f"kubernetes:{api_version}:{kind}Patch",
            resource_name,
            __props__,
            opts)
