# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import meta as _meta

__all__ = [
    'ExemptPriorityLevelConfiguration',
    'ExemptPriorityLevelConfigurationPatch',
    'FlowDistinguisherMethod',
    'FlowDistinguisherMethodPatch',
    'FlowSchema',
    'FlowSchemaCondition',
    'FlowSchemaConditionPatch',
    'FlowSchemaSpec',
    'FlowSchemaSpecPatch',
    'FlowSchemaStatus',
    'FlowSchemaStatusPatch',
    'GroupSubject',
    'GroupSubjectPatch',
    'LimitResponse',
    'LimitResponsePatch',
    'LimitedPriorityLevelConfiguration',
    'LimitedPriorityLevelConfigurationPatch',
    'NonResourcePolicyRule',
    'NonResourcePolicyRulePatch',
    'PolicyRulesWithSubjects',
    'PolicyRulesWithSubjectsPatch',
    'PriorityLevelConfiguration',
    'PriorityLevelConfigurationCondition',
    'PriorityLevelConfigurationConditionPatch',
    'PriorityLevelConfigurationReference',
    'PriorityLevelConfigurationReferencePatch',
    'PriorityLevelConfigurationSpec',
    'PriorityLevelConfigurationSpecPatch',
    'PriorityLevelConfigurationStatus',
    'PriorityLevelConfigurationStatusPatch',
    'QueuingConfiguration',
    'QueuingConfigurationPatch',
    'ResourcePolicyRule',
    'ResourcePolicyRulePatch',
    'ServiceAccountSubject',
    'ServiceAccountSubjectPatch',
    'Subject',
    'SubjectPatch',
    'UserSubject',
    'UserSubjectPatch',
]

@pulumi.output_type
class ExemptPriorityLevelConfiguration(dict):
    """
    ExemptPriorityLevelConfiguration describes the configurable aspects of the handling of exempt requests. In the mandatory exempt configuration object the values in the fields here can be modified by authorized users, unlike the rest of the `spec`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lendablePercent":
            suggest = "lendable_percent"
        elif key == "nominalConcurrencyShares":
            suggest = "nominal_concurrency_shares"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExemptPriorityLevelConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExemptPriorityLevelConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExemptPriorityLevelConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lendable_percent: Optional[int] = None,
                 nominal_concurrency_shares: Optional[int] = None):
        """
        ExemptPriorityLevelConfiguration describes the configurable aspects of the handling of exempt requests. In the mandatory exempt configuration object the values in the fields here can be modified by authorized users, unlike the rest of the `spec`.
        :param int lendable_percent: `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels.  This value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.
               
               LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        :param int nominal_concurrency_shares: `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats nominally reserved for this priority level. This DOES NOT limit the dispatching from this priority level but affects the other priority levels through the borrowing mechanism. The server's concurrency limit (ServerCL) is divided among all the priority levels in proportion to their NCS values:
               
               NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)
               
               Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level. This field has a default value of zero.
        """
        if lendable_percent is not None:
            pulumi.set(__self__, "lendable_percent", lendable_percent)
        if nominal_concurrency_shares is not None:
            pulumi.set(__self__, "nominal_concurrency_shares", nominal_concurrency_shares)

    @property
    @pulumi.getter(name="lendablePercent")
    def lendable_percent(self) -> Optional[int]:
        """
        `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels.  This value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.

        LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        """
        return pulumi.get(self, "lendable_percent")

    @property
    @pulumi.getter(name="nominalConcurrencyShares")
    def nominal_concurrency_shares(self) -> Optional[int]:
        """
        `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats nominally reserved for this priority level. This DOES NOT limit the dispatching from this priority level but affects the other priority levels through the borrowing mechanism. The server's concurrency limit (ServerCL) is divided among all the priority levels in proportion to their NCS values:

        NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)

        Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level. This field has a default value of zero.
        """
        return pulumi.get(self, "nominal_concurrency_shares")


@pulumi.output_type
class ExemptPriorityLevelConfigurationPatch(dict):
    """
    ExemptPriorityLevelConfiguration describes the configurable aspects of the handling of exempt requests. In the mandatory exempt configuration object the values in the fields here can be modified by authorized users, unlike the rest of the `spec`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lendablePercent":
            suggest = "lendable_percent"
        elif key == "nominalConcurrencyShares":
            suggest = "nominal_concurrency_shares"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExemptPriorityLevelConfigurationPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExemptPriorityLevelConfigurationPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExemptPriorityLevelConfigurationPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lendable_percent: Optional[int] = None,
                 nominal_concurrency_shares: Optional[int] = None):
        """
        ExemptPriorityLevelConfiguration describes the configurable aspects of the handling of exempt requests. In the mandatory exempt configuration object the values in the fields here can be modified by authorized users, unlike the rest of the `spec`.
        :param int lendable_percent: `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels.  This value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.
               
               LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        :param int nominal_concurrency_shares: `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats nominally reserved for this priority level. This DOES NOT limit the dispatching from this priority level but affects the other priority levels through the borrowing mechanism. The server's concurrency limit (ServerCL) is divided among all the priority levels in proportion to their NCS values:
               
               NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)
               
               Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level. This field has a default value of zero.
        """
        if lendable_percent is not None:
            pulumi.set(__self__, "lendable_percent", lendable_percent)
        if nominal_concurrency_shares is not None:
            pulumi.set(__self__, "nominal_concurrency_shares", nominal_concurrency_shares)

    @property
    @pulumi.getter(name="lendablePercent")
    def lendable_percent(self) -> Optional[int]:
        """
        `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels.  This value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.

        LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        """
        return pulumi.get(self, "lendable_percent")

    @property
    @pulumi.getter(name="nominalConcurrencyShares")
    def nominal_concurrency_shares(self) -> Optional[int]:
        """
        `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats nominally reserved for this priority level. This DOES NOT limit the dispatching from this priority level but affects the other priority levels through the borrowing mechanism. The server's concurrency limit (ServerCL) is divided among all the priority levels in proportion to their NCS values:

        NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)

        Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level. This field has a default value of zero.
        """
        return pulumi.get(self, "nominal_concurrency_shares")


@pulumi.output_type
class FlowDistinguisherMethod(dict):
    """
    FlowDistinguisherMethod specifies the method of a flow distinguisher.
    """
    def __init__(__self__, *,
                 type: str):
        """
        FlowDistinguisherMethod specifies the method of a flow distinguisher.
        :param str type: `type` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace". Required.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        `type` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace". Required.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FlowDistinguisherMethodPatch(dict):
    """
    FlowDistinguisherMethod specifies the method of a flow distinguisher.
    """
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        FlowDistinguisherMethod specifies the method of a flow distinguisher.
        :param str type: `type` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace". Required.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        `type` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace". Required.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FlowSchema(dict):
    """
    FlowSchema defines the schema of a group of flows. Note that a flow is made up of a set of inbound API requests with similar attributes and is identified by a pair of strings: the name of the FlowSchema and a "flow distinguisher".
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.FlowSchemaSpec'] = None,
                 status: Optional['outputs.FlowSchemaStatus'] = None):
        """
        FlowSchema defines the schema of a group of flows. Note that a flow is made up of a set of inbound API requests with similar attributes and is identified by a pair of strings: the name of the FlowSchema and a "flow distinguisher".
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: `metadata` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'FlowSchemaSpecArgs' spec: `spec` is the specification of the desired behavior of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param 'FlowSchemaStatusArgs' status: `status` is the current status of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'flowcontrol.apiserver.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'FlowSchema')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        `metadata` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.FlowSchemaSpec']:
        """
        `spec` is the specification of the desired behavior of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.FlowSchemaStatus']:
        """
        `status` is the current status of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class FlowSchemaCondition(dict):
    """
    FlowSchemaCondition describes conditions for a FlowSchema.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSchemaCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSchemaCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSchemaCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None,
                 status: Optional[str] = None,
                 type: Optional[str] = None):
        """
        FlowSchemaCondition describes conditions for a FlowSchema.
        :param str last_transition_time: `lastTransitionTime` is the last time the condition transitioned from one status to another.
        :param str message: `message` is a human-readable message indicating details about last transition.
        :param str reason: `reason` is a unique, one-word, CamelCase reason for the condition's last transition.
        :param str status: `status` is the status of the condition. Can be True, False, Unknown. Required.
        :param str type: `type` is the type of the condition. Required.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        `lastTransitionTime` is the last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        `message` is a human-readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        `reason` is a unique, one-word, CamelCase reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        `status` is the status of the condition. Can be True, False, Unknown. Required.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        `type` is the type of the condition. Required.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FlowSchemaConditionPatch(dict):
    """
    FlowSchemaCondition describes conditions for a FlowSchema.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSchemaConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSchemaConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSchemaConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None,
                 status: Optional[str] = None,
                 type: Optional[str] = None):
        """
        FlowSchemaCondition describes conditions for a FlowSchema.
        :param str last_transition_time: `lastTransitionTime` is the last time the condition transitioned from one status to another.
        :param str message: `message` is a human-readable message indicating details about last transition.
        :param str reason: `reason` is a unique, one-word, CamelCase reason for the condition's last transition.
        :param str status: `status` is the status of the condition. Can be True, False, Unknown. Required.
        :param str type: `type` is the type of the condition. Required.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        `lastTransitionTime` is the last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        `message` is a human-readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        `reason` is a unique, one-word, CamelCase reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        `status` is the status of the condition. Can be True, False, Unknown. Required.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        `type` is the type of the condition. Required.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FlowSchemaSpec(dict):
    """
    FlowSchemaSpec describes how the FlowSchema's specification looks like.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "priorityLevelConfiguration":
            suggest = "priority_level_configuration"
        elif key == "distinguisherMethod":
            suggest = "distinguisher_method"
        elif key == "matchingPrecedence":
            suggest = "matching_precedence"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSchemaSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSchemaSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSchemaSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 priority_level_configuration: 'outputs.PriorityLevelConfigurationReference',
                 distinguisher_method: Optional['outputs.FlowDistinguisherMethod'] = None,
                 matching_precedence: Optional[int] = None,
                 rules: Optional[Sequence['outputs.PolicyRulesWithSubjects']] = None):
        """
        FlowSchemaSpec describes how the FlowSchema's specification looks like.
        :param 'PriorityLevelConfigurationReferenceArgs' priority_level_configuration: `priorityLevelConfiguration` should reference a PriorityLevelConfiguration in the cluster. If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.
        :param 'FlowDistinguisherMethodArgs' distinguisher_method: `distinguisherMethod` defines how to compute the flow distinguisher for requests that match this schema. `nil` specifies that the distinguisher is disabled and thus will always be the empty string.
        :param int matching_precedence: `matchingPrecedence` is used to choose among the FlowSchemas that match a given request. The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.
        :param Sequence['PolicyRulesWithSubjectsArgs'] rules: `rules` describes which requests will match this flow schema. This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.
        """
        pulumi.set(__self__, "priority_level_configuration", priority_level_configuration)
        if distinguisher_method is not None:
            pulumi.set(__self__, "distinguisher_method", distinguisher_method)
        if matching_precedence is not None:
            pulumi.set(__self__, "matching_precedence", matching_precedence)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="priorityLevelConfiguration")
    def priority_level_configuration(self) -> 'outputs.PriorityLevelConfigurationReference':
        """
        `priorityLevelConfiguration` should reference a PriorityLevelConfiguration in the cluster. If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.
        """
        return pulumi.get(self, "priority_level_configuration")

    @property
    @pulumi.getter(name="distinguisherMethod")
    def distinguisher_method(self) -> Optional['outputs.FlowDistinguisherMethod']:
        """
        `distinguisherMethod` defines how to compute the flow distinguisher for requests that match this schema. `nil` specifies that the distinguisher is disabled and thus will always be the empty string.
        """
        return pulumi.get(self, "distinguisher_method")

    @property
    @pulumi.getter(name="matchingPrecedence")
    def matching_precedence(self) -> Optional[int]:
        """
        `matchingPrecedence` is used to choose among the FlowSchemas that match a given request. The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.
        """
        return pulumi.get(self, "matching_precedence")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.PolicyRulesWithSubjects']]:
        """
        `rules` describes which requests will match this flow schema. This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class FlowSchemaSpecPatch(dict):
    """
    FlowSchemaSpec describes how the FlowSchema's specification looks like.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distinguisherMethod":
            suggest = "distinguisher_method"
        elif key == "matchingPrecedence":
            suggest = "matching_precedence"
        elif key == "priorityLevelConfiguration":
            suggest = "priority_level_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSchemaSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSchemaSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSchemaSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distinguisher_method: Optional['outputs.FlowDistinguisherMethodPatch'] = None,
                 matching_precedence: Optional[int] = None,
                 priority_level_configuration: Optional['outputs.PriorityLevelConfigurationReferencePatch'] = None,
                 rules: Optional[Sequence['outputs.PolicyRulesWithSubjectsPatch']] = None):
        """
        FlowSchemaSpec describes how the FlowSchema's specification looks like.
        :param 'FlowDistinguisherMethodPatchArgs' distinguisher_method: `distinguisherMethod` defines how to compute the flow distinguisher for requests that match this schema. `nil` specifies that the distinguisher is disabled and thus will always be the empty string.
        :param int matching_precedence: `matchingPrecedence` is used to choose among the FlowSchemas that match a given request. The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.
        :param 'PriorityLevelConfigurationReferencePatchArgs' priority_level_configuration: `priorityLevelConfiguration` should reference a PriorityLevelConfiguration in the cluster. If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.
        :param Sequence['PolicyRulesWithSubjectsPatchArgs'] rules: `rules` describes which requests will match this flow schema. This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.
        """
        if distinguisher_method is not None:
            pulumi.set(__self__, "distinguisher_method", distinguisher_method)
        if matching_precedence is not None:
            pulumi.set(__self__, "matching_precedence", matching_precedence)
        if priority_level_configuration is not None:
            pulumi.set(__self__, "priority_level_configuration", priority_level_configuration)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="distinguisherMethod")
    def distinguisher_method(self) -> Optional['outputs.FlowDistinguisherMethodPatch']:
        """
        `distinguisherMethod` defines how to compute the flow distinguisher for requests that match this schema. `nil` specifies that the distinguisher is disabled and thus will always be the empty string.
        """
        return pulumi.get(self, "distinguisher_method")

    @property
    @pulumi.getter(name="matchingPrecedence")
    def matching_precedence(self) -> Optional[int]:
        """
        `matchingPrecedence` is used to choose among the FlowSchemas that match a given request. The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.
        """
        return pulumi.get(self, "matching_precedence")

    @property
    @pulumi.getter(name="priorityLevelConfiguration")
    def priority_level_configuration(self) -> Optional['outputs.PriorityLevelConfigurationReferencePatch']:
        """
        `priorityLevelConfiguration` should reference a PriorityLevelConfiguration in the cluster. If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.
        """
        return pulumi.get(self, "priority_level_configuration")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.PolicyRulesWithSubjectsPatch']]:
        """
        `rules` describes which requests will match this flow schema. This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class FlowSchemaStatus(dict):
    """
    FlowSchemaStatus represents the current state of a FlowSchema.
    """
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.FlowSchemaCondition']] = None):
        """
        FlowSchemaStatus represents the current state of a FlowSchema.
        :param Sequence['FlowSchemaConditionArgs'] conditions: `conditions` is a list of the current states of FlowSchema.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.FlowSchemaCondition']]:
        """
        `conditions` is a list of the current states of FlowSchema.
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class FlowSchemaStatusPatch(dict):
    """
    FlowSchemaStatus represents the current state of a FlowSchema.
    """
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.FlowSchemaConditionPatch']] = None):
        """
        FlowSchemaStatus represents the current state of a FlowSchema.
        :param Sequence['FlowSchemaConditionPatchArgs'] conditions: `conditions` is a list of the current states of FlowSchema.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.FlowSchemaConditionPatch']]:
        """
        `conditions` is a list of the current states of FlowSchema.
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class GroupSubject(dict):
    """
    GroupSubject holds detailed information for group-kind subject.
    """
    def __init__(__self__, *,
                 name: str):
        """
        GroupSubject holds detailed information for group-kind subject.
        :param str name: name is the user group that matches, or "*" to match all user groups. See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name is the user group that matches, or "*" to match all user groups. See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GroupSubjectPatch(dict):
    """
    GroupSubject holds detailed information for group-kind subject.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        GroupSubject holds detailed information for group-kind subject.
        :param str name: name is the user group that matches, or "*" to match all user groups. See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        name is the user group that matches, or "*" to match all user groups. See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LimitResponse(dict):
    """
    LimitResponse defines how to handle requests that can not be executed right now.
    """
    def __init__(__self__, *,
                 type: str,
                 queuing: Optional['outputs.QueuingConfiguration'] = None):
        """
        LimitResponse defines how to handle requests that can not be executed right now.
        :param str type: `type` is "Queue" or "Reject". "Queue" means that requests that can not be executed upon arrival are held in a queue until they can be executed or a queuing limit is reached. "Reject" means that requests that can not be executed upon arrival are rejected. Required.
        :param 'QueuingConfigurationArgs' queuing: `queuing` holds the configuration parameters for queuing. This field may be non-empty only if `type` is `"Queue"`.
        """
        pulumi.set(__self__, "type", type)
        if queuing is not None:
            pulumi.set(__self__, "queuing", queuing)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        `type` is "Queue" or "Reject". "Queue" means that requests that can not be executed upon arrival are held in a queue until they can be executed or a queuing limit is reached. "Reject" means that requests that can not be executed upon arrival are rejected. Required.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def queuing(self) -> Optional['outputs.QueuingConfiguration']:
        """
        `queuing` holds the configuration parameters for queuing. This field may be non-empty only if `type` is `"Queue"`.
        """
        return pulumi.get(self, "queuing")


@pulumi.output_type
class LimitResponsePatch(dict):
    """
    LimitResponse defines how to handle requests that can not be executed right now.
    """
    def __init__(__self__, *,
                 queuing: Optional['outputs.QueuingConfigurationPatch'] = None,
                 type: Optional[str] = None):
        """
        LimitResponse defines how to handle requests that can not be executed right now.
        :param 'QueuingConfigurationPatchArgs' queuing: `queuing` holds the configuration parameters for queuing. This field may be non-empty only if `type` is `"Queue"`.
        :param str type: `type` is "Queue" or "Reject". "Queue" means that requests that can not be executed upon arrival are held in a queue until they can be executed or a queuing limit is reached. "Reject" means that requests that can not be executed upon arrival are rejected. Required.
        """
        if queuing is not None:
            pulumi.set(__self__, "queuing", queuing)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def queuing(self) -> Optional['outputs.QueuingConfigurationPatch']:
        """
        `queuing` holds the configuration parameters for queuing. This field may be non-empty only if `type` is `"Queue"`.
        """
        return pulumi.get(self, "queuing")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        `type` is "Queue" or "Reject". "Queue" means that requests that can not be executed upon arrival are held in a queue until they can be executed or a queuing limit is reached. "Reject" means that requests that can not be executed upon arrival are rejected. Required.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LimitedPriorityLevelConfiguration(dict):
    """
    LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits. It addresses two issues:
      - How are requests for this priority level limited?
      - What should be done with requests that exceed the limit?
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "borrowingLimitPercent":
            suggest = "borrowing_limit_percent"
        elif key == "lendablePercent":
            suggest = "lendable_percent"
        elif key == "limitResponse":
            suggest = "limit_response"
        elif key == "nominalConcurrencyShares":
            suggest = "nominal_concurrency_shares"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LimitedPriorityLevelConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LimitedPriorityLevelConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LimitedPriorityLevelConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 borrowing_limit_percent: Optional[int] = None,
                 lendable_percent: Optional[int] = None,
                 limit_response: Optional['outputs.LimitResponse'] = None,
                 nominal_concurrency_shares: Optional[int] = None):
        """
        LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits. It addresses two issues:
          - How are requests for this priority level limited?
          - What should be done with requests that exceed the limit?
        :param int borrowing_limit_percent: `borrowingLimitPercent`, if present, configures a limit on how many seats this priority level can borrow from other priority levels. The limit is known as this level's BorrowingConcurrencyLimit (BorrowingCL) and is a limit on the total number of seats that this level may borrow at any one time. This field holds the ratio of that limit to the level's nominal concurrency limit. When this field is non-nil, it must hold a non-negative integer and the limit is calculated as follows.
               
               BorrowingCL(i) = round( NominalCL(i) * borrowingLimitPercent(i)/100.0 )
               
               The value of this field can be more than 100, implying that this priority level can borrow a number of seats that is greater than its own nominal concurrency limit (NominalCL). When this field is left `nil`, the limit is effectively infinite.
        :param int lendable_percent: `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels. The value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.
               
               LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        :param 'LimitResponseArgs' limit_response: `limitResponse` indicates what to do with requests that can not be executed right now
        :param int nominal_concurrency_shares: `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats available at this priority level. This is used both for requests dispatched from this priority level as well as requests dispatched from other priority levels borrowing seats from this level. The server's concurrency limit (ServerCL) is divided among the Limited priority levels in proportion to their NCS values:
               
               NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)
               
               Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level.
               
               If not specified, this field defaults to a value of 30.
               
               Setting this field to zero supports the construction of a "jail" for this priority level that is used to hold some request(s)
        """
        if borrowing_limit_percent is not None:
            pulumi.set(__self__, "borrowing_limit_percent", borrowing_limit_percent)
        if lendable_percent is not None:
            pulumi.set(__self__, "lendable_percent", lendable_percent)
        if limit_response is not None:
            pulumi.set(__self__, "limit_response", limit_response)
        if nominal_concurrency_shares is not None:
            pulumi.set(__self__, "nominal_concurrency_shares", nominal_concurrency_shares)

    @property
    @pulumi.getter(name="borrowingLimitPercent")
    def borrowing_limit_percent(self) -> Optional[int]:
        """
        `borrowingLimitPercent`, if present, configures a limit on how many seats this priority level can borrow from other priority levels. The limit is known as this level's BorrowingConcurrencyLimit (BorrowingCL) and is a limit on the total number of seats that this level may borrow at any one time. This field holds the ratio of that limit to the level's nominal concurrency limit. When this field is non-nil, it must hold a non-negative integer and the limit is calculated as follows.

        BorrowingCL(i) = round( NominalCL(i) * borrowingLimitPercent(i)/100.0 )

        The value of this field can be more than 100, implying that this priority level can borrow a number of seats that is greater than its own nominal concurrency limit (NominalCL). When this field is left `nil`, the limit is effectively infinite.
        """
        return pulumi.get(self, "borrowing_limit_percent")

    @property
    @pulumi.getter(name="lendablePercent")
    def lendable_percent(self) -> Optional[int]:
        """
        `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels. The value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.

        LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        """
        return pulumi.get(self, "lendable_percent")

    @property
    @pulumi.getter(name="limitResponse")
    def limit_response(self) -> Optional['outputs.LimitResponse']:
        """
        `limitResponse` indicates what to do with requests that can not be executed right now
        """
        return pulumi.get(self, "limit_response")

    @property
    @pulumi.getter(name="nominalConcurrencyShares")
    def nominal_concurrency_shares(self) -> Optional[int]:
        """
        `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats available at this priority level. This is used both for requests dispatched from this priority level as well as requests dispatched from other priority levels borrowing seats from this level. The server's concurrency limit (ServerCL) is divided among the Limited priority levels in proportion to their NCS values:

        NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)

        Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level.

        If not specified, this field defaults to a value of 30.

        Setting this field to zero supports the construction of a "jail" for this priority level that is used to hold some request(s)
        """
        return pulumi.get(self, "nominal_concurrency_shares")


@pulumi.output_type
class LimitedPriorityLevelConfigurationPatch(dict):
    """
    LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits. It addresses two issues:
      - How are requests for this priority level limited?
      - What should be done with requests that exceed the limit?
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "borrowingLimitPercent":
            suggest = "borrowing_limit_percent"
        elif key == "lendablePercent":
            suggest = "lendable_percent"
        elif key == "limitResponse":
            suggest = "limit_response"
        elif key == "nominalConcurrencyShares":
            suggest = "nominal_concurrency_shares"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LimitedPriorityLevelConfigurationPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LimitedPriorityLevelConfigurationPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LimitedPriorityLevelConfigurationPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 borrowing_limit_percent: Optional[int] = None,
                 lendable_percent: Optional[int] = None,
                 limit_response: Optional['outputs.LimitResponsePatch'] = None,
                 nominal_concurrency_shares: Optional[int] = None):
        """
        LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits. It addresses two issues:
          - How are requests for this priority level limited?
          - What should be done with requests that exceed the limit?
        :param int borrowing_limit_percent: `borrowingLimitPercent`, if present, configures a limit on how many seats this priority level can borrow from other priority levels. The limit is known as this level's BorrowingConcurrencyLimit (BorrowingCL) and is a limit on the total number of seats that this level may borrow at any one time. This field holds the ratio of that limit to the level's nominal concurrency limit. When this field is non-nil, it must hold a non-negative integer and the limit is calculated as follows.
               
               BorrowingCL(i) = round( NominalCL(i) * borrowingLimitPercent(i)/100.0 )
               
               The value of this field can be more than 100, implying that this priority level can borrow a number of seats that is greater than its own nominal concurrency limit (NominalCL). When this field is left `nil`, the limit is effectively infinite.
        :param int lendable_percent: `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels. The value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.
               
               LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        :param 'LimitResponsePatchArgs' limit_response: `limitResponse` indicates what to do with requests that can not be executed right now
        :param int nominal_concurrency_shares: `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats available at this priority level. This is used both for requests dispatched from this priority level as well as requests dispatched from other priority levels borrowing seats from this level. The server's concurrency limit (ServerCL) is divided among the Limited priority levels in proportion to their NCS values:
               
               NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)
               
               Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level.
               
               If not specified, this field defaults to a value of 30.
               
               Setting this field to zero supports the construction of a "jail" for this priority level that is used to hold some request(s)
        """
        if borrowing_limit_percent is not None:
            pulumi.set(__self__, "borrowing_limit_percent", borrowing_limit_percent)
        if lendable_percent is not None:
            pulumi.set(__self__, "lendable_percent", lendable_percent)
        if limit_response is not None:
            pulumi.set(__self__, "limit_response", limit_response)
        if nominal_concurrency_shares is not None:
            pulumi.set(__self__, "nominal_concurrency_shares", nominal_concurrency_shares)

    @property
    @pulumi.getter(name="borrowingLimitPercent")
    def borrowing_limit_percent(self) -> Optional[int]:
        """
        `borrowingLimitPercent`, if present, configures a limit on how many seats this priority level can borrow from other priority levels. The limit is known as this level's BorrowingConcurrencyLimit (BorrowingCL) and is a limit on the total number of seats that this level may borrow at any one time. This field holds the ratio of that limit to the level's nominal concurrency limit. When this field is non-nil, it must hold a non-negative integer and the limit is calculated as follows.

        BorrowingCL(i) = round( NominalCL(i) * borrowingLimitPercent(i)/100.0 )

        The value of this field can be more than 100, implying that this priority level can borrow a number of seats that is greater than its own nominal concurrency limit (NominalCL). When this field is left `nil`, the limit is effectively infinite.
        """
        return pulumi.get(self, "borrowing_limit_percent")

    @property
    @pulumi.getter(name="lendablePercent")
    def lendable_percent(self) -> Optional[int]:
        """
        `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels. The value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.

        LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        """
        return pulumi.get(self, "lendable_percent")

    @property
    @pulumi.getter(name="limitResponse")
    def limit_response(self) -> Optional['outputs.LimitResponsePatch']:
        """
        `limitResponse` indicates what to do with requests that can not be executed right now
        """
        return pulumi.get(self, "limit_response")

    @property
    @pulumi.getter(name="nominalConcurrencyShares")
    def nominal_concurrency_shares(self) -> Optional[int]:
        """
        `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats available at this priority level. This is used both for requests dispatched from this priority level as well as requests dispatched from other priority levels borrowing seats from this level. The server's concurrency limit (ServerCL) is divided among the Limited priority levels in proportion to their NCS values:

        NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)

        Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level.

        If not specified, this field defaults to a value of 30.

        Setting this field to zero supports the construction of a "jail" for this priority level that is used to hold some request(s)
        """
        return pulumi.get(self, "nominal_concurrency_shares")


@pulumi.output_type
class NonResourcePolicyRule(dict):
    """
    NonResourcePolicyRule is a predicate that matches non-resource requests according to their verb and the target non-resource URL. A NonResourcePolicyRule matches a request if and only if both (a) at least one member of verbs matches the request and (b) at least one member of nonResourceURLs matches the request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nonResourceURLs":
            suggest = "non_resource_urls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NonResourcePolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NonResourcePolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NonResourcePolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 non_resource_urls: Sequence[str],
                 verbs: Sequence[str]):
        """
        NonResourcePolicyRule is a predicate that matches non-resource requests according to their verb and the target non-resource URL. A NonResourcePolicyRule matches a request if and only if both (a) at least one member of verbs matches the request and (b) at least one member of nonResourceURLs matches the request.
        :param Sequence[str] non_resource_urls: `nonResourceURLs` is a set of url prefixes that a user should have access to and may not be empty. For example:
                 - "/healthz" is legal
                 - "/hea*" is illegal
                 - "/hea" is legal but matches nothing
                 - "/hea/*" also matches nothing
                 - "/healthz/*" matches all per-component health checks.
               "*" matches all non-resource urls. if it is present, it must be the only entry. Required.
        :param Sequence[str] verbs: `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs. If it is present, it must be the only entry. Required.
        """
        pulumi.set(__self__, "non_resource_urls", non_resource_urls)
        pulumi.set(__self__, "verbs", verbs)

    @property
    @pulumi.getter(name="nonResourceURLs")
    def non_resource_urls(self) -> Sequence[str]:
        """
        `nonResourceURLs` is a set of url prefixes that a user should have access to and may not be empty. For example:
          - "/healthz" is legal
          - "/hea*" is illegal
          - "/hea" is legal but matches nothing
          - "/hea/*" also matches nothing
          - "/healthz/*" matches all per-component health checks.
        "*" matches all non-resource urls. if it is present, it must be the only entry. Required.
        """
        return pulumi.get(self, "non_resource_urls")

    @property
    @pulumi.getter
    def verbs(self) -> Sequence[str]:
        """
        `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs. If it is present, it must be the only entry. Required.
        """
        return pulumi.get(self, "verbs")


@pulumi.output_type
class NonResourcePolicyRulePatch(dict):
    """
    NonResourcePolicyRule is a predicate that matches non-resource requests according to their verb and the target non-resource URL. A NonResourcePolicyRule matches a request if and only if both (a) at least one member of verbs matches the request and (b) at least one member of nonResourceURLs matches the request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nonResourceURLs":
            suggest = "non_resource_urls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NonResourcePolicyRulePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NonResourcePolicyRulePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NonResourcePolicyRulePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 non_resource_urls: Optional[Sequence[str]] = None,
                 verbs: Optional[Sequence[str]] = None):
        """
        NonResourcePolicyRule is a predicate that matches non-resource requests according to their verb and the target non-resource URL. A NonResourcePolicyRule matches a request if and only if both (a) at least one member of verbs matches the request and (b) at least one member of nonResourceURLs matches the request.
        :param Sequence[str] non_resource_urls: `nonResourceURLs` is a set of url prefixes that a user should have access to and may not be empty. For example:
                 - "/healthz" is legal
                 - "/hea*" is illegal
                 - "/hea" is legal but matches nothing
                 - "/hea/*" also matches nothing
                 - "/healthz/*" matches all per-component health checks.
               "*" matches all non-resource urls. if it is present, it must be the only entry. Required.
        :param Sequence[str] verbs: `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs. If it is present, it must be the only entry. Required.
        """
        if non_resource_urls is not None:
            pulumi.set(__self__, "non_resource_urls", non_resource_urls)
        if verbs is not None:
            pulumi.set(__self__, "verbs", verbs)

    @property
    @pulumi.getter(name="nonResourceURLs")
    def non_resource_urls(self) -> Optional[Sequence[str]]:
        """
        `nonResourceURLs` is a set of url prefixes that a user should have access to and may not be empty. For example:
          - "/healthz" is legal
          - "/hea*" is illegal
          - "/hea" is legal but matches nothing
          - "/hea/*" also matches nothing
          - "/healthz/*" matches all per-component health checks.
        "*" matches all non-resource urls. if it is present, it must be the only entry. Required.
        """
        return pulumi.get(self, "non_resource_urls")

    @property
    @pulumi.getter
    def verbs(self) -> Optional[Sequence[str]]:
        """
        `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs. If it is present, it must be the only entry. Required.
        """
        return pulumi.get(self, "verbs")


@pulumi.output_type
class PolicyRulesWithSubjects(dict):
    """
    PolicyRulesWithSubjects prescribes a test that applies to a request to an apiserver. The test considers the subject making the request, the verb being requested, and the resource to be acted upon. This PolicyRulesWithSubjects matches a request if and only if both (a) at least one member of subjects matches the request and (b) at least one member of resourceRules or nonResourceRules matches the request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nonResourceRules":
            suggest = "non_resource_rules"
        elif key == "resourceRules":
            suggest = "resource_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyRulesWithSubjects. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyRulesWithSubjects.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyRulesWithSubjects.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subjects: Sequence['outputs.Subject'],
                 non_resource_rules: Optional[Sequence['outputs.NonResourcePolicyRule']] = None,
                 resource_rules: Optional[Sequence['outputs.ResourcePolicyRule']] = None):
        """
        PolicyRulesWithSubjects prescribes a test that applies to a request to an apiserver. The test considers the subject making the request, the verb being requested, and the resource to be acted upon. This PolicyRulesWithSubjects matches a request if and only if both (a) at least one member of subjects matches the request and (b) at least one member of resourceRules or nonResourceRules matches the request.
        :param Sequence['SubjectArgs'] subjects: subjects is the list of normal user, serviceaccount, or group that this rule cares about. There must be at least one member in this slice. A slice that includes both the system:authenticated and system:unauthenticated user groups matches every request. Required.
        :param Sequence['NonResourcePolicyRuleArgs'] non_resource_rules: `nonResourceRules` is a list of NonResourcePolicyRules that identify matching requests according to their verb and the target non-resource URL.
        :param Sequence['ResourcePolicyRuleArgs'] resource_rules: `resourceRules` is a slice of ResourcePolicyRules that identify matching requests according to their verb and the target resource. At least one of `resourceRules` and `nonResourceRules` has to be non-empty.
        """
        pulumi.set(__self__, "subjects", subjects)
        if non_resource_rules is not None:
            pulumi.set(__self__, "non_resource_rules", non_resource_rules)
        if resource_rules is not None:
            pulumi.set(__self__, "resource_rules", resource_rules)

    @property
    @pulumi.getter
    def subjects(self) -> Sequence['outputs.Subject']:
        """
        subjects is the list of normal user, serviceaccount, or group that this rule cares about. There must be at least one member in this slice. A slice that includes both the system:authenticated and system:unauthenticated user groups matches every request. Required.
        """
        return pulumi.get(self, "subjects")

    @property
    @pulumi.getter(name="nonResourceRules")
    def non_resource_rules(self) -> Optional[Sequence['outputs.NonResourcePolicyRule']]:
        """
        `nonResourceRules` is a list of NonResourcePolicyRules that identify matching requests according to their verb and the target non-resource URL.
        """
        return pulumi.get(self, "non_resource_rules")

    @property
    @pulumi.getter(name="resourceRules")
    def resource_rules(self) -> Optional[Sequence['outputs.ResourcePolicyRule']]:
        """
        `resourceRules` is a slice of ResourcePolicyRules that identify matching requests according to their verb and the target resource. At least one of `resourceRules` and `nonResourceRules` has to be non-empty.
        """
        return pulumi.get(self, "resource_rules")


@pulumi.output_type
class PolicyRulesWithSubjectsPatch(dict):
    """
    PolicyRulesWithSubjects prescribes a test that applies to a request to an apiserver. The test considers the subject making the request, the verb being requested, and the resource to be acted upon. This PolicyRulesWithSubjects matches a request if and only if both (a) at least one member of subjects matches the request and (b) at least one member of resourceRules or nonResourceRules matches the request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nonResourceRules":
            suggest = "non_resource_rules"
        elif key == "resourceRules":
            suggest = "resource_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyRulesWithSubjectsPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyRulesWithSubjectsPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyRulesWithSubjectsPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 non_resource_rules: Optional[Sequence['outputs.NonResourcePolicyRulePatch']] = None,
                 resource_rules: Optional[Sequence['outputs.ResourcePolicyRulePatch']] = None,
                 subjects: Optional[Sequence['outputs.SubjectPatch']] = None):
        """
        PolicyRulesWithSubjects prescribes a test that applies to a request to an apiserver. The test considers the subject making the request, the verb being requested, and the resource to be acted upon. This PolicyRulesWithSubjects matches a request if and only if both (a) at least one member of subjects matches the request and (b) at least one member of resourceRules or nonResourceRules matches the request.
        :param Sequence['NonResourcePolicyRulePatchArgs'] non_resource_rules: `nonResourceRules` is a list of NonResourcePolicyRules that identify matching requests according to their verb and the target non-resource URL.
        :param Sequence['ResourcePolicyRulePatchArgs'] resource_rules: `resourceRules` is a slice of ResourcePolicyRules that identify matching requests according to their verb and the target resource. At least one of `resourceRules` and `nonResourceRules` has to be non-empty.
        :param Sequence['SubjectPatchArgs'] subjects: subjects is the list of normal user, serviceaccount, or group that this rule cares about. There must be at least one member in this slice. A slice that includes both the system:authenticated and system:unauthenticated user groups matches every request. Required.
        """
        if non_resource_rules is not None:
            pulumi.set(__self__, "non_resource_rules", non_resource_rules)
        if resource_rules is not None:
            pulumi.set(__self__, "resource_rules", resource_rules)
        if subjects is not None:
            pulumi.set(__self__, "subjects", subjects)

    @property
    @pulumi.getter(name="nonResourceRules")
    def non_resource_rules(self) -> Optional[Sequence['outputs.NonResourcePolicyRulePatch']]:
        """
        `nonResourceRules` is a list of NonResourcePolicyRules that identify matching requests according to their verb and the target non-resource URL.
        """
        return pulumi.get(self, "non_resource_rules")

    @property
    @pulumi.getter(name="resourceRules")
    def resource_rules(self) -> Optional[Sequence['outputs.ResourcePolicyRulePatch']]:
        """
        `resourceRules` is a slice of ResourcePolicyRules that identify matching requests according to their verb and the target resource. At least one of `resourceRules` and `nonResourceRules` has to be non-empty.
        """
        return pulumi.get(self, "resource_rules")

    @property
    @pulumi.getter
    def subjects(self) -> Optional[Sequence['outputs.SubjectPatch']]:
        """
        subjects is the list of normal user, serviceaccount, or group that this rule cares about. There must be at least one member in this slice. A slice that includes both the system:authenticated and system:unauthenticated user groups matches every request. Required.
        """
        return pulumi.get(self, "subjects")


@pulumi.output_type
class PriorityLevelConfiguration(dict):
    """
    PriorityLevelConfiguration represents the configuration of a priority level.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PriorityLevelConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PriorityLevelConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PriorityLevelConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.PriorityLevelConfigurationSpec'] = None,
                 status: Optional['outputs.PriorityLevelConfigurationStatus'] = None):
        """
        PriorityLevelConfiguration represents the configuration of a priority level.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: `metadata` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'PriorityLevelConfigurationSpecArgs' spec: `spec` is the specification of the desired behavior of a "request-priority". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param 'PriorityLevelConfigurationStatusArgs' status: `status` is the current status of a "request-priority". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'flowcontrol.apiserver.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'PriorityLevelConfiguration')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        `metadata` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.PriorityLevelConfigurationSpec']:
        """
        `spec` is the specification of the desired behavior of a "request-priority". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.PriorityLevelConfigurationStatus']:
        """
        `status` is the current status of a "request-priority". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PriorityLevelConfigurationCondition(dict):
    """
    PriorityLevelConfigurationCondition defines the condition of priority level.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PriorityLevelConfigurationCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PriorityLevelConfigurationCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PriorityLevelConfigurationCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None,
                 status: Optional[str] = None,
                 type: Optional[str] = None):
        """
        PriorityLevelConfigurationCondition defines the condition of priority level.
        :param str last_transition_time: `lastTransitionTime` is the last time the condition transitioned from one status to another.
        :param str message: `message` is a human-readable message indicating details about last transition.
        :param str reason: `reason` is a unique, one-word, CamelCase reason for the condition's last transition.
        :param str status: `status` is the status of the condition. Can be True, False, Unknown. Required.
        :param str type: `type` is the type of the condition. Required.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        `lastTransitionTime` is the last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        `message` is a human-readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        `reason` is a unique, one-word, CamelCase reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        `status` is the status of the condition. Can be True, False, Unknown. Required.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        `type` is the type of the condition. Required.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PriorityLevelConfigurationConditionPatch(dict):
    """
    PriorityLevelConfigurationCondition defines the condition of priority level.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PriorityLevelConfigurationConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PriorityLevelConfigurationConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PriorityLevelConfigurationConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None,
                 status: Optional[str] = None,
                 type: Optional[str] = None):
        """
        PriorityLevelConfigurationCondition defines the condition of priority level.
        :param str last_transition_time: `lastTransitionTime` is the last time the condition transitioned from one status to another.
        :param str message: `message` is a human-readable message indicating details about last transition.
        :param str reason: `reason` is a unique, one-word, CamelCase reason for the condition's last transition.
        :param str status: `status` is the status of the condition. Can be True, False, Unknown. Required.
        :param str type: `type` is the type of the condition. Required.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        `lastTransitionTime` is the last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        `message` is a human-readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        `reason` is a unique, one-word, CamelCase reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        `status` is the status of the condition. Can be True, False, Unknown. Required.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        `type` is the type of the condition. Required.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PriorityLevelConfigurationReference(dict):
    """
    PriorityLevelConfigurationReference contains information that points to the "request-priority" being used.
    """
    def __init__(__self__, *,
                 name: str):
        """
        PriorityLevelConfigurationReference contains information that points to the "request-priority" being used.
        :param str name: `name` is the name of the priority level configuration being referenced Required.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `name` is the name of the priority level configuration being referenced Required.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PriorityLevelConfigurationReferencePatch(dict):
    """
    PriorityLevelConfigurationReference contains information that points to the "request-priority" being used.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        PriorityLevelConfigurationReference contains information that points to the "request-priority" being used.
        :param str name: `name` is the name of the priority level configuration being referenced Required.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        `name` is the name of the priority level configuration being referenced Required.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PriorityLevelConfigurationSpec(dict):
    """
    PriorityLevelConfigurationSpec specifies the configuration of a priority level.
    """
    def __init__(__self__, *,
                 type: str,
                 exempt: Optional['outputs.ExemptPriorityLevelConfiguration'] = None,
                 limited: Optional['outputs.LimitedPriorityLevelConfiguration'] = None):
        """
        PriorityLevelConfigurationSpec specifies the configuration of a priority level.
        :param str type: `type` indicates whether this priority level is subject to limitation on request execution.  A value of `"Exempt"` means that requests of this priority level are not subject to a limit (and thus are never queued) and do not detract from the capacity made available to other priority levels.  A value of `"Limited"` means that (a) requests of this priority level _are_ subject to limits and (b) some of the server's limited capacity is made available exclusively to this priority level. Required.
        :param 'ExemptPriorityLevelConfigurationArgs' exempt: `exempt` specifies how requests are handled for an exempt priority level. This field MUST be empty if `type` is `"Limited"`. This field MAY be non-empty if `type` is `"Exempt"`. If empty and `type` is `"Exempt"` then the default values for `ExemptPriorityLevelConfiguration` apply.
        :param 'LimitedPriorityLevelConfigurationArgs' limited: `limited` specifies how requests are handled for a Limited priority level. This field must be non-empty if and only if `type` is `"Limited"`.
        """
        pulumi.set(__self__, "type", type)
        if exempt is not None:
            pulumi.set(__self__, "exempt", exempt)
        if limited is not None:
            pulumi.set(__self__, "limited", limited)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        `type` indicates whether this priority level is subject to limitation on request execution.  A value of `"Exempt"` means that requests of this priority level are not subject to a limit (and thus are never queued) and do not detract from the capacity made available to other priority levels.  A value of `"Limited"` means that (a) requests of this priority level _are_ subject to limits and (b) some of the server's limited capacity is made available exclusively to this priority level. Required.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def exempt(self) -> Optional['outputs.ExemptPriorityLevelConfiguration']:
        """
        `exempt` specifies how requests are handled for an exempt priority level. This field MUST be empty if `type` is `"Limited"`. This field MAY be non-empty if `type` is `"Exempt"`. If empty and `type` is `"Exempt"` then the default values for `ExemptPriorityLevelConfiguration` apply.
        """
        return pulumi.get(self, "exempt")

    @property
    @pulumi.getter
    def limited(self) -> Optional['outputs.LimitedPriorityLevelConfiguration']:
        """
        `limited` specifies how requests are handled for a Limited priority level. This field must be non-empty if and only if `type` is `"Limited"`.
        """
        return pulumi.get(self, "limited")


@pulumi.output_type
class PriorityLevelConfigurationSpecPatch(dict):
    """
    PriorityLevelConfigurationSpec specifies the configuration of a priority level.
    """
    def __init__(__self__, *,
                 exempt: Optional['outputs.ExemptPriorityLevelConfigurationPatch'] = None,
                 limited: Optional['outputs.LimitedPriorityLevelConfigurationPatch'] = None,
                 type: Optional[str] = None):
        """
        PriorityLevelConfigurationSpec specifies the configuration of a priority level.
        :param 'ExemptPriorityLevelConfigurationPatchArgs' exempt: `exempt` specifies how requests are handled for an exempt priority level. This field MUST be empty if `type` is `"Limited"`. This field MAY be non-empty if `type` is `"Exempt"`. If empty and `type` is `"Exempt"` then the default values for `ExemptPriorityLevelConfiguration` apply.
        :param 'LimitedPriorityLevelConfigurationPatchArgs' limited: `limited` specifies how requests are handled for a Limited priority level. This field must be non-empty if and only if `type` is `"Limited"`.
        :param str type: `type` indicates whether this priority level is subject to limitation on request execution.  A value of `"Exempt"` means that requests of this priority level are not subject to a limit (and thus are never queued) and do not detract from the capacity made available to other priority levels.  A value of `"Limited"` means that (a) requests of this priority level _are_ subject to limits and (b) some of the server's limited capacity is made available exclusively to this priority level. Required.
        """
        if exempt is not None:
            pulumi.set(__self__, "exempt", exempt)
        if limited is not None:
            pulumi.set(__self__, "limited", limited)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def exempt(self) -> Optional['outputs.ExemptPriorityLevelConfigurationPatch']:
        """
        `exempt` specifies how requests are handled for an exempt priority level. This field MUST be empty if `type` is `"Limited"`. This field MAY be non-empty if `type` is `"Exempt"`. If empty and `type` is `"Exempt"` then the default values for `ExemptPriorityLevelConfiguration` apply.
        """
        return pulumi.get(self, "exempt")

    @property
    @pulumi.getter
    def limited(self) -> Optional['outputs.LimitedPriorityLevelConfigurationPatch']:
        """
        `limited` specifies how requests are handled for a Limited priority level. This field must be non-empty if and only if `type` is `"Limited"`.
        """
        return pulumi.get(self, "limited")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        `type` indicates whether this priority level is subject to limitation on request execution.  A value of `"Exempt"` means that requests of this priority level are not subject to a limit (and thus are never queued) and do not detract from the capacity made available to other priority levels.  A value of `"Limited"` means that (a) requests of this priority level _are_ subject to limits and (b) some of the server's limited capacity is made available exclusively to this priority level. Required.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PriorityLevelConfigurationStatus(dict):
    """
    PriorityLevelConfigurationStatus represents the current state of a "request-priority".
    """
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.PriorityLevelConfigurationCondition']] = None):
        """
        PriorityLevelConfigurationStatus represents the current state of a "request-priority".
        :param Sequence['PriorityLevelConfigurationConditionArgs'] conditions: `conditions` is the current state of "request-priority".
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.PriorityLevelConfigurationCondition']]:
        """
        `conditions` is the current state of "request-priority".
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class PriorityLevelConfigurationStatusPatch(dict):
    """
    PriorityLevelConfigurationStatus represents the current state of a "request-priority".
    """
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.PriorityLevelConfigurationConditionPatch']] = None):
        """
        PriorityLevelConfigurationStatus represents the current state of a "request-priority".
        :param Sequence['PriorityLevelConfigurationConditionPatchArgs'] conditions: `conditions` is the current state of "request-priority".
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.PriorityLevelConfigurationConditionPatch']]:
        """
        `conditions` is the current state of "request-priority".
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class QueuingConfiguration(dict):
    """
    QueuingConfiguration holds the configuration parameters for queuing
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "handSize":
            suggest = "hand_size"
        elif key == "queueLengthLimit":
            suggest = "queue_length_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueuingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueuingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueuingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hand_size: Optional[int] = None,
                 queue_length_limit: Optional[int] = None,
                 queues: Optional[int] = None):
        """
        QueuingConfiguration holds the configuration parameters for queuing
        :param int hand_size: `handSize` is a small positive number that configures the shuffle sharding of requests into queues.  When enqueuing a request at this priority level the request's flow identifier (a string pair) is hashed and the hash value is used to shuffle the list of queues and deal a hand of the size specified here.  The request is put into one of the shortest queues in that hand. `handSize` must be no larger than `queues`, and should be significantly smaller (so that a few heavy flows do not saturate most of the queues).  See the user-facing documentation for more extensive guidance on setting this field.  This field has a default value of 8.
        :param int queue_length_limit: `queueLengthLimit` is the maximum number of requests allowed to be waiting in a given queue of this priority level at a time; excess requests are rejected.  This value must be positive.  If not specified, it will be defaulted to 50.
        :param int queues: `queues` is the number of queues for this priority level. The queues exist independently at each apiserver. The value must be positive.  Setting it to 1 effectively precludes shufflesharding and thus makes the distinguisher method of associated flow schemas irrelevant.  This field has a default value of 64.
        """
        if hand_size is not None:
            pulumi.set(__self__, "hand_size", hand_size)
        if queue_length_limit is not None:
            pulumi.set(__self__, "queue_length_limit", queue_length_limit)
        if queues is not None:
            pulumi.set(__self__, "queues", queues)

    @property
    @pulumi.getter(name="handSize")
    def hand_size(self) -> Optional[int]:
        """
        `handSize` is a small positive number that configures the shuffle sharding of requests into queues.  When enqueuing a request at this priority level the request's flow identifier (a string pair) is hashed and the hash value is used to shuffle the list of queues and deal a hand of the size specified here.  The request is put into one of the shortest queues in that hand. `handSize` must be no larger than `queues`, and should be significantly smaller (so that a few heavy flows do not saturate most of the queues).  See the user-facing documentation for more extensive guidance on setting this field.  This field has a default value of 8.
        """
        return pulumi.get(self, "hand_size")

    @property
    @pulumi.getter(name="queueLengthLimit")
    def queue_length_limit(self) -> Optional[int]:
        """
        `queueLengthLimit` is the maximum number of requests allowed to be waiting in a given queue of this priority level at a time; excess requests are rejected.  This value must be positive.  If not specified, it will be defaulted to 50.
        """
        return pulumi.get(self, "queue_length_limit")

    @property
    @pulumi.getter
    def queues(self) -> Optional[int]:
        """
        `queues` is the number of queues for this priority level. The queues exist independently at each apiserver. The value must be positive.  Setting it to 1 effectively precludes shufflesharding and thus makes the distinguisher method of associated flow schemas irrelevant.  This field has a default value of 64.
        """
        return pulumi.get(self, "queues")


@pulumi.output_type
class QueuingConfigurationPatch(dict):
    """
    QueuingConfiguration holds the configuration parameters for queuing
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "handSize":
            suggest = "hand_size"
        elif key == "queueLengthLimit":
            suggest = "queue_length_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueuingConfigurationPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueuingConfigurationPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueuingConfigurationPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hand_size: Optional[int] = None,
                 queue_length_limit: Optional[int] = None,
                 queues: Optional[int] = None):
        """
        QueuingConfiguration holds the configuration parameters for queuing
        :param int hand_size: `handSize` is a small positive number that configures the shuffle sharding of requests into queues.  When enqueuing a request at this priority level the request's flow identifier (a string pair) is hashed and the hash value is used to shuffle the list of queues and deal a hand of the size specified here.  The request is put into one of the shortest queues in that hand. `handSize` must be no larger than `queues`, and should be significantly smaller (so that a few heavy flows do not saturate most of the queues).  See the user-facing documentation for more extensive guidance on setting this field.  This field has a default value of 8.
        :param int queue_length_limit: `queueLengthLimit` is the maximum number of requests allowed to be waiting in a given queue of this priority level at a time; excess requests are rejected.  This value must be positive.  If not specified, it will be defaulted to 50.
        :param int queues: `queues` is the number of queues for this priority level. The queues exist independently at each apiserver. The value must be positive.  Setting it to 1 effectively precludes shufflesharding and thus makes the distinguisher method of associated flow schemas irrelevant.  This field has a default value of 64.
        """
        if hand_size is not None:
            pulumi.set(__self__, "hand_size", hand_size)
        if queue_length_limit is not None:
            pulumi.set(__self__, "queue_length_limit", queue_length_limit)
        if queues is not None:
            pulumi.set(__self__, "queues", queues)

    @property
    @pulumi.getter(name="handSize")
    def hand_size(self) -> Optional[int]:
        """
        `handSize` is a small positive number that configures the shuffle sharding of requests into queues.  When enqueuing a request at this priority level the request's flow identifier (a string pair) is hashed and the hash value is used to shuffle the list of queues and deal a hand of the size specified here.  The request is put into one of the shortest queues in that hand. `handSize` must be no larger than `queues`, and should be significantly smaller (so that a few heavy flows do not saturate most of the queues).  See the user-facing documentation for more extensive guidance on setting this field.  This field has a default value of 8.
        """
        return pulumi.get(self, "hand_size")

    @property
    @pulumi.getter(name="queueLengthLimit")
    def queue_length_limit(self) -> Optional[int]:
        """
        `queueLengthLimit` is the maximum number of requests allowed to be waiting in a given queue of this priority level at a time; excess requests are rejected.  This value must be positive.  If not specified, it will be defaulted to 50.
        """
        return pulumi.get(self, "queue_length_limit")

    @property
    @pulumi.getter
    def queues(self) -> Optional[int]:
        """
        `queues` is the number of queues for this priority level. The queues exist independently at each apiserver. The value must be positive.  Setting it to 1 effectively precludes shufflesharding and thus makes the distinguisher method of associated flow schemas irrelevant.  This field has a default value of 64.
        """
        return pulumi.get(self, "queues")


@pulumi.output_type
class ResourcePolicyRule(dict):
    """
    ResourcePolicyRule is a predicate that matches some resource requests, testing the request's verb and the target resource. A ResourcePolicyRule matches a resource request if and only if: (a) at least one member of verbs matches the request, (b) at least one member of apiGroups matches the request, (c) at least one member of resources matches the request, and (d) either (d1) the request does not specify a namespace (i.e., `Namespace==""`) and clusterScope is true or (d2) the request specifies a namespace and least one member of namespaces matches the request's namespace.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroups":
            suggest = "api_groups"
        elif key == "clusterScope":
            suggest = "cluster_scope"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_groups: Sequence[str],
                 resources: Sequence[str],
                 verbs: Sequence[str],
                 cluster_scope: Optional[bool] = None,
                 namespaces: Optional[Sequence[str]] = None):
        """
        ResourcePolicyRule is a predicate that matches some resource requests, testing the request's verb and the target resource. A ResourcePolicyRule matches a resource request if and only if: (a) at least one member of verbs matches the request, (b) at least one member of apiGroups matches the request, (c) at least one member of resources matches the request, and (d) either (d1) the request does not specify a namespace (i.e., `Namespace==""`) and clusterScope is true or (d2) the request specifies a namespace and least one member of namespaces matches the request's namespace.
        :param Sequence[str] api_groups: `apiGroups` is a list of matching API groups and may not be empty. "*" matches all API groups and, if present, must be the only entry. Required.
        :param Sequence[str] resources: `resources` is a list of matching resources (i.e., lowercase and plural) with, if desired, subresource.  For example, [ "services", "nodes/status" ].  This list may not be empty. "*" matches all resources and, if present, must be the only entry. Required.
        :param Sequence[str] verbs: `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs and, if present, must be the only entry. Required.
        :param bool cluster_scope: `clusterScope` indicates whether to match requests that do not specify a namespace (which happens either because the resource is not namespaced or the request targets all namespaces). If this field is omitted or false then the `namespaces` field must contain a non-empty list.
        :param Sequence[str] namespaces: `namespaces` is a list of target namespaces that restricts matches.  A request that specifies a target namespace matches only if either (a) this list contains that target namespace or (b) this list contains "*".  Note that "*" matches any specified namespace but does not match a request that _does not specify_ a namespace (see the `clusterScope` field for that). This list may be empty, but only if `clusterScope` is true.
        """
        pulumi.set(__self__, "api_groups", api_groups)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "verbs", verbs)
        if cluster_scope is not None:
            pulumi.set(__self__, "cluster_scope", cluster_scope)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)

    @property
    @pulumi.getter(name="apiGroups")
    def api_groups(self) -> Sequence[str]:
        """
        `apiGroups` is a list of matching API groups and may not be empty. "*" matches all API groups and, if present, must be the only entry. Required.
        """
        return pulumi.get(self, "api_groups")

    @property
    @pulumi.getter
    def resources(self) -> Sequence[str]:
        """
        `resources` is a list of matching resources (i.e., lowercase and plural) with, if desired, subresource.  For example, [ "services", "nodes/status" ].  This list may not be empty. "*" matches all resources and, if present, must be the only entry. Required.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def verbs(self) -> Sequence[str]:
        """
        `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs and, if present, must be the only entry. Required.
        """
        return pulumi.get(self, "verbs")

    @property
    @pulumi.getter(name="clusterScope")
    def cluster_scope(self) -> Optional[bool]:
        """
        `clusterScope` indicates whether to match requests that do not specify a namespace (which happens either because the resource is not namespaced or the request targets all namespaces). If this field is omitted or false then the `namespaces` field must contain a non-empty list.
        """
        return pulumi.get(self, "cluster_scope")

    @property
    @pulumi.getter
    def namespaces(self) -> Optional[Sequence[str]]:
        """
        `namespaces` is a list of target namespaces that restricts matches.  A request that specifies a target namespace matches only if either (a) this list contains that target namespace or (b) this list contains "*".  Note that "*" matches any specified namespace but does not match a request that _does not specify_ a namespace (see the `clusterScope` field for that). This list may be empty, but only if `clusterScope` is true.
        """
        return pulumi.get(self, "namespaces")


@pulumi.output_type
class ResourcePolicyRulePatch(dict):
    """
    ResourcePolicyRule is a predicate that matches some resource requests, testing the request's verb and the target resource. A ResourcePolicyRule matches a resource request if and only if: (a) at least one member of verbs matches the request, (b) at least one member of apiGroups matches the request, (c) at least one member of resources matches the request, and (d) either (d1) the request does not specify a namespace (i.e., `Namespace==""`) and clusterScope is true or (d2) the request specifies a namespace and least one member of namespaces matches the request's namespace.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroups":
            suggest = "api_groups"
        elif key == "clusterScope":
            suggest = "cluster_scope"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePolicyRulePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePolicyRulePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePolicyRulePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_groups: Optional[Sequence[str]] = None,
                 cluster_scope: Optional[bool] = None,
                 namespaces: Optional[Sequence[str]] = None,
                 resources: Optional[Sequence[str]] = None,
                 verbs: Optional[Sequence[str]] = None):
        """
        ResourcePolicyRule is a predicate that matches some resource requests, testing the request's verb and the target resource. A ResourcePolicyRule matches a resource request if and only if: (a) at least one member of verbs matches the request, (b) at least one member of apiGroups matches the request, (c) at least one member of resources matches the request, and (d) either (d1) the request does not specify a namespace (i.e., `Namespace==""`) and clusterScope is true or (d2) the request specifies a namespace and least one member of namespaces matches the request's namespace.
        :param Sequence[str] api_groups: `apiGroups` is a list of matching API groups and may not be empty. "*" matches all API groups and, if present, must be the only entry. Required.
        :param bool cluster_scope: `clusterScope` indicates whether to match requests that do not specify a namespace (which happens either because the resource is not namespaced or the request targets all namespaces). If this field is omitted or false then the `namespaces` field must contain a non-empty list.
        :param Sequence[str] namespaces: `namespaces` is a list of target namespaces that restricts matches.  A request that specifies a target namespace matches only if either (a) this list contains that target namespace or (b) this list contains "*".  Note that "*" matches any specified namespace but does not match a request that _does not specify_ a namespace (see the `clusterScope` field for that). This list may be empty, but only if `clusterScope` is true.
        :param Sequence[str] resources: `resources` is a list of matching resources (i.e., lowercase and plural) with, if desired, subresource.  For example, [ "services", "nodes/status" ].  This list may not be empty. "*" matches all resources and, if present, must be the only entry. Required.
        :param Sequence[str] verbs: `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs and, if present, must be the only entry. Required.
        """
        if api_groups is not None:
            pulumi.set(__self__, "api_groups", api_groups)
        if cluster_scope is not None:
            pulumi.set(__self__, "cluster_scope", cluster_scope)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if verbs is not None:
            pulumi.set(__self__, "verbs", verbs)

    @property
    @pulumi.getter(name="apiGroups")
    def api_groups(self) -> Optional[Sequence[str]]:
        """
        `apiGroups` is a list of matching API groups and may not be empty. "*" matches all API groups and, if present, must be the only entry. Required.
        """
        return pulumi.get(self, "api_groups")

    @property
    @pulumi.getter(name="clusterScope")
    def cluster_scope(self) -> Optional[bool]:
        """
        `clusterScope` indicates whether to match requests that do not specify a namespace (which happens either because the resource is not namespaced or the request targets all namespaces). If this field is omitted or false then the `namespaces` field must contain a non-empty list.
        """
        return pulumi.get(self, "cluster_scope")

    @property
    @pulumi.getter
    def namespaces(self) -> Optional[Sequence[str]]:
        """
        `namespaces` is a list of target namespaces that restricts matches.  A request that specifies a target namespace matches only if either (a) this list contains that target namespace or (b) this list contains "*".  Note that "*" matches any specified namespace but does not match a request that _does not specify_ a namespace (see the `clusterScope` field for that). This list may be empty, but only if `clusterScope` is true.
        """
        return pulumi.get(self, "namespaces")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        `resources` is a list of matching resources (i.e., lowercase and plural) with, if desired, subresource.  For example, [ "services", "nodes/status" ].  This list may not be empty. "*" matches all resources and, if present, must be the only entry. Required.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def verbs(self) -> Optional[Sequence[str]]:
        """
        `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs and, if present, must be the only entry. Required.
        """
        return pulumi.get(self, "verbs")


@pulumi.output_type
class ServiceAccountSubject(dict):
    """
    ServiceAccountSubject holds detailed information for service-account-kind subject.
    """
    def __init__(__self__, *,
                 name: str,
                 namespace: str):
        """
        ServiceAccountSubject holds detailed information for service-account-kind subject.
        :param str name: `name` is the name of matching ServiceAccount objects, or "*" to match regardless of name. Required.
        :param str namespace: `namespace` is the namespace of matching ServiceAccount objects. Required.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `name` is the name of matching ServiceAccount objects, or "*" to match regardless of name. Required.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        `namespace` is the namespace of matching ServiceAccount objects. Required.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class ServiceAccountSubjectPatch(dict):
    """
    ServiceAccountSubject holds detailed information for service-account-kind subject.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 namespace: Optional[str] = None):
        """
        ServiceAccountSubject holds detailed information for service-account-kind subject.
        :param str name: `name` is the name of matching ServiceAccount objects, or "*" to match regardless of name. Required.
        :param str namespace: `namespace` is the namespace of matching ServiceAccount objects. Required.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        `name` is the name of matching ServiceAccount objects, or "*" to match regardless of name. Required.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        `namespace` is the namespace of matching ServiceAccount objects. Required.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class Subject(dict):
    """
    Subject matches the originator of a request, as identified by the request authentication system. There are three ways of matching an originator; by user, group, or service account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Subject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Subject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Subject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 group: Optional['outputs.GroupSubject'] = None,
                 service_account: Optional['outputs.ServiceAccountSubject'] = None,
                 user: Optional['outputs.UserSubject'] = None):
        """
        Subject matches the originator of a request, as identified by the request authentication system. There are three ways of matching an originator; by user, group, or service account.
        :param str kind: `kind` indicates which one of the other fields is non-empty. Required
        :param 'GroupSubjectArgs' group: `group` matches based on user group name.
        :param 'ServiceAccountSubjectArgs' service_account: `serviceAccount` matches ServiceAccounts.
        :param 'UserSubjectArgs' user: `user` matches based on username.
        """
        pulumi.set(__self__, "kind", kind)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        `kind` indicates which one of the other fields is non-empty. Required
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def group(self) -> Optional['outputs.GroupSubject']:
        """
        `group` matches based on user group name.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional['outputs.ServiceAccountSubject']:
        """
        `serviceAccount` matches ServiceAccounts.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def user(self) -> Optional['outputs.UserSubject']:
        """
        `user` matches based on username.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class SubjectPatch(dict):
    """
    Subject matches the originator of a request, as identified by the request authentication system. There are three ways of matching an originator; by user, group, or service account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubjectPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubjectPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubjectPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group: Optional['outputs.GroupSubjectPatch'] = None,
                 kind: Optional[str] = None,
                 service_account: Optional['outputs.ServiceAccountSubjectPatch'] = None,
                 user: Optional['outputs.UserSubjectPatch'] = None):
        """
        Subject matches the originator of a request, as identified by the request authentication system. There are three ways of matching an originator; by user, group, or service account.
        :param 'GroupSubjectPatchArgs' group: `group` matches based on user group name.
        :param str kind: `kind` indicates which one of the other fields is non-empty. Required
        :param 'ServiceAccountSubjectPatchArgs' service_account: `serviceAccount` matches ServiceAccounts.
        :param 'UserSubjectPatchArgs' user: `user` matches based on username.
        """
        if group is not None:
            pulumi.set(__self__, "group", group)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def group(self) -> Optional['outputs.GroupSubjectPatch']:
        """
        `group` matches based on user group name.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        `kind` indicates which one of the other fields is non-empty. Required
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional['outputs.ServiceAccountSubjectPatch']:
        """
        `serviceAccount` matches ServiceAccounts.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def user(self) -> Optional['outputs.UserSubjectPatch']:
        """
        `user` matches based on username.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class UserSubject(dict):
    """
    UserSubject holds detailed information for user-kind subject.
    """
    def __init__(__self__, *,
                 name: str):
        """
        UserSubject holds detailed information for user-kind subject.
        :param str name: `name` is the username that matches, or "*" to match all usernames. Required.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `name` is the username that matches, or "*" to match all usernames. Required.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class UserSubjectPatch(dict):
    """
    UserSubject holds detailed information for user-kind subject.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        UserSubject holds detailed information for user-kind subject.
        :param str name: `name` is the username that matches, or "*" to match all usernames. Required.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        `name` is the username that matches, or "*" to match all usernames. Required.
        """
        return pulumi.get(self, "name")


