# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReleaseArgs', 'Release']

@pulumi.input_type
class ReleaseArgs:
    def __init__(__self__, *,
                 chart: pulumi.Input[str],
                 allow_null_values: Optional[pulumi.Input[bool]] = None,
                 atomic: Optional[pulumi.Input[bool]] = None,
                 cleanup_on_fail: Optional[pulumi.Input[bool]] = None,
                 compat: Optional[pulumi.Input[str]] = None,
                 create_namespace: Optional[pulumi.Input[bool]] = None,
                 dependency_update: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 devel: Optional[pulumi.Input[bool]] = None,
                 disable_crd_hooks: Optional[pulumi.Input[bool]] = None,
                 disable_openapi_validation: Optional[pulumi.Input[bool]] = None,
                 disable_webhooks: Optional[pulumi.Input[bool]] = None,
                 force_update: Optional[pulumi.Input[bool]] = None,
                 keyring: Optional[pulumi.Input[str]] = None,
                 lint: Optional[pulumi.Input[bool]] = None,
                 manifest: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 max_history: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 postrender: Optional[pulumi.Input[str]] = None,
                 recreate_pods: Optional[pulumi.Input[bool]] = None,
                 render_subchart_notes: Optional[pulumi.Input[bool]] = None,
                 replace: Optional[pulumi.Input[bool]] = None,
                 repository_opts: Optional[pulumi.Input['RepositoryOptsArgs']] = None,
                 reset_values: Optional[pulumi.Input[bool]] = None,
                 resource_names: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
                 reuse_values: Optional[pulumi.Input[bool]] = None,
                 skip_await: Optional[pulumi.Input[bool]] = None,
                 skip_crds: Optional[pulumi.Input[bool]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 value_yaml_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]]] = None,
                 values: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 verify: Optional[pulumi.Input[bool]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wait_for_jobs: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Release resource.
        :param pulumi.Input[str] chart: Chart name to be installed. A path may be used.
        :param pulumi.Input[bool] allow_null_values: Whether to allow Null values in helm chart configs.
        :param pulumi.Input[bool] atomic: If set, installation process purges chart on fail. `skipAwait` will be disabled automatically if atomic is used.
        :param pulumi.Input[bool] cleanup_on_fail: Allow deletion of new resources created in this upgrade when upgrade fails.
        :param pulumi.Input[bool] create_namespace: Create the namespace if it does not exist.
        :param pulumi.Input[bool] dependency_update: Run helm dependency update before installing the chart.
        :param pulumi.Input[str] description: Add a custom description
        :param pulumi.Input[bool] devel: Use chart development versions, too. Equivalent to version '>0.0.0-0'. If `version` is set, this is ignored.
        :param pulumi.Input[bool] disable_crd_hooks: Prevent CRD hooks from running, but run other hooks.  See helm install --no-crd-hook
        :param pulumi.Input[bool] disable_openapi_validation: If set, the installation process will not validate rendered templates against the Kubernetes OpenAPI Schema
        :param pulumi.Input[bool] disable_webhooks: Prevent hooks from running.
        :param pulumi.Input[bool] force_update: Force resource update through delete/recreate if needed.
        :param pulumi.Input[str] keyring: Location of public keys used for verification. Used only if `verify` is true
        :param pulumi.Input[bool] lint: Run helm lint when planning.
        :param pulumi.Input[Mapping[str, Any]] manifest: The rendered manifests as JSON. Not yet supported.
        :param pulumi.Input[int] max_history: Limit the maximum number of revisions saved per release. Use 0 for no limit.
        :param pulumi.Input[str] name: Release name.
        :param pulumi.Input[str] namespace: Namespace to install the release into.
        :param pulumi.Input[str] postrender: Postrender command to run.
        :param pulumi.Input[bool] recreate_pods: Perform pods restart during upgrade/rollback.
        :param pulumi.Input[bool] render_subchart_notes: If set, render subchart notes along with the parent.
        :param pulumi.Input[bool] replace: Re-use the given name, even if that name is already used. This is unsafe in production
        :param pulumi.Input['RepositoryOptsArgs'] repository_opts: Specification defining the Helm chart repository to use.
        :param pulumi.Input[bool] reset_values: When upgrading, reset the values to the ones built into the chart.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]] resource_names: Names of resources created by the release grouped by "kind/version".
        :param pulumi.Input[bool] reuse_values: When upgrading, reuse the last release's values and merge in any overrides. If 'resetValues' is specified, this is ignored
        :param pulumi.Input[bool] skip_await: By default, the provider waits until all resources are in a ready state before marking the release as successful. Setting this to true will skip such await logic.
        :param pulumi.Input[bool] skip_crds: If set, no CRDs will be installed. By default, CRDs are installed if not already present.
        :param pulumi.Input[int] timeout: Time in seconds to wait for any individual kubernetes operation.
        :param pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]] value_yaml_files: List of assets (raw yaml files). Content is read and merged with values.
        :param pulumi.Input[Mapping[str, Any]] values: Custom values set for the release.
        :param pulumi.Input[bool] verify: Verify the package before installing it.
        :param pulumi.Input[str] version: Specify the exact chart version to install. If this is not specified, the latest version is installed.
        :param pulumi.Input[bool] wait_for_jobs: Will wait until all Jobs have been completed before marking the release as successful. This is ignored if `skipAwait` is enabled.
        """
        pulumi.set(__self__, "chart", chart)
        if allow_null_values is not None:
            pulumi.set(__self__, "allow_null_values", allow_null_values)
        if atomic is not None:
            pulumi.set(__self__, "atomic", atomic)
        if cleanup_on_fail is not None:
            pulumi.set(__self__, "cleanup_on_fail", cleanup_on_fail)
        if compat is not None:
            pulumi.set(__self__, "compat", 'true')
        if create_namespace is not None:
            pulumi.set(__self__, "create_namespace", create_namespace)
        if dependency_update is not None:
            pulumi.set(__self__, "dependency_update", dependency_update)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if devel is not None:
            pulumi.set(__self__, "devel", devel)
        if disable_crd_hooks is not None:
            pulumi.set(__self__, "disable_crd_hooks", disable_crd_hooks)
        if disable_openapi_validation is not None:
            pulumi.set(__self__, "disable_openapi_validation", disable_openapi_validation)
        if disable_webhooks is not None:
            pulumi.set(__self__, "disable_webhooks", disable_webhooks)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if keyring is not None:
            pulumi.set(__self__, "keyring", keyring)
        if lint is not None:
            pulumi.set(__self__, "lint", lint)
        if manifest is not None:
            pulumi.set(__self__, "manifest", manifest)
        if max_history is not None:
            pulumi.set(__self__, "max_history", max_history)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if postrender is not None:
            pulumi.set(__self__, "postrender", postrender)
        if recreate_pods is not None:
            pulumi.set(__self__, "recreate_pods", recreate_pods)
        if render_subchart_notes is not None:
            pulumi.set(__self__, "render_subchart_notes", render_subchart_notes)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)
        if repository_opts is not None:
            pulumi.set(__self__, "repository_opts", repository_opts)
        if reset_values is not None:
            pulumi.set(__self__, "reset_values", reset_values)
        if resource_names is not None:
            pulumi.set(__self__, "resource_names", resource_names)
        if reuse_values is not None:
            pulumi.set(__self__, "reuse_values", reuse_values)
        if skip_await is not None:
            pulumi.set(__self__, "skip_await", skip_await)
        if skip_crds is not None:
            pulumi.set(__self__, "skip_crds", skip_crds)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if value_yaml_files is not None:
            pulumi.set(__self__, "value_yaml_files", value_yaml_files)
        if values is not None:
            pulumi.set(__self__, "values", values)
        if verify is not None:
            pulumi.set(__self__, "verify", verify)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if wait_for_jobs is not None:
            pulumi.set(__self__, "wait_for_jobs", wait_for_jobs)

    @property
    @pulumi.getter
    def chart(self) -> pulumi.Input[str]:
        """
        Chart name to be installed. A path may be used.
        """
        return pulumi.get(self, "chart")

    @chart.setter
    def chart(self, value: pulumi.Input[str]):
        pulumi.set(self, "chart", value)

    @property
    @pulumi.getter(name="allowNullValues")
    def allow_null_values(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow Null values in helm chart configs.
        """
        return pulumi.get(self, "allow_null_values")

    @allow_null_values.setter
    def allow_null_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_null_values", value)

    @property
    @pulumi.getter
    def atomic(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, installation process purges chart on fail. `skipAwait` will be disabled automatically if atomic is used.
        """
        return pulumi.get(self, "atomic")

    @atomic.setter
    def atomic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "atomic", value)

    @property
    @pulumi.getter(name="cleanupOnFail")
    def cleanup_on_fail(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow deletion of new resources created in this upgrade when upgrade fails.
        """
        return pulumi.get(self, "cleanup_on_fail")

    @cleanup_on_fail.setter
    def cleanup_on_fail(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cleanup_on_fail", value)

    @property
    @pulumi.getter
    def compat(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "compat")

    @compat.setter
    def compat(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compat", value)

    @property
    @pulumi.getter(name="createNamespace")
    def create_namespace(self) -> Optional[pulumi.Input[bool]]:
        """
        Create the namespace if it does not exist.
        """
        return pulumi.get(self, "create_namespace")

    @create_namespace.setter
    def create_namespace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_namespace", value)

    @property
    @pulumi.getter(name="dependencyUpdate")
    def dependency_update(self) -> Optional[pulumi.Input[bool]]:
        """
        Run helm dependency update before installing the chart.
        """
        return pulumi.get(self, "dependency_update")

    @dependency_update.setter
    def dependency_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dependency_update", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Add a custom description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def devel(self) -> Optional[pulumi.Input[bool]]:
        """
        Use chart development versions, too. Equivalent to version '>0.0.0-0'. If `version` is set, this is ignored.
        """
        return pulumi.get(self, "devel")

    @devel.setter
    def devel(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "devel", value)

    @property
    @pulumi.getter(name="disableCRDHooks")
    def disable_crd_hooks(self) -> Optional[pulumi.Input[bool]]:
        """
        Prevent CRD hooks from running, but run other hooks.  See helm install --no-crd-hook
        """
        return pulumi.get(self, "disable_crd_hooks")

    @disable_crd_hooks.setter
    def disable_crd_hooks(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_crd_hooks", value)

    @property
    @pulumi.getter(name="disableOpenapiValidation")
    def disable_openapi_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, the installation process will not validate rendered templates against the Kubernetes OpenAPI Schema
        """
        return pulumi.get(self, "disable_openapi_validation")

    @disable_openapi_validation.setter
    def disable_openapi_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_openapi_validation", value)

    @property
    @pulumi.getter(name="disableWebhooks")
    def disable_webhooks(self) -> Optional[pulumi.Input[bool]]:
        """
        Prevent hooks from running.
        """
        return pulumi.get(self, "disable_webhooks")

    @disable_webhooks.setter
    def disable_webhooks(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_webhooks", value)

    @property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[bool]]:
        """
        Force resource update through delete/recreate if needed.
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_update", value)

    @property
    @pulumi.getter
    def keyring(self) -> Optional[pulumi.Input[str]]:
        """
        Location of public keys used for verification. Used only if `verify` is true
        """
        return pulumi.get(self, "keyring")

    @keyring.setter
    def keyring(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keyring", value)

    @property
    @pulumi.getter
    def lint(self) -> Optional[pulumi.Input[bool]]:
        """
        Run helm lint when planning.
        """
        return pulumi.get(self, "lint")

    @lint.setter
    def lint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "lint", value)

    @property
    @pulumi.getter
    def manifest(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The rendered manifests as JSON. Not yet supported.
        """
        return pulumi.get(self, "manifest")

    @manifest.setter
    def manifest(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "manifest", value)

    @property
    @pulumi.getter(name="maxHistory")
    def max_history(self) -> Optional[pulumi.Input[int]]:
        """
        Limit the maximum number of revisions saved per release. Use 0 for no limit.
        """
        return pulumi.get(self, "max_history")

    @max_history.setter
    def max_history(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_history", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Release name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace to install the release into.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def postrender(self) -> Optional[pulumi.Input[str]]:
        """
        Postrender command to run.
        """
        return pulumi.get(self, "postrender")

    @postrender.setter
    def postrender(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postrender", value)

    @property
    @pulumi.getter(name="recreatePods")
    def recreate_pods(self) -> Optional[pulumi.Input[bool]]:
        """
        Perform pods restart during upgrade/rollback.
        """
        return pulumi.get(self, "recreate_pods")

    @recreate_pods.setter
    def recreate_pods(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "recreate_pods", value)

    @property
    @pulumi.getter(name="renderSubchartNotes")
    def render_subchart_notes(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, render subchart notes along with the parent.
        """
        return pulumi.get(self, "render_subchart_notes")

    @render_subchart_notes.setter
    def render_subchart_notes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "render_subchart_notes", value)

    @property
    @pulumi.getter
    def replace(self) -> Optional[pulumi.Input[bool]]:
        """
        Re-use the given name, even if that name is already used. This is unsafe in production
        """
        return pulumi.get(self, "replace")

    @replace.setter
    def replace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replace", value)

    @property
    @pulumi.getter(name="repositoryOpts")
    def repository_opts(self) -> Optional[pulumi.Input['RepositoryOptsArgs']]:
        """
        Specification defining the Helm chart repository to use.
        """
        return pulumi.get(self, "repository_opts")

    @repository_opts.setter
    def repository_opts(self, value: Optional[pulumi.Input['RepositoryOptsArgs']]):
        pulumi.set(self, "repository_opts", value)

    @property
    @pulumi.getter(name="resetValues")
    def reset_values(self) -> Optional[pulumi.Input[bool]]:
        """
        When upgrading, reset the values to the ones built into the chart.
        """
        return pulumi.get(self, "reset_values")

    @reset_values.setter
    def reset_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reset_values", value)

    @property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]]:
        """
        Names of resources created by the release grouped by "kind/version".
        """
        return pulumi.get(self, "resource_names")

    @resource_names.setter
    def resource_names(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]]):
        pulumi.set(self, "resource_names", value)

    @property
    @pulumi.getter(name="reuseValues")
    def reuse_values(self) -> Optional[pulumi.Input[bool]]:
        """
        When upgrading, reuse the last release's values and merge in any overrides. If 'resetValues' is specified, this is ignored
        """
        return pulumi.get(self, "reuse_values")

    @reuse_values.setter
    def reuse_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reuse_values", value)

    @property
    @pulumi.getter(name="skipAwait")
    def skip_await(self) -> Optional[pulumi.Input[bool]]:
        """
        By default, the provider waits until all resources are in a ready state before marking the release as successful. Setting this to true will skip such await logic.
        """
        return pulumi.get(self, "skip_await")

    @skip_await.setter
    def skip_await(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_await", value)

    @property
    @pulumi.getter(name="skipCrds")
    def skip_crds(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, no CRDs will be installed. By default, CRDs are installed if not already present.
        """
        return pulumi.get(self, "skip_crds")

    @skip_crds.setter
    def skip_crds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_crds", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Time in seconds to wait for any individual kubernetes operation.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="valueYamlFiles")
    def value_yaml_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]]]:
        """
        List of assets (raw yaml files). Content is read and merged with values.
        """
        return pulumi.get(self, "value_yaml_files")

    @value_yaml_files.setter
    def value_yaml_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]]]):
        pulumi.set(self, "value_yaml_files", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Custom values set for the release.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def verify(self) -> Optional[pulumi.Input[bool]]:
        """
        Verify the package before installing it.
        """
        return pulumi.get(self, "verify")

    @verify.setter
    def verify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "verify", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the exact chart version to install. If this is not specified, the latest version is installed.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="waitForJobs")
    def wait_for_jobs(self) -> Optional[pulumi.Input[bool]]:
        """
        Will wait until all Jobs have been completed before marking the release as successful. This is ignored if `skipAwait` is enabled.
        """
        return pulumi.get(self, "wait_for_jobs")

    @wait_for_jobs.setter
    def wait_for_jobs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_jobs", value)


class Release(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_null_values: Optional[pulumi.Input[bool]] = None,
                 atomic: Optional[pulumi.Input[bool]] = None,
                 chart: Optional[pulumi.Input[str]] = None,
                 cleanup_on_fail: Optional[pulumi.Input[bool]] = None,
                 compat: Optional[pulumi.Input[str]] = None,
                 create_namespace: Optional[pulumi.Input[bool]] = None,
                 dependency_update: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 devel: Optional[pulumi.Input[bool]] = None,
                 disable_crd_hooks: Optional[pulumi.Input[bool]] = None,
                 disable_openapi_validation: Optional[pulumi.Input[bool]] = None,
                 disable_webhooks: Optional[pulumi.Input[bool]] = None,
                 force_update: Optional[pulumi.Input[bool]] = None,
                 keyring: Optional[pulumi.Input[str]] = None,
                 lint: Optional[pulumi.Input[bool]] = None,
                 manifest: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 max_history: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 postrender: Optional[pulumi.Input[str]] = None,
                 recreate_pods: Optional[pulumi.Input[bool]] = None,
                 render_subchart_notes: Optional[pulumi.Input[bool]] = None,
                 replace: Optional[pulumi.Input[bool]] = None,
                 repository_opts: Optional[pulumi.Input[Union['RepositoryOptsArgs', 'RepositoryOptsArgsDict']]] = None,
                 reset_values: Optional[pulumi.Input[bool]] = None,
                 resource_names: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
                 reuse_values: Optional[pulumi.Input[bool]] = None,
                 skip_await: Optional[pulumi.Input[bool]] = None,
                 skip_crds: Optional[pulumi.Input[bool]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 value_yaml_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]]] = None,
                 values: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 verify: Optional[pulumi.Input[bool]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wait_for_jobs: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        A `Release` is an instance of a chart running in a Kubernetes cluster. A `Chart` is a Helm package. It contains all the
        resource definitions necessary to run an application, tool, or service inside a Kubernetes cluster.

        This resource models a Helm Release as if it were created by the Helm CLI. The underlying implementation embeds Helm as
        a library to perform the orchestration of the resources. As a result, the full spectrum of Helm features are supported
        natively.

        You may also want to consider the `Chart` resource as an alternative method for managing helm charts. For more information about the trade-offs between these options see: [Choosing the right Helm resource for your use case](https://www.pulumi.com/registry/packages/kubernetes/how-to-guides/choosing-the-right-helm-resource-for-your-use-case)

        ## Example Usage
        ### Local Chart Directory
        ```python
        from pulumi_kubernetes.helm.v3 import Release, ReleaseArgs

        nginx_ingress = Release(
            "nginx-ingress",
            ReleaseArgs(
                chart="./nginx-ingress",
            ),
        )
        ```
        ### Remote Chart
        ```python
        from pulumi_kubernetes.helm.v3 import Release, ReleaseArgs, RepositoryOptsArgs

        nginx_ingress = Release(
            "nginx-ingress",
            ReleaseArgs(
                chart="nginx-ingress",
                version="1.24.4",
                repository_opts=RepositoryOptsArgs(
                    repo="https://charts.helm.sh/stable",
                ),
            ),
        )
        ```
        ### Set Chart Values
        ```python
        from pulumi_kubernetes.helm.v3 import Release, ReleaseArgs, RepositoryOptsArgs

        nginx_ingress = Release(
            "nginx-ingress",
            ReleaseArgs(
                chart="nginx-ingress",
                version="1.24.4",
                repository_opts=RepositoryOptsArgs(
                    repo="https://charts.helm.sh/stable",
                ),
                values={
                    "controller": {
                        "metrics": {
                            "enabled": True,
                        },
                    },
                },
            ),
        )
        ```
        ### Deploy Chart into Namespace
        ```python
        from pulumi_kubernetes.helm.v3 import Release, ReleaseArgs, RepositoryOptsArgs

        nginx_ingress = Release(
            "nginx-ingress",
            ReleaseArgs(
                chart="nginx-ingress",
                version="1.24.4",
                namespace="test-namespace",
                repository_opts=RepositoryOptsArgs(
                    repo="https://charts.helm.sh/stable",
                ),
            ),
        )
        ```

        ### Depend on a Chart resource
        ```python
        import pulumi
        from pulumi_kubernetes.core.v1 import ConfigMap, ConfigMapInitArgs
        from pulumi_kubernetes.helm.v3 import Release, ReleaseArgs, RepositoryOptsArgs

        nginx_ingress = Release(
            "nginx-ingress",
            ReleaseArgs(
                chart="nginx-ingress",
                version="1.24.4",
                namespace="test-namespace",
                repository_opts=RepositoryOptsArgs(
                    repo="https://charts.helm.sh/stable",
                ),
                skip_await=False,
            ),
        )

        # Create a ConfigMap depending on the Chart. The ConfigMap will not be created until after all of the Chart
        # resources are ready. Notice skip_await is set to false above. This is the default and will cause Helm
        # to await the underlying resources to be available. Setting it to true will make the ConfigMap available right away.
        ConfigMap("foo", ConfigMapInitArgs(data={"foo": "bar"}), opts=pulumi.ResourceOptions(depends_on=nginx_ingress))
        ```
        ### Specify Helm Chart Values in File and Code
        ```python
        import pulumi
        from pulumi_kubernetes.helm.v3 import Release, ReleaseArgs, RepositoryOptsArgs

        nginx_ingress = Release(
            "redis",
            ReleaseArgs(
                chart="redis",
                repository_opts=RepositoryOptsArgs(
                    repo="https://raw.githubusercontent.com/bitnami/charts/eb5f9a9513d987b519f0ecd732e7031241c50328/bitnami",
                ),
                value_yaml_files=[pulumi.FileAsset("./metrics.yml")],
                values={
                    cluster: {
                        enabled: true,
                    },
                    rbac: {
                        create: true,
                    }
                },
            ),
        )

        # -- Contents of metrics.yml --
        # metrics:
        #     enabled: true
        ```
        ### Query Kubernetes Resource Installed By Helm Chart
        ```python
        from pulumi import Output
        from pulumi_kubernetes.core.v1 import Service
        from pulumi_kubernetes.helm.v3 import Release, ReleaseArgs, RepositoryOptsArgs

        redis = Release(
            "redis",
            ReleaseArgs(
                chart="redis",
                repository_opts=RepositoryOptsArgs(
                    repo="https://raw.githubusercontent.com/bitnami/charts/eb5f9a9513d987b519f0ecd732e7031241c50328/bitnami",
                ),
                values={
                    "cluster": {
                        "enabled": True,
                    },
                    "rbac": {
                        "create": True,
                    }
                },
            ),
        )

        # srv will only resolve after the redis chart is installed.
        srv = Service.get("redis-master-svc", Output.concat(redis.status.namespace, "/", redis.status.name, "-master"))
        pulumi.export("redisMasterClusterIP", srv.spec.cluster_ip)
        ```

        ## Import

        An existing Helm Release resource can be imported using its `type token`, `name` and identifier, e.g.

        ```sh
        $ pulumi import kubernetes:helm.sh/v3:Release myRelease <namespace>/<releaseName>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_null_values: Whether to allow Null values in helm chart configs.
        :param pulumi.Input[bool] atomic: If set, installation process purges chart on fail. `skipAwait` will be disabled automatically if atomic is used.
        :param pulumi.Input[str] chart: Chart name to be installed. A path may be used.
        :param pulumi.Input[bool] cleanup_on_fail: Allow deletion of new resources created in this upgrade when upgrade fails.
        :param pulumi.Input[bool] create_namespace: Create the namespace if it does not exist.
        :param pulumi.Input[bool] dependency_update: Run helm dependency update before installing the chart.
        :param pulumi.Input[str] description: Add a custom description
        :param pulumi.Input[bool] devel: Use chart development versions, too. Equivalent to version '>0.0.0-0'. If `version` is set, this is ignored.
        :param pulumi.Input[bool] disable_crd_hooks: Prevent CRD hooks from running, but run other hooks.  See helm install --no-crd-hook
        :param pulumi.Input[bool] disable_openapi_validation: If set, the installation process will not validate rendered templates against the Kubernetes OpenAPI Schema
        :param pulumi.Input[bool] disable_webhooks: Prevent hooks from running.
        :param pulumi.Input[bool] force_update: Force resource update through delete/recreate if needed.
        :param pulumi.Input[str] keyring: Location of public keys used for verification. Used only if `verify` is true
        :param pulumi.Input[bool] lint: Run helm lint when planning.
        :param pulumi.Input[Mapping[str, Any]] manifest: The rendered manifests as JSON. Not yet supported.
        :param pulumi.Input[int] max_history: Limit the maximum number of revisions saved per release. Use 0 for no limit.
        :param pulumi.Input[str] name: Release name.
        :param pulumi.Input[str] namespace: Namespace to install the release into.
        :param pulumi.Input[str] postrender: Postrender command to run.
        :param pulumi.Input[bool] recreate_pods: Perform pods restart during upgrade/rollback.
        :param pulumi.Input[bool] render_subchart_notes: If set, render subchart notes along with the parent.
        :param pulumi.Input[bool] replace: Re-use the given name, even if that name is already used. This is unsafe in production
        :param pulumi.Input[Union['RepositoryOptsArgs', 'RepositoryOptsArgsDict']] repository_opts: Specification defining the Helm chart repository to use.
        :param pulumi.Input[bool] reset_values: When upgrading, reset the values to the ones built into the chart.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]] resource_names: Names of resources created by the release grouped by "kind/version".
        :param pulumi.Input[bool] reuse_values: When upgrading, reuse the last release's values and merge in any overrides. If 'resetValues' is specified, this is ignored
        :param pulumi.Input[bool] skip_await: By default, the provider waits until all resources are in a ready state before marking the release as successful. Setting this to true will skip such await logic.
        :param pulumi.Input[bool] skip_crds: If set, no CRDs will be installed. By default, CRDs are installed if not already present.
        :param pulumi.Input[int] timeout: Time in seconds to wait for any individual kubernetes operation.
        :param pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]] value_yaml_files: List of assets (raw yaml files). Content is read and merged with values.
        :param pulumi.Input[Mapping[str, Any]] values: Custom values set for the release.
        :param pulumi.Input[bool] verify: Verify the package before installing it.
        :param pulumi.Input[str] version: Specify the exact chart version to install. If this is not specified, the latest version is installed.
        :param pulumi.Input[bool] wait_for_jobs: Will wait until all Jobs have been completed before marking the release as successful. This is ignored if `skipAwait` is enabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReleaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A `Release` is an instance of a chart running in a Kubernetes cluster. A `Chart` is a Helm package. It contains all the
        resource definitions necessary to run an application, tool, or service inside a Kubernetes cluster.

        This resource models a Helm Release as if it were created by the Helm CLI. The underlying implementation embeds Helm as
        a library to perform the orchestration of the resources. As a result, the full spectrum of Helm features are supported
        natively.

        You may also want to consider the `Chart` resource as an alternative method for managing helm charts. For more information about the trade-offs between these options see: [Choosing the right Helm resource for your use case](https://www.pulumi.com/registry/packages/kubernetes/how-to-guides/choosing-the-right-helm-resource-for-your-use-case)

        ## Example Usage
        ### Local Chart Directory
        ```python
        from pulumi_kubernetes.helm.v3 import Release, ReleaseArgs

        nginx_ingress = Release(
            "nginx-ingress",
            ReleaseArgs(
                chart="./nginx-ingress",
            ),
        )
        ```
        ### Remote Chart
        ```python
        from pulumi_kubernetes.helm.v3 import Release, ReleaseArgs, RepositoryOptsArgs

        nginx_ingress = Release(
            "nginx-ingress",
            ReleaseArgs(
                chart="nginx-ingress",
                version="1.24.4",
                repository_opts=RepositoryOptsArgs(
                    repo="https://charts.helm.sh/stable",
                ),
            ),
        )
        ```
        ### Set Chart Values
        ```python
        from pulumi_kubernetes.helm.v3 import Release, ReleaseArgs, RepositoryOptsArgs

        nginx_ingress = Release(
            "nginx-ingress",
            ReleaseArgs(
                chart="nginx-ingress",
                version="1.24.4",
                repository_opts=RepositoryOptsArgs(
                    repo="https://charts.helm.sh/stable",
                ),
                values={
                    "controller": {
                        "metrics": {
                            "enabled": True,
                        },
                    },
                },
            ),
        )
        ```
        ### Deploy Chart into Namespace
        ```python
        from pulumi_kubernetes.helm.v3 import Release, ReleaseArgs, RepositoryOptsArgs

        nginx_ingress = Release(
            "nginx-ingress",
            ReleaseArgs(
                chart="nginx-ingress",
                version="1.24.4",
                namespace="test-namespace",
                repository_opts=RepositoryOptsArgs(
                    repo="https://charts.helm.sh/stable",
                ),
            ),
        )
        ```

        ### Depend on a Chart resource
        ```python
        import pulumi
        from pulumi_kubernetes.core.v1 import ConfigMap, ConfigMapInitArgs
        from pulumi_kubernetes.helm.v3 import Release, ReleaseArgs, RepositoryOptsArgs

        nginx_ingress = Release(
            "nginx-ingress",
            ReleaseArgs(
                chart="nginx-ingress",
                version="1.24.4",
                namespace="test-namespace",
                repository_opts=RepositoryOptsArgs(
                    repo="https://charts.helm.sh/stable",
                ),
                skip_await=False,
            ),
        )

        # Create a ConfigMap depending on the Chart. The ConfigMap will not be created until after all of the Chart
        # resources are ready. Notice skip_await is set to false above. This is the default and will cause Helm
        # to await the underlying resources to be available. Setting it to true will make the ConfigMap available right away.
        ConfigMap("foo", ConfigMapInitArgs(data={"foo": "bar"}), opts=pulumi.ResourceOptions(depends_on=nginx_ingress))
        ```
        ### Specify Helm Chart Values in File and Code
        ```python
        import pulumi
        from pulumi_kubernetes.helm.v3 import Release, ReleaseArgs, RepositoryOptsArgs

        nginx_ingress = Release(
            "redis",
            ReleaseArgs(
                chart="redis",
                repository_opts=RepositoryOptsArgs(
                    repo="https://raw.githubusercontent.com/bitnami/charts/eb5f9a9513d987b519f0ecd732e7031241c50328/bitnami",
                ),
                value_yaml_files=[pulumi.FileAsset("./metrics.yml")],
                values={
                    cluster: {
                        enabled: true,
                    },
                    rbac: {
                        create: true,
                    }
                },
            ),
        )

        # -- Contents of metrics.yml --
        # metrics:
        #     enabled: true
        ```
        ### Query Kubernetes Resource Installed By Helm Chart
        ```python
        from pulumi import Output
        from pulumi_kubernetes.core.v1 import Service
        from pulumi_kubernetes.helm.v3 import Release, ReleaseArgs, RepositoryOptsArgs

        redis = Release(
            "redis",
            ReleaseArgs(
                chart="redis",
                repository_opts=RepositoryOptsArgs(
                    repo="https://raw.githubusercontent.com/bitnami/charts/eb5f9a9513d987b519f0ecd732e7031241c50328/bitnami",
                ),
                values={
                    "cluster": {
                        "enabled": True,
                    },
                    "rbac": {
                        "create": True,
                    }
                },
            ),
        )

        # srv will only resolve after the redis chart is installed.
        srv = Service.get("redis-master-svc", Output.concat(redis.status.namespace, "/", redis.status.name, "-master"))
        pulumi.export("redisMasterClusterIP", srv.spec.cluster_ip)
        ```

        ## Import

        An existing Helm Release resource can be imported using its `type token`, `name` and identifier, e.g.

        ```sh
        $ pulumi import kubernetes:helm.sh/v3:Release myRelease <namespace>/<releaseName>
        ```

        :param str resource_name: The name of the resource.
        :param ReleaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReleaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_null_values: Optional[pulumi.Input[bool]] = None,
                 atomic: Optional[pulumi.Input[bool]] = None,
                 chart: Optional[pulumi.Input[str]] = None,
                 cleanup_on_fail: Optional[pulumi.Input[bool]] = None,
                 compat: Optional[pulumi.Input[str]] = None,
                 create_namespace: Optional[pulumi.Input[bool]] = None,
                 dependency_update: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 devel: Optional[pulumi.Input[bool]] = None,
                 disable_crd_hooks: Optional[pulumi.Input[bool]] = None,
                 disable_openapi_validation: Optional[pulumi.Input[bool]] = None,
                 disable_webhooks: Optional[pulumi.Input[bool]] = None,
                 force_update: Optional[pulumi.Input[bool]] = None,
                 keyring: Optional[pulumi.Input[str]] = None,
                 lint: Optional[pulumi.Input[bool]] = None,
                 manifest: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 max_history: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 postrender: Optional[pulumi.Input[str]] = None,
                 recreate_pods: Optional[pulumi.Input[bool]] = None,
                 render_subchart_notes: Optional[pulumi.Input[bool]] = None,
                 replace: Optional[pulumi.Input[bool]] = None,
                 repository_opts: Optional[pulumi.Input[Union['RepositoryOptsArgs', 'RepositoryOptsArgsDict']]] = None,
                 reset_values: Optional[pulumi.Input[bool]] = None,
                 resource_names: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
                 reuse_values: Optional[pulumi.Input[bool]] = None,
                 skip_await: Optional[pulumi.Input[bool]] = None,
                 skip_crds: Optional[pulumi.Input[bool]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 value_yaml_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]]] = None,
                 values: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 verify: Optional[pulumi.Input[bool]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wait_for_jobs: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReleaseArgs.__new__(ReleaseArgs)

            __props__.__dict__["allow_null_values"] = allow_null_values
            __props__.__dict__["atomic"] = atomic
            if chart is None and not opts.urn:
                raise TypeError("Missing required property 'chart'")
            __props__.__dict__["chart"] = chart
            __props__.__dict__["cleanup_on_fail"] = cleanup_on_fail
            __props__.__dict__["compat"] = 'true'
            __props__.__dict__["create_namespace"] = create_namespace
            __props__.__dict__["dependency_update"] = dependency_update
            __props__.__dict__["description"] = description
            __props__.__dict__["devel"] = devel
            __props__.__dict__["disable_crd_hooks"] = disable_crd_hooks
            __props__.__dict__["disable_openapi_validation"] = disable_openapi_validation
            __props__.__dict__["disable_webhooks"] = disable_webhooks
            __props__.__dict__["force_update"] = force_update
            __props__.__dict__["keyring"] = keyring
            __props__.__dict__["lint"] = lint
            __props__.__dict__["manifest"] = manifest
            __props__.__dict__["max_history"] = max_history
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["postrender"] = postrender
            __props__.__dict__["recreate_pods"] = recreate_pods
            __props__.__dict__["render_subchart_notes"] = render_subchart_notes
            __props__.__dict__["replace"] = replace
            __props__.__dict__["repository_opts"] = repository_opts
            __props__.__dict__["reset_values"] = reset_values
            __props__.__dict__["resource_names"] = resource_names
            __props__.__dict__["reuse_values"] = reuse_values
            __props__.__dict__["skip_await"] = skip_await
            __props__.__dict__["skip_crds"] = skip_crds
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["value_yaml_files"] = value_yaml_files
            __props__.__dict__["values"] = values
            __props__.__dict__["verify"] = verify
            __props__.__dict__["version"] = version
            __props__.__dict__["wait_for_jobs"] = wait_for_jobs
            __props__.__dict__["status"] = None
        super(Release, __self__).__init__(
            'kubernetes:helm.sh/v3:Release',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Release':
        """
        Get an existing Release resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ReleaseArgs.__new__(ReleaseArgs)

        __props__.__dict__["allow_null_values"] = None
        __props__.__dict__["atomic"] = None
        __props__.__dict__["chart"] = None
        __props__.__dict__["cleanup_on_fail"] = None
        __props__.__dict__["create_namespace"] = None
        __props__.__dict__["dependency_update"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["devel"] = None
        __props__.__dict__["disable_crd_hooks"] = None
        __props__.__dict__["disable_openapi_validation"] = None
        __props__.__dict__["disable_webhooks"] = None
        __props__.__dict__["force_update"] = None
        __props__.__dict__["keyring"] = None
        __props__.__dict__["lint"] = None
        __props__.__dict__["manifest"] = None
        __props__.__dict__["max_history"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["namespace"] = None
        __props__.__dict__["postrender"] = None
        __props__.__dict__["recreate_pods"] = None
        __props__.__dict__["render_subchart_notes"] = None
        __props__.__dict__["replace"] = None
        __props__.__dict__["repository_opts"] = None
        __props__.__dict__["reset_values"] = None
        __props__.__dict__["resource_names"] = None
        __props__.__dict__["reuse_values"] = None
        __props__.__dict__["skip_await"] = None
        __props__.__dict__["skip_crds"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["timeout"] = None
        __props__.__dict__["value_yaml_files"] = None
        __props__.__dict__["values"] = None
        __props__.__dict__["verify"] = None
        __props__.__dict__["version"] = None
        __props__.__dict__["wait_for_jobs"] = None
        return Release(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowNullValues")
    def allow_null_values(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to allow Null values in helm chart configs.
        """
        return pulumi.get(self, "allow_null_values")

    @property
    @pulumi.getter
    def atomic(self) -> pulumi.Output[Optional[bool]]:
        """
        If set, installation process purges chart on fail. `skipAwait` will be disabled automatically if atomic is used.
        """
        return pulumi.get(self, "atomic")

    @property
    @pulumi.getter
    def chart(self) -> pulumi.Output[str]:
        """
        Chart name to be installed. A path may be used.
        """
        return pulumi.get(self, "chart")

    @property
    @pulumi.getter(name="cleanupOnFail")
    def cleanup_on_fail(self) -> pulumi.Output[Optional[bool]]:
        """
        Allow deletion of new resources created in this upgrade when upgrade fails.
        """
        return pulumi.get(self, "cleanup_on_fail")

    @property
    @pulumi.getter(name="createNamespace")
    def create_namespace(self) -> pulumi.Output[Optional[bool]]:
        """
        Create the namespace if it does not exist.
        """
        return pulumi.get(self, "create_namespace")

    @property
    @pulumi.getter(name="dependencyUpdate")
    def dependency_update(self) -> pulumi.Output[Optional[bool]]:
        """
        Run helm dependency update before installing the chart.
        """
        return pulumi.get(self, "dependency_update")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Add a custom description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def devel(self) -> pulumi.Output[Optional[bool]]:
        """
        Use chart development versions, too. Equivalent to version '>0.0.0-0'. If `version` is set, this is ignored.
        """
        return pulumi.get(self, "devel")

    @property
    @pulumi.getter(name="disableCRDHooks")
    def disable_crd_hooks(self) -> pulumi.Output[Optional[bool]]:
        """
        Prevent CRD hooks from running, but run other hooks.  See helm install --no-crd-hook
        """
        return pulumi.get(self, "disable_crd_hooks")

    @property
    @pulumi.getter(name="disableOpenapiValidation")
    def disable_openapi_validation(self) -> pulumi.Output[Optional[bool]]:
        """
        If set, the installation process will not validate rendered templates against the Kubernetes OpenAPI Schema
        """
        return pulumi.get(self, "disable_openapi_validation")

    @property
    @pulumi.getter(name="disableWebhooks")
    def disable_webhooks(self) -> pulumi.Output[Optional[bool]]:
        """
        Prevent hooks from running.
        """
        return pulumi.get(self, "disable_webhooks")

    @property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> pulumi.Output[Optional[bool]]:
        """
        Force resource update through delete/recreate if needed.
        """
        return pulumi.get(self, "force_update")

    @property
    @pulumi.getter
    def keyring(self) -> pulumi.Output[Optional[str]]:
        """
        Location of public keys used for verification. Used only if `verify` is true
        """
        return pulumi.get(self, "keyring")

    @property
    @pulumi.getter
    def lint(self) -> pulumi.Output[Optional[bool]]:
        """
        Run helm lint when planning.
        """
        return pulumi.get(self, "lint")

    @property
    @pulumi.getter
    def manifest(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        The rendered manifests as JSON. Not yet supported.
        """
        return pulumi.get(self, "manifest")

    @property
    @pulumi.getter(name="maxHistory")
    def max_history(self) -> pulumi.Output[Optional[int]]:
        """
        Limit the maximum number of revisions saved per release. Use 0 for no limit.
        """
        return pulumi.get(self, "max_history")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        Release name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        Namespace to install the release into.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def postrender(self) -> pulumi.Output[Optional[str]]:
        """
        Postrender command to run.
        """
        return pulumi.get(self, "postrender")

    @property
    @pulumi.getter(name="recreatePods")
    def recreate_pods(self) -> pulumi.Output[Optional[bool]]:
        """
        Perform pods restart during upgrade/rollback.
        """
        return pulumi.get(self, "recreate_pods")

    @property
    @pulumi.getter(name="renderSubchartNotes")
    def render_subchart_notes(self) -> pulumi.Output[Optional[bool]]:
        """
        If set, render subchart notes along with the parent.
        """
        return pulumi.get(self, "render_subchart_notes")

    @property
    @pulumi.getter
    def replace(self) -> pulumi.Output[Optional[bool]]:
        """
        Re-use the given name, even if that name is already used. This is unsafe in production
        """
        return pulumi.get(self, "replace")

    @property
    @pulumi.getter(name="repositoryOpts")
    def repository_opts(self) -> pulumi.Output[Optional['outputs.RepositoryOpts']]:
        """
        Specification defining the Helm chart repository to use.
        """
        return pulumi.get(self, "repository_opts")

    @property
    @pulumi.getter(name="resetValues")
    def reset_values(self) -> pulumi.Output[Optional[bool]]:
        """
        When upgrading, reset the values to the ones built into the chart.
        """
        return pulumi.get(self, "reset_values")

    @property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> pulumi.Output[Optional[Mapping[str, Sequence[str]]]]:
        """
        Names of resources created by the release grouped by "kind/version".
        """
        return pulumi.get(self, "resource_names")

    @property
    @pulumi.getter(name="reuseValues")
    def reuse_values(self) -> pulumi.Output[Optional[bool]]:
        """
        When upgrading, reuse the last release's values and merge in any overrides. If 'resetValues' is specified, this is ignored
        """
        return pulumi.get(self, "reuse_values")

    @property
    @pulumi.getter(name="skipAwait")
    def skip_await(self) -> pulumi.Output[Optional[bool]]:
        """
        By default, the provider waits until all resources are in a ready state before marking the release as successful. Setting this to true will skip such await logic.
        """
        return pulumi.get(self, "skip_await")

    @property
    @pulumi.getter(name="skipCrds")
    def skip_crds(self) -> pulumi.Output[Optional[bool]]:
        """
        If set, no CRDs will be installed. By default, CRDs are installed if not already present.
        """
        return pulumi.get(self, "skip_crds")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['outputs.ReleaseStatus']:
        """
        Status of the deployed release.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[int]]:
        """
        Time in seconds to wait for any individual kubernetes operation.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="valueYamlFiles")
    def value_yaml_files(self) -> pulumi.Output[Optional[Sequence[Union[pulumi.Asset, pulumi.Archive]]]]:
        """
        List of assets (raw yaml files). Content is read and merged with values (with values taking precedence).
        """
        return pulumi.get(self, "value_yaml_files")

    @property
    @pulumi.getter
    def values(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Custom values set for the release.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def verify(self) -> pulumi.Output[Optional[bool]]:
        """
        Verify the package before installing it.
        """
        return pulumi.get(self, "verify")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[str]]:
        """
        Specify the exact chart version to install. If this is not specified, the latest version is installed.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="waitForJobs")
    def wait_for_jobs(self) -> pulumi.Output[Optional[bool]]:
        """
        Will wait until all Jobs have been completed before marking the release as successful. This is ignored if `skipAwait` is enabled.
        """
        return pulumi.get(self, "wait_for_jobs")

