# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from ... import core as _core
from ... import meta as _meta

__all__ = [
    'AllocationResultArgs',
    'AllocationResultArgsDict',
    'BasicDevicePatchArgs',
    'BasicDevicePatchArgsDict',
    'BasicDeviceArgs',
    'BasicDeviceArgsDict',
    'CELDeviceSelectorPatchArgs',
    'CELDeviceSelectorPatchArgsDict',
    'CELDeviceSelectorArgs',
    'CELDeviceSelectorArgsDict',
    'DeviceAllocationConfigurationArgs',
    'DeviceAllocationConfigurationArgsDict',
    'DeviceAllocationResultArgs',
    'DeviceAllocationResultArgsDict',
    'DeviceAttributeArgs',
    'DeviceAttributeArgsDict',
    'DeviceClaimConfigurationPatchArgs',
    'DeviceClaimConfigurationPatchArgsDict',
    'DeviceClaimConfigurationArgs',
    'DeviceClaimConfigurationArgsDict',
    'DeviceClaimPatchArgs',
    'DeviceClaimPatchArgsDict',
    'DeviceClaimArgs',
    'DeviceClaimArgsDict',
    'DeviceClassConfigurationPatchArgs',
    'DeviceClassConfigurationPatchArgsDict',
    'DeviceClassConfigurationArgs',
    'DeviceClassConfigurationArgsDict',
    'DeviceClassSpecPatchArgs',
    'DeviceClassSpecPatchArgsDict',
    'DeviceClassSpecArgs',
    'DeviceClassSpecArgsDict',
    'DeviceClassArgs',
    'DeviceClassArgsDict',
    'DeviceConstraintPatchArgs',
    'DeviceConstraintPatchArgsDict',
    'DeviceConstraintArgs',
    'DeviceConstraintArgsDict',
    'DevicePatchArgs',
    'DevicePatchArgsDict',
    'DeviceRequestAllocationResultArgs',
    'DeviceRequestAllocationResultArgsDict',
    'DeviceRequestPatchArgs',
    'DeviceRequestPatchArgsDict',
    'DeviceRequestArgs',
    'DeviceRequestArgsDict',
    'DeviceSelectorPatchArgs',
    'DeviceSelectorPatchArgsDict',
    'DeviceSelectorArgs',
    'DeviceSelectorArgsDict',
    'DeviceArgs',
    'DeviceArgsDict',
    'OpaqueDeviceConfigurationPatchArgs',
    'OpaqueDeviceConfigurationPatchArgsDict',
    'OpaqueDeviceConfigurationArgs',
    'OpaqueDeviceConfigurationArgsDict',
    'PodSchedulingContextSpecPatchArgs',
    'PodSchedulingContextSpecPatchArgsDict',
    'PodSchedulingContextSpecArgs',
    'PodSchedulingContextSpecArgsDict',
    'PodSchedulingContextStatusArgs',
    'PodSchedulingContextStatusArgsDict',
    'PodSchedulingContextArgs',
    'PodSchedulingContextArgsDict',
    'ResourceClaimConsumerReferenceArgs',
    'ResourceClaimConsumerReferenceArgsDict',
    'ResourceClaimSchedulingStatusArgs',
    'ResourceClaimSchedulingStatusArgsDict',
    'ResourceClaimSpecPatchArgs',
    'ResourceClaimSpecPatchArgsDict',
    'ResourceClaimSpecArgs',
    'ResourceClaimSpecArgsDict',
    'ResourceClaimStatusArgs',
    'ResourceClaimStatusArgsDict',
    'ResourceClaimTemplateSpecPatchArgs',
    'ResourceClaimTemplateSpecPatchArgsDict',
    'ResourceClaimTemplateSpecArgs',
    'ResourceClaimTemplateSpecArgsDict',
    'ResourceClaimTemplateArgs',
    'ResourceClaimTemplateArgsDict',
    'ResourceClaimArgs',
    'ResourceClaimArgsDict',
    'ResourcePoolPatchArgs',
    'ResourcePoolPatchArgsDict',
    'ResourcePoolArgs',
    'ResourcePoolArgsDict',
    'ResourceSliceSpecPatchArgs',
    'ResourceSliceSpecPatchArgsDict',
    'ResourceSliceSpecArgs',
    'ResourceSliceSpecArgsDict',
]

MYPY = False

if not MYPY:
    class AllocationResultArgsDict(TypedDict):
        """
        AllocationResult contains attributes of an allocated resource.
        """
        controller: NotRequired[pulumi.Input[str]]
        """
        Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.

        A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        devices: NotRequired[pulumi.Input['DeviceAllocationResultArgsDict']]
        """
        Devices is the result of allocating devices.
        """
        node_selector: NotRequired[pulumi.Input['_core.v1.NodeSelectorArgsDict']]
        """
        NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
        """
elif False:
    AllocationResultArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AllocationResultArgs:
    def __init__(__self__, *,
                 controller: Optional[pulumi.Input[str]] = None,
                 devices: Optional[pulumi.Input['DeviceAllocationResultArgs']] = None,
                 node_selector: Optional[pulumi.Input['_core.v1.NodeSelectorArgs']] = None):
        """
        AllocationResult contains attributes of an allocated resource.
        :param pulumi.Input[str] controller: Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.
               
               A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        :param pulumi.Input['DeviceAllocationResultArgs'] devices: Devices is the result of allocating devices.
        :param pulumi.Input['_core.v1.NodeSelectorArgs'] node_selector: NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)

    @property
    @pulumi.getter
    def controller(self) -> Optional[pulumi.Input[str]]:
        """
        Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.

        A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "controller")

    @controller.setter
    def controller(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller", value)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input['DeviceAllocationResultArgs']]:
        """
        Devices is the result of allocating devices.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input['DeviceAllocationResultArgs']]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[pulumi.Input['_core.v1.NodeSelectorArgs']]:
        """
        NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
        """
        return pulumi.get(self, "node_selector")

    @node_selector.setter
    def node_selector(self, value: Optional[pulumi.Input['_core.v1.NodeSelectorArgs']]):
        pulumi.set(self, "node_selector", value)


if not MYPY:
    class BasicDevicePatchArgsDict(TypedDict):
        """
        BasicDevice defines one device instance.
        """
        attributes: NotRequired[pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgsDict']]]]
        """
        Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        capacity: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
elif False:
    BasicDevicePatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BasicDevicePatchArgs:
    def __init__(__self__, *,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgs']]]] = None,
                 capacity: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        BasicDevice defines one device instance.
        :param pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgs']]] attributes: Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.
               
               The maximum number of attributes and capacities combined is 32.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] capacity: Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.
               
               The maximum number of attributes and capacities combined is 32.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgs']]]]:
        """
        Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "capacity", value)


if not MYPY:
    class BasicDeviceArgsDict(TypedDict):
        """
        BasicDevice defines one device instance.
        """
        attributes: NotRequired[pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgsDict']]]]
        """
        Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        capacity: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
elif False:
    BasicDeviceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BasicDeviceArgs:
    def __init__(__self__, *,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgs']]]] = None,
                 capacity: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        BasicDevice defines one device instance.
        :param pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgs']]] attributes: Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.
               
               The maximum number of attributes and capacities combined is 32.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] capacity: Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.
               
               The maximum number of attributes and capacities combined is 32.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgs']]]]:
        """
        Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "capacity", value)


if not MYPY:
    class CELDeviceSelectorPatchArgsDict(TypedDict):
        """
        CELDeviceSelector contains a CEL expression for selecting a device.
        """
        expression: NotRequired[pulumi.Input[str]]
        """
        Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.

        The expression's input is an object named "device", which carries the following properties:
         - driver (string): the name of the driver which defines this device.
         - attributes (map[string]object): the device's attributes, grouped by prefix
           (e.g. device.attributes["dra.example.com"] evaluates to an object with all
           of the attributes which were prefixed by "dra.example.com".
         - capacity (map[string]object): the device's capacities, grouped by prefix.

        Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:

            device.driver
            device.attributes["dra.example.com"].model
            device.attributes["ext.example.com"].family
            device.capacity["dra.example.com"].modules

        The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.

        The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.

        If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.

        A robust expression should check for the existence of attributes before referencing them.

        For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:

            cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)
        """
elif False:
    CELDeviceSelectorPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CELDeviceSelectorPatchArgs:
    def __init__(__self__, *,
                 expression: Optional[pulumi.Input[str]] = None):
        """
        CELDeviceSelector contains a CEL expression for selecting a device.
        :param pulumi.Input[str] expression: Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.
               
               The expression's input is an object named "device", which carries the following properties:
                - driver (string): the name of the driver which defines this device.
                - attributes (map[string]object): the device's attributes, grouped by prefix
                  (e.g. device.attributes["dra.example.com"] evaluates to an object with all
                  of the attributes which were prefixed by "dra.example.com".
                - capacity (map[string]object): the device's capacities, grouped by prefix.
               
               Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:
               
                   device.driver
                   device.attributes["dra.example.com"].model
                   device.attributes["ext.example.com"].family
                   device.capacity["dra.example.com"].modules
               
               The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.
               
               The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.
               
               If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.
               
               A robust expression should check for the existence of attributes before referencing them.
               
               For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:
               
                   cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.

        The expression's input is an object named "device", which carries the following properties:
         - driver (string): the name of the driver which defines this device.
         - attributes (map[string]object): the device's attributes, grouped by prefix
           (e.g. device.attributes["dra.example.com"] evaluates to an object with all
           of the attributes which were prefixed by "dra.example.com".
         - capacity (map[string]object): the device's capacities, grouped by prefix.

        Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:

            device.driver
            device.attributes["dra.example.com"].model
            device.attributes["ext.example.com"].family
            device.capacity["dra.example.com"].modules

        The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.

        The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.

        If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.

        A robust expression should check for the existence of attributes before referencing them.

        For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:

            cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)


if not MYPY:
    class CELDeviceSelectorArgsDict(TypedDict):
        """
        CELDeviceSelector contains a CEL expression for selecting a device.
        """
        expression: pulumi.Input[str]
        """
        Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.

        The expression's input is an object named "device", which carries the following properties:
         - driver (string): the name of the driver which defines this device.
         - attributes (map[string]object): the device's attributes, grouped by prefix
           (e.g. device.attributes["dra.example.com"] evaluates to an object with all
           of the attributes which were prefixed by "dra.example.com".
         - capacity (map[string]object): the device's capacities, grouped by prefix.

        Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:

            device.driver
            device.attributes["dra.example.com"].model
            device.attributes["ext.example.com"].family
            device.capacity["dra.example.com"].modules

        The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.

        The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.

        If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.

        A robust expression should check for the existence of attributes before referencing them.

        For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:

            cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)
        """
elif False:
    CELDeviceSelectorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CELDeviceSelectorArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str]):
        """
        CELDeviceSelector contains a CEL expression for selecting a device.
        :param pulumi.Input[str] expression: Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.
               
               The expression's input is an object named "device", which carries the following properties:
                - driver (string): the name of the driver which defines this device.
                - attributes (map[string]object): the device's attributes, grouped by prefix
                  (e.g. device.attributes["dra.example.com"] evaluates to an object with all
                  of the attributes which were prefixed by "dra.example.com".
                - capacity (map[string]object): the device's capacities, grouped by prefix.
               
               Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:
               
                   device.driver
                   device.attributes["dra.example.com"].model
                   device.attributes["ext.example.com"].family
                   device.capacity["dra.example.com"].modules
               
               The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.
               
               The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.
               
               If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.
               
               A robust expression should check for the existence of attributes before referencing them.
               
               For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:
               
                   cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)
        """
        pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        """
        Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.

        The expression's input is an object named "device", which carries the following properties:
         - driver (string): the name of the driver which defines this device.
         - attributes (map[string]object): the device's attributes, grouped by prefix
           (e.g. device.attributes["dra.example.com"] evaluates to an object with all
           of the attributes which were prefixed by "dra.example.com".
         - capacity (map[string]object): the device's capacities, grouped by prefix.

        Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:

            device.driver
            device.attributes["dra.example.com"].model
            device.attributes["ext.example.com"].family
            device.capacity["dra.example.com"].modules

        The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.

        The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.

        If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.

        A robust expression should check for the existence of attributes before referencing them.

        For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:

            cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)


if not MYPY:
    class DeviceAllocationConfigurationArgsDict(TypedDict):
        """
        DeviceAllocationConfiguration gets embedded in an AllocationResult.
        """
        source: pulumi.Input[str]
        """
        Source records whether the configuration comes from a class and thus is not something that a normal user would have been able to set or from a claim.
        """
        opaque: NotRequired[pulumi.Input['OpaqueDeviceConfigurationArgsDict']]
        """
        Opaque provides driver-specific configuration parameters.
        """
        requests: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Requests lists the names of requests where the configuration applies. If empty, its applies to all requests.
        """
elif False:
    DeviceAllocationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceAllocationConfigurationArgs:
    def __init__(__self__, *,
                 source: pulumi.Input[str],
                 opaque: Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        DeviceAllocationConfiguration gets embedded in an AllocationResult.
        :param pulumi.Input[str] source: Source records whether the configuration comes from a class and thus is not something that a normal user would have been able to set or from a claim.
        :param pulumi.Input['OpaqueDeviceConfigurationArgs'] opaque: Opaque provides driver-specific configuration parameters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requests: Requests lists the names of requests where the configuration applies. If empty, its applies to all requests.
        """
        pulumi.set(__self__, "source", source)
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        Source records whether the configuration comes from a class and thus is not something that a normal user would have been able to set or from a claim.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def opaque(self) -> Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']]:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @opaque.setter
    def opaque(self, value: Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']]):
        pulumi.set(self, "opaque", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Requests lists the names of requests where the configuration applies. If empty, its applies to all requests.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "requests", value)


if not MYPY:
    class DeviceAllocationResultArgsDict(TypedDict):
        """
        DeviceAllocationResult is the result of allocating devices.
        """
        config: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceAllocationConfigurationArgsDict']]]]
        """
        This field is a combination of all the claim and class configuration parameters. Drivers can distinguish between those based on a flag.

        This includes configuration parameters for drivers which have no allocated devices in the result because it is up to the drivers which configuration parameters they support. They can silently ignore unknown configuration parameters.
        """
        results: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceRequestAllocationResultArgsDict']]]]
        """
        Results lists all allocated devices.
        """
elif False:
    DeviceAllocationResultArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceAllocationResultArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceAllocationConfigurationArgs']]]] = None,
                 results: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestAllocationResultArgs']]]] = None):
        """
        DeviceAllocationResult is the result of allocating devices.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceAllocationConfigurationArgs']]] config: This field is a combination of all the claim and class configuration parameters. Drivers can distinguish between those based on a flag.
               
               This includes configuration parameters for drivers which have no allocated devices in the result because it is up to the drivers which configuration parameters they support. They can silently ignore unknown configuration parameters.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceRequestAllocationResultArgs']]] results: Results lists all allocated devices.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if results is not None:
            pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceAllocationConfigurationArgs']]]]:
        """
        This field is a combination of all the claim and class configuration parameters. Drivers can distinguish between those based on a flag.

        This includes configuration parameters for drivers which have no allocated devices in the result because it is up to the drivers which configuration parameters they support. They can silently ignore unknown configuration parameters.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceAllocationConfigurationArgs']]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def results(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestAllocationResultArgs']]]]:
        """
        Results lists all allocated devices.
        """
        return pulumi.get(self, "results")

    @results.setter
    def results(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestAllocationResultArgs']]]]):
        pulumi.set(self, "results", value)


if not MYPY:
    class DeviceAttributeArgsDict(TypedDict):
        """
        DeviceAttribute must have exactly one field set.
        """
        bool: NotRequired[pulumi.Input[bool]]
        """
        BoolValue is a true/false value.
        """
        int: NotRequired[pulumi.Input[int]]
        """
        IntValue is a number.
        """
        string: NotRequired[pulumi.Input[str]]
        """
        StringValue is a string. Must not be longer than 64 characters.
        """
        version: NotRequired[pulumi.Input[str]]
        """
        VersionValue is a semantic version according to semver.org spec 2.0.0. Must not be longer than 64 characters.
        """
elif False:
    DeviceAttributeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceAttributeArgs:
    def __init__(__self__, *,
                 bool: Optional[pulumi.Input[bool]] = None,
                 int: Optional[pulumi.Input[int]] = None,
                 string: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        DeviceAttribute must have exactly one field set.
        :param pulumi.Input[bool] bool: BoolValue is a true/false value.
        :param pulumi.Input[int] int: IntValue is a number.
        :param pulumi.Input[str] string: StringValue is a string. Must not be longer than 64 characters.
        :param pulumi.Input[str] version: VersionValue is a semantic version according to semver.org spec 2.0.0. Must not be longer than 64 characters.
        """
        if bool is not None:
            pulumi.set(__self__, "bool", bool)
        if int is not None:
            pulumi.set(__self__, "int", int)
        if string is not None:
            pulumi.set(__self__, "string", string)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bool(self) -> Optional[pulumi.Input[bool]]:
        """
        BoolValue is a true/false value.
        """
        return pulumi.get(self, "bool")

    @bool.setter
    def bool(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bool", value)

    @property
    @pulumi.getter
    def int(self) -> Optional[pulumi.Input[int]]:
        """
        IntValue is a number.
        """
        return pulumi.get(self, "int")

    @int.setter
    def int(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "int", value)

    @property
    @pulumi.getter
    def string(self) -> Optional[pulumi.Input[str]]:
        """
        StringValue is a string. Must not be longer than 64 characters.
        """
        return pulumi.get(self, "string")

    @string.setter
    def string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "string", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        VersionValue is a semantic version according to semver.org spec 2.0.0. Must not be longer than 64 characters.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class DeviceClaimConfigurationPatchArgsDict(TypedDict):
        """
        DeviceClaimConfiguration is used for configuration parameters in DeviceClaim.
        """
        opaque: NotRequired[pulumi.Input['OpaqueDeviceConfigurationPatchArgsDict']]
        """
        Opaque provides driver-specific configuration parameters.
        """
        requests: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.
        """
elif False:
    DeviceClaimConfigurationPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClaimConfigurationPatchArgs:
    def __init__(__self__, *,
                 opaque: Optional[pulumi.Input['OpaqueDeviceConfigurationPatchArgs']] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        DeviceClaimConfiguration is used for configuration parameters in DeviceClaim.
        :param pulumi.Input['OpaqueDeviceConfigurationPatchArgs'] opaque: Opaque provides driver-specific configuration parameters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requests: Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def opaque(self) -> Optional[pulumi.Input['OpaqueDeviceConfigurationPatchArgs']]:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @opaque.setter
    def opaque(self, value: Optional[pulumi.Input['OpaqueDeviceConfigurationPatchArgs']]):
        pulumi.set(self, "opaque", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "requests", value)


if not MYPY:
    class DeviceClaimConfigurationArgsDict(TypedDict):
        """
        DeviceClaimConfiguration is used for configuration parameters in DeviceClaim.
        """
        opaque: NotRequired[pulumi.Input['OpaqueDeviceConfigurationArgsDict']]
        """
        Opaque provides driver-specific configuration parameters.
        """
        requests: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.
        """
elif False:
    DeviceClaimConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClaimConfigurationArgs:
    def __init__(__self__, *,
                 opaque: Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        DeviceClaimConfiguration is used for configuration parameters in DeviceClaim.
        :param pulumi.Input['OpaqueDeviceConfigurationArgs'] opaque: Opaque provides driver-specific configuration parameters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requests: Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def opaque(self) -> Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']]:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @opaque.setter
    def opaque(self, value: Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']]):
        pulumi.set(self, "opaque", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "requests", value)


if not MYPY:
    class DeviceClaimPatchArgsDict(TypedDict):
        """
        DeviceClaim defines how to request devices with a ResourceClaim.
        """
        config: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationPatchArgsDict']]]]
        """
        This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        """
        constraints: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceConstraintPatchArgsDict']]]]
        """
        These constraints must be satisfied by the set of devices that get allocated for the claim.
        """
        requests: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceRequestPatchArgsDict']]]]
        """
        Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
elif False:
    DeviceClaimPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClaimPatchArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationPatchArgs']]]] = None,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceConstraintPatchArgs']]]] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestPatchArgs']]]] = None):
        """
        DeviceClaim defines how to request devices with a ResourceClaim.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationPatchArgs']]] config: This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceConstraintPatchArgs']]] constraints: These constraints must be satisfied by the set of devices that get allocated for the claim.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceRequestPatchArgs']]] requests: Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationPatchArgs']]]]:
        """
        This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationPatchArgs']]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceConstraintPatchArgs']]]]:
        """
        These constraints must be satisfied by the set of devices that get allocated for the claim.
        """
        return pulumi.get(self, "constraints")

    @constraints.setter
    def constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceConstraintPatchArgs']]]]):
        pulumi.set(self, "constraints", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestPatchArgs']]]]:
        """
        Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestPatchArgs']]]]):
        pulumi.set(self, "requests", value)


if not MYPY:
    class DeviceClaimArgsDict(TypedDict):
        """
        DeviceClaim defines how to request devices with a ResourceClaim.
        """
        config: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationArgsDict']]]]
        """
        This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        """
        constraints: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceConstraintArgsDict']]]]
        """
        These constraints must be satisfied by the set of devices that get allocated for the claim.
        """
        requests: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceRequestArgsDict']]]]
        """
        Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
elif False:
    DeviceClaimArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClaimArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationArgs']]]] = None,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceConstraintArgs']]]] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestArgs']]]] = None):
        """
        DeviceClaim defines how to request devices with a ResourceClaim.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationArgs']]] config: This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceConstraintArgs']]] constraints: These constraints must be satisfied by the set of devices that get allocated for the claim.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceRequestArgs']]] requests: Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationArgs']]]]:
        """
        This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationArgs']]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceConstraintArgs']]]]:
        """
        These constraints must be satisfied by the set of devices that get allocated for the claim.
        """
        return pulumi.get(self, "constraints")

    @constraints.setter
    def constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceConstraintArgs']]]]):
        pulumi.set(self, "constraints", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestArgs']]]]:
        """
        Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestArgs']]]]):
        pulumi.set(self, "requests", value)


if not MYPY:
    class DeviceClassConfigurationPatchArgsDict(TypedDict):
        """
        DeviceClassConfiguration is used in DeviceClass.
        """
        opaque: NotRequired[pulumi.Input['OpaqueDeviceConfigurationPatchArgsDict']]
        """
        Opaque provides driver-specific configuration parameters.
        """
elif False:
    DeviceClassConfigurationPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClassConfigurationPatchArgs:
    def __init__(__self__, *,
                 opaque: Optional[pulumi.Input['OpaqueDeviceConfigurationPatchArgs']] = None):
        """
        DeviceClassConfiguration is used in DeviceClass.
        :param pulumi.Input['OpaqueDeviceConfigurationPatchArgs'] opaque: Opaque provides driver-specific configuration parameters.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)

    @property
    @pulumi.getter
    def opaque(self) -> Optional[pulumi.Input['OpaqueDeviceConfigurationPatchArgs']]:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @opaque.setter
    def opaque(self, value: Optional[pulumi.Input['OpaqueDeviceConfigurationPatchArgs']]):
        pulumi.set(self, "opaque", value)


if not MYPY:
    class DeviceClassConfigurationArgsDict(TypedDict):
        """
        DeviceClassConfiguration is used in DeviceClass.
        """
        opaque: NotRequired[pulumi.Input['OpaqueDeviceConfigurationArgsDict']]
        """
        Opaque provides driver-specific configuration parameters.
        """
elif False:
    DeviceClassConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClassConfigurationArgs:
    def __init__(__self__, *,
                 opaque: Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']] = None):
        """
        DeviceClassConfiguration is used in DeviceClass.
        :param pulumi.Input['OpaqueDeviceConfigurationArgs'] opaque: Opaque provides driver-specific configuration parameters.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)

    @property
    @pulumi.getter
    def opaque(self) -> Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']]:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @opaque.setter
    def opaque(self, value: Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']]):
        pulumi.set(self, "opaque", value)


if not MYPY:
    class DeviceClassSpecPatchArgsDict(TypedDict):
        """
        DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.
        """
        config: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationPatchArgsDict']]]]
        """
        Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.

        They are passed to the driver, but are not considered while allocating the claim.
        """
        selectors: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgsDict']]]]
        """
        Each selector must be satisfied by a device which is claimed via this class.
        """
        suitable_nodes: NotRequired[pulumi.Input['_core.v1.NodeSelectorPatchArgsDict']]
        """
        Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.

        Setting this field is optional. If unset, all Nodes are candidates.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
elif False:
    DeviceClassSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClassSpecPatchArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationPatchArgs']]]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]]] = None,
                 suitable_nodes: Optional[pulumi.Input['_core.v1.NodeSelectorPatchArgs']] = None):
        """
        DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationPatchArgs']]] config: Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.
               
               They are passed to the driver, but are not considered while allocating the claim.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]] selectors: Each selector must be satisfied by a device which is claimed via this class.
        :param pulumi.Input['_core.v1.NodeSelectorPatchArgs'] suitable_nodes: Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.
               
               Setting this field is optional. If unset, all Nodes are candidates.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if suitable_nodes is not None:
            pulumi.set(__self__, "suitable_nodes", suitable_nodes)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationPatchArgs']]]]:
        """
        Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.

        They are passed to the driver, but are not considered while allocating the claim.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationPatchArgs']]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]]]:
        """
        Each selector must be satisfied by a device which is claimed via this class.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]]]):
        pulumi.set(self, "selectors", value)

    @property
    @pulumi.getter(name="suitableNodes")
    def suitable_nodes(self) -> Optional[pulumi.Input['_core.v1.NodeSelectorPatchArgs']]:
        """
        Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.

        Setting this field is optional. If unset, all Nodes are candidates.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "suitable_nodes")

    @suitable_nodes.setter
    def suitable_nodes(self, value: Optional[pulumi.Input['_core.v1.NodeSelectorPatchArgs']]):
        pulumi.set(self, "suitable_nodes", value)


if not MYPY:
    class DeviceClassSpecArgsDict(TypedDict):
        """
        DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.
        """
        config: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationArgsDict']]]]
        """
        Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.

        They are passed to the driver, but are not considered while allocating the claim.
        """
        selectors: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgsDict']]]]
        """
        Each selector must be satisfied by a device which is claimed via this class.
        """
        suitable_nodes: NotRequired[pulumi.Input['_core.v1.NodeSelectorArgsDict']]
        """
        Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.

        Setting this field is optional. If unset, all Nodes are candidates.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
elif False:
    DeviceClassSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClassSpecArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationArgs']]]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]]] = None,
                 suitable_nodes: Optional[pulumi.Input['_core.v1.NodeSelectorArgs']] = None):
        """
        DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationArgs']]] config: Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.
               
               They are passed to the driver, but are not considered while allocating the claim.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]] selectors: Each selector must be satisfied by a device which is claimed via this class.
        :param pulumi.Input['_core.v1.NodeSelectorArgs'] suitable_nodes: Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.
               
               Setting this field is optional. If unset, all Nodes are candidates.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if suitable_nodes is not None:
            pulumi.set(__self__, "suitable_nodes", suitable_nodes)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationArgs']]]]:
        """
        Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.

        They are passed to the driver, but are not considered while allocating the claim.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationArgs']]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]]]:
        """
        Each selector must be satisfied by a device which is claimed via this class.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]]]):
        pulumi.set(self, "selectors", value)

    @property
    @pulumi.getter(name="suitableNodes")
    def suitable_nodes(self) -> Optional[pulumi.Input['_core.v1.NodeSelectorArgs']]:
        """
        Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.

        Setting this field is optional. If unset, all Nodes are candidates.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "suitable_nodes")

    @suitable_nodes.setter
    def suitable_nodes(self, value: Optional[pulumi.Input['_core.v1.NodeSelectorArgs']]):
        pulumi.set(self, "suitable_nodes", value)


if not MYPY:
    class DeviceClassArgsDict(TypedDict):
        """
        DeviceClass is a vendor- or admin-provided resource that contains device configuration and selectors. It can be referenced in the device requests of a claim to apply these presets. Cluster scoped.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        """
        spec: pulumi.Input['DeviceClassSpecArgsDict']
        """
        Spec defines what can be allocated and how to configure it.

        This is mutable. Consumers have to be prepared for classes changing at any time, either because they get updated or replaced. Claim allocations are done once based on whatever was set in classes at the time of allocation.

        Changing the spec automatically increments the metadata.generation number.
        """
        api_version: NotRequired[pulumi.Input[str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object metadata
        """
elif False:
    DeviceClassArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClassArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['DeviceClassSpecArgs'],
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None):
        """
        DeviceClass is a vendor- or admin-provided resource that contains device configuration and selectors. It can be referenced in the device requests of a claim to apply these presets. Cluster scoped.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param pulumi.Input['DeviceClassSpecArgs'] spec: Spec defines what can be allocated and how to configure it.
               
               This is mutable. Consumers have to be prepared for classes changing at any time, either because they get updated or replaced. Claim allocations are done once based on whatever was set in classes at the time of allocation.
               
               Changing the spec automatically increments the metadata.generation number.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object metadata
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha3')
        if kind is not None:
            pulumi.set(__self__, "kind", 'DeviceClass')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['DeviceClassSpecArgs']:
        """
        Spec defines what can be allocated and how to configure it.

        This is mutable. Consumers have to be prepared for classes changing at any time, either because they get updated or replaced. Claim allocations are done once based on whatever was set in classes at the time of allocation.

        Changing the spec automatically increments the metadata.generation number.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['DeviceClassSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)


if not MYPY:
    class DeviceConstraintPatchArgsDict(TypedDict):
        """
        DeviceConstraint must have exactly one field set besides Requests.
        """
        match_attribute: NotRequired[pulumi.Input[str]]
        """
        MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.

        For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.

        Must include the domain qualifier.
        """
        requests: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.
        """
elif False:
    DeviceConstraintPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceConstraintPatchArgs:
    def __init__(__self__, *,
                 match_attribute: Optional[pulumi.Input[str]] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        DeviceConstraint must have exactly one field set besides Requests.
        :param pulumi.Input[str] match_attribute: MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.
               
               For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.
               
               Must include the domain qualifier.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requests: Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.
        """
        if match_attribute is not None:
            pulumi.set(__self__, "match_attribute", match_attribute)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter(name="matchAttribute")
    def match_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.

        For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.

        Must include the domain qualifier.
        """
        return pulumi.get(self, "match_attribute")

    @match_attribute.setter
    def match_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match_attribute", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "requests", value)


if not MYPY:
    class DeviceConstraintArgsDict(TypedDict):
        """
        DeviceConstraint must have exactly one field set besides Requests.
        """
        match_attribute: NotRequired[pulumi.Input[str]]
        """
        MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.

        For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.

        Must include the domain qualifier.
        """
        requests: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.
        """
elif False:
    DeviceConstraintArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceConstraintArgs:
    def __init__(__self__, *,
                 match_attribute: Optional[pulumi.Input[str]] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        DeviceConstraint must have exactly one field set besides Requests.
        :param pulumi.Input[str] match_attribute: MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.
               
               For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.
               
               Must include the domain qualifier.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requests: Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.
        """
        if match_attribute is not None:
            pulumi.set(__self__, "match_attribute", match_attribute)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter(name="matchAttribute")
    def match_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.

        For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.

        Must include the domain qualifier.
        """
        return pulumi.get(self, "match_attribute")

    @match_attribute.setter
    def match_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match_attribute", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "requests", value)


if not MYPY:
    class DevicePatchArgsDict(TypedDict):
        """
        Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.
        """
        basic: NotRequired[pulumi.Input['BasicDevicePatchArgsDict']]
        """
        Basic defines one device instance.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        """
elif False:
    DevicePatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DevicePatchArgs:
    def __init__(__self__, *,
                 basic: Optional[pulumi.Input['BasicDevicePatchArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.
        :param pulumi.Input['BasicDevicePatchArgs'] basic: Basic defines one device instance.
        :param pulumi.Input[str] name: Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        """
        if basic is not None:
            pulumi.set(__self__, "basic", basic)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def basic(self) -> Optional[pulumi.Input['BasicDevicePatchArgs']]:
        """
        Basic defines one device instance.
        """
        return pulumi.get(self, "basic")

    @basic.setter
    def basic(self, value: Optional[pulumi.Input['BasicDevicePatchArgs']]):
        pulumi.set(self, "basic", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class DeviceRequestAllocationResultArgsDict(TypedDict):
        """
        DeviceRequestAllocationResult contains the allocation result for one request.
        """
        device: pulumi.Input[str]
        """
        Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        """
        driver: pulumi.Input[str]
        """
        Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        pool: pulumi.Input[str]
        """
        This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).

        Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        """
        request: pulumi.Input[str]
        """
        Request is the name of the request in the claim which caused this device to be allocated. Multiple devices may have been allocated per request.
        """
elif False:
    DeviceRequestAllocationResultArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceRequestAllocationResultArgs:
    def __init__(__self__, *,
                 device: pulumi.Input[str],
                 driver: pulumi.Input[str],
                 pool: pulumi.Input[str],
                 request: pulumi.Input[str]):
        """
        DeviceRequestAllocationResult contains the allocation result for one request.
        :param pulumi.Input[str] device: Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        :param pulumi.Input[str] driver: Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        :param pulumi.Input[str] pool: This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).
               
               Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        :param pulumi.Input[str] request: Request is the name of the request in the claim which caused this device to be allocated. Multiple devices may have been allocated per request.
        """
        pulumi.set(__self__, "device", device)
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "pool", pool)
        pulumi.set(__self__, "request", request)

    @property
    @pulumi.getter
    def device(self) -> pulumi.Input[str]:
        """
        Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: pulumi.Input[str]):
        pulumi.set(self, "device", value)

    @property
    @pulumi.getter
    def driver(self) -> pulumi.Input[str]:
        """
        Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: pulumi.Input[str]):
        pulumi.set(self, "driver", value)

    @property
    @pulumi.getter
    def pool(self) -> pulumi.Input[str]:
        """
        This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).

        Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: pulumi.Input[str]):
        pulumi.set(self, "pool", value)

    @property
    @pulumi.getter
    def request(self) -> pulumi.Input[str]:
        """
        Request is the name of the request in the claim which caused this device to be allocated. Multiple devices may have been allocated per request.
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: pulumi.Input[str]):
        pulumi.set(self, "request", value)


if not MYPY:
    class DeviceRequestPatchArgsDict(TypedDict):
        """
        DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.

        A DeviceClassName is currently required. Clients must check that it is indeed set. It's absence indicates that something changed in a way that is not supported by the client yet, in which case it must refuse to handle the request.
        """
        admin_access: NotRequired[pulumi.Input[bool]]
        """
        AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
        """
        allocation_mode: NotRequired[pulumi.Input[str]]
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This request is for all of the matching devices in a pool.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AlloctionMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        count: NotRequired[pulumi.Input[int]]
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        """
        device_class_name: NotRequired[pulumi.Input[str]]
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.

        A class is required. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.

        Must be a DNS label.
        """
        selectors: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgsDict']]]]
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
        """
elif False:
    DeviceRequestPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceRequestPatchArgs:
    def __init__(__self__, *,
                 admin_access: Optional[pulumi.Input[bool]] = None,
                 allocation_mode: Optional[pulumi.Input[str]] = None,
                 count: Optional[pulumi.Input[int]] = None,
                 device_class_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]]] = None):
        """
        DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.

        A DeviceClassName is currently required. Clients must check that it is indeed set. It's absence indicates that something changed in a way that is not supported by the client yet, in which case it must refuse to handle the request.
        :param pulumi.Input[bool] admin_access: AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
        :param pulumi.Input[str] allocation_mode: AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:
               
               - ExactCount: This request is for a specific number of devices.
                 This is the default. The exact number is provided in the
                 count field.
               
               - All: This request is for all of the matching devices in a pool.
                 Allocation will fail if some devices are already allocated,
                 unless adminAccess is requested.
               
               If AlloctionMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.
               
               More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        :param pulumi.Input[int] count: Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        :param pulumi.Input[str] device_class_name: DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.
               
               A class is required. Which classes are available depends on the cluster.
               
               Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        :param pulumi.Input[str] name: Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.
               
               Must be a DNS label.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]] selectors: Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
        """
        if admin_access is not None:
            pulumi.set(__self__, "admin_access", admin_access)
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if device_class_name is not None:
            pulumi.set(__self__, "device_class_name", device_class_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)

    @property
    @pulumi.getter(name="adminAccess")
    def admin_access(self) -> Optional[pulumi.Input[bool]]:
        """
        AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
        """
        return pulumi.get(self, "admin_access")

    @admin_access.setter
    def admin_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_access", value)

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[pulumi.Input[str]]:
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This request is for all of the matching devices in a pool.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AlloctionMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        return pulumi.get(self, "allocation_mode")

    @allocation_mode.setter
    def allocation_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocation_mode", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="deviceClassName")
    def device_class_name(self) -> Optional[pulumi.Input[str]]:
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.

        A class is required. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        return pulumi.get(self, "device_class_name")

    @device_class_name.setter
    def device_class_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_class_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.

        Must be a DNS label.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]]]:
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]]]):
        pulumi.set(self, "selectors", value)


if not MYPY:
    class DeviceRequestArgsDict(TypedDict):
        """
        DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.

        A DeviceClassName is currently required. Clients must check that it is indeed set. It's absence indicates that something changed in a way that is not supported by the client yet, in which case it must refuse to handle the request.
        """
        device_class_name: pulumi.Input[str]
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.

        A class is required. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        name: pulumi.Input[str]
        """
        Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.

        Must be a DNS label.
        """
        admin_access: NotRequired[pulumi.Input[bool]]
        """
        AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
        """
        allocation_mode: NotRequired[pulumi.Input[str]]
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This request is for all of the matching devices in a pool.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AlloctionMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        count: NotRequired[pulumi.Input[int]]
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        """
        selectors: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgsDict']]]]
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
        """
elif False:
    DeviceRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceRequestArgs:
    def __init__(__self__, *,
                 device_class_name: pulumi.Input[str],
                 name: pulumi.Input[str],
                 admin_access: Optional[pulumi.Input[bool]] = None,
                 allocation_mode: Optional[pulumi.Input[str]] = None,
                 count: Optional[pulumi.Input[int]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]]] = None):
        """
        DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.

        A DeviceClassName is currently required. Clients must check that it is indeed set. It's absence indicates that something changed in a way that is not supported by the client yet, in which case it must refuse to handle the request.
        :param pulumi.Input[str] device_class_name: DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.
               
               A class is required. Which classes are available depends on the cluster.
               
               Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        :param pulumi.Input[str] name: Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.
               
               Must be a DNS label.
        :param pulumi.Input[bool] admin_access: AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
        :param pulumi.Input[str] allocation_mode: AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:
               
               - ExactCount: This request is for a specific number of devices.
                 This is the default. The exact number is provided in the
                 count field.
               
               - All: This request is for all of the matching devices in a pool.
                 Allocation will fail if some devices are already allocated,
                 unless adminAccess is requested.
               
               If AlloctionMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.
               
               More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        :param pulumi.Input[int] count: Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]] selectors: Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
        """
        pulumi.set(__self__, "device_class_name", device_class_name)
        pulumi.set(__self__, "name", name)
        if admin_access is not None:
            pulumi.set(__self__, "admin_access", admin_access)
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)

    @property
    @pulumi.getter(name="deviceClassName")
    def device_class_name(self) -> pulumi.Input[str]:
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.

        A class is required. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        return pulumi.get(self, "device_class_name")

    @device_class_name.setter
    def device_class_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "device_class_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.

        Must be a DNS label.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="adminAccess")
    def admin_access(self) -> Optional[pulumi.Input[bool]]:
        """
        AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
        """
        return pulumi.get(self, "admin_access")

    @admin_access.setter
    def admin_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_access", value)

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[pulumi.Input[str]]:
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This request is for all of the matching devices in a pool.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AlloctionMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        return pulumi.get(self, "allocation_mode")

    @allocation_mode.setter
    def allocation_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocation_mode", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]]]:
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]]]):
        pulumi.set(self, "selectors", value)


if not MYPY:
    class DeviceSelectorPatchArgsDict(TypedDict):
        """
        DeviceSelector must have exactly one field set.
        """
        cel: NotRequired[pulumi.Input['CELDeviceSelectorPatchArgsDict']]
        """
        CEL contains a CEL expression for selecting a device.
        """
elif False:
    DeviceSelectorPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceSelectorPatchArgs:
    def __init__(__self__, *,
                 cel: Optional[pulumi.Input['CELDeviceSelectorPatchArgs']] = None):
        """
        DeviceSelector must have exactly one field set.
        :param pulumi.Input['CELDeviceSelectorPatchArgs'] cel: CEL contains a CEL expression for selecting a device.
        """
        if cel is not None:
            pulumi.set(__self__, "cel", cel)

    @property
    @pulumi.getter
    def cel(self) -> Optional[pulumi.Input['CELDeviceSelectorPatchArgs']]:
        """
        CEL contains a CEL expression for selecting a device.
        """
        return pulumi.get(self, "cel")

    @cel.setter
    def cel(self, value: Optional[pulumi.Input['CELDeviceSelectorPatchArgs']]):
        pulumi.set(self, "cel", value)


if not MYPY:
    class DeviceSelectorArgsDict(TypedDict):
        """
        DeviceSelector must have exactly one field set.
        """
        cel: NotRequired[pulumi.Input['CELDeviceSelectorArgsDict']]
        """
        CEL contains a CEL expression for selecting a device.
        """
elif False:
    DeviceSelectorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceSelectorArgs:
    def __init__(__self__, *,
                 cel: Optional[pulumi.Input['CELDeviceSelectorArgs']] = None):
        """
        DeviceSelector must have exactly one field set.
        :param pulumi.Input['CELDeviceSelectorArgs'] cel: CEL contains a CEL expression for selecting a device.
        """
        if cel is not None:
            pulumi.set(__self__, "cel", cel)

    @property
    @pulumi.getter
    def cel(self) -> Optional[pulumi.Input['CELDeviceSelectorArgs']]:
        """
        CEL contains a CEL expression for selecting a device.
        """
        return pulumi.get(self, "cel")

    @cel.setter
    def cel(self, value: Optional[pulumi.Input['CELDeviceSelectorArgs']]):
        pulumi.set(self, "cel", value)


if not MYPY:
    class DeviceArgsDict(TypedDict):
        """
        Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.
        """
        name: pulumi.Input[str]
        """
        Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        """
        basic: NotRequired[pulumi.Input['BasicDeviceArgsDict']]
        """
        Basic defines one device instance.
        """
elif False:
    DeviceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 basic: Optional[pulumi.Input['BasicDeviceArgs']] = None):
        """
        Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.
        :param pulumi.Input[str] name: Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        :param pulumi.Input['BasicDeviceArgs'] basic: Basic defines one device instance.
        """
        pulumi.set(__self__, "name", name)
        if basic is not None:
            pulumi.set(__self__, "basic", basic)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def basic(self) -> Optional[pulumi.Input['BasicDeviceArgs']]:
        """
        Basic defines one device instance.
        """
        return pulumi.get(self, "basic")

    @basic.setter
    def basic(self, value: Optional[pulumi.Input['BasicDeviceArgs']]):
        pulumi.set(self, "basic", value)


if not MYPY:
    class OpaqueDeviceConfigurationPatchArgsDict(TypedDict):
        """
        OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.
        """
        driver: NotRequired[pulumi.Input[str]]
        """
        Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.

        An admission policy provided by the driver developer could use this to decide whether it needs to validate them.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        parameters: NotRequired[Any]
        """
        Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.
        """
elif False:
    OpaqueDeviceConfigurationPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OpaqueDeviceConfigurationPatchArgs:
    def __init__(__self__, *,
                 driver: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[Any] = None):
        """
        OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.
        :param pulumi.Input[str] driver: Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.
               
               An admission policy provided by the driver developer could use this to decide whether it needs to validate them.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        :param Any parameters: Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.
        """
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def driver(self) -> Optional[pulumi.Input[str]]:
        """
        Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.

        An admission policy provided by the driver developer could use this to decide whether it needs to validate them.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "driver", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[Any]):
        pulumi.set(self, "parameters", value)


if not MYPY:
    class OpaqueDeviceConfigurationArgsDict(TypedDict):
        """
        OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.
        """
        driver: pulumi.Input[str]
        """
        Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.

        An admission policy provided by the driver developer could use this to decide whether it needs to validate them.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        parameters: Any
        """
        Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.
        """
elif False:
    OpaqueDeviceConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OpaqueDeviceConfigurationArgs:
    def __init__(__self__, *,
                 driver: pulumi.Input[str],
                 parameters: Any):
        """
        OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.
        :param pulumi.Input[str] driver: Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.
               
               An admission policy provided by the driver developer could use this to decide whether it needs to validate them.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        :param Any parameters: Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.
        """
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def driver(self) -> pulumi.Input[str]:
        """
        Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.

        An admission policy provided by the driver developer could use this to decide whether it needs to validate them.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: pulumi.Input[str]):
        pulumi.set(self, "driver", value)

    @property
    @pulumi.getter
    def parameters(self) -> Any:
        """
        Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Any):
        pulumi.set(self, "parameters", value)


if not MYPY:
    class PodSchedulingContextSpecPatchArgsDict(TypedDict):
        """
        PodSchedulingContextSpec describes where resources for the Pod are needed.
        """
        potential_nodes: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        PotentialNodes lists nodes where the Pod might be able to run.

        The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        """
        selected_node: NotRequired[pulumi.Input[str]]
        """
        SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
elif False:
    PodSchedulingContextSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PodSchedulingContextSpecPatchArgs:
    def __init__(__self__, *,
                 potential_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 selected_node: Optional[pulumi.Input[str]] = None):
        """
        PodSchedulingContextSpec describes where resources for the Pod are needed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] potential_nodes: PotentialNodes lists nodes where the Pod might be able to run.
               
               The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        :param pulumi.Input[str] selected_node: SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        if potential_nodes is not None:
            pulumi.set(__self__, "potential_nodes", potential_nodes)
        if selected_node is not None:
            pulumi.set(__self__, "selected_node", selected_node)

    @property
    @pulumi.getter(name="potentialNodes")
    def potential_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        PotentialNodes lists nodes where the Pod might be able to run.

        The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "potential_nodes")

    @potential_nodes.setter
    def potential_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "potential_nodes", value)

    @property
    @pulumi.getter(name="selectedNode")
    def selected_node(self) -> Optional[pulumi.Input[str]]:
        """
        SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        return pulumi.get(self, "selected_node")

    @selected_node.setter
    def selected_node(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selected_node", value)


if not MYPY:
    class PodSchedulingContextSpecArgsDict(TypedDict):
        """
        PodSchedulingContextSpec describes where resources for the Pod are needed.
        """
        potential_nodes: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        PotentialNodes lists nodes where the Pod might be able to run.

        The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        """
        selected_node: NotRequired[pulumi.Input[str]]
        """
        SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
elif False:
    PodSchedulingContextSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PodSchedulingContextSpecArgs:
    def __init__(__self__, *,
                 potential_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 selected_node: Optional[pulumi.Input[str]] = None):
        """
        PodSchedulingContextSpec describes where resources for the Pod are needed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] potential_nodes: PotentialNodes lists nodes where the Pod might be able to run.
               
               The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        :param pulumi.Input[str] selected_node: SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        if potential_nodes is not None:
            pulumi.set(__self__, "potential_nodes", potential_nodes)
        if selected_node is not None:
            pulumi.set(__self__, "selected_node", selected_node)

    @property
    @pulumi.getter(name="potentialNodes")
    def potential_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        PotentialNodes lists nodes where the Pod might be able to run.

        The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "potential_nodes")

    @potential_nodes.setter
    def potential_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "potential_nodes", value)

    @property
    @pulumi.getter(name="selectedNode")
    def selected_node(self) -> Optional[pulumi.Input[str]]:
        """
        SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        return pulumi.get(self, "selected_node")

    @selected_node.setter
    def selected_node(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selected_node", value)


if not MYPY:
    class PodSchedulingContextStatusArgsDict(TypedDict):
        """
        PodSchedulingContextStatus describes where resources for the Pod can be allocated.
        """
        resource_claims: NotRequired[pulumi.Input[Sequence[pulumi.Input['ResourceClaimSchedulingStatusArgsDict']]]]
        """
        ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
elif False:
    PodSchedulingContextStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PodSchedulingContextStatusArgs:
    def __init__(__self__, *,
                 resource_claims: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceClaimSchedulingStatusArgs']]]] = None):
        """
        PodSchedulingContextStatus describes where resources for the Pod can be allocated.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceClaimSchedulingStatusArgs']]] resource_claims: ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        if resource_claims is not None:
            pulumi.set(__self__, "resource_claims", resource_claims)

    @property
    @pulumi.getter(name="resourceClaims")
    def resource_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceClaimSchedulingStatusArgs']]]]:
        """
        ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        return pulumi.get(self, "resource_claims")

    @resource_claims.setter
    def resource_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceClaimSchedulingStatusArgs']]]]):
        pulumi.set(self, "resource_claims", value)


if not MYPY:
    class PodSchedulingContextArgsDict(TypedDict):
        """
        PodSchedulingContext objects hold information that is needed to schedule a Pod with ResourceClaims that use "WaitForFirstConsumer" allocation mode.

        This is an alpha type and requires enabling the DRAControlPlaneController feature gate.
        """
        spec: pulumi.Input['PodSchedulingContextSpecArgsDict']
        """
        Spec describes where resources for the Pod are needed.
        """
        api_version: NotRequired[pulumi.Input[str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object metadata
        """
        status: NotRequired[pulumi.Input['PodSchedulingContextStatusArgsDict']]
        """
        Status describes where resources for the Pod can be allocated.
        """
elif False:
    PodSchedulingContextArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PodSchedulingContextArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['PodSchedulingContextSpecArgs'],
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 status: Optional[pulumi.Input['PodSchedulingContextStatusArgs']] = None):
        """
        PodSchedulingContext objects hold information that is needed to schedule a Pod with ResourceClaims that use "WaitForFirstConsumer" allocation mode.

        This is an alpha type and requires enabling the DRAControlPlaneController feature gate.
        :param pulumi.Input['PodSchedulingContextSpecArgs'] spec: Spec describes where resources for the Pod are needed.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object metadata
        :param pulumi.Input['PodSchedulingContextStatusArgs'] status: Status describes where resources for the Pod can be allocated.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha3')
        if kind is not None:
            pulumi.set(__self__, "kind", 'PodSchedulingContext')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['PodSchedulingContextSpecArgs']:
        """
        Spec describes where resources for the Pod are needed.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['PodSchedulingContextSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['PodSchedulingContextStatusArgs']]:
        """
        Status describes where resources for the Pod can be allocated.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['PodSchedulingContextStatusArgs']]):
        pulumi.set(self, "status", value)


if not MYPY:
    class ResourceClaimConsumerReferenceArgsDict(TypedDict):
        """
        ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
        """
        name: pulumi.Input[str]
        """
        Name is the name of resource being referenced.
        """
        resource: pulumi.Input[str]
        """
        Resource is the type of resource being referenced, for example "pods".
        """
        uid: pulumi.Input[str]
        """
        UID identifies exactly one incarnation of the resource.
        """
        api_group: NotRequired[pulumi.Input[str]]
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
elif False:
    ResourceClaimConsumerReferenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimConsumerReferenceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 resource: pulumi.Input[str],
                 uid: pulumi.Input[str],
                 api_group: Optional[pulumi.Input[str]] = None):
        """
        ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
        :param pulumi.Input[str] name: Name is the name of resource being referenced.
        :param pulumi.Input[str] resource: Resource is the type of resource being referenced, for example "pods".
        :param pulumi.Input[str] uid: UID identifies exactly one incarnation of the resource.
        :param pulumi.Input[str] api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "uid", uid)
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def resource(self) -> pulumi.Input[str]:
        """
        Resource is the type of resource being referenced, for example "pods".
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource", value)

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Input[str]:
        """
        UID identifies exactly one incarnation of the resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: pulumi.Input[str]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[pulumi.Input[str]]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")

    @api_group.setter
    def api_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_group", value)


if not MYPY:
    class ResourceClaimSchedulingStatusArgsDict(TypedDict):
        """
        ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
        """
        name: pulumi.Input[str]
        """
        Name matches the pod.spec.resourceClaims[*].Name field.
        """
        unsuitable_nodes: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.

        The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
elif False:
    ResourceClaimSchedulingStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimSchedulingStatusArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 unsuitable_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
        :param pulumi.Input[str] name: Name matches the pod.spec.resourceClaims[*].Name field.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] unsuitable_nodes: UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.
               
               The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        pulumi.set(__self__, "name", name)
        if unsuitable_nodes is not None:
            pulumi.set(__self__, "unsuitable_nodes", unsuitable_nodes)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name matches the pod.spec.resourceClaims[*].Name field.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="unsuitableNodes")
    def unsuitable_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.

        The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "unsuitable_nodes")

    @unsuitable_nodes.setter
    def unsuitable_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "unsuitable_nodes", value)


if not MYPY:
    class ResourceClaimSpecPatchArgsDict(TypedDict):
        """
        ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it.
        """
        controller: NotRequired[pulumi.Input[str]]
        """
        Controller is the name of the DRA driver that is meant to handle allocation of this claim. If empty, allocation is handled by the scheduler while scheduling a pod.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        devices: NotRequired[pulumi.Input['DeviceClaimPatchArgsDict']]
        """
        Devices defines how to request devices.
        """
elif False:
    ResourceClaimSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimSpecPatchArgs:
    def __init__(__self__, *,
                 controller: Optional[pulumi.Input[str]] = None,
                 devices: Optional[pulumi.Input['DeviceClaimPatchArgs']] = None):
        """
        ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it.
        :param pulumi.Input[str] controller: Controller is the name of the DRA driver that is meant to handle allocation of this claim. If empty, allocation is handled by the scheduler while scheduling a pod.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        :param pulumi.Input['DeviceClaimPatchArgs'] devices: Devices defines how to request devices.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)

    @property
    @pulumi.getter
    def controller(self) -> Optional[pulumi.Input[str]]:
        """
        Controller is the name of the DRA driver that is meant to handle allocation of this claim. If empty, allocation is handled by the scheduler while scheduling a pod.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "controller")

    @controller.setter
    def controller(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller", value)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input['DeviceClaimPatchArgs']]:
        """
        Devices defines how to request devices.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input['DeviceClaimPatchArgs']]):
        pulumi.set(self, "devices", value)


if not MYPY:
    class ResourceClaimSpecArgsDict(TypedDict):
        """
        ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it.
        """
        controller: NotRequired[pulumi.Input[str]]
        """
        Controller is the name of the DRA driver that is meant to handle allocation of this claim. If empty, allocation is handled by the scheduler while scheduling a pod.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        devices: NotRequired[pulumi.Input['DeviceClaimArgsDict']]
        """
        Devices defines how to request devices.
        """
elif False:
    ResourceClaimSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimSpecArgs:
    def __init__(__self__, *,
                 controller: Optional[pulumi.Input[str]] = None,
                 devices: Optional[pulumi.Input['DeviceClaimArgs']] = None):
        """
        ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it.
        :param pulumi.Input[str] controller: Controller is the name of the DRA driver that is meant to handle allocation of this claim. If empty, allocation is handled by the scheduler while scheduling a pod.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        :param pulumi.Input['DeviceClaimArgs'] devices: Devices defines how to request devices.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)

    @property
    @pulumi.getter
    def controller(self) -> Optional[pulumi.Input[str]]:
        """
        Controller is the name of the DRA driver that is meant to handle allocation of this claim. If empty, allocation is handled by the scheduler while scheduling a pod.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "controller")

    @controller.setter
    def controller(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller", value)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input['DeviceClaimArgs']]:
        """
        Devices defines how to request devices.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input['DeviceClaimArgs']]):
        pulumi.set(self, "devices", value)


if not MYPY:
    class ResourceClaimStatusArgsDict(TypedDict):
        """
        ResourceClaimStatus tracks whether the resource has been allocated and what the result of that was.
        """
        allocation: NotRequired[pulumi.Input['AllocationResultArgsDict']]
        """
        Allocation is set once the claim has been allocated successfully.
        """
        deallocation_requested: NotRequired[pulumi.Input[bool]]
        """
        Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.

        This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        reserved_for: NotRequired[pulumi.Input[Sequence[pulumi.Input['ResourceClaimConsumerReferenceArgsDict']]]]
        """
        ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.

        In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.

        Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.

        There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
elif False:
    ResourceClaimStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimStatusArgs:
    def __init__(__self__, *,
                 allocation: Optional[pulumi.Input['AllocationResultArgs']] = None,
                 deallocation_requested: Optional[pulumi.Input[bool]] = None,
                 reserved_for: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceClaimConsumerReferenceArgs']]]] = None):
        """
        ResourceClaimStatus tracks whether the resource has been allocated and what the result of that was.
        :param pulumi.Input['AllocationResultArgs'] allocation: Allocation is set once the claim has been allocated successfully.
        :param pulumi.Input[bool] deallocation_requested: Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.
               
               This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceClaimConsumerReferenceArgs']]] reserved_for: ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.
               
               In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.
               
               Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.
               
               There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
        if allocation is not None:
            pulumi.set(__self__, "allocation", allocation)
        if deallocation_requested is not None:
            pulumi.set(__self__, "deallocation_requested", deallocation_requested)
        if reserved_for is not None:
            pulumi.set(__self__, "reserved_for", reserved_for)

    @property
    @pulumi.getter
    def allocation(self) -> Optional[pulumi.Input['AllocationResultArgs']]:
        """
        Allocation is set once the claim has been allocated successfully.
        """
        return pulumi.get(self, "allocation")

    @allocation.setter
    def allocation(self, value: Optional[pulumi.Input['AllocationResultArgs']]):
        pulumi.set(self, "allocation", value)

    @property
    @pulumi.getter(name="deallocationRequested")
    def deallocation_requested(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.

        This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "deallocation_requested")

    @deallocation_requested.setter
    def deallocation_requested(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deallocation_requested", value)

    @property
    @pulumi.getter(name="reservedFor")
    def reserved_for(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceClaimConsumerReferenceArgs']]]]:
        """
        ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.

        In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.

        Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.

        There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "reserved_for")

    @reserved_for.setter
    def reserved_for(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceClaimConsumerReferenceArgs']]]]):
        pulumi.set(self, "reserved_for", value)


if not MYPY:
    class ResourceClaimTemplateSpecPatchArgsDict(TypedDict):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaPatchArgsDict']]
        """
        ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        spec: NotRequired[pulumi.Input['ResourceClaimSpecPatchArgsDict']]
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
elif False:
    ResourceClaimTemplateSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimTemplateSpecPatchArgs:
    def __init__(__self__, *,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaPatchArgs']] = None,
                 spec: Optional[pulumi.Input['ResourceClaimSpecPatchArgs']] = None):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        :param pulumi.Input['_meta.v1.ObjectMetaPatchArgs'] metadata: ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        :param pulumi.Input['ResourceClaimSpecPatchArgs'] spec: Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaPatchArgs']]:
        """
        ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaPatchArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['ResourceClaimSpecPatchArgs']]:
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['ResourceClaimSpecPatchArgs']]):
        pulumi.set(self, "spec", value)


if not MYPY:
    class ResourceClaimTemplateSpecArgsDict(TypedDict):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        """
        spec: pulumi.Input['ResourceClaimSpecArgsDict']
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
elif False:
    ResourceClaimTemplateSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimTemplateSpecArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['ResourceClaimSpecArgs'],
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        :param pulumi.Input['ResourceClaimSpecArgs'] spec: Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        pulumi.set(__self__, "spec", spec)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['ResourceClaimSpecArgs']:
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['ResourceClaimSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)


if not MYPY:
    class ResourceClaimTemplateArgsDict(TypedDict):
        """
        ResourceClaimTemplate is used to produce ResourceClaim objects.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        """
        spec: pulumi.Input['ResourceClaimTemplateSpecArgsDict']
        """
        Describes the ResourceClaim that is to be generated.

        This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
        """
        api_version: NotRequired[pulumi.Input[str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object metadata
        """
elif False:
    ResourceClaimTemplateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimTemplateArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['ResourceClaimTemplateSpecArgs'],
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None):
        """
        ResourceClaimTemplate is used to produce ResourceClaim objects.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param pulumi.Input['ResourceClaimTemplateSpecArgs'] spec: Describes the ResourceClaim that is to be generated.
               
               This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object metadata
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha3')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClaimTemplate')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['ResourceClaimTemplateSpecArgs']:
        """
        Describes the ResourceClaim that is to be generated.

        This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['ResourceClaimTemplateSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)


if not MYPY:
    class ResourceClaimArgsDict(TypedDict):
        """
        ResourceClaim describes a request for access to resources in the cluster, for use by workloads. For example, if a workload needs an accelerator device with specific properties, this is how that request is expressed. The status stanza tracks whether this claim has been satisfied and what specific resources have been allocated.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        """
        spec: pulumi.Input['ResourceClaimSpecArgsDict']
        """
        Spec describes what is being requested and how to configure it. The spec is immutable.
        """
        api_version: NotRequired[pulumi.Input[str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object metadata
        """
        status: NotRequired[pulumi.Input['ResourceClaimStatusArgsDict']]
        """
        Status describes whether the claim is ready to use and what has been allocated.
        """
elif False:
    ResourceClaimArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['ResourceClaimSpecArgs'],
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 status: Optional[pulumi.Input['ResourceClaimStatusArgs']] = None):
        """
        ResourceClaim describes a request for access to resources in the cluster, for use by workloads. For example, if a workload needs an accelerator device with specific properties, this is how that request is expressed. The status stanza tracks whether this claim has been satisfied and what specific resources have been allocated.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param pulumi.Input['ResourceClaimSpecArgs'] spec: Spec describes what is being requested and how to configure it. The spec is immutable.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object metadata
        :param pulumi.Input['ResourceClaimStatusArgs'] status: Status describes whether the claim is ready to use and what has been allocated.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha3')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClaim')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['ResourceClaimSpecArgs']:
        """
        Spec describes what is being requested and how to configure it. The spec is immutable.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['ResourceClaimSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['ResourceClaimStatusArgs']]:
        """
        Status describes whether the claim is ready to use and what has been allocated.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['ResourceClaimStatusArgs']]):
        pulumi.set(self, "status", value)


if not MYPY:
    class ResourcePoolPatchArgsDict(TypedDict):
        """
        ResourcePool describes the pool that ResourceSlices belong to.
        """
        generation: NotRequired[pulumi.Input[int]]
        """
        Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.

        Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.

        It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        """
        resource_slice_count: NotRequired[pulumi.Input[int]]
        """
        ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.

        Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
elif False:
    ResourcePoolPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourcePoolPatchArgs:
    def __init__(__self__, *,
                 generation: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_slice_count: Optional[pulumi.Input[int]] = None):
        """
        ResourcePool describes the pool that ResourceSlices belong to.
        :param pulumi.Input[int] generation: Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.
               
               Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        :param pulumi.Input[str] name: Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.
               
               It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        :param pulumi.Input[int] resource_slice_count: ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.
               
               Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_slice_count is not None:
            pulumi.set(__self__, "resource_slice_count", resource_slice_count)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[int]]:
        """
        Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.

        Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.

        It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceSliceCount")
    def resource_slice_count(self) -> Optional[pulumi.Input[int]]:
        """
        ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.

        Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
        return pulumi.get(self, "resource_slice_count")

    @resource_slice_count.setter
    def resource_slice_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "resource_slice_count", value)


if not MYPY:
    class ResourcePoolArgsDict(TypedDict):
        """
        ResourcePool describes the pool that ResourceSlices belong to.
        """
        generation: pulumi.Input[int]
        """
        Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.

        Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        """
        name: pulumi.Input[str]
        """
        Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.

        It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        """
        resource_slice_count: pulumi.Input[int]
        """
        ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.

        Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
elif False:
    ResourcePoolArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourcePoolArgs:
    def __init__(__self__, *,
                 generation: pulumi.Input[int],
                 name: pulumi.Input[str],
                 resource_slice_count: pulumi.Input[int]):
        """
        ResourcePool describes the pool that ResourceSlices belong to.
        :param pulumi.Input[int] generation: Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.
               
               Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        :param pulumi.Input[str] name: Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.
               
               It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        :param pulumi.Input[int] resource_slice_count: ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.
               
               Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_slice_count", resource_slice_count)

    @property
    @pulumi.getter
    def generation(self) -> pulumi.Input[int]:
        """
        Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.

        Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: pulumi.Input[int]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.

        It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceSliceCount")
    def resource_slice_count(self) -> pulumi.Input[int]:
        """
        ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.

        Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
        return pulumi.get(self, "resource_slice_count")

    @resource_slice_count.setter
    def resource_slice_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "resource_slice_count", value)


if not MYPY:
    class ResourceSliceSpecPatchArgsDict(TypedDict):
        """
        ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
        """
        all_nodes: NotRequired[pulumi.Input[bool]]
        """
        AllNodes indicates that all nodes have access to the resources in the pool.

        Exactly one of NodeName, NodeSelector and AllNodes must be set.
        """
        devices: NotRequired[pulumi.Input[Sequence[pulumi.Input['DevicePatchArgsDict']]]]
        """
        Devices lists some or all of the devices in this pool.

        Must not have more than 128 entries.
        """
        driver: NotRequired[pulumi.Input[str]]
        """
        Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        """
        node_name: NotRequired[pulumi.Input[str]]
        """
        NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.

        This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.

        Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
        """
        node_selector: NotRequired[pulumi.Input['_core.v1.NodeSelectorPatchArgsDict']]
        """
        NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.

        Must use exactly one term.

        Exactly one of NodeName, NodeSelector and AllNodes must be set.
        """
        pool: NotRequired[pulumi.Input['ResourcePoolPatchArgsDict']]
        """
        Pool describes the pool that this ResourceSlice belongs to.
        """
elif False:
    ResourceSliceSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceSliceSpecPatchArgs:
    def __init__(__self__, *,
                 all_nodes: Optional[pulumi.Input[bool]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input['DevicePatchArgs']]]] = None,
                 driver: Optional[pulumi.Input[str]] = None,
                 node_name: Optional[pulumi.Input[str]] = None,
                 node_selector: Optional[pulumi.Input['_core.v1.NodeSelectorPatchArgs']] = None,
                 pool: Optional[pulumi.Input['ResourcePoolPatchArgs']] = None):
        """
        ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
        :param pulumi.Input[bool] all_nodes: AllNodes indicates that all nodes have access to the resources in the pool.
               
               Exactly one of NodeName, NodeSelector and AllNodes must be set.
        :param pulumi.Input[Sequence[pulumi.Input['DevicePatchArgs']]] devices: Devices lists some or all of the devices in this pool.
               
               Must not have more than 128 entries.
        :param pulumi.Input[str] driver: Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        :param pulumi.Input[str] node_name: NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.
               
               This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.
               
               Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
        :param pulumi.Input['_core.v1.NodeSelectorPatchArgs'] node_selector: NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.
               
               Must use exactly one term.
               
               Exactly one of NodeName, NodeSelector and AllNodes must be set.
        :param pulumi.Input['ResourcePoolPatchArgs'] pool: Pool describes the pool that this ResourceSlice belongs to.
        """
        if all_nodes is not None:
            pulumi.set(__self__, "all_nodes", all_nodes)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)

    @property
    @pulumi.getter(name="allNodes")
    def all_nodes(self) -> Optional[pulumi.Input[bool]]:
        """
        AllNodes indicates that all nodes have access to the resources in the pool.

        Exactly one of NodeName, NodeSelector and AllNodes must be set.
        """
        return pulumi.get(self, "all_nodes")

    @all_nodes.setter
    def all_nodes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_nodes", value)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DevicePatchArgs']]]]:
        """
        Devices lists some or all of the devices in this pool.

        Must not have more than 128 entries.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DevicePatchArgs']]]]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter
    def driver(self) -> Optional[pulumi.Input[str]]:
        """
        Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "driver", value)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[pulumi.Input[str]]:
        """
        NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.

        This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.

        Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_name", value)

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[pulumi.Input['_core.v1.NodeSelectorPatchArgs']]:
        """
        NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.

        Must use exactly one term.

        Exactly one of NodeName, NodeSelector and AllNodes must be set.
        """
        return pulumi.get(self, "node_selector")

    @node_selector.setter
    def node_selector(self, value: Optional[pulumi.Input['_core.v1.NodeSelectorPatchArgs']]):
        pulumi.set(self, "node_selector", value)

    @property
    @pulumi.getter
    def pool(self) -> Optional[pulumi.Input['ResourcePoolPatchArgs']]:
        """
        Pool describes the pool that this ResourceSlice belongs to.
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: Optional[pulumi.Input['ResourcePoolPatchArgs']]):
        pulumi.set(self, "pool", value)


if not MYPY:
    class ResourceSliceSpecArgsDict(TypedDict):
        """
        ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
        """
        driver: pulumi.Input[str]
        """
        Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        """
        pool: pulumi.Input['ResourcePoolArgsDict']
        """
        Pool describes the pool that this ResourceSlice belongs to.
        """
        all_nodes: NotRequired[pulumi.Input[bool]]
        """
        AllNodes indicates that all nodes have access to the resources in the pool.

        Exactly one of NodeName, NodeSelector and AllNodes must be set.
        """
        devices: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceArgsDict']]]]
        """
        Devices lists some or all of the devices in this pool.

        Must not have more than 128 entries.
        """
        node_name: NotRequired[pulumi.Input[str]]
        """
        NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.

        This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.

        Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
        """
        node_selector: NotRequired[pulumi.Input['_core.v1.NodeSelectorArgsDict']]
        """
        NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.

        Must use exactly one term.

        Exactly one of NodeName, NodeSelector and AllNodes must be set.
        """
elif False:
    ResourceSliceSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceSliceSpecArgs:
    def __init__(__self__, *,
                 driver: pulumi.Input[str],
                 pool: pulumi.Input['ResourcePoolArgs'],
                 all_nodes: Optional[pulumi.Input[bool]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceArgs']]]] = None,
                 node_name: Optional[pulumi.Input[str]] = None,
                 node_selector: Optional[pulumi.Input['_core.v1.NodeSelectorArgs']] = None):
        """
        ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
        :param pulumi.Input[str] driver: Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        :param pulumi.Input['ResourcePoolArgs'] pool: Pool describes the pool that this ResourceSlice belongs to.
        :param pulumi.Input[bool] all_nodes: AllNodes indicates that all nodes have access to the resources in the pool.
               
               Exactly one of NodeName, NodeSelector and AllNodes must be set.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceArgs']]] devices: Devices lists some or all of the devices in this pool.
               
               Must not have more than 128 entries.
        :param pulumi.Input[str] node_name: NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.
               
               This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.
               
               Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
        :param pulumi.Input['_core.v1.NodeSelectorArgs'] node_selector: NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.
               
               Must use exactly one term.
               
               Exactly one of NodeName, NodeSelector and AllNodes must be set.
        """
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "pool", pool)
        if all_nodes is not None:
            pulumi.set(__self__, "all_nodes", all_nodes)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)

    @property
    @pulumi.getter
    def driver(self) -> pulumi.Input[str]:
        """
        Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: pulumi.Input[str]):
        pulumi.set(self, "driver", value)

    @property
    @pulumi.getter
    def pool(self) -> pulumi.Input['ResourcePoolArgs']:
        """
        Pool describes the pool that this ResourceSlice belongs to.
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: pulumi.Input['ResourcePoolArgs']):
        pulumi.set(self, "pool", value)

    @property
    @pulumi.getter(name="allNodes")
    def all_nodes(self) -> Optional[pulumi.Input[bool]]:
        """
        AllNodes indicates that all nodes have access to the resources in the pool.

        Exactly one of NodeName, NodeSelector and AllNodes must be set.
        """
        return pulumi.get(self, "all_nodes")

    @all_nodes.setter
    def all_nodes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_nodes", value)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceArgs']]]]:
        """
        Devices lists some or all of the devices in this pool.

        Must not have more than 128 entries.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceArgs']]]]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[pulumi.Input[str]]:
        """
        NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.

        This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.

        Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_name", value)

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[pulumi.Input['_core.v1.NodeSelectorArgs']]:
        """
        NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.

        Must use exactly one term.

        Exactly one of NodeName, NodeSelector and AllNodes must be set.
        """
        return pulumi.get(self, "node_selector")

    @node_selector.setter
    def node_selector(self, value: Optional[pulumi.Input['_core.v1.NodeSelectorArgs']]):
        pulumi.set(self, "node_selector", value)


