# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import core as _core
from ... import meta as _meta

__all__ = [
    'AllocationResult',
    'AllocationResultPatch',
    'BasicDevice',
    'BasicDevicePatch',
    'CELDeviceSelector',
    'CELDeviceSelectorPatch',
    'Device',
    'DeviceAllocationConfiguration',
    'DeviceAllocationConfigurationPatch',
    'DeviceAllocationResult',
    'DeviceAllocationResultPatch',
    'DeviceAttribute',
    'DeviceClaim',
    'DeviceClaimConfiguration',
    'DeviceClaimConfigurationPatch',
    'DeviceClaimPatch',
    'DeviceClass',
    'DeviceClassConfiguration',
    'DeviceClassConfigurationPatch',
    'DeviceClassSpec',
    'DeviceClassSpecPatch',
    'DeviceConstraint',
    'DeviceConstraintPatch',
    'DevicePatch',
    'DeviceRequest',
    'DeviceRequestAllocationResult',
    'DeviceRequestAllocationResultPatch',
    'DeviceRequestPatch',
    'DeviceSelector',
    'DeviceSelectorPatch',
    'OpaqueDeviceConfiguration',
    'OpaqueDeviceConfigurationPatch',
    'PodSchedulingContext',
    'PodSchedulingContextSpec',
    'PodSchedulingContextSpecPatch',
    'PodSchedulingContextStatus',
    'PodSchedulingContextStatusPatch',
    'ResourceClaim',
    'ResourceClaimConsumerReference',
    'ResourceClaimConsumerReferencePatch',
    'ResourceClaimSchedulingStatus',
    'ResourceClaimSchedulingStatusPatch',
    'ResourceClaimSpec',
    'ResourceClaimSpecPatch',
    'ResourceClaimStatus',
    'ResourceClaimStatusPatch',
    'ResourceClaimTemplate',
    'ResourceClaimTemplateSpec',
    'ResourceClaimTemplateSpecPatch',
    'ResourcePool',
    'ResourcePoolPatch',
    'ResourceSliceSpec',
    'ResourceSliceSpecPatch',
]

@pulumi.output_type
class AllocationResult(dict):
    """
    AllocationResult contains attributes of an allocated resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeSelector":
            suggest = "node_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllocationResult. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllocationResult.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllocationResult.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 controller: Optional[str] = None,
                 devices: Optional['outputs.DeviceAllocationResult'] = None,
                 node_selector: Optional['_core.v1.outputs.NodeSelector'] = None):
        """
        AllocationResult contains attributes of an allocated resource.
        :param str controller: Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.
               
               A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        :param 'DeviceAllocationResultArgs' devices: Devices is the result of allocating devices.
        :param '_core.v1.NodeSelectorArgs' node_selector: NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)

    @property
    @pulumi.getter
    def controller(self) -> Optional[str]:
        """
        Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.

        A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "controller")

    @property
    @pulumi.getter
    def devices(self) -> Optional['outputs.DeviceAllocationResult']:
        """
        Devices is the result of allocating devices.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional['_core.v1.outputs.NodeSelector']:
        """
        NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
        """
        return pulumi.get(self, "node_selector")


@pulumi.output_type
class AllocationResultPatch(dict):
    """
    AllocationResult contains attributes of an allocated resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeSelector":
            suggest = "node_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllocationResultPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllocationResultPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllocationResultPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 controller: Optional[str] = None,
                 devices: Optional['outputs.DeviceAllocationResultPatch'] = None,
                 node_selector: Optional['_core.v1.outputs.NodeSelectorPatch'] = None):
        """
        AllocationResult contains attributes of an allocated resource.
        :param str controller: Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.
               
               A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        :param 'DeviceAllocationResultPatchArgs' devices: Devices is the result of allocating devices.
        :param '_core.v1.NodeSelectorPatchArgs' node_selector: NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)

    @property
    @pulumi.getter
    def controller(self) -> Optional[str]:
        """
        Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.

        A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "controller")

    @property
    @pulumi.getter
    def devices(self) -> Optional['outputs.DeviceAllocationResultPatch']:
        """
        Devices is the result of allocating devices.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional['_core.v1.outputs.NodeSelectorPatch']:
        """
        NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
        """
        return pulumi.get(self, "node_selector")


@pulumi.output_type
class BasicDevice(dict):
    """
    BasicDevice defines one device instance.
    """
    def __init__(__self__, *,
                 attributes: Optional[Mapping[str, 'outputs.DeviceAttribute']] = None,
                 capacity: Optional[Mapping[str, str]] = None):
        """
        BasicDevice defines one device instance.
        :param Mapping[str, 'DeviceAttributeArgs'] attributes: Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.
               
               The maximum number of attributes and capacities combined is 32.
        :param Mapping[str, str] capacity: Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.
               
               The maximum number of attributes and capacities combined is 32.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[Mapping[str, 'outputs.DeviceAttribute']]:
        """
        Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[Mapping[str, str]]:
        """
        Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class BasicDevicePatch(dict):
    """
    BasicDevice defines one device instance.
    """
    def __init__(__self__, *,
                 attributes: Optional[Mapping[str, 'outputs.DeviceAttribute']] = None,
                 capacity: Optional[Mapping[str, str]] = None):
        """
        BasicDevice defines one device instance.
        :param Mapping[str, 'DeviceAttributeArgs'] attributes: Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.
               
               The maximum number of attributes and capacities combined is 32.
        :param Mapping[str, str] capacity: Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.
               
               The maximum number of attributes and capacities combined is 32.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[Mapping[str, 'outputs.DeviceAttribute']]:
        """
        Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[Mapping[str, str]]:
        """
        Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class CELDeviceSelector(dict):
    """
    CELDeviceSelector contains a CEL expression for selecting a device.
    """
    def __init__(__self__, *,
                 expression: str):
        """
        CELDeviceSelector contains a CEL expression for selecting a device.
        :param str expression: Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.
               
               The expression's input is an object named "device", which carries the following properties:
                - driver (string): the name of the driver which defines this device.
                - attributes (map[string]object): the device's attributes, grouped by prefix
                  (e.g. device.attributes["dra.example.com"] evaluates to an object with all
                  of the attributes which were prefixed by "dra.example.com".
                - capacity (map[string]object): the device's capacities, grouped by prefix.
               
               Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:
               
                   device.driver
                   device.attributes["dra.example.com"].model
                   device.attributes["ext.example.com"].family
                   device.capacity["dra.example.com"].modules
               
               The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.
               
               The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.
               
               If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.
               
               A robust expression should check for the existence of attributes before referencing them.
               
               For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:
               
                   cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)
        """
        pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.

        The expression's input is an object named "device", which carries the following properties:
         - driver (string): the name of the driver which defines this device.
         - attributes (map[string]object): the device's attributes, grouped by prefix
           (e.g. device.attributes["dra.example.com"] evaluates to an object with all
           of the attributes which were prefixed by "dra.example.com".
         - capacity (map[string]object): the device's capacities, grouped by prefix.

        Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:

            device.driver
            device.attributes["dra.example.com"].model
            device.attributes["ext.example.com"].family
            device.capacity["dra.example.com"].modules

        The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.

        The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.

        If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.

        A robust expression should check for the existence of attributes before referencing them.

        For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:

            cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class CELDeviceSelectorPatch(dict):
    """
    CELDeviceSelector contains a CEL expression for selecting a device.
    """
    def __init__(__self__, *,
                 expression: Optional[str] = None):
        """
        CELDeviceSelector contains a CEL expression for selecting a device.
        :param str expression: Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.
               
               The expression's input is an object named "device", which carries the following properties:
                - driver (string): the name of the driver which defines this device.
                - attributes (map[string]object): the device's attributes, grouped by prefix
                  (e.g. device.attributes["dra.example.com"] evaluates to an object with all
                  of the attributes which were prefixed by "dra.example.com".
                - capacity (map[string]object): the device's capacities, grouped by prefix.
               
               Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:
               
                   device.driver
                   device.attributes["dra.example.com"].model
                   device.attributes["ext.example.com"].family
                   device.capacity["dra.example.com"].modules
               
               The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.
               
               The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.
               
               If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.
               
               A robust expression should check for the existence of attributes before referencing them.
               
               For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:
               
                   cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.

        The expression's input is an object named "device", which carries the following properties:
         - driver (string): the name of the driver which defines this device.
         - attributes (map[string]object): the device's attributes, grouped by prefix
           (e.g. device.attributes["dra.example.com"] evaluates to an object with all
           of the attributes which were prefixed by "dra.example.com".
         - capacity (map[string]object): the device's capacities, grouped by prefix.

        Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:

            device.driver
            device.attributes["dra.example.com"].model
            device.attributes["ext.example.com"].family
            device.capacity["dra.example.com"].modules

        The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.

        The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.

        If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.

        A robust expression should check for the existence of attributes before referencing them.

        For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:

            cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class Device(dict):
    """
    Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.
    """
    def __init__(__self__, *,
                 name: str,
                 basic: Optional['outputs.BasicDevice'] = None):
        """
        Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.
        :param str name: Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        :param 'BasicDeviceArgs' basic: Basic defines one device instance.
        """
        pulumi.set(__self__, "name", name)
        if basic is not None:
            pulumi.set(__self__, "basic", basic)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def basic(self) -> Optional['outputs.BasicDevice']:
        """
        Basic defines one device instance.
        """
        return pulumi.get(self, "basic")


@pulumi.output_type
class DeviceAllocationConfiguration(dict):
    """
    DeviceAllocationConfiguration gets embedded in an AllocationResult.
    """
    def __init__(__self__, *,
                 source: str,
                 opaque: Optional['outputs.OpaqueDeviceConfiguration'] = None,
                 requests: Optional[Sequence[str]] = None):
        """
        DeviceAllocationConfiguration gets embedded in an AllocationResult.
        :param str source: Source records whether the configuration comes from a class and thus is not something that a normal user would have been able to set or from a claim.
        :param 'OpaqueDeviceConfigurationArgs' opaque: Opaque provides driver-specific configuration parameters.
        :param Sequence[str] requests: Requests lists the names of requests where the configuration applies. If empty, its applies to all requests.
        """
        pulumi.set(__self__, "source", source)
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        Source records whether the configuration comes from a class and thus is not something that a normal user would have been able to set or from a claim.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def opaque(self) -> Optional['outputs.OpaqueDeviceConfiguration']:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence[str]]:
        """
        Requests lists the names of requests where the configuration applies. If empty, its applies to all requests.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class DeviceAllocationConfigurationPatch(dict):
    """
    DeviceAllocationConfiguration gets embedded in an AllocationResult.
    """
    def __init__(__self__, *,
                 opaque: Optional['outputs.OpaqueDeviceConfigurationPatch'] = None,
                 requests: Optional[Sequence[str]] = None,
                 source: Optional[str] = None):
        """
        DeviceAllocationConfiguration gets embedded in an AllocationResult.
        :param 'OpaqueDeviceConfigurationPatchArgs' opaque: Opaque provides driver-specific configuration parameters.
        :param Sequence[str] requests: Requests lists the names of requests where the configuration applies. If empty, its applies to all requests.
        :param str source: Source records whether the configuration comes from a class and thus is not something that a normal user would have been able to set or from a claim.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def opaque(self) -> Optional['outputs.OpaqueDeviceConfigurationPatch']:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence[str]]:
        """
        Requests lists the names of requests where the configuration applies. If empty, its applies to all requests.
        """
        return pulumi.get(self, "requests")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        Source records whether the configuration comes from a class and thus is not something that a normal user would have been able to set or from a claim.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class DeviceAllocationResult(dict):
    """
    DeviceAllocationResult is the result of allocating devices.
    """
    def __init__(__self__, *,
                 config: Optional[Sequence['outputs.DeviceAllocationConfiguration']] = None,
                 results: Optional[Sequence['outputs.DeviceRequestAllocationResult']] = None):
        """
        DeviceAllocationResult is the result of allocating devices.
        :param Sequence['DeviceAllocationConfigurationArgs'] config: This field is a combination of all the claim and class configuration parameters. Drivers can distinguish between those based on a flag.
               
               This includes configuration parameters for drivers which have no allocated devices in the result because it is up to the drivers which configuration parameters they support. They can silently ignore unknown configuration parameters.
        :param Sequence['DeviceRequestAllocationResultArgs'] results: Results lists all allocated devices.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if results is not None:
            pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter
    def config(self) -> Optional[Sequence['outputs.DeviceAllocationConfiguration']]:
        """
        This field is a combination of all the claim and class configuration parameters. Drivers can distinguish between those based on a flag.

        This includes configuration parameters for drivers which have no allocated devices in the result because it is up to the drivers which configuration parameters they support. They can silently ignore unknown configuration parameters.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def results(self) -> Optional[Sequence['outputs.DeviceRequestAllocationResult']]:
        """
        Results lists all allocated devices.
        """
        return pulumi.get(self, "results")


@pulumi.output_type
class DeviceAllocationResultPatch(dict):
    """
    DeviceAllocationResult is the result of allocating devices.
    """
    def __init__(__self__, *,
                 config: Optional[Sequence['outputs.DeviceAllocationConfigurationPatch']] = None,
                 results: Optional[Sequence['outputs.DeviceRequestAllocationResultPatch']] = None):
        """
        DeviceAllocationResult is the result of allocating devices.
        :param Sequence['DeviceAllocationConfigurationPatchArgs'] config: This field is a combination of all the claim and class configuration parameters. Drivers can distinguish between those based on a flag.
               
               This includes configuration parameters for drivers which have no allocated devices in the result because it is up to the drivers which configuration parameters they support. They can silently ignore unknown configuration parameters.
        :param Sequence['DeviceRequestAllocationResultPatchArgs'] results: Results lists all allocated devices.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if results is not None:
            pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter
    def config(self) -> Optional[Sequence['outputs.DeviceAllocationConfigurationPatch']]:
        """
        This field is a combination of all the claim and class configuration parameters. Drivers can distinguish between those based on a flag.

        This includes configuration parameters for drivers which have no allocated devices in the result because it is up to the drivers which configuration parameters they support. They can silently ignore unknown configuration parameters.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def results(self) -> Optional[Sequence['outputs.DeviceRequestAllocationResultPatch']]:
        """
        Results lists all allocated devices.
        """
        return pulumi.get(self, "results")


@pulumi.output_type
class DeviceAttribute(dict):
    """
    DeviceAttribute must have exactly one field set.
    """
    def __init__(__self__, *,
                 bool: Optional[bool] = None,
                 int: Optional[int] = None,
                 string: Optional[str] = None,
                 version: Optional[str] = None):
        """
        DeviceAttribute must have exactly one field set.
        :param bool bool: BoolValue is a true/false value.
        :param int int: IntValue is a number.
        :param str string: StringValue is a string. Must not be longer than 64 characters.
        :param str version: VersionValue is a semantic version according to semver.org spec 2.0.0. Must not be longer than 64 characters.
        """
        if bool is not None:
            pulumi.set(__self__, "bool", bool)
        if int is not None:
            pulumi.set(__self__, "int", int)
        if string is not None:
            pulumi.set(__self__, "string", string)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bool(self) -> Optional[bool]:
        """
        BoolValue is a true/false value.
        """
        return pulumi.get(self, "bool")

    @property
    @pulumi.getter
    def int(self) -> Optional[int]:
        """
        IntValue is a number.
        """
        return pulumi.get(self, "int")

    @property
    @pulumi.getter
    def string(self) -> Optional[str]:
        """
        StringValue is a string. Must not be longer than 64 characters.
        """
        return pulumi.get(self, "string")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        VersionValue is a semantic version according to semver.org spec 2.0.0. Must not be longer than 64 characters.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class DeviceClaim(dict):
    """
    DeviceClaim defines how to request devices with a ResourceClaim.
    """
    def __init__(__self__, *,
                 config: Optional[Sequence['outputs.DeviceClaimConfiguration']] = None,
                 constraints: Optional[Sequence['outputs.DeviceConstraint']] = None,
                 requests: Optional[Sequence['outputs.DeviceRequest']] = None):
        """
        DeviceClaim defines how to request devices with a ResourceClaim.
        :param Sequence['DeviceClaimConfigurationArgs'] config: This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        :param Sequence['DeviceConstraintArgs'] constraints: These constraints must be satisfied by the set of devices that get allocated for the claim.
        :param Sequence['DeviceRequestArgs'] requests: Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def config(self) -> Optional[Sequence['outputs.DeviceClaimConfiguration']]:
        """
        This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def constraints(self) -> Optional[Sequence['outputs.DeviceConstraint']]:
        """
        These constraints must be satisfied by the set of devices that get allocated for the claim.
        """
        return pulumi.get(self, "constraints")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence['outputs.DeviceRequest']]:
        """
        Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class DeviceClaimConfiguration(dict):
    """
    DeviceClaimConfiguration is used for configuration parameters in DeviceClaim.
    """
    def __init__(__self__, *,
                 opaque: Optional['outputs.OpaqueDeviceConfiguration'] = None,
                 requests: Optional[Sequence[str]] = None):
        """
        DeviceClaimConfiguration is used for configuration parameters in DeviceClaim.
        :param 'OpaqueDeviceConfigurationArgs' opaque: Opaque provides driver-specific configuration parameters.
        :param Sequence[str] requests: Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def opaque(self) -> Optional['outputs.OpaqueDeviceConfiguration']:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence[str]]:
        """
        Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class DeviceClaimConfigurationPatch(dict):
    """
    DeviceClaimConfiguration is used for configuration parameters in DeviceClaim.
    """
    def __init__(__self__, *,
                 opaque: Optional['outputs.OpaqueDeviceConfigurationPatch'] = None,
                 requests: Optional[Sequence[str]] = None):
        """
        DeviceClaimConfiguration is used for configuration parameters in DeviceClaim.
        :param 'OpaqueDeviceConfigurationPatchArgs' opaque: Opaque provides driver-specific configuration parameters.
        :param Sequence[str] requests: Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def opaque(self) -> Optional['outputs.OpaqueDeviceConfigurationPatch']:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence[str]]:
        """
        Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class DeviceClaimPatch(dict):
    """
    DeviceClaim defines how to request devices with a ResourceClaim.
    """
    def __init__(__self__, *,
                 config: Optional[Sequence['outputs.DeviceClaimConfigurationPatch']] = None,
                 constraints: Optional[Sequence['outputs.DeviceConstraintPatch']] = None,
                 requests: Optional[Sequence['outputs.DeviceRequestPatch']] = None):
        """
        DeviceClaim defines how to request devices with a ResourceClaim.
        :param Sequence['DeviceClaimConfigurationPatchArgs'] config: This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        :param Sequence['DeviceConstraintPatchArgs'] constraints: These constraints must be satisfied by the set of devices that get allocated for the claim.
        :param Sequence['DeviceRequestPatchArgs'] requests: Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def config(self) -> Optional[Sequence['outputs.DeviceClaimConfigurationPatch']]:
        """
        This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def constraints(self) -> Optional[Sequence['outputs.DeviceConstraintPatch']]:
        """
        These constraints must be satisfied by the set of devices that get allocated for the claim.
        """
        return pulumi.get(self, "constraints")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence['outputs.DeviceRequestPatch']]:
        """
        Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class DeviceClass(dict):
    """
    DeviceClass is a vendor- or admin-provided resource that contains device configuration and selectors. It can be referenced in the device requests of a claim to apply these presets. Cluster scoped.

    This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceClass. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceClass.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceClass.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.DeviceClassSpec',
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None):
        """
        DeviceClass is a vendor- or admin-provided resource that contains device configuration and selectors. It can be referenced in the device requests of a claim to apply these presets. Cluster scoped.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param 'DeviceClassSpecArgs' spec: Spec defines what can be allocated and how to configure it.
               
               This is mutable. Consumers have to be prepared for classes changing at any time, either because they get updated or replaced. Claim allocations are done once based on whatever was set in classes at the time of allocation.
               
               Changing the spec automatically increments the metadata.generation number.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha3')
        if kind is not None:
            pulumi.set(__self__, "kind", 'DeviceClass')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.DeviceClassSpec':
        """
        Spec defines what can be allocated and how to configure it.

        This is mutable. Consumers have to be prepared for classes changing at any time, either because they get updated or replaced. Claim allocations are done once based on whatever was set in classes at the time of allocation.

        Changing the spec automatically increments the metadata.generation number.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class DeviceClassConfiguration(dict):
    """
    DeviceClassConfiguration is used in DeviceClass.
    """
    def __init__(__self__, *,
                 opaque: Optional['outputs.OpaqueDeviceConfiguration'] = None):
        """
        DeviceClassConfiguration is used in DeviceClass.
        :param 'OpaqueDeviceConfigurationArgs' opaque: Opaque provides driver-specific configuration parameters.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)

    @property
    @pulumi.getter
    def opaque(self) -> Optional['outputs.OpaqueDeviceConfiguration']:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")


@pulumi.output_type
class DeviceClassConfigurationPatch(dict):
    """
    DeviceClassConfiguration is used in DeviceClass.
    """
    def __init__(__self__, *,
                 opaque: Optional['outputs.OpaqueDeviceConfigurationPatch'] = None):
        """
        DeviceClassConfiguration is used in DeviceClass.
        :param 'OpaqueDeviceConfigurationPatchArgs' opaque: Opaque provides driver-specific configuration parameters.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)

    @property
    @pulumi.getter
    def opaque(self) -> Optional['outputs.OpaqueDeviceConfigurationPatch']:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")


@pulumi.output_type
class DeviceClassSpec(dict):
    """
    DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "suitableNodes":
            suggest = "suitable_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceClassSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceClassSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceClassSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: Optional[Sequence['outputs.DeviceClassConfiguration']] = None,
                 selectors: Optional[Sequence['outputs.DeviceSelector']] = None,
                 suitable_nodes: Optional['_core.v1.outputs.NodeSelector'] = None):
        """
        DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.
        :param Sequence['DeviceClassConfigurationArgs'] config: Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.
               
               They are passed to the driver, but are not considered while allocating the claim.
        :param Sequence['DeviceSelectorArgs'] selectors: Each selector must be satisfied by a device which is claimed via this class.
        :param '_core.v1.NodeSelectorArgs' suitable_nodes: Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.
               
               Setting this field is optional. If unset, all Nodes are candidates.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if suitable_nodes is not None:
            pulumi.set(__self__, "suitable_nodes", suitable_nodes)

    @property
    @pulumi.getter
    def config(self) -> Optional[Sequence['outputs.DeviceClassConfiguration']]:
        """
        Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.

        They are passed to the driver, but are not considered while allocating the claim.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def selectors(self) -> Optional[Sequence['outputs.DeviceSelector']]:
        """
        Each selector must be satisfied by a device which is claimed via this class.
        """
        return pulumi.get(self, "selectors")

    @property
    @pulumi.getter(name="suitableNodes")
    def suitable_nodes(self) -> Optional['_core.v1.outputs.NodeSelector']:
        """
        Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.

        Setting this field is optional. If unset, all Nodes are candidates.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "suitable_nodes")


@pulumi.output_type
class DeviceClassSpecPatch(dict):
    """
    DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "suitableNodes":
            suggest = "suitable_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceClassSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceClassSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceClassSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: Optional[Sequence['outputs.DeviceClassConfigurationPatch']] = None,
                 selectors: Optional[Sequence['outputs.DeviceSelectorPatch']] = None,
                 suitable_nodes: Optional['_core.v1.outputs.NodeSelectorPatch'] = None):
        """
        DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.
        :param Sequence['DeviceClassConfigurationPatchArgs'] config: Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.
               
               They are passed to the driver, but are not considered while allocating the claim.
        :param Sequence['DeviceSelectorPatchArgs'] selectors: Each selector must be satisfied by a device which is claimed via this class.
        :param '_core.v1.NodeSelectorPatchArgs' suitable_nodes: Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.
               
               Setting this field is optional. If unset, all Nodes are candidates.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if suitable_nodes is not None:
            pulumi.set(__self__, "suitable_nodes", suitable_nodes)

    @property
    @pulumi.getter
    def config(self) -> Optional[Sequence['outputs.DeviceClassConfigurationPatch']]:
        """
        Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.

        They are passed to the driver, but are not considered while allocating the claim.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def selectors(self) -> Optional[Sequence['outputs.DeviceSelectorPatch']]:
        """
        Each selector must be satisfied by a device which is claimed via this class.
        """
        return pulumi.get(self, "selectors")

    @property
    @pulumi.getter(name="suitableNodes")
    def suitable_nodes(self) -> Optional['_core.v1.outputs.NodeSelectorPatch']:
        """
        Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.

        Setting this field is optional. If unset, all Nodes are candidates.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "suitable_nodes")


@pulumi.output_type
class DeviceConstraint(dict):
    """
    DeviceConstraint must have exactly one field set besides Requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchAttribute":
            suggest = "match_attribute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceConstraint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceConstraint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceConstraint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_attribute: Optional[str] = None,
                 requests: Optional[Sequence[str]] = None):
        """
        DeviceConstraint must have exactly one field set besides Requests.
        :param str match_attribute: MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.
               
               For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.
               
               Must include the domain qualifier.
        :param Sequence[str] requests: Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.
        """
        if match_attribute is not None:
            pulumi.set(__self__, "match_attribute", match_attribute)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter(name="matchAttribute")
    def match_attribute(self) -> Optional[str]:
        """
        MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.

        For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.

        Must include the domain qualifier.
        """
        return pulumi.get(self, "match_attribute")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence[str]]:
        """
        Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class DeviceConstraintPatch(dict):
    """
    DeviceConstraint must have exactly one field set besides Requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchAttribute":
            suggest = "match_attribute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceConstraintPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceConstraintPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceConstraintPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_attribute: Optional[str] = None,
                 requests: Optional[Sequence[str]] = None):
        """
        DeviceConstraint must have exactly one field set besides Requests.
        :param str match_attribute: MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.
               
               For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.
               
               Must include the domain qualifier.
        :param Sequence[str] requests: Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.
        """
        if match_attribute is not None:
            pulumi.set(__self__, "match_attribute", match_attribute)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter(name="matchAttribute")
    def match_attribute(self) -> Optional[str]:
        """
        MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.

        For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.

        Must include the domain qualifier.
        """
        return pulumi.get(self, "match_attribute")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence[str]]:
        """
        Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class DevicePatch(dict):
    """
    Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.
    """
    def __init__(__self__, *,
                 basic: Optional['outputs.BasicDevicePatch'] = None,
                 name: Optional[str] = None):
        """
        Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.
        :param 'BasicDevicePatchArgs' basic: Basic defines one device instance.
        :param str name: Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        """
        if basic is not None:
            pulumi.set(__self__, "basic", basic)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def basic(self) -> Optional['outputs.BasicDevicePatch']:
        """
        Basic defines one device instance.
        """
        return pulumi.get(self, "basic")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DeviceRequest(dict):
    """
    DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.

    A DeviceClassName is currently required. Clients must check that it is indeed set. It's absence indicates that something changed in a way that is not supported by the client yet, in which case it must refuse to handle the request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceClassName":
            suggest = "device_class_name"
        elif key == "adminAccess":
            suggest = "admin_access"
        elif key == "allocationMode":
            suggest = "allocation_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_class_name: str,
                 name: str,
                 admin_access: Optional[bool] = None,
                 allocation_mode: Optional[str] = None,
                 count: Optional[int] = None,
                 selectors: Optional[Sequence['outputs.DeviceSelector']] = None):
        """
        DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.

        A DeviceClassName is currently required. Clients must check that it is indeed set. It's absence indicates that something changed in a way that is not supported by the client yet, in which case it must refuse to handle the request.
        :param str device_class_name: DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.
               
               A class is required. Which classes are available depends on the cluster.
               
               Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        :param str name: Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.
               
               Must be a DNS label.
        :param bool admin_access: AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
        :param str allocation_mode: AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:
               
               - ExactCount: This request is for a specific number of devices.
                 This is the default. The exact number is provided in the
                 count field.
               
               - All: This request is for all of the matching devices in a pool.
                 Allocation will fail if some devices are already allocated,
                 unless adminAccess is requested.
               
               If AlloctionMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.
               
               More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        :param int count: Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        :param Sequence['DeviceSelectorArgs'] selectors: Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
        """
        pulumi.set(__self__, "device_class_name", device_class_name)
        pulumi.set(__self__, "name", name)
        if admin_access is not None:
            pulumi.set(__self__, "admin_access", admin_access)
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)

    @property
    @pulumi.getter(name="deviceClassName")
    def device_class_name(self) -> str:
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.

        A class is required. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        return pulumi.get(self, "device_class_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.

        Must be a DNS label.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="adminAccess")
    def admin_access(self) -> Optional[bool]:
        """
        AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
        """
        return pulumi.get(self, "admin_access")

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[str]:
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This request is for all of the matching devices in a pool.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AlloctionMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        return pulumi.get(self, "allocation_mode")

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def selectors(self) -> Optional[Sequence['outputs.DeviceSelector']]:
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
        """
        return pulumi.get(self, "selectors")


@pulumi.output_type
class DeviceRequestAllocationResult(dict):
    """
    DeviceRequestAllocationResult contains the allocation result for one request.
    """
    def __init__(__self__, *,
                 device: str,
                 driver: str,
                 pool: str,
                 request: str):
        """
        DeviceRequestAllocationResult contains the allocation result for one request.
        :param str device: Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        :param str driver: Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        :param str pool: This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).
               
               Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        :param str request: Request is the name of the request in the claim which caused this device to be allocated. Multiple devices may have been allocated per request.
        """
        pulumi.set(__self__, "device", device)
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "pool", pool)
        pulumi.set(__self__, "request", request)

    @property
    @pulumi.getter
    def device(self) -> str:
        """
        Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter
    def driver(self) -> str:
        """
        Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter
    def pool(self) -> str:
        """
        This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).

        Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter
    def request(self) -> str:
        """
        Request is the name of the request in the claim which caused this device to be allocated. Multiple devices may have been allocated per request.
        """
        return pulumi.get(self, "request")


@pulumi.output_type
class DeviceRequestAllocationResultPatch(dict):
    """
    DeviceRequestAllocationResult contains the allocation result for one request.
    """
    def __init__(__self__, *,
                 device: Optional[str] = None,
                 driver: Optional[str] = None,
                 pool: Optional[str] = None,
                 request: Optional[str] = None):
        """
        DeviceRequestAllocationResult contains the allocation result for one request.
        :param str device: Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        :param str driver: Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        :param str pool: This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).
               
               Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        :param str request: Request is the name of the request in the claim which caused this device to be allocated. Multiple devices may have been allocated per request.
        """
        if device is not None:
            pulumi.set(__self__, "device", device)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)
        if request is not None:
            pulumi.set(__self__, "request", request)

    @property
    @pulumi.getter
    def device(self) -> Optional[str]:
        """
        Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter
    def driver(self) -> Optional[str]:
        """
        Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter
    def pool(self) -> Optional[str]:
        """
        This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).

        Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter
    def request(self) -> Optional[str]:
        """
        Request is the name of the request in the claim which caused this device to be allocated. Multiple devices may have been allocated per request.
        """
        return pulumi.get(self, "request")


@pulumi.output_type
class DeviceRequestPatch(dict):
    """
    DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.

    A DeviceClassName is currently required. Clients must check that it is indeed set. It's absence indicates that something changed in a way that is not supported by the client yet, in which case it must refuse to handle the request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminAccess":
            suggest = "admin_access"
        elif key == "allocationMode":
            suggest = "allocation_mode"
        elif key == "deviceClassName":
            suggest = "device_class_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceRequestPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceRequestPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceRequestPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_access: Optional[bool] = None,
                 allocation_mode: Optional[str] = None,
                 count: Optional[int] = None,
                 device_class_name: Optional[str] = None,
                 name: Optional[str] = None,
                 selectors: Optional[Sequence['outputs.DeviceSelectorPatch']] = None):
        """
        DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.

        A DeviceClassName is currently required. Clients must check that it is indeed set. It's absence indicates that something changed in a way that is not supported by the client yet, in which case it must refuse to handle the request.
        :param bool admin_access: AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
        :param str allocation_mode: AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:
               
               - ExactCount: This request is for a specific number of devices.
                 This is the default. The exact number is provided in the
                 count field.
               
               - All: This request is for all of the matching devices in a pool.
                 Allocation will fail if some devices are already allocated,
                 unless adminAccess is requested.
               
               If AlloctionMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.
               
               More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        :param int count: Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        :param str device_class_name: DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.
               
               A class is required. Which classes are available depends on the cluster.
               
               Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        :param str name: Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.
               
               Must be a DNS label.
        :param Sequence['DeviceSelectorPatchArgs'] selectors: Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
        """
        if admin_access is not None:
            pulumi.set(__self__, "admin_access", admin_access)
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if device_class_name is not None:
            pulumi.set(__self__, "device_class_name", device_class_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)

    @property
    @pulumi.getter(name="adminAccess")
    def admin_access(self) -> Optional[bool]:
        """
        AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
        """
        return pulumi.get(self, "admin_access")

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[str]:
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This request is for all of the matching devices in a pool.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AlloctionMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        return pulumi.get(self, "allocation_mode")

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="deviceClassName")
    def device_class_name(self) -> Optional[str]:
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.

        A class is required. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        return pulumi.get(self, "device_class_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.

        Must be a DNS label.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def selectors(self) -> Optional[Sequence['outputs.DeviceSelectorPatch']]:
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
        """
        return pulumi.get(self, "selectors")


@pulumi.output_type
class DeviceSelector(dict):
    """
    DeviceSelector must have exactly one field set.
    """
    def __init__(__self__, *,
                 cel: Optional['outputs.CELDeviceSelector'] = None):
        """
        DeviceSelector must have exactly one field set.
        :param 'CELDeviceSelectorArgs' cel: CEL contains a CEL expression for selecting a device.
        """
        if cel is not None:
            pulumi.set(__self__, "cel", cel)

    @property
    @pulumi.getter
    def cel(self) -> Optional['outputs.CELDeviceSelector']:
        """
        CEL contains a CEL expression for selecting a device.
        """
        return pulumi.get(self, "cel")


@pulumi.output_type
class DeviceSelectorPatch(dict):
    """
    DeviceSelector must have exactly one field set.
    """
    def __init__(__self__, *,
                 cel: Optional['outputs.CELDeviceSelectorPatch'] = None):
        """
        DeviceSelector must have exactly one field set.
        :param 'CELDeviceSelectorPatchArgs' cel: CEL contains a CEL expression for selecting a device.
        """
        if cel is not None:
            pulumi.set(__self__, "cel", cel)

    @property
    @pulumi.getter
    def cel(self) -> Optional['outputs.CELDeviceSelectorPatch']:
        """
        CEL contains a CEL expression for selecting a device.
        """
        return pulumi.get(self, "cel")


@pulumi.output_type
class OpaqueDeviceConfiguration(dict):
    """
    OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.
    """
    def __init__(__self__, *,
                 driver: str,
                 parameters: Any):
        """
        OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.
        :param str driver: Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.
               
               An admission policy provided by the driver developer could use this to decide whether it needs to validate them.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        :param Any parameters: Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.
        """
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def driver(self) -> str:
        """
        Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.

        An admission policy provided by the driver developer could use this to decide whether it needs to validate them.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter
    def parameters(self) -> Any:
        """
        Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class OpaqueDeviceConfigurationPatch(dict):
    """
    OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.
    """
    def __init__(__self__, *,
                 driver: Optional[str] = None,
                 parameters: Optional[Any] = None):
        """
        OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.
        :param str driver: Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.
               
               An admission policy provided by the driver developer could use this to decide whether it needs to validate them.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        :param Any parameters: Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.
        """
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def driver(self) -> Optional[str]:
        """
        Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.

        An admission policy provided by the driver developer could use this to decide whether it needs to validate them.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class PodSchedulingContext(dict):
    """
    PodSchedulingContext objects hold information that is needed to schedule a Pod with ResourceClaims that use "WaitForFirstConsumer" allocation mode.

    This is an alpha type and requires enabling the DRAControlPlaneController feature gate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.PodSchedulingContextSpec',
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 status: Optional['outputs.PodSchedulingContextStatus'] = None):
        """
        PodSchedulingContext objects hold information that is needed to schedule a Pod with ResourceClaims that use "WaitForFirstConsumer" allocation mode.

        This is an alpha type and requires enabling the DRAControlPlaneController feature gate.
        :param 'PodSchedulingContextSpecArgs' spec: Spec describes where resources for the Pod are needed.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        :param 'PodSchedulingContextStatusArgs' status: Status describes where resources for the Pod can be allocated.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha3')
        if kind is not None:
            pulumi.set(__self__, "kind", 'PodSchedulingContext')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.PodSchedulingContextSpec':
        """
        Spec describes where resources for the Pod are needed.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.PodSchedulingContextStatus']:
        """
        Status describes where resources for the Pod can be allocated.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PodSchedulingContextSpec(dict):
    """
    PodSchedulingContextSpec describes where resources for the Pod are needed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "potentialNodes":
            suggest = "potential_nodes"
        elif key == "selectedNode":
            suggest = "selected_node"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingContextSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingContextSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingContextSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 potential_nodes: Optional[Sequence[str]] = None,
                 selected_node: Optional[str] = None):
        """
        PodSchedulingContextSpec describes where resources for the Pod are needed.
        :param Sequence[str] potential_nodes: PotentialNodes lists nodes where the Pod might be able to run.
               
               The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        :param str selected_node: SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        if potential_nodes is not None:
            pulumi.set(__self__, "potential_nodes", potential_nodes)
        if selected_node is not None:
            pulumi.set(__self__, "selected_node", selected_node)

    @property
    @pulumi.getter(name="potentialNodes")
    def potential_nodes(self) -> Optional[Sequence[str]]:
        """
        PotentialNodes lists nodes where the Pod might be able to run.

        The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "potential_nodes")

    @property
    @pulumi.getter(name="selectedNode")
    def selected_node(self) -> Optional[str]:
        """
        SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        return pulumi.get(self, "selected_node")


@pulumi.output_type
class PodSchedulingContextSpecPatch(dict):
    """
    PodSchedulingContextSpec describes where resources for the Pod are needed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "potentialNodes":
            suggest = "potential_nodes"
        elif key == "selectedNode":
            suggest = "selected_node"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingContextSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingContextSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingContextSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 potential_nodes: Optional[Sequence[str]] = None,
                 selected_node: Optional[str] = None):
        """
        PodSchedulingContextSpec describes where resources for the Pod are needed.
        :param Sequence[str] potential_nodes: PotentialNodes lists nodes where the Pod might be able to run.
               
               The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        :param str selected_node: SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        if potential_nodes is not None:
            pulumi.set(__self__, "potential_nodes", potential_nodes)
        if selected_node is not None:
            pulumi.set(__self__, "selected_node", selected_node)

    @property
    @pulumi.getter(name="potentialNodes")
    def potential_nodes(self) -> Optional[Sequence[str]]:
        """
        PotentialNodes lists nodes where the Pod might be able to run.

        The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "potential_nodes")

    @property
    @pulumi.getter(name="selectedNode")
    def selected_node(self) -> Optional[str]:
        """
        SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        return pulumi.get(self, "selected_node")


@pulumi.output_type
class PodSchedulingContextStatus(dict):
    """
    PodSchedulingContextStatus describes where resources for the Pod can be allocated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceClaims":
            suggest = "resource_claims"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingContextStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingContextStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingContextStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_claims: Optional[Sequence['outputs.ResourceClaimSchedulingStatus']] = None):
        """
        PodSchedulingContextStatus describes where resources for the Pod can be allocated.
        :param Sequence['ResourceClaimSchedulingStatusArgs'] resource_claims: ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        if resource_claims is not None:
            pulumi.set(__self__, "resource_claims", resource_claims)

    @property
    @pulumi.getter(name="resourceClaims")
    def resource_claims(self) -> Optional[Sequence['outputs.ResourceClaimSchedulingStatus']]:
        """
        ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        return pulumi.get(self, "resource_claims")


@pulumi.output_type
class PodSchedulingContextStatusPatch(dict):
    """
    PodSchedulingContextStatus describes where resources for the Pod can be allocated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceClaims":
            suggest = "resource_claims"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingContextStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingContextStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingContextStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_claims: Optional[Sequence['outputs.ResourceClaimSchedulingStatusPatch']] = None):
        """
        PodSchedulingContextStatus describes where resources for the Pod can be allocated.
        :param Sequence['ResourceClaimSchedulingStatusPatchArgs'] resource_claims: ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        if resource_claims is not None:
            pulumi.set(__self__, "resource_claims", resource_claims)

    @property
    @pulumi.getter(name="resourceClaims")
    def resource_claims(self) -> Optional[Sequence['outputs.ResourceClaimSchedulingStatusPatch']]:
        """
        ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        return pulumi.get(self, "resource_claims")


@pulumi.output_type
class ResourceClaim(dict):
    """
    ResourceClaim describes a request for access to resources in the cluster, for use by workloads. For example, if a workload needs an accelerator device with specific properties, this is how that request is expressed. The status stanza tracks whether this claim has been satisfied and what specific resources have been allocated.

    This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaim. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaim.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaim.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.ResourceClaimSpec',
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 status: Optional['outputs.ResourceClaimStatus'] = None):
        """
        ResourceClaim describes a request for access to resources in the cluster, for use by workloads. For example, if a workload needs an accelerator device with specific properties, this is how that request is expressed. The status stanza tracks whether this claim has been satisfied and what specific resources have been allocated.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param 'ResourceClaimSpecArgs' spec: Spec describes what is being requested and how to configure it. The spec is immutable.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        :param 'ResourceClaimStatusArgs' status: Status describes whether the claim is ready to use and what has been allocated.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha3')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClaim')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ResourceClaimSpec':
        """
        Spec describes what is being requested and how to configure it. The spec is immutable.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.ResourceClaimStatus']:
        """
        Status describes whether the claim is ready to use and what has been allocated.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ResourceClaimConsumerReference(dict):
    """
    ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimConsumerReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimConsumerReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimConsumerReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 resource: str,
                 uid: str,
                 api_group: Optional[str] = None):
        """
        ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
        :param str name: Name is the name of resource being referenced.
        :param str resource: Resource is the type of resource being referenced, for example "pods".
        :param str uid: UID identifies exactly one incarnation of the resource.
        :param str api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "uid", uid)
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resource(self) -> str:
        """
        Resource is the type of resource being referenced, for example "pods".
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        UID identifies exactly one incarnation of the resource.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[str]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")


@pulumi.output_type
class ResourceClaimConsumerReferencePatch(dict):
    """
    ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimConsumerReferencePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimConsumerReferencePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimConsumerReferencePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_group: Optional[str] = None,
                 name: Optional[str] = None,
                 resource: Optional[str] = None,
                 uid: Optional[str] = None):
        """
        ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
        :param str api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        :param str name: Name is the name of resource being referenced.
        :param str resource: Resource is the type of resource being referenced, for example "pods".
        :param str uid: UID identifies exactly one incarnation of the resource.
        """
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[str]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resource(self) -> Optional[str]:
        """
        Resource is the type of resource being referenced, for example "pods".
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def uid(self) -> Optional[str]:
        """
        UID identifies exactly one incarnation of the resource.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ResourceClaimSchedulingStatus(dict):
    """
    ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unsuitableNodes":
            suggest = "unsuitable_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimSchedulingStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimSchedulingStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimSchedulingStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 unsuitable_nodes: Optional[Sequence[str]] = None):
        """
        ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
        :param str name: Name matches the pod.spec.resourceClaims[*].Name field.
        :param Sequence[str] unsuitable_nodes: UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.
               
               The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        pulumi.set(__self__, "name", name)
        if unsuitable_nodes is not None:
            pulumi.set(__self__, "unsuitable_nodes", unsuitable_nodes)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name matches the pod.spec.resourceClaims[*].Name field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="unsuitableNodes")
    def unsuitable_nodes(self) -> Optional[Sequence[str]]:
        """
        UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.

        The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "unsuitable_nodes")


@pulumi.output_type
class ResourceClaimSchedulingStatusPatch(dict):
    """
    ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unsuitableNodes":
            suggest = "unsuitable_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimSchedulingStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimSchedulingStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimSchedulingStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 unsuitable_nodes: Optional[Sequence[str]] = None):
        """
        ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
        :param str name: Name matches the pod.spec.resourceClaims[*].Name field.
        :param Sequence[str] unsuitable_nodes: UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.
               
               The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if unsuitable_nodes is not None:
            pulumi.set(__self__, "unsuitable_nodes", unsuitable_nodes)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name matches the pod.spec.resourceClaims[*].Name field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="unsuitableNodes")
    def unsuitable_nodes(self) -> Optional[Sequence[str]]:
        """
        UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.

        The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "unsuitable_nodes")


@pulumi.output_type
class ResourceClaimSpec(dict):
    """
    ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it.
    """
    def __init__(__self__, *,
                 controller: Optional[str] = None,
                 devices: Optional['outputs.DeviceClaim'] = None):
        """
        ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it.
        :param str controller: Controller is the name of the DRA driver that is meant to handle allocation of this claim. If empty, allocation is handled by the scheduler while scheduling a pod.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        :param 'DeviceClaimArgs' devices: Devices defines how to request devices.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)

    @property
    @pulumi.getter
    def controller(self) -> Optional[str]:
        """
        Controller is the name of the DRA driver that is meant to handle allocation of this claim. If empty, allocation is handled by the scheduler while scheduling a pod.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "controller")

    @property
    @pulumi.getter
    def devices(self) -> Optional['outputs.DeviceClaim']:
        """
        Devices defines how to request devices.
        """
        return pulumi.get(self, "devices")


@pulumi.output_type
class ResourceClaimSpecPatch(dict):
    """
    ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it.
    """
    def __init__(__self__, *,
                 controller: Optional[str] = None,
                 devices: Optional['outputs.DeviceClaimPatch'] = None):
        """
        ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it.
        :param str controller: Controller is the name of the DRA driver that is meant to handle allocation of this claim. If empty, allocation is handled by the scheduler while scheduling a pod.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        :param 'DeviceClaimPatchArgs' devices: Devices defines how to request devices.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)

    @property
    @pulumi.getter
    def controller(self) -> Optional[str]:
        """
        Controller is the name of the DRA driver that is meant to handle allocation of this claim. If empty, allocation is handled by the scheduler while scheduling a pod.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "controller")

    @property
    @pulumi.getter
    def devices(self) -> Optional['outputs.DeviceClaimPatch']:
        """
        Devices defines how to request devices.
        """
        return pulumi.get(self, "devices")


@pulumi.output_type
class ResourceClaimStatus(dict):
    """
    ResourceClaimStatus tracks whether the resource has been allocated and what the result of that was.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deallocationRequested":
            suggest = "deallocation_requested"
        elif key == "reservedFor":
            suggest = "reserved_for"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation: Optional['outputs.AllocationResult'] = None,
                 deallocation_requested: Optional[bool] = None,
                 reserved_for: Optional[Sequence['outputs.ResourceClaimConsumerReference']] = None):
        """
        ResourceClaimStatus tracks whether the resource has been allocated and what the result of that was.
        :param 'AllocationResultArgs' allocation: Allocation is set once the claim has been allocated successfully.
        :param bool deallocation_requested: Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.
               
               This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        :param Sequence['ResourceClaimConsumerReferenceArgs'] reserved_for: ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.
               
               In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.
               
               Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.
               
               There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
        if allocation is not None:
            pulumi.set(__self__, "allocation", allocation)
        if deallocation_requested is not None:
            pulumi.set(__self__, "deallocation_requested", deallocation_requested)
        if reserved_for is not None:
            pulumi.set(__self__, "reserved_for", reserved_for)

    @property
    @pulumi.getter
    def allocation(self) -> Optional['outputs.AllocationResult']:
        """
        Allocation is set once the claim has been allocated successfully.
        """
        return pulumi.get(self, "allocation")

    @property
    @pulumi.getter(name="deallocationRequested")
    def deallocation_requested(self) -> Optional[bool]:
        """
        Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.

        This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "deallocation_requested")

    @property
    @pulumi.getter(name="reservedFor")
    def reserved_for(self) -> Optional[Sequence['outputs.ResourceClaimConsumerReference']]:
        """
        ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.

        In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.

        Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.

        There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "reserved_for")


@pulumi.output_type
class ResourceClaimStatusPatch(dict):
    """
    ResourceClaimStatus tracks whether the resource has been allocated and what the result of that was.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deallocationRequested":
            suggest = "deallocation_requested"
        elif key == "reservedFor":
            suggest = "reserved_for"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation: Optional['outputs.AllocationResultPatch'] = None,
                 deallocation_requested: Optional[bool] = None,
                 reserved_for: Optional[Sequence['outputs.ResourceClaimConsumerReferencePatch']] = None):
        """
        ResourceClaimStatus tracks whether the resource has been allocated and what the result of that was.
        :param 'AllocationResultPatchArgs' allocation: Allocation is set once the claim has been allocated successfully.
        :param bool deallocation_requested: Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.
               
               This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        :param Sequence['ResourceClaimConsumerReferencePatchArgs'] reserved_for: ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.
               
               In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.
               
               Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.
               
               There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
        if allocation is not None:
            pulumi.set(__self__, "allocation", allocation)
        if deallocation_requested is not None:
            pulumi.set(__self__, "deallocation_requested", deallocation_requested)
        if reserved_for is not None:
            pulumi.set(__self__, "reserved_for", reserved_for)

    @property
    @pulumi.getter
    def allocation(self) -> Optional['outputs.AllocationResultPatch']:
        """
        Allocation is set once the claim has been allocated successfully.
        """
        return pulumi.get(self, "allocation")

    @property
    @pulumi.getter(name="deallocationRequested")
    def deallocation_requested(self) -> Optional[bool]:
        """
        Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.

        This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "deallocation_requested")

    @property
    @pulumi.getter(name="reservedFor")
    def reserved_for(self) -> Optional[Sequence['outputs.ResourceClaimConsumerReferencePatch']]:
        """
        ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.

        In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.

        Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.

        There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "reserved_for")


@pulumi.output_type
class ResourceClaimTemplate(dict):
    """
    ResourceClaimTemplate is used to produce ResourceClaim objects.

    This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.ResourceClaimTemplateSpec',
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None):
        """
        ResourceClaimTemplate is used to produce ResourceClaim objects.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param 'ResourceClaimTemplateSpecArgs' spec: Describes the ResourceClaim that is to be generated.
               
               This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha3')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClaimTemplate')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ResourceClaimTemplateSpec':
        """
        Describes the ResourceClaim that is to be generated.

        This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class ResourceClaimTemplateSpec(dict):
    """
    ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
    """
    def __init__(__self__, *,
                 spec: 'outputs.ResourceClaimSpec',
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        :param 'ResourceClaimSpecArgs' spec: Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        :param '_meta.v1.ObjectMetaArgs' metadata: ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        pulumi.set(__self__, "spec", spec)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ResourceClaimSpec':
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class ResourceClaimTemplateSpecPatch(dict):
    """
    ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
    """
    def __init__(__self__, *,
                 metadata: Optional['_meta.v1.outputs.ObjectMetaPatch'] = None,
                 spec: Optional['outputs.ResourceClaimSpecPatch'] = None):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        :param '_meta.v1.ObjectMetaPatchArgs' metadata: ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        :param 'ResourceClaimSpecPatchArgs' spec: Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMetaPatch']:
        """
        ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.ResourceClaimSpecPatch']:
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class ResourcePool(dict):
    """
    ResourcePool describes the pool that ResourceSlices belong to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceSliceCount":
            suggest = "resource_slice_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 generation: int,
                 name: str,
                 resource_slice_count: int):
        """
        ResourcePool describes the pool that ResourceSlices belong to.
        :param int generation: Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.
               
               Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        :param str name: Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.
               
               It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        :param int resource_slice_count: ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.
               
               Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_slice_count", resource_slice_count)

    @property
    @pulumi.getter
    def generation(self) -> int:
        """
        Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.

        Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.

        It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceSliceCount")
    def resource_slice_count(self) -> int:
        """
        ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.

        Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
        return pulumi.get(self, "resource_slice_count")


@pulumi.output_type
class ResourcePoolPatch(dict):
    """
    ResourcePool describes the pool that ResourceSlices belong to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceSliceCount":
            suggest = "resource_slice_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePoolPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePoolPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePoolPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 generation: Optional[int] = None,
                 name: Optional[str] = None,
                 resource_slice_count: Optional[int] = None):
        """
        ResourcePool describes the pool that ResourceSlices belong to.
        :param int generation: Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.
               
               Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        :param str name: Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.
               
               It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        :param int resource_slice_count: ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.
               
               Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_slice_count is not None:
            pulumi.set(__self__, "resource_slice_count", resource_slice_count)

    @property
    @pulumi.getter
    def generation(self) -> Optional[int]:
        """
        Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.

        Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.

        It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceSliceCount")
    def resource_slice_count(self) -> Optional[int]:
        """
        ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.

        Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
        return pulumi.get(self, "resource_slice_count")


@pulumi.output_type
class ResourceSliceSpec(dict):
    """
    ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allNodes":
            suggest = "all_nodes"
        elif key == "nodeName":
            suggest = "node_name"
        elif key == "nodeSelector":
            suggest = "node_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceSliceSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceSliceSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceSliceSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver: str,
                 pool: 'outputs.ResourcePool',
                 all_nodes: Optional[bool] = None,
                 devices: Optional[Sequence['outputs.Device']] = None,
                 node_name: Optional[str] = None,
                 node_selector: Optional['_core.v1.outputs.NodeSelector'] = None):
        """
        ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
        :param str driver: Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        :param 'ResourcePoolArgs' pool: Pool describes the pool that this ResourceSlice belongs to.
        :param bool all_nodes: AllNodes indicates that all nodes have access to the resources in the pool.
               
               Exactly one of NodeName, NodeSelector and AllNodes must be set.
        :param Sequence['DeviceArgs'] devices: Devices lists some or all of the devices in this pool.
               
               Must not have more than 128 entries.
        :param str node_name: NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.
               
               This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.
               
               Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
        :param '_core.v1.NodeSelectorArgs' node_selector: NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.
               
               Must use exactly one term.
               
               Exactly one of NodeName, NodeSelector and AllNodes must be set.
        """
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "pool", pool)
        if all_nodes is not None:
            pulumi.set(__self__, "all_nodes", all_nodes)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)

    @property
    @pulumi.getter
    def driver(self) -> str:
        """
        Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter
    def pool(self) -> 'outputs.ResourcePool':
        """
        Pool describes the pool that this ResourceSlice belongs to.
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter(name="allNodes")
    def all_nodes(self) -> Optional[bool]:
        """
        AllNodes indicates that all nodes have access to the resources in the pool.

        Exactly one of NodeName, NodeSelector and AllNodes must be set.
        """
        return pulumi.get(self, "all_nodes")

    @property
    @pulumi.getter
    def devices(self) -> Optional[Sequence['outputs.Device']]:
        """
        Devices lists some or all of the devices in this pool.

        Must not have more than 128 entries.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[str]:
        """
        NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.

        This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.

        Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional['_core.v1.outputs.NodeSelector']:
        """
        NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.

        Must use exactly one term.

        Exactly one of NodeName, NodeSelector and AllNodes must be set.
        """
        return pulumi.get(self, "node_selector")


@pulumi.output_type
class ResourceSliceSpecPatch(dict):
    """
    ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allNodes":
            suggest = "all_nodes"
        elif key == "nodeName":
            suggest = "node_name"
        elif key == "nodeSelector":
            suggest = "node_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceSliceSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceSliceSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceSliceSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_nodes: Optional[bool] = None,
                 devices: Optional[Sequence['outputs.DevicePatch']] = None,
                 driver: Optional[str] = None,
                 node_name: Optional[str] = None,
                 node_selector: Optional['_core.v1.outputs.NodeSelectorPatch'] = None,
                 pool: Optional['outputs.ResourcePoolPatch'] = None):
        """
        ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
        :param bool all_nodes: AllNodes indicates that all nodes have access to the resources in the pool.
               
               Exactly one of NodeName, NodeSelector and AllNodes must be set.
        :param Sequence['DevicePatchArgs'] devices: Devices lists some or all of the devices in this pool.
               
               Must not have more than 128 entries.
        :param str driver: Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        :param str node_name: NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.
               
               This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.
               
               Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
        :param '_core.v1.NodeSelectorPatchArgs' node_selector: NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.
               
               Must use exactly one term.
               
               Exactly one of NodeName, NodeSelector and AllNodes must be set.
        :param 'ResourcePoolPatchArgs' pool: Pool describes the pool that this ResourceSlice belongs to.
        """
        if all_nodes is not None:
            pulumi.set(__self__, "all_nodes", all_nodes)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)

    @property
    @pulumi.getter(name="allNodes")
    def all_nodes(self) -> Optional[bool]:
        """
        AllNodes indicates that all nodes have access to the resources in the pool.

        Exactly one of NodeName, NodeSelector and AllNodes must be set.
        """
        return pulumi.get(self, "all_nodes")

    @property
    @pulumi.getter
    def devices(self) -> Optional[Sequence['outputs.DevicePatch']]:
        """
        Devices lists some or all of the devices in this pool.

        Must not have more than 128 entries.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter
    def driver(self) -> Optional[str]:
        """
        Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[str]:
        """
        NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.

        This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.

        Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional['_core.v1.outputs.NodeSelectorPatch']:
        """
        NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.

        Must use exactly one term.

        Exactly one of NodeName, NodeSelector and AllNodes must be set.
        """
        return pulumi.get(self, "node_selector")

    @property
    @pulumi.getter
    def pool(self) -> Optional['outputs.ResourcePoolPatch']:
        """
        Pool describes the pool that this ResourceSlice belongs to.
        """
        return pulumi.get(self, "pool")


