# mypy-boto3-migrationhub-config

[![PyPI - mypy-boto3-migrationhub-config](https://img.shields.io/pypi/v/mypy-boto3-migrationhub-config.svg?color=blue)](https://pypi.org/project/mypy-boto3-migrationhub-config)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-migrationhub-config.svg?color=blue)](https://pypi.org/project/mypy-boto3-migrationhub-config)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.MigrationHubConfig 1.14.4](https://boto3.amazonaws.com/v1/documentation/api/1.14.4/reference/services/migrationhub-config.html#MigrationHubConfig) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `MigrationHubConfig` service.

```bash
python -m pip install boto3-stubs[migrationhub-config]
```

## How to use

### Client annotations

`MigrationHubConfigClient` provides annotations for `boto3.client("migrationhub-config")`.

```python
import boto3

from mypy_boto3_migrationhub_config import MigrationHubConfigClient
from mypy_boto3_migrationhub_config.type_defs import HomeRegionControlTypeDef, ...

client: MigrationHubConfigClient = boto3.client("migrationhub-config")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: MigrationHubConfigClient = session.client("migrationhub-config")
```








### Typed dictionations

`mypy_boto3_migrationhub_config.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> HomeRegionControlTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_migrationhub_config` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("migrationhub-config")

session_client = boto3.Session().client("migrationhub-config")
```
