# Generated by Django 1.9.9 on 2017-01-19 18:58

from django.db import migrations


insurances = [
    ('111', 'Všeobecná zdravotní pojišťovna ČR'),
    ('201', 'Vojenská zdravotní pojišťovna ČR'),
    ('205', 'Česká průmyslová zdravotní pojišťovna'),
    ('207', 'Oborová zdravotní poj. zam. bank, poj. a stav.'),
    ('209', 'Zaměstnanecká pojišťovna Škoda'),
    ('211', 'Zdravotní pojišťovna ministerstva vnitra ČR'),
    ('213', 'Revírní bratrská pokladna, zdrav. pojišťovna'),
]

subject_types = [
    {'subject_type': 'course', 'name': 'kroužek', 'name_genitiv': 'kroužku', 'name_akuzativ': 'kroužek', 'plural': 'kroužky', 'slug': 'krouzky'},
    {'subject_type': 'event',  'name': 'tábor',   'name_genitiv': 'táboru',  'name_akuzativ': 'tábor',   'plural': 'tábory',  'slug': 'tabory'},
]

age_groups = ['děti', 'dospělí']


def initial_data(apps, schema_editor):
    Insurance = apps.get_model('leprikon', 'insurance')
    if Insurance.objects.count() == 0:
        [Insurance.objects.create(code=i[0], name=i[1]) for i in insurances]

    PrintSetup = apps.get_model('leprikon', 'printsetup')
    print_setup = PrintSetup.objects.first() or PrintSetup.objects.create(name='výchozí')

    SubjectType = apps.get_model('leprikon', 'subjecttype')
    if SubjectType.objects.count() == 0:
        [SubjectType.objects.create(order=order, reg_print_setup=print_setup, **st) for order, st in enumerate(subject_types)]

    AgeGroup = apps.get_model('leprikon', 'agegroup')
    if AgeGroup.objects.count() == 0:
        [AgeGroup.objects.create(order=order, name=name) for order, name in enumerate(age_groups)]


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('leprikon', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(initial_data),
    ]
