"""
Greb pipeline module.

Provides orchestrators, tools, and utilities for intelligent code search.
"""

from .base import (
    FileSpan,
    CandidateMatch,
    RankedResult,
    PipelineConfig,
    ExtractedKeywords,
    QueryRequest,
    QueryResponse,
)

from .orchestrator import PipelineOrchestrator, create_orchestrator
from .grep import GrepTool
from .read import ReadTool
from .rerank import RerankTool

# Optional intelligent components
try:
    from .intelligent_orchestrator import IntelligentOrchestrator
    from .code_analyzer import FastCodeAnalyzer, CodeReference
    from .search_context import SearchContext
    from .bm25_scorer import BM25Scorer, score_candidates as bm25_score_candidates
    from .flashrank_reranker import FlashRankReranker, flashrank_rerank

    __all__ = [
        # Base classes
        'FileSpan',
        'CandidateMatch',
        'RankedResult',
        'PipelineConfig',
        'ExtractedKeywords',
        'QueryRequest',
        'QueryResponse',
        # Orchestrators
        'PipelineOrchestrator',
        'IntelligentOrchestrator',
        'create_orchestrator',
        # Tools
        'GrepTool',
        'ReadTool',
        'RerankTool',
        # Intelligent components
        'FastCodeAnalyzer',
        'CodeReference',
        'SearchContext',
        'BM25Scorer',
        'bm25_score_candidates',
        'FlashRankReranker',
        'flashrank_rerank',
    ]
except ImportError:
    # Intelligent components not available
    __all__ = [
        # Base classes
        'FileSpan',
        'CandidateMatch',
        'RankedResult',
        'PipelineConfig',
        'ExtractedKeywords',
        'QueryRequest',
        'QueryResponse',
        # Orchestrators
        'PipelineOrchestrator',
        'create_orchestrator',
        # Tools
        'GrepTool',
        'ReadTool',
        'RerankTool',
    ]
