# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins
import collections.abc
import numpy
import numpy.typing
import typing
from quil import QuilError
from quil.instructions import AttributeValue, CalibrationDefinition, CalibrationIdentifier, Declaration, FrameIdentifier, Gate, GateDefinition, GateSignature, Instruction, MeasureCalibrationDefinition, MeasureCalibrationIdentifier, Measurement, MemoryReference, Pragma, Qubit, QubitPlaceholder, Sharing, Target, TargetPlaceholder, Vector, Waveform

class BasicBlock:
    @property
    def instructions(self) -> builtins.list[Instruction]:
        r"""
        A list of the instructions in the block, in order of definition.
        
        This does not include the label or terminator instructions.
        """
    @property
    def label(self) -> typing.Optional[Target]:
        r"""
        The label of the block, if any.
        This is used to target this block in control flow.
        """
    @property
    def terminator(self) -> typing.Optional[Instruction]:
        r"""
        The control flow terminator instruction of the block, if any.
        
        If this is ``None``, the implicit behavior is to "continue" to the subsequent block.
        """
    def __new__(cls, instance:BasicBlock) -> BasicBlock: ...
    def __repr__(self) -> builtins.str: ...
    def as_schedule_seconds(self, program:Program) -> ScheduleSeconds: ...
    def gate_depth(self, gate_minimum_qubit_count:builtins.int) -> builtins.int:
        r"""
        Return the length of the longest path
        from an initial instruction (one with no prerequisite instructions)
        to a final instruction (one with no dependent instructions),
        where the length of a path is the number of gate instructions in the path.
        
        :param gate_minimum_qubit_count:
            The minimum number of qubits in a gate
            for it to be counted in the depth.
        """

class BasicBlockScheduleError(ProgramError):
    ...

class CalibrationExpansion:
    r"""
    Details about the expansion of a calibration.
    """
    @property
    def calibration_used(self) -> CalibrationSource:
        r"""
        The calibration used to expand the instruction.
        """
    @property
    def expansions(self) -> InstructionSourceMap:
        r"""
        The source map describing the nested expansions made.
        """
    @property
    def range(self) -> range:
        r"""
        The range of instructions in the expanded list
        which were generated by this expansion.
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __repr__(self) -> builtins.str: ...

class CalibrationSet:
    r"""
    A collection of Quil calibrations (`DEFCAL` instructions) with utility methods.
    
    This exposes the semantics similar to [`CalibrationSet`] to Python users,
    so see the documentation there for more information.
    """
    @property
    def calibrations(self) -> builtins.list[CalibrationDefinition]:
        r"""
        Return a list of all [`CalibrationDefinition`]s in the set.
        """
    @property
    def measure_calibrations(self) -> builtins.list[MeasureCalibrationDefinition]:
        r"""
        Return a list of all [`MeasureCalibrationDefinition`]s in the set.
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __len__(self) -> builtins.int:
        r"""
        Return the count of contained calibrations.
        """
    def __new__(cls, calibrations:typing.Sequence[CalibrationDefinition], measure_calibrations:typing.Sequence[MeasureCalibrationDefinition]) -> CalibrationSet: ...
    def __repr__(self) -> builtins.str: ...
    def expand(self, instruction:Instruction, previous_calibrations:typing.Sequence[Instruction]) -> typing.Optional[builtins.list[Instruction]]:
        r"""
        Given an instruction, return the instructions to which it is expanded if there is a match.
        Recursively calibrate instructions, returning an error if a calibration directly or indirectly
        expands into itself.
        
        Return only the expanded instructions; for more information about the expansion process,
        see [`Self::expand_with_detail`].
        """
    def extend(self, other:CalibrationSet) -> None:
        r"""
        Append another [`CalibrationSet`] onto this one.
        
        Calibrations with conflicting [`CalibrationSignature`]s are overwritten by the ones in the
        given set.
        """
    def get_match_for_gate(self, gate:Gate) -> typing.Optional[CalibrationDefinition]:
        r"""
        Return the final calibration which matches the gate per the `QuilT` specification:
        
        A calibration matches a gate if:
        1. It has the same name
        2. It has the same modifiers
        3. It has the same qubit count (any mix of fixed & variable)
        4. It has the same parameter count (both specified and unspecified)
        5. All fixed qubits in the calibration definition match those in the gate
        6. All specified parameters in the calibration definition match those in the gate
        """
    def get_match_for_measurement(self, measurement:Measurement) -> typing.Optional[MeasureCalibrationDefinition]:
        r"""
        Returns the last-specified ``MeasureCalibrationDefinition`` that matches the target
        qubit (if any), or otherwise the last-specified one that specified no qubit.
        
        If multiple calibrations match the measurement, the precedence is as follows:
        
          1. Match fixed qubit.
          2. Match variable qubit.
          3. Match no qubit.
        
        In the case of multiple calibrations with equal precedence, the last one wins.
        """
    def insert_calibration(self, calibration:CalibrationDefinition) -> typing.Optional[CalibrationDefinition]:
        r"""
        Insert a [`CalibrationDefinition`] into the set.
        
        If a calibration with the same [signature][crate::instruction::CalibrationSignature] already
        exists in the set, it will be replaced and the old calibration will be returned.
        """
    def insert_measurement_calibration(self, calibration:MeasureCalibrationDefinition) -> typing.Optional[MeasureCalibrationDefinition]:
        r"""
        Insert a [`MeasureCalibrationDefinition`] into the set.
        
        If a calibration with the same [signature][crate::instruction::CalibrationSignature] already
        exists in the set, it will be replaced and the old calibration will be returned.
        """
    def is_empty(self) -> builtins.bool:
        r"""
        Return true if this contains no data.
        """
    def to_instructions(self) -> builtins.list[Instruction]:
        r"""
        Return the Quil instructions which describe the contained calibrations.
        """

class CalibrationSource:
    r"""
    The source of a calibration, either a [`CalibrationIdentifier`] or a
    [`MeasureCalibrationIdentifier`].
    """
    def __getnewargs__(self) -> tuple[CalibrationIdentifier | MeasureCalibrationIdentifier]: ...
    def __repr__(self) -> builtins.str: ...
    class Calibration(CalibrationSource):
        r"""
        Describes a `DEFCAL` instruction
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> CalibrationIdentifier: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:CalibrationIdentifier) -> CalibrationSource.Calibration: ...
    
    class MeasureCalibration(CalibrationSource):
        r"""
        Describes a `DEFCAL MEASURE` instruction
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> MeasureCalibrationIdentifier: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:MeasureCalibrationIdentifier) -> CalibrationSource.MeasureCalibration: ...
    

class ComputedScheduleError(ProgramError):
    r"""
    Error raised if the computed schedule is invalid.
    """
    ...

class ControlFlowGraph:
    def __new__(cls, instance:ControlFlowGraph) -> ControlFlowGraph: ...
    def __repr__(self) -> builtins.str: ...
    def basic_blocks(self) -> builtins.list[BasicBlock]:
        r"""
        Return a list of all the basic blocks in the control flow graph, in order of definition.
        """
    def has_dynamic_control_flow(self) -> builtins.bool:
        r"""
        Return ``True`` if the program has dynamic control flow, i.e. contains a conditional branch instruction.
        
        ``False`` does not imply that there is only one basic block in the program.
        Multiple basic blocks may have non-conditional control flow among them,
        in which the execution order is deterministic and does not depend on program state.
        This may be a sequence of basic blocks with fixed `JUMP`s or without explicit terminators.
        """

class FrameSet:
    r"""
    A collection of Quil frames (`DEFFRAME` instructions) with utility methods.
    """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __len__(self) -> builtins.int:
        r"""
        Return the number of frames described within.
        """
    def __new__(cls) -> FrameSet: ...
    def __repr__(self) -> builtins.str: ...
    def get(self, identifier:FrameIdentifier) -> typing.Optional[builtins.dict[builtins.str, AttributeValue]]:
        r"""
        Retrieve the `FrameAttributes` of a `Frame` by its `FrameIdentifier`.
        """
    def get_all_frames(self) -> builtins.dict[FrameIdentifier, builtins.dict[builtins.str, AttributeValue]]: ...
    def get_keys(self) -> builtins.list[FrameIdentifier]:
        r"""
        Return a list of all `FrameIdentifier`s described by this `FrameSet`.
        """
    def insert(self, identifier:FrameIdentifier, attributes:typing.Mapping[builtins.str, AttributeValue]) -> None:
        r"""
        Insert a new frame by ID, overwriting any existing one.
        """
    def intersection(self, identifiers:builtins.set[FrameIdentifier]) -> FrameSet:
        r"""
        Return a new `FrameSet` which describes only the given `FrameIdentifier`s.
        """
    def is_empty(self) -> builtins.bool:
        r"""
        Return true if this describes no frames.
        """
    def merge(self, other:FrameSet) -> None:
        r"""
        Merge another [FrameSet] with this one, overwriting any existing keys
        """
    def to_instructions(self) -> builtins.list[Instruction]:
        r"""
        Return the Quil instructions which describe the contained frames.
        """

class InstructionSourceMap:
    r"""
    A source map describing how instructions in a source program were
    expanded into a target program. Each entry describes an instruction
    index in the source program which were expanded accordingto either
    a calibration or a sequence gate definition.
    """
    def entries(self) -> builtins.list[InstructionSourceMapEntry]: ...
    def list_sources_for_calibration_used(self, calibration_used:CalibrationSource) -> builtins.list[builtins.int]:
        r"""
        Given a particular calibration (`DEFCAL` or `DEFCAL MEASURE`), =
        return the locations in the source which were expanded using that calibration.
        
        This is `O(n)` where `n` is the number of first-level calibration expansions performed,
        which is at worst `O(i)` where `i` is the number of source instructions.
        """
    def list_sources_for_gate_expansion(self, gate_signature:GateSignature) -> builtins.list[builtins.int]:
        r"""
        Given a gate signature, return the locations in the source program which were
        expanded using that gate signature.
        
        This is `O(n)` where `n` is the number of first-level sequence gate expansions performed,
        which is at worst `O(i)` where `i` is the number of source instructions.
        """
    def list_sources_for_target_index(self, target_index:builtins.int) -> builtins.list[builtins.int]:
        r"""
        Return all source ranges in the source map
        which were used to generate the target index.
        
        This is `O(n)` where `n` is the number of first-level expansions performed,
        which is at worst `O(i)` where `i` is the number of source instructions.
        """
    def list_targets_for_source_index(self, source_index:builtins.int) -> builtins.list[InstructionTarget]:
        r"""
        Return all target ranges which were used to generate the source range.
        
        This is `O(n)` where `n` is the number of first-level expansions performed,
        which is at worst `O(i)` where `i` is the number of source instructions.
        """

class InstructionSourceMapEntry:
    r"""
    A source map entry, mapping a range of source instructions by index to an
    `InstructionTarget`.
    
    Note that both `source_location` and `target_location` are relative to the scope of expansion.
    In the case of a nested expansion, both describe the location relative only to that
    level of expansion and *not* the original program.
    """
    def source_location(self) -> builtins.int:
        r"""
        The instruction index within the source program's body instructions.
        """
    def target_location(self) -> InstructionTarget:
        r"""
        The location of the expanded instruction within the target program's body instructions.
        """

class InstructionTarget:
    r"""
    The result of having expanded a certain instruction within a program.
    
    - `calibration`: The instruction has a matching Quil-T calibration and was expanded by it into
      other instructions, as described by a `CalibrationExpansion`.
    - `defgate_sequence`: The instruction has a matching `DEFGATE ... AS SEQUENCE` and was expanded
      by it into other instructions, as described by a `DefGateSequenceExpansion`.
    - `unmodified`: The instruction was not expanded and is described by an integer, the index of the instruction
      within the resulting program's body instructions.
    """
    def __getnewargs__(self) -> tuple[CalibrationExpansion, builtins.int]: ...
    def __repr__(self) -> builtins.str: ...
    class Calibration(InstructionTarget):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> CalibrationExpansion: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:CalibrationExpansion) -> InstructionTarget.Calibration: ...
    
    class DefGateSequence(InstructionTarget):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> OwnedDefGateSequenceExpansion: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:OwnedDefGateSequenceExpansion) -> InstructionTarget.DefGateSequence: ...
    
    class Unmodified(InstructionTarget):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.int: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:builtins.int) -> InstructionTarget.Unmodified: ...
    

class MemoryRegion:
    @property
    def sharing(self) -> typing.Optional[Sharing]: ...
    @property
    def size(self) -> Vector: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[Vector, typing.Optional[Sharing]]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, size:Vector, sharing:typing.Optional[Sharing]) -> MemoryRegion: ...
    def __repr__(self) -> builtins.str: ...

class OwnedDefGateSequenceExpansion:
    r"""
    [`DefGateSequenceExpansion`] references data from [`quil_rs::instruction::GateDefinition`]s used to expand instructions.
    As such, it is incompatible with Python's memory management,
    so we define an owned type here.
    """
    @property
    def range(self) -> range:
        r"""
        The range of instructions in the expanded list which were generated by this expansion.
        """
    @property
    def source_signature(self) -> GateSignature:
        r"""
        The signature of the sequence gate definition which was used to expand the instruction.
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def expansions(self) -> InstructionSourceMap:
        r"""
        The source map describing the nested expansions made.
        """

class Program:
    r"""
    A Quil Program instance describes a quantum program with metadata used in execution.
    
    This contains not only instructions which are executed in turn on the quantum processor, but
    also the "headers" used to describe and manipulate those instructions, such as calibrations
    and frame definitions.
    """
    @property
    def body_instructions(self) -> builtins.list[Instruction]: ...
    @property
    def calibrations(self) -> CalibrationSet: ...
    @calibrations.setter
    def calibrations(self, value: CalibrationSet) -> None: ...
    @property
    def declarations(self) -> builtins.dict[builtins.str, Declaration]: ...
    @property
    def frames(self) -> FrameSet: ...
    @frames.setter
    def frames(self, value: FrameSet) -> None: ...
    @property
    def gate_definitions(self) -> builtins.dict[builtins.str, GateDefinition]: ...
    @gate_definitions.setter
    def gate_definitions(self, value: builtins.dict[builtins.str, GateDefinition]) -> None: ...
    @property
    def instructions(self) -> builtins.list[Instruction]: ...
    @instructions.setter
    def instructions(self, value: builtins.list[Instruction]) -> None: ...
    @property
    def memory_regions(self) -> builtins.dict[builtins.str, MemoryRegion]: ...
    @memory_regions.setter
    def memory_regions(self, value: builtins.dict[builtins.str, MemoryRegion]) -> None: ...
    @property
    def pragma_extern_map(self) -> builtins.dict[typing.Optional[builtins.str], Pragma]: ...
    @property
    def used_qubits(self) -> builtins.set[Qubit]: ...
    @property
    def waveforms(self) -> builtins.dict[builtins.str, Waveform]: ...
    @waveforms.setter
    def waveforms(self, value: builtins.dict[builtins.str, Waveform]) -> None: ...
    def __add__(self, rhs:Program) -> Program: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getstate__(self) -> bytes:
        r"""
        This will raise an error if the program contains any unresolved
        placeholders. This is because they can't be converted to valid quil,
        nor can they be serialized and deserialized in a consistent way.
        """
    def __iadd__(self, rhs:Program) -> None: ...
    def __new__(cls) -> Program: ...
    def __repr__(self) -> builtins.str: ...
    def __setstate__(self, state:bytes) -> None: ...
    def add_instruction(self, instruction:Instruction) -> None:
        r"""
        Add an instruction to the end of the program.
        
        Note, parsing extern signatures is deferred here to maintain infallibility
        of [`Program::add_instruction`]. This means that invalid `PRAGMA EXTERN`
        instructions are still added to the [`Program::extern_pragma_map`];
        duplicate `PRAGMA EXTERN` names are overwritten.
        """
    def add_instructions(self, instructions:typing.Sequence[Instruction]) -> None:
        r"""
        Add a list of instructions to the end of the program.
        """
    def clone_without_body_instructions(self) -> Program:
        r"""
        Like `Clone`, but does not clone the body instructions.
        """
    def control_flow_graph(self) -> ControlFlowGraph:
        r"""
        Return the [control flow graph][] of the program.
        
        [control flow graph]: https://en.wikipedia.org/wiki/Control-flow_graph
        """
    def copy(self) -> Program:
        r"""
        Return a deep copy of the `Program`.
        """
    def dagger(self) -> Program:
        r"""
        Creates a new conjugate transpose of the [`Program`] by reversing the order of gate
        instructions and applying the DAGGER modifier to each.
        
        # Errors
        
        Errors if any of the instructions in the program are not [`Instruction::Gate`]
        """
    def expand_calibrations(self) -> Program:
        r"""
        Expand any instructions in the program which have a matching calibration,
        leaving the others unchanged.
        Return the expanded copy of the program.
        
        Returns an error if any instruction expands into itself.
        
        See [`Program::expand_calibrations_with_source_map`] for a version that returns a source mapping.
        """
    def expand_calibrations_with_source_map(self) -> tuple[Program, InstructionSourceMap]:
        r"""
        Expand any instructions in the program which have a matching calibration,
        leaving the others unchanged.
        Return the expanded copy of the program
        and a source mapping describing the expansions made.
        """
    def expand_defgate_sequences(self, predicate:collections.abc.Callable[[str], bool] | None=None) -> Program:
        r"""
        Expand any instructions in the program which have a matching sequence gate definition, leaving
        the others unchanged.
        
        Recurses though each instruction while ensuring there is no cycle in the expansion graph (i.e. no sequence
        gate definitions expand directly or indirectly into itself).
        
        :param predicate: If provided, only sequence gate definitions which match the predicate will be expanded.
            Defaults to expanding all sequence gate definitions.
        
        # Example
        
        Below, we show the results of gate sequence expansion on a program that has two gate
        sequence definitions. The first, `seq1`, has a matching calibration and we do not
        want to expand it. The second, `seq2`, does not have a matching calibration and
        we do want to expand it.
        
        >>> quil = '''
        ... DEFCAL seq1 0 1:
        ...     FENCE 0 1
        ...     NONBLOCKING PULSE 0 "rf" drag_gaussian(duration: 6.000000000000001e-08, fwhm: 1.5000000000000002e-08, t0: 3.0000000000000004e-08, anh: -190000000.0, alpha: -1.6453719598238201, scale: 0.168265925924524, phase: 0.0, detuning: 0)
        ...     NONBLOCKING PULSE 1 "rf" drag_gaussian(duration: 6.000000000000001e-08, fwhm: 1.5000000000000002e-08, t0: 3.0000000000000004e-08, anh: -190000000.0, alpha: -1.6453719598238201, scale: 0.168265925924524, phase: 0.0, detuning: 0)
        ...     FENCE 0 1
        ...
        ... DEFGATE seq1() a b AS SEQUENCE:
        ...     RX(pi/2) a
        ...     RX(pi/2) b
        ...
        ... DEFGATE seq2(%theta, %psi, %phi) a AS SEQUENCE:
        ...     RZ(%theta) a
        ...     RX(pi/2) a
        ...     RZ(%phi) a
        ...
        ... seq1 0 1
        ... seq2(1.5707963267948966, 3.141592653589793, 0) 0
        ... seq2(3.141592653589793, 0, 1.5707963267948966) 1
        ... '''
        >>> program = Program.parse(quil);
        >>> calibrated_gate_names = {calibration.identifier.name for calibration in program.calibrations.calibrations}
        >>> expanded_program = program.expand_defgate_sequences(lambda name: name not in calibrated_gate_names)
        >>>
        >>> expected_quil = '''
        ... DEFCAL seq1 0 1:
        ...     FENCE 0 1
        ...     NONBLOCKING PULSE 0 "rf" drag_gaussian(duration: 6.000000000000001e-08, fwhm: 1.5000000000000002e-08, t0: 3.0000000000000004e-08, anh: -190000000.0, alpha: -1.6453719598238201, scale: 0.168265925924524, phase: 0.0, detuning: 0)
        ...     NONBLOCKING PULSE 1 "rf" drag_gaussian(duration: 6.000000000000001e-08, fwhm: 1.5000000000000002e-08, t0: 3.0000000000000004e-08, anh: -190000000.0, alpha: -1.6453719598238201, scale: 0.168265925924524, phase: 0.0, detuning: 0)
        ...     FENCE 0 1
        ...
        ... DEFGATE seq1 a b AS SEQUENCE:
        ...     RX(pi/2) a
        ...     RX(pi/2) b
        ...
        ... seq1 0 1
        ...
        ... RZ(1.5707963267948966) 0
        ... RX(pi/2) 0
        ... RZ(3.141592653589793) 0
        ... RX(pi/2) 0
        ... RZ(0) 0
        ...
        ... RZ(3.141592653589793) 1
        ... RX(pi/2) 1
        ... RZ(0) 1
        ... RX(pi/2) 1
        ... RZ(1.5707963267948966) 1
        ... '''
        >>>
        >>> expected_program = Program.parse(expected_quil)
        >>>
        >>> assert expanded_program == expected_program
        """
    def expand_defgate_sequences_with_source_map(self, predicate:collections.abc.Callable[[str], bool] | None=None) -> tuple[Program, InstructionSourceMap]:
        r"""
        Expand any instructions in the program which have a matching sequence gate definition, leaving
        the others unchanged. Note, the new program will drop any gate definitions which are no longer
        referenced in the program.
        
        Recurses though each instruction while ensuring there is no cycle in the expansion graph (i.e. no sequence
        gate definitions expand directly or indirectly into itself).
        
        :param predicate: If provided, only sequence gate definitions which match the predicate will be expanded.
        Defaults to expanding all sequence gate definitions.
        
        Return the expanded copy of the program and a source mapping describing the expansions made.
        
        # Example
        
        See `expand_defgate_sequences`.
        """
    def filter_instructions(self, predicate:collections.abc.Callable[[Instruction], bool]) -> Program:
        r"""
        Return a new ``Program`` containing only the instructions
        for which `predicate` returns true.
        """
    def into_simplified(self) -> Program:
        r"""
        Simplify this program into a new [`Program`] which contains only instructions
        and definitions which are executed; effectively, perform dead code removal.
        
        Removes:
        - All calibrations, following calibration expansion
        - Frame definitions which are not used by any instruction such as `PULSE` or `CAPTURE`
        - Waveform definitions which are not used by any instruction
        - `PRAGMA EXTERN` instructions which are not used by any `CALL` instruction (see
          [`Program::extern_pragma_map`]).
        
        When a valid program is simplified, it remains valid.
        
        # Note
        
        If you need custom instruction handling during simplification,
        use [`InstructionHandler::simplify_program`] instead.
        """
    @staticmethod
    def parse(input:builtins.str) -> Program:
        r"""
        Parse a `Program` from a string.
        
        # Errors
        
        Raises a `ProgramError` if the string isn't a valid ``Quil`` expression.
        """
    def resolve_placeholders(self) -> None:
        r"""
        Resolve [`LabelPlaceholder`]s and [`QubitPlaceholder`]s within the program using default resolvers.
        
        See [`resolve_placeholders_with_custom_resolvers`](Self::resolve_placeholders_with_custom_resolvers),
        [`default_target_resolver`](Self::default_target_resolver),
        and [`default_qubit_resolver`](Self::default_qubit_resolver) for more information.
        """
    def resolve_placeholders_with_custom_resolvers(self, *, target_resolver:typing.Optional[collections.abc.Callable[[TargetPlaceholder], typing.Optional[builtins.str]]]=None, qubit_resolver:typing.Optional[collections.abc.Callable[[QubitPlaceholder], typing.Optional[builtins.int]]]=None) -> None:
        r"""
        Resolve ``TargetPlaceholder``s and ``QubitPlaceholder``s within the program.
        
        The resolved values will remain unique to that placeholder
        within the scope of the program.
        If you provide ``target_resolver`` and/or ``qubit_resolver``,
        those will be used to resolve those values respectively.
        If your resolver returns `None` for a particular placeholder,
        it will not be replaced but will be left as a placeholder.
        If you do not provide a resolver for a placeholder,
        a default resolver will be used which will generate
        a unique value for that placeholder within the scope of the program
        using an auto-incrementing value (for qubit) or suffix (for target)
        while ensuring that unique value is not already in use within the program.
        """
    def to_instructions(self) -> builtins.list[Instruction]:
        r"""
        Return a copy of all of the instructions which constitute this [`Program`].
        """
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...
    def to_unitary(self, n_qubits:builtins.int) -> numpy.typing.NDArray[numpy.complex128]:
        r"""
        Return the unitary of a program.
        
        # Errors
        
        Returns an error if the program contains instructions other than `Gate`s.
        """
    def wrap_in_loop(self, loop_count_reference:MemoryReference, start_target:Target, end_target:Target, iterations:builtins.int) -> Program:
        r"""
        Return a copy of the [`Program`] wrapped in a loop that repeats `iterations` times.
        
        The loop is constructed by wrapping the body of the program in classical Quil instructions.
        The given `loop_count_reference` must refer to an INTEGER memory region. The value at the
        reference given will be set to `iterations` and decremented in the loop. The loop will
        terminate when the reference reaches 0. For this reason your program should not itself
        modify the value at the reference unless you intend to modify the remaining number of
        iterations (i.e. to break the loop).
        
        The given `start_target` and `end_target` will be used as the entry and exit points for the
        loop, respectively. You should provide unique [`Target`]s that won't be used elsewhere in
        the program.
        
        If `iterations` is 0, then a copy of the program is returned without any changes.
        """

class ProgramError(QuilError):
    r"""
    Errors encountered related to a Program.
    """
    ...

class QubitGraphError(ProgramError):
    ...

class ScheduleSeconds:
    r"""
    A Schedule is a ``DependencyGraph`` flattened into a linear sequence of instructions,
    each of which is assigned a start time and duration.
    """
    @property
    def duration(self) -> builtins.float:
        r"""
        The schedule duration, in seconds.
        
        This is the maximum end time among all scheduled items.
        """
    @property
    def items(self) -> builtins.list[ScheduleSecondsItem]:
        r"""
        Scheduled items, in an unspecified order.
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __repr__(self) -> builtins.str: ...

class ScheduleSecondsItem:
    r"""
    A single item within a schedule, representing a single instruction within a basic block.
    """
    @property
    def instruction_index(self) -> builtins.int:
        r"""
        The time span during which the instruction is scheduled.
        """
    @property
    def time_span(self) -> TimeSpanSeconds:
        r"""
        The index of the instruction within the basic block.
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __repr__(self) -> builtins.str: ...

class TimeSpanSeconds:
    r"""
    A time span, in seconds.
    """
    @property
    def duration(self) -> builtins.float:
        r"""
        The duration of the time span, in seconds.
        """
    @property
    def end(self) -> builtins.float:
        r"""
        The end time of the time span, in seconds.
        
        This is the sum of the start time and duration.
        """
    @property
    def start(self) -> builtins.float:
        r"""
        The inclusive start time of the time span,
        in seconds relative to the start of the scheduling context (such as the basic block).
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __repr__(self) -> builtins.str: ...

