# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins
import numpy
import numpy.typing
import typing
from quil import QuilError
from quil.expression import Expression
from enum import Enum

class Arithmetic:
    @property
    def destination(self) -> MemoryReference: ...
    @property
    def operator(self) -> ArithmeticOperator: ...
    @property
    def source(self) -> ArithmeticOperand: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[ArithmeticOperator, MemoryReference, ArithmeticOperand]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, operator:ArithmeticOperator, destination:MemoryReference, source:ArithmeticOperand) -> Arithmetic: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class ArithmeticOperand:
    def __getnewargs__(self) -> tuple[int | float | MemoryReference]: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...
    class LiteralInteger(ArithmeticOperand):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.int: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:builtins.int) -> ArithmeticOperand.LiteralInteger: ...
    
    class LiteralReal(ArithmeticOperand):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.float: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:builtins.float) -> ArithmeticOperand.LiteralReal: ...
    
    class MemoryReference(ArithmeticOperand):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> MemoryReference: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:MemoryReference) -> ArithmeticOperand.MemoryReference: ...
    

class AttributeValue:
    def __getnewargs__(self) -> tuple[str | Expression]: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...
    class Expression(AttributeValue):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Expression: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Expression) -> AttributeValue.Expression: ...
    
    class String(AttributeValue):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.str: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:builtins.str) -> AttributeValue.String: ...
    

class BinaryLogic:
    @property
    def destination(self) -> MemoryReference: ...
    @property
    def operator(self) -> BinaryOperator: ...
    @property
    def source(self) -> BinaryOperand: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[BinaryOperator, MemoryReference, BinaryOperand]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, operator:BinaryOperator, destination:MemoryReference, source:BinaryOperand) -> BinaryLogic: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class BinaryOperand:
    def __getnewargs__(self) -> tuple[int | MemoryReference]: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...
    class LiteralInteger(BinaryOperand):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.int: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:builtins.int) -> BinaryOperand.LiteralInteger: ...
    
    class MemoryReference(BinaryOperand):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> MemoryReference: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:MemoryReference) -> BinaryOperand.MemoryReference: ...
    

class CalibrationDefinition:
    @property
    def identifier(self) -> CalibrationIdentifier: ...
    @identifier.setter
    def identifier(self, value: CalibrationIdentifier) -> None: ...
    @property
    def instructions(self) -> builtins.list[Instruction]: ...
    @instructions.setter
    def instructions(self, value: builtins.list[Instruction]) -> None: ...
    @property
    def modifiers(self) -> builtins.list[GateModifier]:
        r"""
        The list of [`GateModifier`]s that this calibration definition is for.
        """
    @property
    def name(self) -> builtins.str:
        r"""
        The gate name that this calibration definition is for.
        """
    @property
    def parameters(self) -> builtins.list[Expression]:
        r"""
        The list of parameters that this calibration definition is for.
        """
    @property
    def qubits(self) -> builtins.list[Qubit]:
        r"""
        The list of [`Qubit`]s that this calibration definition is for.
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[CalibrationIdentifier, builtins.list[Instruction]]: ...
    def __new__(cls, identifier:CalibrationIdentifier, instructions:typing.Sequence[Instruction]) -> CalibrationDefinition:
        r"""
        Builds a new calibration definition.
        """
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class CalibrationIdentifier:
    r"""
    Unique identifier for a calibration definition within a program
    """
    @property
    def modifiers(self) -> builtins.list[GateModifier]:
        r"""
        The modifiers applied to the gate
        """
    @modifiers.setter
    def modifiers(self, value: builtins.list[GateModifier]) -> None:
        r"""
        The modifiers applied to the gate
        """
    @property
    def name(self) -> builtins.str:
        r"""
        The name of the gate
        """
    @name.setter
    def name(self, value: builtins.str) -> None:
        r"""
        The name of the gate
        """
    @property
    def parameters(self) -> builtins.list[Expression]:
        r"""
        The parameters of the gate - these are the variables in the calibration definition
        """
    @parameters.setter
    def parameters(self, value: builtins.list[Expression]) -> None:
        r"""
        The parameters of the gate - these are the variables in the calibration definition
        """
    @property
    def qubits(self) -> builtins.list[Qubit]:
        r"""
        The qubits on which the gate is applied
        """
    @qubits.setter
    def qubits(self, value: builtins.list[Qubit]) -> None:
        r"""
        The qubits on which the gate is applied
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.str, builtins.list[Expression], builtins.list[Qubit], builtins.list[GateModifier]]: ...
    def __new__(cls, name:builtins.str, parameters:typing.Sequence[Expression], qubits:typing.Sequence[Qubit], modifiers:typing.Sequence[GateModifier]) -> CalibrationIdentifier:
        r"""
        Builds a new calibration identifier.
        
        Raises an error if the given name isn't a valid Quil identifier.
        """
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Call:
    r"""
    A call instruction with a name and arguments.
    
    An instruction that calls an external function declared with a `PRAGMA EXTERN` instruction.
    These calls are generally specific to a particular hardware or virtual machine backend.
    
    For further detail, see:
    
    * [Other instructions and Directives](https://github.com/quil-lang/quil/blob/master/rfcs/extern-call.md) in the Quil specification.
    * [EXTERN / CALL RFC](https://github.com/quil-lang/quil/blob/master/rfcs/extern-call.md)
    * [quil#87](https://github.com/quil-lang/quil/issues/87)
    
    Also see [`ExternSignature`].
    """
    @property
    def arguments(self) -> builtins.list[CallArgument]:
        r"""
        The arguments of the call instruction.
        """
    @property
    def name(self) -> builtins.str:
        r"""
        The name of the call instruction. This must be a valid user identifier.
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.str, builtins.list[CallArgument]]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, name:builtins.str, arguments:typing.Sequence[CallArgument]) -> Call:
        r"""
        Create a new call instruction with resolved arguments.
        This will validate the name as a user identifier.
        """
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class CallArgument:
    r"""
    A parsed, but unresolved call argument. This may be resolved into a [`ResolvedCallArgument`]
    with the appropriate [`ExternSignature`]. Resolution is required for building the
    [`crate::Program`] memory graph.
    """
    def __getnewargs__(self) -> tuple[str | MemoryReference | complex]: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...
    class Identifier(CallArgument):
        r"""
        A reference to a declared memory location. Note, this may be resolved to either
        a scalar or vector. In the former case, the assumed index is 0.
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.str: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:builtins.str) -> CallArgument.Identifier: ...
    
    class Immediate(CallArgument):
        r"""
        An immediate value. This may be resolved to a non-mutable scalar.
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.complex: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:builtins.complex) -> CallArgument.Immediate: ...
    
    class MemoryReference(CallArgument):
        r"""
        A reference to a memory location. This may be resolved to a scalar.
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> MemoryReference: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:MemoryReference) -> CallArgument.MemoryReference: ...
    

class CallError(QuilError):
    r"""
    Errors that may occur when initializing a ``Call``.
    """
    ...

class Capture:
    @property
    def blocking(self) -> builtins.bool: ...
    @blocking.setter
    def blocking(self, value: builtins.bool) -> None: ...
    @property
    def frame(self) -> FrameIdentifier: ...
    @frame.setter
    def frame(self, value: FrameIdentifier) -> None: ...
    @property
    def memory_reference(self) -> MemoryReference: ...
    @memory_reference.setter
    def memory_reference(self, value: MemoryReference) -> None: ...
    @property
    def waveform(self) -> WaveformInvocation: ...
    @waveform.setter
    def waveform(self, value: WaveformInvocation) -> None: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.bool, FrameIdentifier, MemoryReference, WaveformInvocation]: ...
    def __new__(cls, blocking:builtins.bool, frame:FrameIdentifier, memory_reference:MemoryReference, waveform:WaveformInvocation) -> Capture: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class CircuitDefinition:
    @property
    def instructions(self) -> builtins.list[Instruction]: ...
    @instructions.setter
    def instructions(self, value: builtins.list[Instruction]) -> None: ...
    @property
    def name(self) -> builtins.str: ...
    @name.setter
    def name(self, value: builtins.str) -> None: ...
    @property
    def parameters(self) -> builtins.list[builtins.str]: ...
    @parameters.setter
    def parameters(self, value: builtins.list[builtins.str]) -> None: ...
    @property
    def qubit_variables(self) -> builtins.list[builtins.str]: ...
    @qubit_variables.setter
    def qubit_variables(self, value: builtins.list[builtins.str]) -> None: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.str, builtins.list[builtins.str], builtins.list[builtins.str], builtins.list[Instruction]]: ...
    def __new__(cls, name:builtins.str, parameters:typing.Sequence[builtins.str], qubit_variables:typing.Sequence[builtins.str], instructions:typing.Sequence[Instruction]) -> CircuitDefinition: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Comparison:
    @property
    def destination(self) -> MemoryReference: ...
    @property
    def lhs(self) -> MemoryReference: ...
    @property
    def operator(self) -> ComparisonOperator: ...
    @property
    def rhs(self) -> ComparisonOperand: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[ComparisonOperator, MemoryReference, MemoryReference, ComparisonOperand]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, operator:ComparisonOperator, destination:MemoryReference, lhs:MemoryReference, rhs:ComparisonOperand) -> Comparison: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class ComparisonOperand:
    def __getnewargs__(self) -> tuple[int | float | MemoryReference]: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...
    class LiteralInteger(ComparisonOperand):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.int: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:builtins.int) -> ComparisonOperand.LiteralInteger: ...
    
    class LiteralReal(ComparisonOperand):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.float: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:builtins.float) -> ComparisonOperand.LiteralReal: ...
    
    class MemoryReference(ComparisonOperand):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> MemoryReference: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:MemoryReference) -> ComparisonOperand.MemoryReference: ...
    

class Convert:
    @property
    def destination(self) -> MemoryReference: ...
    @property
    def source(self) -> MemoryReference: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[MemoryReference, MemoryReference]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, destination:MemoryReference, source:MemoryReference) -> Convert: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Declaration:
    @property
    def name(self) -> builtins.str: ...
    @property
    def sharing(self) -> typing.Optional[Sharing]: ...
    @property
    def size(self) -> Vector: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.str, Vector, typing.Optional[Sharing]]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, name:builtins.str, size:Vector, sharing:typing.Optional[Sharing]) -> Declaration: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class DefGateSequence:
    r"""
    A sequence of gates that make up a defined gate (i.e. with `DEFGATE ... AS SEQUENCE`).
    """
    @property
    def gates(self) -> builtins.list[Gate]:
        r"""
        The list of `Gate` objects that make up the sequence.
        """
    @property
    def qubits(self) -> builtins.list[builtins.str]:
        r"""
        The list of qubit variable names in the gate signature.
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.list[builtins.str], builtins.list[Gate]]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, qubits:typing.Sequence[builtins.str], gates:typing.Sequence[Gate]) -> DefGateSequence:
        r"""
        Creates a new `DefGateSequence` with the given qubits and gates.
        
        `qubits` should be a list of qubit names that the gates in the sequence will act on.
        `gates` should be a list of `Gate` objects that make up the sequence.
        Each gate must reference qubits in the `qubits` list by name.
        They may not specify a fixed qubit.
        """
    def __repr__(self) -> builtins.str: ...

class DefGateSequenceError(InstructionError):
    r"""
    Errors that can occur when initializing a sequence gate definition.
    """
    ...

class Delay:
    @property
    def duration(self) -> Expression: ...
    @property
    def frame_names(self) -> builtins.list[builtins.str]: ...
    @property
    def qubits(self) -> builtins.list[Qubit]: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[Expression, builtins.list[builtins.str], builtins.list[Qubit]]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, duration:Expression, frame_names:typing.Sequence[builtins.str], qubits:typing.Sequence[Qubit]) -> Delay: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Exchange:
    @property
    def left(self) -> MemoryReference: ...
    @property
    def right(self) -> MemoryReference: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[MemoryReference, MemoryReference]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, left:MemoryReference, right:MemoryReference) -> Exchange: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class ExternError(QuilError):
    r"""
    Errors that may occur when initializing or validating a ``PRAGMA EXTERN`` instruction.
    """
    ...

class ExternParameter:
    r"""
    An extern parameter with a name, mutability, and data type.
    """
    @property
    def data_type(self) -> ExternParameterType:
        r"""
        The data type of the parameter.
        """
    @property
    def mutable(self) -> builtins.bool:
        r"""
        Whether the parameter is mutable.
        """
    @property
    def name(self) -> builtins.str:
        r"""
        The name of the parameter. This must be a valid user identifier.
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.str, builtins.bool, ExternParameterType]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, name:builtins.str, mutable:builtins.bool, data_type:ExternParameterType) -> ExternParameter:
        r"""
        Create a new extern parameter. This will fail if the parameter name
        is not a valid user identifier.
        """
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class ExternParameterType:
    r"""
    A parameter type within an extern signature.
    """
    def __getnewargs__(self) -> tuple[ScalarType | Vector]: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...
    class FixedLengthVector(ExternParameterType):
        r"""
        A fixed-length vector, which must accept a memory region name of the appropriate
        length and data type.
        
        For instance `PRAGMA EXTERN foo "(bar : INTEGER[2])"`.
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Vector: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Vector) -> ExternParameterType.FixedLengthVector: ...
    
    class Scalar(ExternParameterType):
        r"""
        A scalar parameter, which may accept a memory reference or immediate value.
        
        For instance `PRAGMA EXTERN foo "(bar : INTEGER)"`.
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> ScalarType: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:ScalarType) -> ExternParameterType.Scalar: ...
    
    class VariableLengthVector(ExternParameterType):
        r"""
        A variable-length vector, which must accept a memory region name of the appropriate
        data type.
        
        For instance `PRAGMA EXTERN foo "(bar : INTEGER[])"`.
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> ScalarType: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:ScalarType) -> ExternParameterType.VariableLengthVector: ...
    

class ExternSignature:
    r"""
    An extern signature with a return type and parameters.
    
    The signature of a ``PRAGMA EXTERN`` instruction.
    This signature is defined by a list of ``ExternParameter``s and an optional return type.
    See the [Quil Specification](https://github.com/quil-lang/quil/blob/7f532c7cdde9f51eae6abe7408cc868fba9f91f6/specgen/spec/sec-other.s)
    for details on how these signatures are formed.
    """
    @property
    def parameters(self) -> builtins.list[ExternParameter]:
        r"""
        The parameters of the extern signature.
        """
    @property
    def return_type(self) -> typing.Optional[ScalarType]:
        r"""
        The return type of the extern signature, if any.
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[typing.Optional[ScalarType], builtins.list[ExternParameter]]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, return_type:typing.Optional[ScalarType], parameters:typing.Sequence[ExternParameter]) -> ExternSignature:
        r"""
        Create a new extern signature.
        """
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Fence:
    @property
    def qubits(self) -> builtins.list[Qubit]: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.list[Qubit]]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, qubits:typing.Sequence[Qubit]) -> Fence: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class FrameDefinition:
    @property
    def attributes(self) -> builtins.dict[builtins.str, AttributeValue]: ...
    @attributes.setter
    def attributes(self, value: builtins.dict[builtins.str, AttributeValue]) -> None: ...
    @property
    def identifier(self) -> FrameIdentifier: ...
    @identifier.setter
    def identifier(self, value: FrameIdentifier) -> None: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[FrameIdentifier, builtins.dict[builtins.str, AttributeValue]]: ...
    def __new__(cls, identifier:FrameIdentifier, attributes:typing.Mapping[builtins.str, AttributeValue]) -> FrameDefinition: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class FrameIdentifier:
    @property
    def name(self) -> builtins.str: ...
    @property
    def qubits(self) -> builtins.list[Qubit]: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.str, builtins.list[Qubit]]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, name:builtins.str, qubits:typing.Sequence[Qubit]) -> FrameIdentifier: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Gate:
    r"""
    A struct encapsulating all the properties of a Quil Quantum Gate.
    """
    @property
    def modifiers(self) -> builtins.list[GateModifier]: ...
    @property
    def name(self) -> builtins.str: ...
    @property
    def parameters(self) -> builtins.list[Expression]: ...
    @property
    def qubits(self) -> builtins.list[Qubit]: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.str, builtins.list[Expression], builtins.list[Qubit], builtins.list[GateModifier]]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, name:builtins.str, parameters:typing.Sequence[Expression], qubits:typing.Sequence[Qubit], modifiers:typing.Sequence[GateModifier]) -> Gate: ...
    def __repr__(self) -> builtins.str: ...
    def controlled(self, control_qubit:Qubit) -> Gate:
        r"""
        Return a copy of the ``Gate`` with the ``CONTROLLED`` modifier added to it.
        """
    def dagger(self) -> Gate:
        r"""
        Return a copy of the ``Gate`` with the ``DAGGER`` modifier added to it.
        """
    def forked(self, fork_qubit:Qubit, alt_params:typing.Sequence[Expression]) -> Gate:
        r"""
        Return a copy of the ``Gate`` with the ``FORKED`` modifier added to it.
        
        Raises a ``GateError`` if the number of provided alternate parameters
        don't equal the number of existing parameters.
        """
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...
    def to_unitary(self, n_qubits:builtins.int) -> numpy.typing.NDArray[numpy.complex128]:
        r"""
        Get the matrix resulting from lifting this ``Gate``
        to the full `n_qubits`-qubit Hilbert space.
        
        Raises a ``GateError`` if any of the parameters of this ``Gate`` are non-constant,
        if any of the ``Qubit``s are variable,
        if the name of this ``Gate`` is unknown,
        or if there are an unexpected number of parameters.
        
        # Notes
        
        A previous version of this library called this `to_unitary_mut`,
        and modified the ``Gate`` when called.
        This is no longer possible, as it would modify the ``Gate``'s hash,
        leading to confusing bugs.
        ``Gate``s, as well as all other hashable classes, are immutable from Python.
        
        # Bugs
        
        Supplying `n_qubits` as `0` will raise an unspecified exception;
        other invalid input parameters may silently return an invalid result.
        """

class GateDefinition:
    r"""
    A struct encapsulating a quil Gate Definition
    """
    @property
    def name(self) -> builtins.str: ...
    @property
    def parameters(self) -> builtins.list[builtins.str]: ...
    @property
    def signature(self) -> GateSignature: ...
    @property
    def specification(self) -> GateSpecification: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.str, builtins.list[builtins.str], GateSpecification]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, name:builtins.str, parameters:typing.Sequence[builtins.str], specification:GateSpecification) -> GateDefinition: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class GateError(QuilError):
    r"""
    Errors that may occur when performing operations on a ``Gate``.
    """
    ...

class GateSignature:
    r"""
    A signature for a gate definition; this does not include the gate definition content.
    To get a signature from a definition, use `GateDefinition.signature`.
    """
    @property
    def gate_parameters(self) -> builtins.list[builtins.str]: ...
    @property
    def gate_type(self) -> GateType: ...
    @property
    def name(self) -> builtins.str: ...
    @property
    def qubit_parameters(self) -> builtins.list[builtins.str]: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.str, builtins.list[builtins.str], builtins.list[builtins.str], GateType]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, name:builtins.str, gate_parameters:typing.Sequence[builtins.str], qubit_parameters:typing.Sequence[builtins.str], gate_type:GateType) -> GateSignature: ...
    def __repr__(self) -> builtins.str: ...

class GateSpecification:
    r"""
    An enum representing a the specification of a [`GateDefinition`] for a given [`GateType`]
    """
    def __getnewargs__(self) -> tuple[list[list[Expression]] | list[int] | PauliSum | DefGateSequence]: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...
    class Matrix(GateSpecification):
        r"""
        A matrix of [`Expression`]s representing a unitary operation for a [`GateType::Matrix`].
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.list[builtins.list[Expression]]: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:typing.Sequence[typing.Sequence[Expression]]) -> GateSpecification.Matrix: ...
    
    class PauliSum(GateSpecification):
        r"""
        A Hermitian operator specified as a Pauli sum, a sum of combinations of Pauli operators,
        used for a [`GateType::PauliSum`]
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> PauliSum: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:PauliSum) -> GateSpecification.PauliSum: ...
    
    class Permutation(GateSpecification):
        r"""
        A vector of integers that defines the permutation used for a [`GateType::Permutation`]
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.list[builtins.int]: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:typing.Sequence[builtins.int]) -> GateSpecification.Permutation: ...
    
    class Sequence(GateSpecification):
        r"""
        A sequence of gates.
        """
        __match_args__ = ("_0",)
        @property
        def _0(self) -> DefGateSequence: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:DefGateSequence) -> GateSpecification.Sequence: ...
    

class Include:
    @property
    def filename(self) -> builtins.str: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.str]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, filename:builtins.str) -> Include: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Instruction:
    r"""
    A Quil instruction.
    
    Each variant (for Python users, each nested subclass)
    corresponds to a possible type of Quil instruction,
    which is accessible as a member within the variant.
    
    # Python Users
    
    The subclasses of this class are class attributes defined on it,
    and can be used to "wrap" instructions when they should be stored together.
    In particular, they are *NOT* the instruction classes you'd typically create,
    and instances of instruction classes are *NOT* subclasses of this class:
    
    ```python
    >>> from quil.instructions import Instruction, Gate, Qubit
    >>> issubclass(Instruction.Gate, Instruction)
    True
    >>> issubclass(Gate, Instruction)
    False
    >>> g = Gate("X", (), (Qubit.Fixed(0),), ())
    >>> isinstance(g, Gate)
    True
    >>> isinstance(g, Instruction.Gate)
    False
    >>> g_instr = Instruction.Gate(g)
    >>> isinstance(g_instr, Gate)
    False
    >>> isinstance(g_instr, Instruction.Gate)
    True
    >>> isinstance(g_instr._0, Gate)
    True
    >>> g_instr._0 == g
    True
    ```
    
    The point of this class is to wrap different kinds of instructions
    when stored together in a collection, all of which are of type `Instruction`.
    You can check for different instruction variants and destructure them using `match`:
    
    ```python
    match g_instr:
        case Instruction.Gate(gate):
            assert isinstance(gate, Gate)
        case Instruction.Wait() | Instruction.Nop():
            # note the `()` -- these aren't like Python's enumerations!
    ```
    """
    def __getnewargs__(self) -> tuple[()] | tuple[Arithmetic | BinaryLogic | Call | Capture | CalibrationDefinition | CircuitDefinition | Comparison | Convert | Declaration | Delay | Exchange | Fence | FrameDefinition | Gate | GateDefinition | Include | Jump | JumpUnless | JumpWhen | Label | Load | MeasureCalibrationDefinition | Measurement | Move | Pragma | Pulse | RawCapture | Reset | SetFrequency | SetPhase | SetScale | ShiftFrequency | ShiftPhase | Store | SwapPhases | UnaryLogic | WaveformDefinition]: ...
    def __repr__(self) -> builtins.str: ...
    def is_quil_t(self) -> builtins.bool:
        r"""
        Returns true if the instruction is a Quil-T instruction.
        """
    @staticmethod
    def parse(string:builtins.str) -> Instruction: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...
    class Arithmetic(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Arithmetic: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Arithmetic) -> Instruction.Arithmetic: ...
    
    class BinaryLogic(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> BinaryLogic: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:BinaryLogic) -> Instruction.BinaryLogic: ...
    
    class CalibrationDefinition(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> CalibrationDefinition: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:CalibrationDefinition) -> Instruction.CalibrationDefinition: ...
    
    class Call(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Call: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Call) -> Instruction.Call: ...
    
    class Capture(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Capture: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Capture) -> Instruction.Capture: ...
    
    class CircuitDefinition(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> CircuitDefinition: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:CircuitDefinition) -> Instruction.CircuitDefinition: ...
    
    class Comparison(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Comparison: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Comparison) -> Instruction.Comparison: ...
    
    class Convert(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Convert: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Convert) -> Instruction.Convert: ...
    
    class Declaration(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Declaration: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Declaration) -> Instruction.Declaration: ...
    
    class Delay(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Delay: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Delay) -> Instruction.Delay: ...
    
    class Exchange(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Exchange: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Exchange) -> Instruction.Exchange: ...
    
    class Fence(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Fence: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Fence) -> Instruction.Fence: ...
    
    class FrameDefinition(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> FrameDefinition: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:FrameDefinition) -> Instruction.FrameDefinition: ...
    
    class Gate(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Gate: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Gate) -> Instruction.Gate: ...
    
    class GateDefinition(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> GateDefinition: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:GateDefinition) -> Instruction.GateDefinition: ...
    
    class Halt(Instruction):
        __match_args__ = ()
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls) -> Instruction.Halt: ...
    
    class Include(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Include: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Include) -> Instruction.Include: ...
    
    class Jump(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Jump: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Jump) -> Instruction.Jump: ...
    
    class JumpUnless(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> JumpUnless: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:JumpUnless) -> Instruction.JumpUnless: ...
    
    class JumpWhen(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> JumpWhen: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:JumpWhen) -> Instruction.JumpWhen: ...
    
    class Label(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Label: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Label) -> Instruction.Label: ...
    
    class Load(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Load: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Load) -> Instruction.Load: ...
    
    class MeasureCalibrationDefinition(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> MeasureCalibrationDefinition: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:MeasureCalibrationDefinition) -> Instruction.MeasureCalibrationDefinition: ...
    
    class Measurement(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Measurement: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Measurement) -> Instruction.Measurement: ...
    
    class Move(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Move: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Move) -> Instruction.Move: ...
    
    class Nop(Instruction):
        __match_args__ = ()
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls) -> Instruction.Nop: ...
    
    class Pragma(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Pragma: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Pragma) -> Instruction.Pragma: ...
    
    class Pulse(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Pulse: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Pulse) -> Instruction.Pulse: ...
    
    class RawCapture(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> RawCapture: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:RawCapture) -> Instruction.RawCapture: ...
    
    class Reset(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Reset: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Reset) -> Instruction.Reset: ...
    
    class SetFrequency(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> SetFrequency: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:SetFrequency) -> Instruction.SetFrequency: ...
    
    class SetPhase(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> SetPhase: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:SetPhase) -> Instruction.SetPhase: ...
    
    class SetScale(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> SetScale: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:SetScale) -> Instruction.SetScale: ...
    
    class ShiftFrequency(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> ShiftFrequency: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:ShiftFrequency) -> Instruction.ShiftFrequency: ...
    
    class ShiftPhase(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> ShiftPhase: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:ShiftPhase) -> Instruction.ShiftPhase: ...
    
    class Store(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> Store: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:Store) -> Instruction.Store: ...
    
    class SwapPhases(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> SwapPhases: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:SwapPhases) -> Instruction.SwapPhases: ...
    
    class UnaryLogic(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> UnaryLogic: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:UnaryLogic) -> Instruction.UnaryLogic: ...
    
    class Wait(Instruction):
        __match_args__ = ()
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls) -> Instruction.Wait: ...
    
    class WaveformDefinition(Instruction):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> WaveformDefinition: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:WaveformDefinition) -> Instruction.WaveformDefinition: ...
    

class InstructionError(QuilError):
    r"""
    Base error type for errors related to ``Instruction`` processing.
    """
    ...

class Jump:
    @property
    def target(self) -> Target: ...
    @target.setter
    def target(self, value: Target) -> None: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[Target]: ...
    def __new__(cls, target:Target) -> Jump: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class JumpUnless:
    @property
    def condition(self) -> MemoryReference: ...
    @condition.setter
    def condition(self, value: MemoryReference) -> None: ...
    @property
    def target(self) -> Target: ...
    @target.setter
    def target(self, value: Target) -> None: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[Target, MemoryReference]: ...
    def __new__(cls, target:Target, condition:MemoryReference) -> JumpUnless: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class JumpWhen:
    @property
    def condition(self) -> MemoryReference: ...
    @condition.setter
    def condition(self, value: MemoryReference) -> None: ...
    @property
    def target(self) -> Target: ...
    @target.setter
    def target(self, value: Target) -> None: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[Target, MemoryReference]: ...
    def __new__(cls, target:Target, condition:MemoryReference) -> JumpWhen: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Label:
    @property
    def target(self) -> Target: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[Target]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, target:Target) -> Label: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Load:
    @property
    def destination(self) -> MemoryReference: ...
    @property
    def offset(self) -> MemoryReference: ...
    @property
    def source(self) -> builtins.str: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[MemoryReference, builtins.str, MemoryReference]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, destination:MemoryReference, source:builtins.str, offset:MemoryReference) -> Load: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class MeasureCalibrationDefinition:
    @property
    def identifier(self) -> MeasureCalibrationIdentifier: ...
    @identifier.setter
    def identifier(self, value: MeasureCalibrationIdentifier) -> None: ...
    @property
    def instructions(self) -> builtins.list[Instruction]: ...
    @instructions.setter
    def instructions(self, value: builtins.list[Instruction]) -> None: ...
    @property
    def name(self) -> typing.Optional[builtins.str]:
        r"""
        The Quil-T name of the measurement that this measure calibration definition is for, if any.
        """
    @property
    def qubit(self) -> Qubit:
        r"""
        The qubit that this measure calibration definition is for.
        """
    @property
    def target(self) -> typing.Optional[builtins.str]:
        r"""
        The name the measurement calibration uses for the variable it will write the measurement
        result to, if this is a measurement for record.
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[MeasureCalibrationIdentifier, builtins.list[Instruction]]: ...
    def __new__(cls, identifier:MeasureCalibrationIdentifier, instructions:typing.Sequence[Instruction]) -> MeasureCalibrationDefinition: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class MeasureCalibrationIdentifier:
    r"""
    A unique identifier for a measurement calibration definition within a program
    """
    @property
    def name(self) -> typing.Optional[builtins.str]:
        r"""
        The Quil-T name of the measurement, if any.
        """
    @name.setter
    def name(self, value: typing.Optional[builtins.str]) -> None:
        r"""
        The Quil-T name of the measurement, if any.
        """
    @property
    def qubit(self) -> Qubit:
        r"""
        The qubit which is being measured.
        """
    @qubit.setter
    def qubit(self, value: Qubit) -> None:
        r"""
        The qubit which is being measured.
        """
    @property
    def target(self) -> typing.Optional[builtins.str]:
        r"""
        The name the definition uses for the variable it will write the measurement result to, if
        this is a measurement for record.
        
        If this is missing, this is a calibration for a measurement for effect.
        """
    @target.setter
    def target(self, value: typing.Optional[builtins.str]) -> None:
        r"""
        The name the definition uses for the variable it will write the measurement result to, if
        this is a measurement for record.
        
        If this is missing, this is a calibration for a measurement for effect.
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs_ex__(self) -> tuple[tuple[Qubit, str | None], dict[str, str | None]]: ...
    def __new__(cls, qubit:Qubit, target:typing.Optional[builtins.str], *, name:typing.Optional[builtins.str]=None) -> MeasureCalibrationIdentifier: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Measurement:
    @property
    def name(self) -> typing.Optional[builtins.str]: ...
    @property
    def qubit(self) -> Qubit: ...
    @property
    def target(self) -> typing.Optional[MemoryReference]: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs_ex__(self) -> tuple[tuple[Qubit, MemoryReference | None], dict[str, str | None]]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, qubit:Qubit, target:typing.Optional[MemoryReference], *, name:typing.Optional[builtins.str]=None) -> Measurement: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class MemoryReference:
    @property
    def index(self) -> builtins.int: ...
    @property
    def name(self) -> builtins.str: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.str, builtins.int]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, name:builtins.str, index:builtins.int) -> MemoryReference: ...
    def __repr__(self) -> builtins.str: ...
    @staticmethod
    def parse(string:builtins.str) -> MemoryReference: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Move:
    @property
    def destination(self) -> MemoryReference: ...
    @property
    def source(self) -> ArithmeticOperand: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[MemoryReference, ArithmeticOperand]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, destination:MemoryReference, source:ArithmeticOperand) -> Move: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Offset:
    @property
    def data_type(self) -> ScalarType: ...
    @property
    def offset(self) -> builtins.int: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.int, ScalarType]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, offset:builtins.int, data_type:ScalarType) -> Offset: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class ParseInstructionError(InstructionError):
    r"""
    Errors that may occur while parsing an ``Instruction``.
    """
    ...

class ParseMemoryReferenceError(QuilError):
    r"""
    Errors that may occur while parsing a ``MemoryReference``.
    """
    ...

class PauliSum:
    @property
    def arguments(self) -> builtins.list[builtins.str]: ...
    @property
    def terms(self) -> builtins.list[PauliTerm]: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.list[builtins.str], builtins.list[PauliTerm]]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, arguments:typing.Sequence[builtins.str], terms:typing.Sequence[PauliTerm]) -> PauliSum: ...
    def __repr__(self) -> builtins.str: ...

class PauliTerm:
    @property
    def arguments(self) -> builtins.list[tuple[PauliGate, builtins.str]]: ...
    @property
    def expression(self) -> Expression: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.list[tuple[PauliGate, builtins.str]], Expression]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, arguments:typing.Sequence[tuple[PauliGate, builtins.str]], expression:Expression) -> PauliTerm: ...
    def __repr__(self) -> builtins.str: ...

class Pragma:
    @property
    def arguments(self) -> builtins.list[PragmaArgument]: ...
    @property
    def data(self) -> typing.Optional[builtins.str]: ...
    @property
    def name(self) -> builtins.str: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.str, builtins.list[PragmaArgument], typing.Optional[builtins.str]]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, name:builtins.str, arguments:typing.Sequence[PragmaArgument], data:typing.Optional[builtins.str]) -> Pragma: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class PragmaArgument:
    def __getnewargs__(self) -> tuple[int | str]: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...
    class Identifier(PragmaArgument):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.str: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:builtins.str) -> PragmaArgument.Identifier: ...
    
    class Integer(PragmaArgument):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.int: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:builtins.int) -> PragmaArgument.Integer: ...
    

class Pulse:
    @property
    def blocking(self) -> builtins.bool: ...
    @blocking.setter
    def blocking(self, value: builtins.bool) -> None: ...
    @property
    def frame(self) -> FrameIdentifier: ...
    @frame.setter
    def frame(self, value: FrameIdentifier) -> None: ...
    @property
    def waveform(self) -> WaveformInvocation: ...
    @waveform.setter
    def waveform(self, value: WaveformInvocation) -> None: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.bool, FrameIdentifier, WaveformInvocation]: ...
    def __new__(cls, blocking:builtins.bool, frame:FrameIdentifier, waveform:WaveformInvocation) -> Pulse: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Qubit:
    def __getnewargs__(self) -> tuple[int | str | QubitPlaceholder]: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...
    class Fixed(Qubit):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.int: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:builtins.int) -> Qubit.Fixed: ...
    
    class Placeholder(Qubit):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> QubitPlaceholder: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:QubitPlaceholder) -> Qubit.Placeholder: ...
    
    class Variable(Qubit):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.str: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:builtins.str) -> Qubit.Variable: ...
    

class QubitPlaceholder:
    r"""
    An opaque placeholder for a qubit whose index may be assigned at a later time.
    """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __ge__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> typing.NoReturn:
        r"""
        `QubitPlaceholder`s do not support `pickle` or `deepcopy`.
        Calling this method will raise an error.
        """
    def __gt__(self, other:builtins.object) -> builtins.bool: ...
    def __hash__(self) -> builtins.int: ...
    def __le__(self, other:builtins.object) -> builtins.bool: ...
    def __lt__(self, other:builtins.object) -> builtins.bool: ...
    def __new__(cls) -> QubitPlaceholder: ...
    def __repr__(self) -> builtins.str: ...

class RawCapture:
    @property
    def blocking(self) -> builtins.bool: ...
    @property
    def duration(self) -> Expression: ...
    @property
    def frame(self) -> FrameIdentifier: ...
    @property
    def memory_reference(self) -> MemoryReference: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.bool, FrameIdentifier, Expression, MemoryReference]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, blocking:builtins.bool, frame:FrameIdentifier, duration:Expression, memory_reference:MemoryReference) -> RawCapture: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Reset:
    @property
    def qubit(self) -> typing.Optional[Qubit]: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[typing.Optional[Qubit]]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, qubit:typing.Optional[Qubit]) -> Reset: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class SetFrequency:
    @property
    def frame(self) -> FrameIdentifier: ...
    @property
    def frequency(self) -> Expression: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[FrameIdentifier, Expression]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, frame:FrameIdentifier, frequency:Expression) -> SetFrequency: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class SetPhase:
    @property
    def frame(self) -> FrameIdentifier: ...
    @property
    def phase(self) -> Expression: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[FrameIdentifier, Expression]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, frame:FrameIdentifier, phase:Expression) -> SetPhase: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class SetScale:
    @property
    def frame(self) -> FrameIdentifier: ...
    @property
    def scale(self) -> Expression: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[FrameIdentifier, Expression]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, frame:FrameIdentifier, scale:Expression) -> SetScale: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Sharing:
    @property
    def name(self) -> builtins.str: ...
    @property
    def offsets(self) -> builtins.list[Offset]: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.str, builtins.list[Offset]]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, name:builtins.str, offsets:typing.Sequence[Offset]) -> Sharing: ...
    def __repr__(self) -> builtins.str: ...

class ShiftFrequency:
    @property
    def frame(self) -> FrameIdentifier: ...
    @property
    def frequency(self) -> Expression: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[FrameIdentifier, Expression]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, frame:FrameIdentifier, frequency:Expression) -> ShiftFrequency: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class ShiftPhase:
    @property
    def frame(self) -> FrameIdentifier: ...
    @property
    def phase(self) -> Expression: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[FrameIdentifier, Expression]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, frame:FrameIdentifier, phase:Expression) -> ShiftPhase: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Store:
    @property
    def destination(self) -> builtins.str: ...
    @property
    def offset(self) -> MemoryReference: ...
    @property
    def source(self) -> ArithmeticOperand: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.str, MemoryReference, ArithmeticOperand]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, destination:builtins.str, offset:MemoryReference, source:ArithmeticOperand) -> Store: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class SwapPhases:
    @property
    def frame_1(self) -> FrameIdentifier: ...
    @property
    def frame_2(self) -> FrameIdentifier: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[FrameIdentifier, FrameIdentifier]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, frame_1:FrameIdentifier, frame_2:FrameIdentifier) -> SwapPhases: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Target:
    def __getnewargs__(self) -> tuple[str | TargetPlaceholder]: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...
    class Fixed(Target):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.str: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:builtins.str) -> Target.Fixed: ...
    
    class Placeholder(Target):
        __match_args__ = ("_0",)
        @property
        def _0(self) -> TargetPlaceholder: ...
        def __getitem__(self, key:builtins.int) -> typing.Any: ...
        def __len__(self) -> builtins.int: ...
        def __new__(cls, _0:TargetPlaceholder) -> Target.Placeholder: ...
    

class TargetPlaceholder:
    r"""
    An opaque placeholder for a label whose index may be assigned
    at a later time.
    """
    @property
    def base_label(self) -> builtins.str: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __ge__(self, other:builtins.object) -> builtins.bool: ...
    def __gt__(self, other:builtins.object) -> builtins.bool: ...
    def __hash__(self) -> builtins.int: ...
    def __le__(self, other:builtins.object) -> builtins.bool: ...
    def __lt__(self, other:builtins.object) -> builtins.bool: ...
    def __new__(cls, base_label:builtins.str) -> TargetPlaceholder: ...
    def __repr__(self) -> builtins.str: ...

class UnaryLogic:
    @property
    def operand(self) -> MemoryReference: ...
    @property
    def operator(self) -> UnaryOperator: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[UnaryOperator, MemoryReference]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, operator:UnaryOperator, operand:MemoryReference) -> UnaryLogic: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Vector:
    @property
    def data_type(self) -> ScalarType: ...
    @property
    def length(self) -> builtins.int: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[ScalarType, builtins.int]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, data_type:ScalarType, length:builtins.int) -> Vector: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class Waveform:
    @property
    def matrix(self) -> builtins.list[Expression]: ...
    @property
    def parameters(self) -> builtins.list[builtins.str]: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, matrix:typing.Sequence[Expression], parameters:typing.Sequence[builtins.str]) -> Waveform: ...
    def __repr__(self) -> builtins.str: ...

class WaveformDefinition:
    @property
    def definition(self) -> Waveform: ...
    @property
    def name(self) -> builtins.str: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.str, Waveform]: ...
    def __hash__(self) -> builtins.int: ...
    def __new__(cls, name:builtins.str, definition:Waveform) -> WaveformDefinition: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class WaveformInvocation:
    @property
    def name(self) -> builtins.str: ...
    @property
    def parameters(self) -> builtins.dict[builtins.str, Expression]: ...
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __getnewargs__(self) -> tuple[builtins.str, builtins.dict[builtins.str, Expression]]: ...
    def __new__(cls, name:builtins.str, parameters:typing.Mapping[builtins.str, Expression]) -> WaveformInvocation: ...
    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class ArithmeticOperator(Enum):
    ADD = ...
    SUBTRACT = ...
    DIVIDE = ...
    MULTIPLY = ...

    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class BinaryOperator(Enum):
    AND = ...
    IOR = ...
    XOR = ...

    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class ComparisonOperator(Enum):
    EQUAL = ...
    GREATER_THAN_OR_EQUAL = ...
    GREATER_THAN = ...
    LESS_THAN_OR_EQUAL = ...
    LESS_THAN = ...

    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class GateModifier(Enum):
    r"""
    An enum of all the possible modifiers on a quil [`Gate`]
    """
    CONTROLLED = ...
    r"""
    The `CONTROLLED` modifier makes the gate take an extra [`Qubit`] parameter as a control
    qubit.
    """
    DAGGER = ...
    r"""
    The `DAGGER` modifier does a complex-conjugate transpose on the [`Gate`].
    """
    FORKED = ...
    r"""
    The `FORKED` modifier allows an alternate set of parameters to be used based on the state
    of a qubit.
    """

    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class GateType(Enum):
    r"""
    The type of a [`GateDefinition`] used within the [`GateSignature`].
    """
    MATRIX = ...
    PERMUTATION = ...
    PAULI_SUM = ...
    SEQUENCE = ...

    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class PauliGate(Enum):
    I = ...
    X = ...
    Y = ...
    Z = ...

    def __repr__(self) -> builtins.str: ...
    @staticmethod
    def parse(input:builtins.str) -> PauliGate:
        r"""
        Parse a ``PauliGate`` from a string.
        
        Raises a ``ParseExpressionError`` error if the string isn't a valid Quil expression.
        """

class ScalarType(Enum):
    BIT = ...
    INTEGER = ...
    OCTET = ...
    REAL = ...

    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

class UnaryOperator(Enum):
    NEG = ...
    NOT = ...

    def __repr__(self) -> builtins.str: ...
    def to_quil(self) -> builtins.str: ...
    def to_quil_or_debug(self) -> builtins.str: ...

