# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins

class BoxcarKernel:
    r"""
    A Boxcar waveform.
    """
    @property
    def phase(self) -> builtins.float:
        r"""
        The phase, in cycles.
        """
    @phase.setter
    def phase(self, value: builtins.float) -> None:
        r"""
        The phase, in cycles.
        """
    @property
    def sample_count(self) -> builtins.int:
        r"""
        Sample count, which must be positive.
        """
    @sample_count.setter
    def sample_count(self, value: builtins.int) -> None:
        r"""
        Sample count, which must be positive.
        """
    @property
    def scale(self) -> builtins.float:
        r"""
        Scale applied to the waveform envelope.
        """
    @scale.setter
    def scale(self, value: builtins.float) -> None:
        r"""
        Scale applied to the waveform envelope.
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __new__(cls, phase:builtins.float, scale:builtins.float, sample_count:builtins.int) -> BoxcarKernel:
        r"""
        Create a new `BoxcarKernel`.
        
        This raises an error if `sample_count` is zero.
        """
    def __repr__(self) -> builtins.str: ...
    def into_iq_value(self) -> builtins.complex:
        r"""
        Get the `complex` value this `BoxcarKernel` represents.
        """

class DragGaussian:
    r"""
    Creates a waveform with a DRAG-corrected Gaussian shape.
    
    This is a Gaussian shape with an additional component proportional to the time derivative of the main Gaussian pulse.
    
    See Motzoi F. et al., Phys. Rev. Lett., 103 (2009) 110501. for details.
    """
    @property
    def alpha(self) -> builtins.float:
        r"""
        DRAG parameter - controls strength of the imaginary term
        """
    @alpha.setter
    def alpha(self, value: builtins.float) -> None:
        r"""
        DRAG parameter - controls strength of the imaginary term
        """
    @property
    def anh(self) -> builtins.float:
        r"""
        Qubit anharmonicity - sets rate of evolution for the imaginary term (Hz)
        """
    @anh.setter
    def anh(self, value: builtins.float) -> None:
        r"""
        Qubit anharmonicity - sets rate of evolution for the imaginary term (Hz)
        """
    @property
    def detuning(self) -> builtins.float:
        r"""
        Explicit detuning to bake into iq values
        """
    @detuning.setter
    def detuning(self, value: builtins.float) -> None:
        r"""
        Explicit detuning to bake into iq values
        """
    @property
    def duration(self) -> builtins.float:
        r"""
        Full duration of the pulse (s)
        """
    @duration.setter
    def duration(self, value: builtins.float) -> None:
        r"""
        Full duration of the pulse (s)
        """
    @property
    def fwhm(self) -> builtins.float:
        r"""
        Full width half maximum of the pulse (s)
        """
    @fwhm.setter
    def fwhm(self, value: builtins.float) -> None:
        r"""
        Full width half maximum of the pulse (s)
        """
    @property
    def phase(self) -> builtins.float:
        r"""
        Phase shift for entire waveform
        """
    @phase.setter
    def phase(self, value: builtins.float) -> None:
        r"""
        Phase shift for entire waveform
        """
    @property
    def sample_rate(self) -> builtins.float:
        r"""
        Generate samples at this rate (Hz)
        """
    @sample_rate.setter
    def sample_rate(self, value: builtins.float) -> None:
        r"""
        Generate samples at this rate (Hz)
        """
    @property
    def scale(self) -> builtins.float:
        r"""
        Scale to apply to waveform envelope
        """
    @scale.setter
    def scale(self, value: builtins.float) -> None:
        r"""
        Scale to apply to waveform envelope
        """
    @property
    def t0(self) -> builtins.float:
        r"""
        Center/offset for pulse centroid (s)
        """
    @t0.setter
    def t0(self, value: builtins.float) -> None:
        r"""
        Center/offset for pulse centroid (s)
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __new__(cls, duration:builtins.float, fwhm:builtins.float, t0:builtins.float, anh:builtins.float, alpha:builtins.float, sample_rate:builtins.float, scale:builtins.float, phase:builtins.float, detuning:builtins.float) -> DragGaussian: ...
    def __repr__(self) -> builtins.str: ...
    def into_iq_value(self) -> builtins.list[builtins.complex]:
        r"""
        Get the a list of `complex` values from this waveform.
        """

class ErfSquare:
    r"""
    A waveform with a flat top and edges that are error functions (erfs).
    """
    @property
    def detuning(self) -> builtins.float:
        r"""
        Explicit detuning to bake into iq values
        """
    @detuning.setter
    def detuning(self, value: builtins.float) -> None:
        r"""
        Explicit detuning to bake into iq values
        """
    @property
    def duration(self) -> builtins.float:
        r"""
        Full duration of the pulse (s)
        """
    @duration.setter
    def duration(self, value: builtins.float) -> None:
        r"""
        Full duration of the pulse (s)
        """
    @property
    def pad_left(self) -> builtins.float:
        r"""
        Length of zero padding to add to beginning of pulse (s)
        """
    @pad_left.setter
    def pad_left(self, value: builtins.float) -> None:
        r"""
        Length of zero padding to add to beginning of pulse (s)
        """
    @property
    def pad_right(self) -> builtins.float:
        r"""
        Length of zero padding to add to end of pulse (s)
        """
    @pad_right.setter
    def pad_right(self, value: builtins.float) -> None:
        r"""
        Length of zero padding to add to end of pulse (s)
        """
    @property
    def phase(self) -> builtins.float:
        r"""
        Phase shift for entire waveform
        """
    @phase.setter
    def phase(self, value: builtins.float) -> None:
        r"""
        Phase shift for entire waveform
        """
    @property
    def positive_polarity(self) -> builtins.bool:
        r"""
        Toggle for positive/negative polarity
        """
    @positive_polarity.setter
    def positive_polarity(self, value: builtins.bool) -> None:
        r"""
        Toggle for positive/negative polarity
        """
    @property
    def risetime(self) -> builtins.float:
        r"""
        Slope of erf shoulders (2x FWHM of erf in s)
        """
    @risetime.setter
    def risetime(self, value: builtins.float) -> None:
        r"""
        Slope of erf shoulders (2x FWHM of erf in s)
        """
    @property
    def sample_rate(self) -> builtins.float:
        r"""
        Generate wavform samples at this rate (Hz)
        """
    @sample_rate.setter
    def sample_rate(self, value: builtins.float) -> None:
        r"""
        Generate wavform samples at this rate (Hz)
        """
    @property
    def scale(self) -> builtins.float:
        r"""
        Scale to apply to waveform envelope
        """
    @scale.setter
    def scale(self, value: builtins.float) -> None:
        r"""
        Scale to apply to waveform envelope
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __new__(cls, duration:builtins.float, risetime:builtins.float, sample_rate:builtins.float, pad_left:builtins.float, pad_right:builtins.float, positive_polarity:builtins.bool, scale:builtins.float, phase:builtins.float, detuning:builtins.float) -> ErfSquare: ...
    def __repr__(self) -> builtins.str: ...
    def into_iq_value(self) -> builtins.list[builtins.complex]:
        r"""
        Get the a list of `complex` values from this waveform.
        """

class Gaussian:
    r"""
    Creates a waveform with a Gaussian shape.
    """
    @property
    def detuning(self) -> builtins.float:
        r"""
        Explicit detuning to bake into IQ values
        """
    @detuning.setter
    def detuning(self, value: builtins.float) -> None:
        r"""
        Explicit detuning to bake into IQ values
        """
    @property
    def duration(self) -> builtins.float:
        r"""
        Full duration of the pulse (s)
        """
    @duration.setter
    def duration(self, value: builtins.float) -> None:
        r"""
        Full duration of the pulse (s)
        """
    @property
    def fwhm(self) -> builtins.float:
        r"""
        Full width half maximum of the pulse (s)
        """
    @fwhm.setter
    def fwhm(self, value: builtins.float) -> None:
        r"""
        Full width half maximum of the pulse (s)
        """
    @property
    def phase(self) -> builtins.float:
        r"""
        Phase shift for entire waveform
        """
    @phase.setter
    def phase(self, value: builtins.float) -> None:
        r"""
        Phase shift for entire waveform
        """
    @property
    def sample_rate(self) -> builtins.float:
        r"""
        Generate waveform samples at this rate (Hz)
        """
    @sample_rate.setter
    def sample_rate(self, value: builtins.float) -> None:
        r"""
        Generate waveform samples at this rate (Hz)
        """
    @property
    def scale(self) -> builtins.float:
        r"""
        Scale to apply to waveform envelope
        """
    @scale.setter
    def scale(self, value: builtins.float) -> None:
        r"""
        Scale to apply to waveform envelope
        """
    @property
    def t0(self) -> builtins.float:
        r"""
        Center/offset for pulse centroid (s)
        """
    @t0.setter
    def t0(self, value: builtins.float) -> None:
        r"""
        Center/offset for pulse centroid (s)
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __new__(cls, duration:builtins.float, fwhm:builtins.float, t0:builtins.float, sample_rate:builtins.float, scale:builtins.float, phase:builtins.float, detuning:builtins.float) -> Gaussian: ...
    def __repr__(self) -> builtins.str: ...
    def into_iq_value(self) -> builtins.list[builtins.complex]:
        r"""
        Get the a list of `complex` values from this waveform.
        """

class HermiteGaussian:
    r"""
    Creates a Hermite Gaussian waveform.
    
    This extends the basic DRAG pulse by adding an additional imaginary term to the pulse envelope consisting of a
    Gaussian pulse modified by the second order Hermite polynomial.
    
    Refer to
    "Effects of arbitrary laser or NMR pulse shapes on population inversion and coherence"
    Warren S. Warren. 81, (1984); doi: 10.1063/1.447644
    for details.
    """
    @property
    def alpha(self) -> builtins.float:
        r"""
        DRAG parameter - controls strength of the imaginary term
        """
    @alpha.setter
    def alpha(self, value: builtins.float) -> None:
        r"""
        DRAG parameter - controls strength of the imaginary term
        """
    @property
    def anh(self) -> builtins.float:
        r"""
        Qubit anharmonicity - sets rate of evolution for the imaginary term
        """
    @anh.setter
    def anh(self, value: builtins.float) -> None:
        r"""
        Qubit anharmonicity - sets rate of evolution for the imaginary term
        """
    @property
    def detuning(self) -> builtins.float:
        r"""
        Explicit detuning to bake into iq values
        """
    @detuning.setter
    def detuning(self, value: builtins.float) -> None:
        r"""
        Explicit detuning to bake into iq values
        """
    @property
    def duration(self) -> builtins.float:
        r"""
        Full duration of the pulse
        """
    @duration.setter
    def duration(self, value: builtins.float) -> None:
        r"""
        Full duration of the pulse
        """
    @property
    def fwhm(self) -> builtins.float:
        r"""
        Full width half maximum of the pulse
        """
    @fwhm.setter
    def fwhm(self, value: builtins.float) -> None:
        r"""
        Full width half maximum of the pulse
        """
    @property
    def phase(self) -> builtins.float:
        r"""
        Phase shift for entire waveform
        """
    @phase.setter
    def phase(self, value: builtins.float) -> None:
        r"""
        Phase shift for entire waveform
        """
    @property
    def sample_rate(self) -> builtins.float:
        r"""
        Generate samples at this rate
        """
    @sample_rate.setter
    def sample_rate(self, value: builtins.float) -> None:
        r"""
        Generate samples at this rate
        """
    @property
    def scale(self) -> builtins.float:
        r"""
        Scale to apply to waveform envelope
        """
    @scale.setter
    def scale(self, value: builtins.float) -> None:
        r"""
        Scale to apply to waveform envelope
        """
    @property
    def second_order_hrm_coeff(self) -> builtins.float:
        r"""
        Coefficient of the second order Hermite polynomial term.
        """
    @second_order_hrm_coeff.setter
    def second_order_hrm_coeff(self, value: builtins.float) -> None:
        r"""
        Coefficient of the second order Hermite polynomial term.
        """
    @property
    def t0(self) -> builtins.float:
        r"""
        Center/offset for pulse centroid
        """
    @t0.setter
    def t0(self, value: builtins.float) -> None:
        r"""
        Center/offset for pulse centroid
        """
    def __eq__(self, other:builtins.object) -> builtins.bool: ...
    def __new__(cls, duration:builtins.float, fwhm:builtins.float, t0:builtins.float, anh:builtins.float, alpha:builtins.float, sample_rate:builtins.float, second_order_hrm_coeff:builtins.float, scale:builtins.float, phase:builtins.float, detuning:builtins.float) -> HermiteGaussian: ...
    def __repr__(self) -> builtins.str: ...
    def into_iq_value(self) -> builtins.list[builtins.complex]:
        r"""
        Get the a list of `complex` values from this waveform.
        """

def apply_phase_and_detuning(iq_values:list, phase:builtins.float, detuning:builtins.float, sample_rate:builtins.float) -> None:
    r"""
    Modulate and phase shift waveform IQ data in place.
    """

