<a id="mypy-boto3-clouddirectory"></a>

# mypy-boto3-clouddirectory

[![PyPI - mypy-boto3-clouddirectory](https://img.shields.io/pypi/v/mypy-boto3-clouddirectory.svg?color=blue)](https://pypi.org/project/mypy-boto3-clouddirectory)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-clouddirectory.svg?color=blue)](https://pypi.org/project/mypy-boto3-clouddirectory)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-clouddirectory?color=blue)](https://pypistats.org/packages/mypy-boto3-clouddirectory)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/main/logo.png)

Type annotations for
[boto3.CloudDirectory 1.21.23](https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/clouddirectory.html#CloudDirectory)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 7.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-clouddirectory docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_clouddirectory/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/main/demo.gif)

- [mypy-boto3-clouddirectory](#mypy-boto3-clouddirectory)
  - [How to install](#how-to-install)
    - [VSCode extension](#vscode-extension)
    - [From PyPI with pip](#from-pypi-with-pip)
  - [How to uninstall](#how-to-uninstall)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Emacs](#emacs)
    - [Sublime Text](#sublime-text)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [How it works](#how-it-works)
  - [What's new](#what's-new)
    - [Implemented features](#implemented-features)
    - [Latest changes](#latest-changes)
  - [Versioning](#versioning)
  - [Thank you](#thank-you)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

<a id="vscode-extension"></a>

### VSCode extension

Add
[AWS Boto3](https://marketplace.visualstudio.com/items?itemName=Boto3typed.boto3-ide)
extension to your VSCode and run `AWS boto3: Quick Start` command.

Click `Modify` and select `boto3 common` and `CloudDirectory`.

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `boto3-stubs` for `CloudDirectory` service.

```bash
# install with boto3 type annotations
python -m pip install 'boto3-stubs[clouddirectory]'


# Lite version does not provide session.client/resource overloads
# it is more RAM-friendly, but requires explicit type annotations
python -m pip install 'boto3-stubs-lite[clouddirectory]'


# standalone installation
python -m pip install mypy-boto3-clouddirectory
```

<a id="how-to-uninstall"></a>

## How to uninstall

```bash
python -m pip uninstall -y mypy-boto3-clouddirectory
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto3-stubs[clouddirectory]` in your environment:

```bash
python -m pip install 'boto3-stubs[clouddirectory]'
```

Both type checking and code completion should now work. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

Install `boto3-stubs-lite[clouddirectory]` in your environment:

```bash
python -m pip install 'boto3-stubs-lite[clouddirectory]'`
```

Both type checking and code completion should now work. Explicit type
annotations **are required**.

Use `boto3-stubs` package instead for implicit type discovery.

<a id="emacs"></a>

### Emacs

- Install `boto3-stubs` with services you use in your environment:

```bash
python -m pip install 'boto3-stubs[clouddirectory]'
```

- Install [use-package](https://github.com/jwiegley/use-package),
  [lsp](https://github.com/emacs-lsp/lsp-mode/),
  [company](https://github.com/company-mode/company-mode) and
  [flycheck](https://github.com/flycheck/flycheck) packages
- Install [lsp-pyright](https://github.com/emacs-lsp/lsp-pyright) package

```elisp
(use-package lsp-pyright
  :ensure t
  :hook (python-mode . (lambda ()
                          (require 'lsp-pyright)
                          (lsp)))  ; or lsp-deferred
  :init (when (executable-find "python3")
          (setq lsp-pyright-python-executable-cmd "python3"))
  )
```

- Make sure emacs uses the environment where you have installed `boto3-stubs`

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="sublime-text"></a>

### Sublime Text

- Install `boto3-stubs[clouddirectory]` with services you use in your
  environment:

```bash
python -m pip install 'boto3-stubs[clouddirectory]'
```

- Install [LSP-pyright](https://github.com/sublimelsp/LSP-pyright) package

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto3-stubs[clouddirectory]` in your environment:

```bash
python -m pip install 'boto3-stubs[clouddirectory]'`
```

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `npm i -g pyright`
- Install `boto3-stubs[clouddirectory]` in your environment:

```bash
python -m pip install 'boto3-stubs[clouddirectory]'
```

Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`CloudDirectoryClient` provides annotations for
`boto3.client("clouddirectory")`.

```python
from boto3.session import Session

from mypy_boto3_clouddirectory import CloudDirectoryClient

client: CloudDirectoryClient = Session().client("clouddirectory")

# now client usage is checked by mypy and IDE should provide code completion
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_clouddirectory.paginator` module contains type annotations for all
paginators.

```python
from boto3.session import Session

from mypy_boto3_clouddirectory import CloudDirectoryClient
from mypy_boto3_clouddirectory.paginator import (
    ListAppliedSchemaArnsPaginator,
    ListAttachedIndicesPaginator,
    ListDevelopmentSchemaArnsPaginator,
    ListDirectoriesPaginator,
    ListFacetAttributesPaginator,
    ListFacetNamesPaginator,
    ListIncomingTypedLinksPaginator,
    ListIndexPaginator,
    ListManagedSchemaArnsPaginator,
    ListObjectAttributesPaginator,
    ListObjectParentPathsPaginator,
    ListObjectPoliciesPaginator,
    ListOutgoingTypedLinksPaginator,
    ListPolicyAttachmentsPaginator,
    ListPublishedSchemaArnsPaginator,
    ListTagsForResourcePaginator,
    ListTypedLinkFacetAttributesPaginator,
    ListTypedLinkFacetNamesPaginator,
    LookupPolicyPaginator,
)

client: CloudDirectoryClient = Session().client("clouddirectory")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_applied_schema_arns_paginator: ListAppliedSchemaArnsPaginator = client.get_paginator("list_applied_schema_arns")
list_attached_indices_paginator: ListAttachedIndicesPaginator = client.get_paginator("list_attached_indices")
list_development_schema_arns_paginator: ListDevelopmentSchemaArnsPaginator = client.get_paginator("list_development_schema_arns")
list_directories_paginator: ListDirectoriesPaginator = client.get_paginator("list_directories")
list_facet_attributes_paginator: ListFacetAttributesPaginator = client.get_paginator("list_facet_attributes")
list_facet_names_paginator: ListFacetNamesPaginator = client.get_paginator("list_facet_names")
list_incoming_typed_links_paginator: ListIncomingTypedLinksPaginator = client.get_paginator("list_incoming_typed_links")
list_index_paginator: ListIndexPaginator = client.get_paginator("list_index")
list_managed_schema_arns_paginator: ListManagedSchemaArnsPaginator = client.get_paginator("list_managed_schema_arns")
list_object_attributes_paginator: ListObjectAttributesPaginator = client.get_paginator("list_object_attributes")
list_object_parent_paths_paginator: ListObjectParentPathsPaginator = client.get_paginator("list_object_parent_paths")
list_object_policies_paginator: ListObjectPoliciesPaginator = client.get_paginator("list_object_policies")
list_outgoing_typed_links_paginator: ListOutgoingTypedLinksPaginator = client.get_paginator("list_outgoing_typed_links")
list_policy_attachments_paginator: ListPolicyAttachmentsPaginator = client.get_paginator("list_policy_attachments")
list_published_schema_arns_paginator: ListPublishedSchemaArnsPaginator = client.get_paginator("list_published_schema_arns")
list_tags_for_resource_paginator: ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
list_typed_link_facet_attributes_paginator: ListTypedLinkFacetAttributesPaginator = client.get_paginator("list_typed_link_facet_attributes")
list_typed_link_facet_names_paginator: ListTypedLinkFacetNamesPaginator = client.get_paginator("list_typed_link_facet_names")
lookup_policy_paginator: LookupPolicyPaginator = client.get_paginator("lookup_policy")
```

<a id="literals"></a>

### Literals

`mypy_boto3_clouddirectory.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_clouddirectory.literals import (
    BatchReadExceptionTypeType,
    ConsistencyLevelType,
    DirectoryStateType,
    FacetAttributeTypeType,
    FacetStyleType,
    ListAppliedSchemaArnsPaginatorName,
    ListAttachedIndicesPaginatorName,
    ListDevelopmentSchemaArnsPaginatorName,
    ListDirectoriesPaginatorName,
    ListFacetAttributesPaginatorName,
    ListFacetNamesPaginatorName,
    ListIncomingTypedLinksPaginatorName,
    ListIndexPaginatorName,
    ListManagedSchemaArnsPaginatorName,
    ListObjectAttributesPaginatorName,
    ListObjectParentPathsPaginatorName,
    ListObjectPoliciesPaginatorName,
    ListOutgoingTypedLinksPaginatorName,
    ListPolicyAttachmentsPaginatorName,
    ListPublishedSchemaArnsPaginatorName,
    ListTagsForResourcePaginatorName,
    ListTypedLinkFacetAttributesPaginatorName,
    ListTypedLinkFacetNamesPaginatorName,
    LookupPolicyPaginatorName,
    ObjectTypeType,
    RangeModeType,
    RequiredAttributeBehaviorType,
    RuleTypeType,
    UpdateActionTypeType,
    CloudDirectoryServiceName,
    ServiceName,
    ResourceServiceName,
    PaginatorName,
)

def check_value(value: BatchReadExceptionTypeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_clouddirectory.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_clouddirectory.type_defs import (
    AddFacetToObjectRequestRequestTypeDef,
    ApplySchemaRequestRequestTypeDef,
    ApplySchemaResponseTypeDef,
    AttachObjectRequestRequestTypeDef,
    AttachObjectResponseTypeDef,
    AttachPolicyRequestRequestTypeDef,
    AttachToIndexRequestRequestTypeDef,
    AttachToIndexResponseTypeDef,
    AttachTypedLinkRequestRequestTypeDef,
    AttachTypedLinkResponseTypeDef,
    AttributeKeyAndValueTypeDef,
    AttributeKeyTypeDef,
    AttributeNameAndValueTypeDef,
    BatchAddFacetToObjectTypeDef,
    BatchAttachObjectResponseTypeDef,
    BatchAttachObjectTypeDef,
    BatchAttachPolicyTypeDef,
    BatchAttachToIndexResponseTypeDef,
    BatchAttachToIndexTypeDef,
    BatchAttachTypedLinkResponseTypeDef,
    BatchAttachTypedLinkTypeDef,
    BatchCreateIndexResponseTypeDef,
    BatchCreateIndexTypeDef,
    BatchCreateObjectResponseTypeDef,
    BatchCreateObjectTypeDef,
    BatchDeleteObjectTypeDef,
    BatchDetachFromIndexResponseTypeDef,
    BatchDetachFromIndexTypeDef,
    BatchDetachObjectResponseTypeDef,
    BatchDetachObjectTypeDef,
    BatchDetachPolicyTypeDef,
    BatchDetachTypedLinkTypeDef,
    BatchGetLinkAttributesResponseTypeDef,
    BatchGetLinkAttributesTypeDef,
    BatchGetObjectAttributesResponseTypeDef,
    BatchGetObjectAttributesTypeDef,
    BatchGetObjectInformationResponseTypeDef,
    BatchGetObjectInformationTypeDef,
    BatchListAttachedIndicesResponseTypeDef,
    BatchListAttachedIndicesTypeDef,
    BatchListIncomingTypedLinksResponseTypeDef,
    BatchListIncomingTypedLinksTypeDef,
    BatchListIndexResponseTypeDef,
    BatchListIndexTypeDef,
    BatchListObjectAttributesResponseTypeDef,
    BatchListObjectAttributesTypeDef,
    BatchListObjectChildrenResponseTypeDef,
    BatchListObjectChildrenTypeDef,
    BatchListObjectParentPathsResponseTypeDef,
    BatchListObjectParentPathsTypeDef,
    BatchListObjectParentsResponseTypeDef,
    BatchListObjectParentsTypeDef,
    BatchListObjectPoliciesResponseTypeDef,
    BatchListObjectPoliciesTypeDef,
    BatchListOutgoingTypedLinksResponseTypeDef,
    BatchListOutgoingTypedLinksTypeDef,
    BatchListPolicyAttachmentsResponseTypeDef,
    BatchListPolicyAttachmentsTypeDef,
    BatchLookupPolicyResponseTypeDef,
    BatchLookupPolicyTypeDef,
    BatchReadExceptionTypeDef,
    BatchReadOperationResponseTypeDef,
    BatchReadOperationTypeDef,
    BatchReadRequestRequestTypeDef,
    BatchReadResponseTypeDef,
    BatchReadSuccessfulResponseTypeDef,
    BatchRemoveFacetFromObjectTypeDef,
    BatchUpdateLinkAttributesTypeDef,
    BatchUpdateObjectAttributesResponseTypeDef,
    BatchUpdateObjectAttributesTypeDef,
    BatchWriteOperationResponseTypeDef,
    BatchWriteOperationTypeDef,
    BatchWriteRequestRequestTypeDef,
    BatchWriteResponseTypeDef,
    CreateDirectoryRequestRequestTypeDef,
    CreateDirectoryResponseTypeDef,
    CreateFacetRequestRequestTypeDef,
    CreateIndexRequestRequestTypeDef,
    CreateIndexResponseTypeDef,
    CreateObjectRequestRequestTypeDef,
    CreateObjectResponseTypeDef,
    CreateSchemaRequestRequestTypeDef,
    CreateSchemaResponseTypeDef,
    CreateTypedLinkFacetRequestRequestTypeDef,
    DeleteDirectoryRequestRequestTypeDef,
    DeleteDirectoryResponseTypeDef,
    DeleteFacetRequestRequestTypeDef,
    DeleteObjectRequestRequestTypeDef,
    DeleteSchemaRequestRequestTypeDef,
    DeleteSchemaResponseTypeDef,
    DeleteTypedLinkFacetRequestRequestTypeDef,
    DetachFromIndexRequestRequestTypeDef,
    DetachFromIndexResponseTypeDef,
    DetachObjectRequestRequestTypeDef,
    DetachObjectResponseTypeDef,
    DetachPolicyRequestRequestTypeDef,
    DetachTypedLinkRequestRequestTypeDef,
    DirectoryTypeDef,
    DisableDirectoryRequestRequestTypeDef,
    DisableDirectoryResponseTypeDef,
    EnableDirectoryRequestRequestTypeDef,
    EnableDirectoryResponseTypeDef,
    FacetAttributeDefinitionTypeDef,
    FacetAttributeReferenceTypeDef,
    FacetAttributeTypeDef,
    FacetAttributeUpdateTypeDef,
    FacetTypeDef,
    GetAppliedSchemaVersionRequestRequestTypeDef,
    GetAppliedSchemaVersionResponseTypeDef,
    GetDirectoryRequestRequestTypeDef,
    GetDirectoryResponseTypeDef,
    GetFacetRequestRequestTypeDef,
    GetFacetResponseTypeDef,
    GetLinkAttributesRequestRequestTypeDef,
    GetLinkAttributesResponseTypeDef,
    GetObjectAttributesRequestRequestTypeDef,
    GetObjectAttributesResponseTypeDef,
    GetObjectInformationRequestRequestTypeDef,
    GetObjectInformationResponseTypeDef,
    GetSchemaAsJsonRequestRequestTypeDef,
    GetSchemaAsJsonResponseTypeDef,
    GetTypedLinkFacetInformationRequestRequestTypeDef,
    GetTypedLinkFacetInformationResponseTypeDef,
    IndexAttachmentTypeDef,
    LinkAttributeActionTypeDef,
    LinkAttributeUpdateTypeDef,
    ListAppliedSchemaArnsRequestRequestTypeDef,
    ListAppliedSchemaArnsResponseTypeDef,
    ListAttachedIndicesRequestRequestTypeDef,
    ListAttachedIndicesResponseTypeDef,
    ListDevelopmentSchemaArnsRequestRequestTypeDef,
    ListDevelopmentSchemaArnsResponseTypeDef,
    ListDirectoriesRequestRequestTypeDef,
    ListDirectoriesResponseTypeDef,
    ListFacetAttributesRequestRequestTypeDef,
    ListFacetAttributesResponseTypeDef,
    ListFacetNamesRequestRequestTypeDef,
    ListFacetNamesResponseTypeDef,
    ListIncomingTypedLinksRequestRequestTypeDef,
    ListIncomingTypedLinksResponseTypeDef,
    ListIndexRequestRequestTypeDef,
    ListIndexResponseTypeDef,
    ListManagedSchemaArnsRequestRequestTypeDef,
    ListManagedSchemaArnsResponseTypeDef,
    ListObjectAttributesRequestRequestTypeDef,
    ListObjectAttributesResponseTypeDef,
    ListObjectChildrenRequestRequestTypeDef,
    ListObjectChildrenResponseTypeDef,
    ListObjectParentPathsRequestRequestTypeDef,
    ListObjectParentPathsResponseTypeDef,
    ListObjectParentsRequestRequestTypeDef,
    ListObjectParentsResponseTypeDef,
    ListObjectPoliciesRequestRequestTypeDef,
    ListObjectPoliciesResponseTypeDef,
    ListOutgoingTypedLinksRequestRequestTypeDef,
    ListOutgoingTypedLinksResponseTypeDef,
    ListPolicyAttachmentsRequestRequestTypeDef,
    ListPolicyAttachmentsResponseTypeDef,
    ListPublishedSchemaArnsRequestRequestTypeDef,
    ListPublishedSchemaArnsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListTypedLinkFacetAttributesRequestRequestTypeDef,
    ListTypedLinkFacetAttributesResponseTypeDef,
    ListTypedLinkFacetNamesRequestRequestTypeDef,
    ListTypedLinkFacetNamesResponseTypeDef,
    LookupPolicyRequestRequestTypeDef,
    LookupPolicyResponseTypeDef,
    ObjectAttributeActionTypeDef,
    ObjectAttributeRangeTypeDef,
    ObjectAttributeUpdateTypeDef,
    ObjectIdentifierAndLinkNameTupleTypeDef,
    ObjectReferenceTypeDef,
    PaginatorConfigTypeDef,
    PathToObjectIdentifiersTypeDef,
    PolicyAttachmentTypeDef,
    PolicyToPathTypeDef,
    PublishSchemaRequestRequestTypeDef,
    PublishSchemaResponseTypeDef,
    PutSchemaFromJsonRequestRequestTypeDef,
    PutSchemaFromJsonResponseTypeDef,
    RemoveFacetFromObjectRequestRequestTypeDef,
    ResponseMetadataTypeDef,
    RuleTypeDef,
    SchemaFacetTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    TypedAttributeValueRangeTypeDef,
    TypedAttributeValueTypeDef,
    TypedLinkAttributeDefinitionTypeDef,
    TypedLinkAttributeRangeTypeDef,
    TypedLinkFacetAttributeUpdateTypeDef,
    TypedLinkFacetTypeDef,
    TypedLinkSchemaAndFacetNameTypeDef,
    TypedLinkSpecifierTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateFacetRequestRequestTypeDef,
    UpdateLinkAttributesRequestRequestTypeDef,
    UpdateObjectAttributesRequestRequestTypeDef,
    UpdateObjectAttributesResponseTypeDef,
    UpdateSchemaRequestRequestTypeDef,
    UpdateSchemaResponseTypeDef,
    UpdateTypedLinkFacetRequestRequestTypeDef,
    UpgradeAppliedSchemaRequestRequestTypeDef,
    UpgradeAppliedSchemaResponseTypeDef,
    UpgradePublishedSchemaRequestRequestTypeDef,
    UpgradePublishedSchemaResponseTypeDef,
)

def get_structure() -> AddFacetToObjectRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="how-it-works"></a>

## How it works

Fully automated
[mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder) carefully
generates type annotations for each service, patiently waiting for `boto3`
updates. It delivers a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type
  annotations extracted from the documentation (blame `botocore` docs if types
  are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) and
  [isort](https://github.com/PyCQA/isort) for readability.

<a id="what's-new"></a>

## What's new

<a id="implemented-features"></a>

### Implemented features

- Fully type annotated `boto3`, `botocore` and `aiobotocore` libraries
- `mypy`, `pyright`, `VSCode`, `PyCharm`, `Sublime Text` and `Emacs`
  compatibility
- `Client`, `ServiceResource`, `Resource`, `Waiter` `Paginator` type
  annotations for each service
- Generated `TypeDefs` for each service
- Generated `Literals` for each service
- Auto discovery of types for `boto3.client` and `boto3.session` calls
- Auto discovery of types for `session.client` and `session.session` calls
- Auto discovery of types for `client.get_waiter` and `client.get_paginator`
  calls
- Auto discovery of types for `ServiceResource` and `Resource` collections
- Auto discovery of types for `aiobotocore.Session.create_client` calls

<a id="latest-changes"></a>

### Latest changes

Builder changelog can be found in
[Releases](https://github.com/vemel/mypy_boto3_builder/releases).

<a id="versioning"></a>

## Versioning

`mypy-boto3-clouddirectory` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="thank-you"></a>

## Thank you

- [Allie Fitter](https://github.com/alliefitter) for
  [boto3-type-annotations](https://pypi.org/project/boto3-type-annotations/),
  this package is based on top of his work
- [black](https://github.com/psf/black) developers for an awesome formatting
  tool
- [Timothy Edmund Crosley](https://github.com/timothycrosley) for
  [isort](https://github.com/PyCQA/isort) and how flexible it is
- [mypy](https://github.com/python/mypy) developers for doing all dirty work
  for us
- [pyright](https://github.com/microsoft/pyright) team for the new era of typed
  Python

<a id="documentation"></a>

## Documentation

All services type annotations can be found in
[boto3 docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_clouddirectory/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
