"""Pydantic models for Digikala API responses."""

from .common_models import (
    URL,
    Image,
    Images,
    Color,
    Rating,
    Price,
    Seller,
    SellerRating,
    SellerGrade,
    SellerProperties,
    Warranty,
    DigiPlus,
    DigiPlusService,
    ShipmentMethods,
    ShipmentProvider,
    ShipmentLabel,
    ShipmentPrice,
    DataLayer,
    Properties,
    BaseResponse,
)
from .product_models import (
    Product,
    ProductDetail,
    InactiveProduct,
    ActiveProduct,
    ProductDetailResponse,
    DefaultVariant,
    Theme,
    ThemeValue,
    DigiClub,
    Insurance,
    InsuranceCover,
    Category,
    Brand,
    BrandLogo,
    Review,
    ReviewAttribute,
    ProsAndCons,
    Suggestion,
    Variant,
    Breadcrumb,
    Specification,
    SpecificationAttribute,
)
from .search_models import (
    ProductSearchResponse,
    SearchData,
    QuickFilter,
    SortOptions,
    Pager,
)
from .seller_models import (
    SellerProductListResponse,
    SellerData,
    SellerDetail,
    SellerIcon,
    SellerDetailRating,
    SellerStatistics,
)
from .brand_models import (
    BrandProductsResponse,
    BrandData,
    BrandDetail,
    SponsoredBrand,
    Advertisement,
)

__all__ = [
    # Common models
    "URL",
    "Image",
    "Images",
    "Color",
    "Rating",
    "Price",
    "Seller",
    "SellerRating",
    "SellerGrade",
    "SellerProperties",
    "Warranty",
    "DigiPlus",
    "DigiPlusService",
    "ShipmentMethods",
    "ShipmentProvider",
    "ShipmentLabel",
    "ShipmentPrice",
    "DataLayer",
    "Properties",
    "BaseResponse",
    # Product models
    "Product",
    "ProductDetail",
    "InactiveProduct",
    "ActiveProduct",
    "ProductDetailResponse",
    "DefaultVariant",
    "Theme",
    "ThemeValue",
    "DigiClub",
    "Insurance",
    "InsuranceCover",
    "Category",
    "Brand",
    "BrandLogo",
    "Review",
    "ReviewAttribute",
    "ProsAndCons",
    "Suggestion",
    "Variant",
    "Breadcrumb",
    "Specification",
    "SpecificationAttribute",
    # Search models
    "ProductSearchResponse",
    "SearchData",
    "QuickFilter",
    "SortOptions",
    "Pager",
    # Seller models
    "SellerProductListResponse",
    "SellerData",
    "SellerDetail",
    "SellerIcon",
    "SellerDetailRating",
    "SellerStatistics",
    # Brand models
    "BrandProductsResponse",
    "BrandData",
    "BrandDetail",
    "SponsoredBrand",
    "Advertisement",
]