# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from scope_client.api_bindings.models.connector_pagination_options import ConnectorPaginationOptions
from scope_client.api_bindings.models.data_result_filter import DataResultFilter
from typing import Optional, Set
from typing_extensions import Self

class FetchDataJobSpec(BaseModel):
    """
    FetchDataJobSpec
    """ # noqa: E501
    job_type: Optional[StrictStr] = 'fetch_data'
    dataset_id: Optional[StrictStr]
    available_dataset_id: Optional[StrictStr] = None
    start_timestamp: datetime = Field(description="The start timestamp to use for fetching data.")
    end_timestamp: datetime = Field(description="The end timestamp to use for fetching data.")
    operation_id: StrictStr = Field(description="The id of the data retrieval operation.")
    data_filters: List[DataResultFilter] = Field(description="Filters to apply to the metrics data.")
    pagination_options: ConnectorPaginationOptions = Field(description="Pagination options to use for fetching data.")
    __properties: ClassVar[List[str]] = ["job_type", "dataset_id", "available_dataset_id", "start_timestamp", "end_timestamp", "operation_id", "data_filters", "pagination_options"]

    @field_validator('job_type')
    def job_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['fetch_data']):
            raise ValueError("must be one of enum values ('fetch_data')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FetchDataJobSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in data_filters (list)
        _items = []
        if self.data_filters:
            for _item_data_filters in self.data_filters:
                if _item_data_filters:
                    _items.append(_item_data_filters.to_dict())
            _dict['data_filters'] = _items
        # override the default output from pydantic by calling `to_dict()` of pagination_options
        if self.pagination_options:
            _dict['pagination_options'] = self.pagination_options.to_dict()
        # set to None if dataset_id (nullable) is None
        # and model_fields_set contains the field
        if self.dataset_id is None and "dataset_id" in self.model_fields_set:
            _dict['dataset_id'] = None

        # set to None if available_dataset_id (nullable) is None
        # and model_fields_set contains the field
        if self.available_dataset_id is None and "available_dataset_id" in self.model_fields_set:
            _dict['available_dataset_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FetchDataJobSpec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "job_type": obj.get("job_type") if obj.get("job_type") is not None else 'fetch_data',
            "dataset_id": obj.get("dataset_id"),
            "available_dataset_id": obj.get("available_dataset_id"),
            "start_timestamp": obj.get("start_timestamp"),
            "end_timestamp": obj.get("end_timestamp"),
            "operation_id": obj.get("operation_id"),
            "data_filters": [DataResultFilter.from_dict(_item) for _item in obj["data_filters"]] if obj.get("data_filters") is not None else None,
            "pagination_options": ConnectorPaginationOptions.from_dict(obj["pagination_options"]) if obj.get("pagination_options") is not None else None
        })
        return _obj


