# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from scope_client.api_bindings.models.job_kind import JobKind
from scope_client.api_bindings.models.job_priority import JobPriority
from scope_client.api_bindings.models.job_spec import JobSpec
from scope_client.api_bindings.models.job_state import JobState
from scope_client.api_bindings.models.job_trigger import JobTrigger
from scope_client.api_bindings.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class Job(BaseModel):
    """
    Job
    """ # noqa: E501
    id: StrictStr = Field(description="UUID of the job.")
    kind: JobKind = Field(description="Type of job.")
    job_spec: JobSpec
    state: JobState = Field(description="Current state of the job.")
    project_id: StrictStr = Field(description="ID of parent project.")
    data_plane_id: Optional[StrictStr] = None
    queued_at: datetime = Field(description="ISO 8601 timestamp when the job was queued.")
    ready_at: datetime = Field(description="ISO 8601 timestamp of the earliest time the job can be executed.")
    started_at: Optional[datetime] = None
    finished_at: Optional[datetime] = None
    duration_sec: Optional[StrictInt] = None
    error_count: Optional[StrictInt] = None
    trigger_type: JobTrigger = Field(description="Type of trigger.")
    triggered_by_user: Optional[User] = None
    schedule_id: Optional[StrictStr] = None
    attempts: StrictInt = Field(description="Number of times the job was attempted.")
    max_attempts: StrictInt = Field(description="Max number of times the job can fail and be retried.")
    nonce: Optional[StrictStr] = None
    memory_requirements_mb: StrictInt = Field(description="Memory requirements for the job in megabytes.")
    job_priority: JobPriority = Field(description="Priority of the job.")
    __properties: ClassVar[List[str]] = ["id", "kind", "job_spec", "state", "project_id", "data_plane_id", "queued_at", "ready_at", "started_at", "finished_at", "duration_sec", "error_count", "trigger_type", "triggered_by_user", "schedule_id", "attempts", "max_attempts", "nonce", "memory_requirements_mb", "job_priority"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Job from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of job_spec
        if self.job_spec:
            _dict['job_spec'] = self.job_spec.to_dict()
        # override the default output from pydantic by calling `to_dict()` of triggered_by_user
        if self.triggered_by_user:
            _dict['triggered_by_user'] = self.triggered_by_user.to_dict()
        # set to None if data_plane_id (nullable) is None
        # and model_fields_set contains the field
        if self.data_plane_id is None and "data_plane_id" in self.model_fields_set:
            _dict['data_plane_id'] = None

        # set to None if started_at (nullable) is None
        # and model_fields_set contains the field
        if self.started_at is None and "started_at" in self.model_fields_set:
            _dict['started_at'] = None

        # set to None if finished_at (nullable) is None
        # and model_fields_set contains the field
        if self.finished_at is None and "finished_at" in self.model_fields_set:
            _dict['finished_at'] = None

        # set to None if duration_sec (nullable) is None
        # and model_fields_set contains the field
        if self.duration_sec is None and "duration_sec" in self.model_fields_set:
            _dict['duration_sec'] = None

        # set to None if error_count (nullable) is None
        # and model_fields_set contains the field
        if self.error_count is None and "error_count" in self.model_fields_set:
            _dict['error_count'] = None

        # set to None if triggered_by_user (nullable) is None
        # and model_fields_set contains the field
        if self.triggered_by_user is None and "triggered_by_user" in self.model_fields_set:
            _dict['triggered_by_user'] = None

        # set to None if schedule_id (nullable) is None
        # and model_fields_set contains the field
        if self.schedule_id is None and "schedule_id" in self.model_fields_set:
            _dict['schedule_id'] = None

        # set to None if nonce (nullable) is None
        # and model_fields_set contains the field
        if self.nonce is None and "nonce" in self.model_fields_set:
            _dict['nonce'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Job from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "kind": obj.get("kind"),
            "job_spec": JobSpec.from_dict(obj["job_spec"]) if obj.get("job_spec") is not None else None,
            "state": obj.get("state"),
            "project_id": obj.get("project_id"),
            "data_plane_id": obj.get("data_plane_id"),
            "queued_at": obj.get("queued_at"),
            "ready_at": obj.get("ready_at"),
            "started_at": obj.get("started_at"),
            "finished_at": obj.get("finished_at"),
            "duration_sec": obj.get("duration_sec"),
            "error_count": obj.get("error_count"),
            "trigger_type": obj.get("trigger_type"),
            "triggered_by_user": User.from_dict(obj["triggered_by_user"]) if obj.get("triggered_by_user") is not None else None,
            "schedule_id": obj.get("schedule_id"),
            "attempts": obj.get("attempts"),
            "max_attempts": obj.get("max_attempts"),
            "nonce": obj.get("nonce"),
            "memory_requirements_mb": obj.get("memory_requirements_mb"),
            "job_priority": obj.get("job_priority")
        })
        return _obj


