# ТЗ: Переработка мсп мемори банк

> Пришли к согласованой концепции структуры мсп сервера для мемори банка. Большая часть текущей логики должна быть переработана или адаптирована под новую реализацию.

## MemoryBank Structure

### Changes:

> Так как структура отрабатьвалась на мемори-банке реального проекта используй его как референс для изучения новой структуры, там есть все шаблоны, и примеры уже реальных частей в новой структуре описаной (Путь: `/home/vlad/tech/job/modus/memory_bank_kenoma/`)

> Также важно чтобы ты изучил в документации MCP работу ресурсов(`https://gofastmcp.com/servers/resources`) и промптов (`https://gofastmcp.com/servers/prompts`) так как в пред.версиях мы упустили этот функционал и сделали не совсем логичную структуру правильную для мсп серверов и городили копирование команд и тулзы которые не совсем тулзы.

> Для работы с `Python Claude Code SDK` используй документацию в интернете и всегда все действия с этим сверяй с ее реализацией (мы достаем API ключ из сетапа `claude-helpers setup` - глобальных настроек. Если установлен `plan-mode` мы должны пробрасывать специальный параметр для этого чтобы он корректно использовался)

- В новой версии структуры Memory-bank удалены епики и компоненты из части имплементации так как таски слишком мелко для одной итерации с агентами. Было упрощено к одному уровню и переименовано концепт в инкремент
    - Теперь каждый архитектурный компонент декомпозируется на этапы-инкрементов в файле decomposition.md и потом в подпапке по отдельным инкрементам описывается их полное тело как одной атомарной задаче для работы по циклу owner<->PM<->Dev, Tech-Lead
    - Рядом с файлом декомпозиции теперь лежит обязательный inital-state.md который в ручном режиме прописывается на этапе дизайна и работает в паре с progress-state на уровне progress (для мсп ресурса state мы делаем комбинирование из двух файлов этих стейтов, а не отдаем какой-то из этих оригинальных файлов т.к вместе онии представляют структуру от начального овервью состояния в начале релиза до фикса состояний по окончанию каждого инкремента)

- В новом воркфлоу для мемори банка изменилась суть. Теперь мы работаем по принципу:
    - Промптом-командой /implement-component в МСП `owner` с `pm` тригерит команду которая загружает в него его роль и протокол работы и устанавливает фокус на релизе и его компоненте по чему он понимает что ему нужно вызвать свой фокус и сделать заметку, и после этого он сможет вызвать роль dev и начать воркфлоу.
    - Агент `qa` был переименован в `tech-lead`. Но его задача остается прежней - он валидирует то что сделал `dev` - и по завершению `pm` уточняет `owner` отчет и спрашивает ок ли он перейти к дальнейшему инкременту (вызов тулзы мсп) или продолжим работать по текущей (вернуть dev или qa с новым контекстом - или если qa вернулся с проблемй или `dev` и после согласования с овнером `pm` возвращает нужного саб-агента) 
    - Фокус теперь отдельными мсп прописан для каждой роли, но он статичен и при вызове в инкременте работы если его нет билдиться по формуле динамически и потом используется с этого файла (можно удалить чтобы перебилдить если там что-то не нравится) + также теперь фокус не содержит стандарты тех и они вынесены в ресурсыс, и также журнал в ресурсы и там теперь более менее статичный контекст за исключением некоторых частей сборки
    - Команда `run` переименована на `increment-component` и вынесена из клод slash-команд для копирования в воркфлоу в мсп промпты т.к Claude-code с ними совместим и так. (Теперь на init мемори банка при привязвке рабочей папки к мемори банку предлагаем только скопировать саб-агентов и даже не предлагаем клод мд)


### Templates:

- В мемори банке по кеноме твоем референсе есть `templates/workflow/*` - где задана структура файлов по мсп промптам где они нужны(где используется Claude Code SDK агент под капотом в запросе) и также для саб-агентов и промптов.
    - Текущие промпты саб агентов там хоть и правильно по воркфлоу описаны - но не адаптированы под работу с МСП инструментами поэтому лучшее агентов промпты базовые оставить адаптировав те что уже есть заменим только `qa` на `tech-lead` и убрав из них лишние устаревшие детали или неактуальные.
    - Схема работы с промптами остается как есть - мы используем из мемори банка если привязаный к проекту где вызов имеет такие в папке шаблонам (и саму папку шаблонов - без ошибок) - и если нету то использует стандартные версии из самого `claude-helpers`

- из `HIL` функционала планируется на `claude-helpers init` убрать предложение установить команду обработки клод мд промпта + добавление слеш команды `/voice` - и заменить ее на `ask` промпт-команду в МСП `HIL` т.к это более правильно с точки зренияи структуры

- Детальная работа с промптами написанная в алгоритмах описания функций в детализации изменений 

### Флоу работы по этому ТЗ:

1. Тщательно и детально критически проанализировать контекст тут и все ссылки проверять чтобы понять полноту написаного так как здесь много тех деталей к которым нужно внимательно относится и всее обдумать
2. Изучить примеры новой структуры в кенома референсее но учитывая что это лишь референс и там все еще не прям под нашу реализацию
3. Проанализировать текущую реализацию относительно рефлексии на задачу доработки утилиты нашей и тщательно критически все обдумав в папке `tmp-todo` где это ТЗ описано создать папку `tasks` где разбить это ТЗ на конкретный план доработки итеративный (лаконично четко то что нужно ссылаясь просто на ТЗ в детализации и согласовано чтобы добиться результата работы как описано в этом документе) - по этому воркфлоу после мы приступим к разработке 
4. Проанализировать что получилось и тщательно и критически провалидировать

### Флоу Имлпементации:

1. Приступить к таске 1 в нашем временой декомпозиции по ТЗ, и тщательно для начала изучить нужные описанные ресурсы включая то что в интернете для правильной работы с этим тех деталями
2. Найди и критически проанализировать что и как будем править и перерабатывать чтобы не намусорить репозиторий при переработке старого кода так как раньше был сложный флоу на фоне текущих упрощений по реализации более правильных
3. Таска за таской итеративно имплементировать по плану делая валидацию и отчет на каждой
4. Все моменты которые тебе не понятны сверять со мной и искать все в интернете если нет актуальных данных - не делай измнений поспешных или если ты не уверен на угад


### Важный контекст:

- Сессия работы с ПМ для овнера всегда на уровне компонента поэтому мы везде пробрасываем именно его
    - Но отдельные `dev` и `tech-lead` работают на уровне инкремента - однако его мы не передаем в тулзах так как инкременты идут синхронно друг за другом и по переходам фиксируют овервью реализации в стейте компонента
    - При вызове МСП и любого с ним флоу при разработке мы четкое выделяем что:
        - Папка где это происходит - рабочий репозиторий
        - Папка с которым через `.helpers` конфигурацию мемори банком он связан - это его мемори банк по которому мы работаем
    - Инициализация рабочей репы с мемори банком возможна если там уже инициализирован `claude-helpers init`
        - А также если он не связан с каким-то мемори банком МСП тулзы и ресурсы будут бросать ошибки т.к мы не знаем где это выполнять
- Во многом флоу и сейчас работает по схожему принципу просто плохо структурировано и довольно усложненной перегруженной логикой которая не нужна для первой версии итеративного флоу нашего. Поэтому текущую реализацию можно учитывать как важный контекст и опыт особенно примеры работы с `Claude Code SDK` и `fast-mcp` базово + конечно же с мемори банком (понимание как получить и прробросить путь к правильной папке к мемори банку им как понять что есть путь к папке рабочей ) 

## MemoryBank: New MCP Server

### MCP Tools

- `get-pm-focus(release: str, component: str, page: int = 1) -> str,` - Получить текущий фокус по текущему компоненту и состоянию для `pm` (поддержка пагинации важна + информация о текущей и доступных страницах)
    - Если файл найден в компоненте в папке текущего инкремента: Возвращаем его
    - Если файл не найден в компоненте в папке текущего инкремента:
        - Используя промпт дистиляции продукта (`templates/workflow/memory-bank/product-distillation.md` из мемори банка - если не найден стандартный из `claude-helpers`) получаем дистиляцию продукта
        - Формируем файл `pm-focus.md` в папке мемори-банка `progress/releases/{release}/{component}/increments/{increment}` по формуле: `pm-focus= distilled_product + component + decomposition.md for component + component state (inital + progress)`
            - по факту используем шаблон фокуса ПМ (из мемори банка `templates/progress/pm-focus.md` если не найден стандартный из `claude-helpers`) просто подставляя нужные плейсхолдеры если они запрашиваются в теле по частям нашей формулы в шаблон (сам шаблон и его корректность нужно доработать)  

- `get-dev-focus(release: str, component: str, page: int = 1) -> str` - Получить текущий фокус по текущему инкременту компонента для `dev` агента (поддержка пагинации важна + информация о текущей и доступных страницах)
    - Если файл найден в компоненте в папке текущего инкремента: Возвращаем его
    - Если файл не найден в компоненте в папке текущего инкремента:
        - Используя промпт дистиляции продукта (`templates/workflow/memory-bank/product-distillation.md` из мемори банка - если не найден стандартный из `claude-helpers`) получаем дистиляцию продукта
        - Формируем файл `dev-focus.md` в папке мемори-банка `progress/releases/{release}/{component}/increments/{increment}` по формуле: dev-focus= distilled_product + component + increment for component + (component inital state from implementation + progress_state from progress component)
            - по факту используем шаблон фокуса ПМ (из мемори банка `templates/progress/dev-focus.md` если не найден стандартный из `claude-helpers`) просто подставляя нужные плейсхолдеры если они запрашиваются в теле по частям нашей формулы в шаблон (сам шаблон и его корректность нужно доработать) 

- `get-tech-lead-focus(release: str, component: str, page: int = 1) -> str` - Получить текущий фокус по текущему инкременту компонента для `tech-lead` агента (поддержка пагинации важна + информация о текущей и доступных страницах)
    - Если файл найден в компоненте в папке текущего инкремента: Возвращаем его
    - Если файл не найден в компоненте в папке текущего инкремента:
        - Используя промпт дистиляции продукта (`templates/workflow/memory-bank/product-distillation.md` из мемори банка - если не найден стандартный из `claude-helpers`) получаем дистиляцию продукта
        - Формируем файл `tech-lead-focus.md` в папке мемори-банка `progress/releases/{release}/{component}/increments/{increment}` по формуле: `tech-lead-focus= distilled_product + component + increment for component + (component inital state from implementation + progress_state from progress component)`
            - по факту используем шаблон фокуса ПМ (из мемори банка `templates/progress/tech-lead-focus.md` если не найден стандартный из `claude-helpers`) просто подставляя нужные плейсхолдеры если они запрашиваются в теле по частям нашей формулы в шаблон (сам шаблон и его корректность нужно доработать)

- `journal-note(release: str, component: str, role: Literal['dev', 'owner', 'pm', 'tech-lead'], message: str)` - Сделать запись в журнал текущего инкремента компонента от имени какой-то роли (Мейлстоуны т.к начало работы, конец, блокеры и issue - то есть ключевые стейты)
    - В папке мемори банка по `progress/releases/{release}/{component}/increments/{increment}/journal.md` (если нету файла такого по пути или недостает папок - создавать по шаблону) добавляем новую запись под заголовков '## {datetime-utc-0-with-timezone} - {role}' и под ним в его блоке тело сообщения
        - Используем шаблон из мемори банка - `templates/progress/progress-state.md` для базового стейт файла и образца структуры (его нужно доработать - это больше набросок псевдо структуры)

- `next-increment(release: str, component: str)` - Переключить стейт компонента на следующий инкремент (триггерит флоу овервью имплементации инкремента сборки в стейте как закрытие его состояния на закрытое используя промпт `templates/workflow/memory-bank/increment-implementaion-overview.md` - если не найден стандартный из `claude-helpers`)
    - в папке мемори банка по `progress/releases/{release}/{component}/progress-state.md` (если нету или не хватает папок - создаем по шаблону `templates/progress/progress-state.md`) используется как образец структуры стейта.
    - Claude Code SDK агент с промптом `increment-implementaion-overview.md` запускается по папке текущей рабочей + папке мемори банка привязаного в среде
        - Полученный овервью аккуратно вставляется в секции конкретного инкремента и блок его стейта помечается как завершенный + yaml тег в шапке стейта заменяется параметр текущего инкремента на следующий
    - Метод возвращает контекст о том какой следующий инкремент и что он готов для начала работы

- `ask-memory-bank(release: str, component: str, query: str) -> str` - Задать вопрос к мемори банку высокоуровневый который по промпте `ask-memory-bank` из шаблонов воркфлоу(`templates/workflow/memory-bank/ask-memory-bank.md` в мемори банке - если не найден стандартный из `claude-helpers`) мемори банка с рабочей директорией в подключенном мемори банке обработает запрос и даст четкий ответ как спрарвочник без доп.вопросов встречных (используя `Claude Code SDK`)

> Все что  не описано - удалено из флоу т.к не имеет реальной надобности. Некоторые части похожие на текущие но переименованы и изменен флоу их работы.

### MCP Resources

> MCP ресурсы это болеее правильная структура для формирования ресурсов если это не action выделяя в тулзы как мы делали раньше. Изучив по ним документацию нужно реализовать такие +- статичные ресурсы средствами ресурсов (ТАКЖЕ ВОЗМОЖНО ПОЧТИ НА КАЖДОМ МОГУТ БЫТЬ БОЛЬШИЕ ФАЙЛЫ И ВАЖНО ПРЕДУСМОТРЕТЬ ПАГИНАЦИЮ И  БЫТЬ УВЕРЕНЫМИ ЧТО АГЕНТ МОЖЕТ ПОНЯТЬ ЧТО ТАМ НУЖНО ИЗУЧИТЬ ЕЩЕ СТРАНИЦЫ - твоя задача разобраться как это сделать правильно тоже)

- `/architecture/tech-context/*` -  давать в МСП  ресурсы мемори банка все вложенные в `tech-context` папку мемори банка если были найдены 
- `/architecture/{release}/{component}/component.md` - прокси к спецификации компонента по релизу из папки мемори банка 
- `/todo/{release}/{component}/increment.md` - прокси к текущему инкременту по стейту компонента в папке мемори банка (достаем из компонента текущий инкремент и выдаем его тело из имлпементации)
- `/todo/{release}/{component}/decomposition.md` - прокси к декомпозиции овервью из имплементации текущего компонента в мемори банке проекта  
- `/progress/{release}/{component}/journal.md` - прокси к журналу текущего инкремента компонента в мемори банке папке проекта
- `/proogress/{release}/{component}/state.md` - динамическая выдача комбинации из двух файлов стейта инитал из имлплементации + прогресс стейта из компонента прогресса

### MCP Prompt

- `implement-component` - замена старой команды `run` для `pm` вынесенная в МСП промпт для более нативной интеграции (без копирования слеш команд в среду разработки из мемори банка при ините `claude-helpers memory-bank init` связывая рабочую папку с мемори банком - теперь предлагаем копировать только саб агентов и добавлять мсп сервер)


### Claude-Helpers CLI Update

- `claude-helpers memory-bank spawn-structure` - Как и раньше должна в текущей папке заспавнить папку `memory-bank` которая будет содержать структуру базовых папок мемори-банка и пустых файлов по шаблонам включая Claude.md
    - Только используется уже неакутальная структура старая + мешанина с тем что мы копируем сразу с шаблонами хотя для этого отдельная команда
- `claude-helpers memory-bank spawn-prompts` - лишняя команда которую нужно удалить(часть функционала на спавн шаблонов вынесено) 
- `claude-helpers memory-bank spawn-templates` - команда которая создает папку шаблонов(если она есть то только недостающих файлов) из стндартных в `claude-helpers`
- `claude-helpers memory-bank setup-mcp` - как и сейчас запрашивать должна имя мемори-банка и при выборе создавать его в глобальном конфиге для потом доступности для инита в рабочих папках (сейчас там зачем-то создается файл с json мсп мемори банка хотя нее понятно зачем мы ведь привязываем мсп командой инит и там не нужен файл этот - это вот только убрать нужно )
- `claude-helpers memory-bank init` - Как и сейчас запрашивает из доступных выбор мемори банка и при выборе создает в `.helpers` настройку связывающую папку разработки с мемори банком (нужно для того чтобы при вызове мсп тулзов мы понимали что есть папка работы и какая для нее папка мемории банка чтобы там что-то делать)
    - Также спрашиваем нужно ли добавить саб-агентов - если да копируем из мемори банка шаблонов (если найдены - если нет стандартные `claude-helpers`)
    - Также спрашиваем нужно ли добавить мсп - если да добавляем мсп для работы с мемори банком
    - Большая часть флоу текущего остается

## HIL: UPD MCP server

### MCP Tools

- `ask-human(query: str, sender_role: str)` - замена старой команды МСП для запроса к человеку с более понятным именем (по сути переименованиеи просто)

### MCP Prompts

- `ask` - замена слеш команды `/voice` и вынесена в МСП промпты для более нативной интеграции (Теперь на `claude-helpers init` не нужно предлагать копировать команды слеш т.к мсп полностью покрывает интеграцию и достаточно спавна папки хелпера и добавление мсп)


### Claude-Helpers CLI Update

- `claude-helpers init` - большая часть флоу сохраняется
    - Мы как и раньше если нету инициализируем если есть спрашиваем нужно или пересоздать папку `.helpers` с правильной структурой для работы нашей утилиты
    - Предлагаем добавить МСП сервер для `HIL` + также как и сейчас увеличить лимит таймаута на мсп (Разница только в том что большее не предлагаем копирование слеш команд и манипуляций для клод мд)

## Skeleton: MCP Server

> Остается в прежнем виде. Мы позволяем использоввать стандартные скелетоны(сейчас только один) для спавна командой, но если найдена папка мемори-банка в текщей папке - то выводим как доступные еслии найдены скелетоны еще из ее папки шаблонов (как и сейчас)