# Task 05: Реализация MCP Prompts

## Описание
Создание MCP Prompts для команд, которые инициируют воркфлоу через промпты вместо слеш-команд.

## Что нужно сделать

### 1. Memory Bank Prompts (mcp_prompts.py)
```python
@mcp.prompt
def implement_component(release: str, component: str) -> str:
    """
    Инициирует воркфлоу реализации компонента для owner/PM.
    Загружает роль и протокол работы, устанавливает фокус.
    """
    # Загрузка промпта из templates/workflow/pm/implement-component.md
    # Подстановка переменных release, component
    # Возврат промпта для начала воркфлоу
```

### 2. HIL Prompts
```python
@mcp.prompt  
def ask(query: str = None) -> str:
    """
    Замена слеш-команды /voice для запроса к человеку.
    Позволяет использовать голосовой ввод.
    """
    # Формирование промпта для активации HIL
    # Опционально: указание на голосовой режим
```

### 3. Интеграция с шаблонами
- Загрузка промптов из Memory Bank templates с fallback на встроенные
- Подстановка переменных в шаблоны
- Валидация параметров

### 4. Работа с контекстом
- Доступ к текущему состоянию компонента
- Передача необходимых данных в промпт
- Форматирование для LLM

## Что использовать из текущей реализации
- Логику загрузки шаблонов
- Работу с путями Memory Bank

## Новое
- Использование @mcp.prompt декоратора
- Структурированные промпты вместо команд
- Нативная интеграция с Claude Code

## Результат
- Замена слеш-команд на MCP промпты
- Более естественная интеграция с Claude Code
- Упрощенная установка (не нужно копировать команды)

## Время: 3-4 часа