# Task 06: Реализация ask-memory-bank

## Описание
Создание интеллектуального инструмента для запросов к Memory Bank с использованием Claude Code SDK.

## Что нужно сделать

### 1. MCP Tool ask-memory-bank
```python
@mcp.tool
async def ask_memory_bank(release: str, component: str, query: str) -> str:
    """
    Интеллектуальный поиск и анализ в Memory Bank.
    Использует Claude Code SDK для обработки запросов.
    """
    # Загрузка промпта ask-memory-bank.md
    # Сбор контекста из Memory Bank
    # Запуск Claude Code SDK
    # Возврат структурированного ответа
```

### 2. Интеграция Claude Code SDK
- Использование ClaudeCodeOptions для настройки
- Передача контекста Memory Bank и рабочей директории
- Обработка ответов и форматирование

### 3. Промпт ask-memory-bank.md
- Создание/адаптация промпта для анализа Memory Bank
- Инструкции для четких ответов без встречных вопросов
- Форматирование как справочник

### 4. Оптимизация контекста
- Умный отбор релевантных файлов
- Ограничение размера контекста
- Приоритизация по релевантности к запросу

## Что использовать из текущей реализации
- Базовую логику работы с Claude SDK (если есть)
- Функции поиска и загрузки файлов

## Новое
- Полноценная интеграция Claude Code SDK
- Интеллектуальный анализ запросов
- Контекстно-зависимые ответы

## Результат
- Мощный инструмент для работы с Memory Bank
- Быстрые и точные ответы на вопросы
- Использование AI для навигации по проекту

## Время: 5-6 часов