# Task 07: Обновление CLI команд

## Описание
Переработка CLI команд claude-helpers для работы с новой структурой Memory Bank и упрощения воркфлоу.

## Что нужно сделать

### 1. Обновление memory-bank команд

#### spawn-structure
- Использовать новую структуру с инкрементами
- Создавать правильные папки:
  - implementation/releases/{release}/components/{component}/increments/
  - progress/releases/{release}/components/{component}/increments/
- Копировать базовые шаблоны

#### spawn-templates
- Новая команда для создания/обновления шаблонов
- Копирует из встроенных в claude-helpers
- Создает структуру templates/:
  - workflow/memory-bank/
  - workflow/pm/agents/
  - progress/
  - implementation/

#### setup-mcp
- Убрать создание лишнего JSON файла
- Только регистрация Memory Bank в глобальном конфиге
- Упростить диалог

#### init
- Убрать предложение копировать слеш-команды
- Спрашивать только:
  - Добавить саб-агентов? (dev, tech-lead)
  - Добавить MCP сервер Memory Bank?
- Создавать связку с Memory Bank в .helpers/

### 2. Обновление HIL команд

#### init (HIL часть)
- Убрать копирование слеш-команд
- Убрать модификацию CLAUDE.md для команд
- Оставить только:
  - Создание .helpers/ структуры
  - Добавление MCP сервера HIL
  - Увеличение таймаута MCP

### 3. Удаление устаревших команд
- spawn-prompts (функционал в spawn-templates)
- Старые команды работы с эпиками/задачами

## Что сохранить из текущей реализации
- Базовую логику диалогов с пользователем
- Работу с конфигурацией
- Создание структуры папок

## Что изменить
- Упростить воркфлоу установки
- Убрать лишние шаги
- Адаптировать под новую структуру

## Результат
- Упрощенный и понятный CLI
- Быстрая установка и настройка
- Соответствие новой архитектуре

## Время: 4-5 часов