# Task 09: Тестирование и интеграция

## Описание
Комплексное тестирование новой реализации и интеграция всех компонентов.

## Что нужно сделать

### 1. Unit тесты для core функций
- Тесты для работы с инкрементами
- Тесты пагинации
- Тесты генерации фокусов
- Тесты MCP resources/tools/prompts

### 2. Интеграционные тесты
- Полный воркфлоу: init -> setup -> implement-component
- Переход между инкрементами
- Генерация и кеширование фокусов
- Работа ask-memory-bank

### 3. Тестирование с реальным Memory Bank
- Создать тестовый Memory Bank
- Протестировать все команды CLI
- Проверить MCP сервер через Claude Code
- Валидация шаблонов и промптов

### 4. Отладка и оптимизация
- Профилирование производительности
- Оптимизация работы с большими файлами
- Улучшение error handling
- Логирование для отладки

### 5. Документация
- Обновить README с новыми командами
- Примеры использования
- Migration guide от старой версии
- Troubleshooting секция

## Критерии успеха
- Все тесты проходят
- MCP сервер корректно регистрируется в Claude Code
- Воркфлоу работает end-to-end
- Производительность приемлемая (фокус < 5 сек)

## Результат
- Стабильная, протестированная система
- Готовность к production использованию
- Полная документация

## Время: 6-8 часов