# Task 10: Очистка и миграция

## Описание
Финальная очистка кода от устаревших частей и подготовка миграционного пути для существующих пользователей.

## Что нужно сделать

### 1. Удаление устаревшего кода
- Старые модели (FeatureState с эпиками/задачами)
- Неиспользуемые функции в server.py
- Дублирующий код в mcp_server.py
- Старые команды CLI

### 2. Рефакторинг оставшегося кода
- Унификация naming conventions
- Улучшение структуры модулей
- Оптимизация импортов
- Type hints везде

### 3. Миграционный скрипт
```python
claude-helpers memory-bank migrate
```
- Конвертация старой структуры в новую
- Преобразование эпиков/задач в инкременты
- Обновление состояний
- Backup старых данных

### 4. Обратная совместимость
- Определить что можно сохранить
- Deprecation warnings для старых команд
- Graceful fallback где возможно

### 5. Версионирование
- Обновить версию в pyproject.toml
- Написать CHANGELOG
- Обновить зависимости

## Что сохранить
- Базовые конфигурации пользователей
- Существующие Memory Bank (с миграцией)

## Что удалить окончательно
- Все упоминания эпиков/задач в коде
- Старые шаблоны
- Неиспользуемые зависимости

## Результат
- Чистый, maintainable код
- Плавная миграция для пользователей
- Готовность к релизу

## Время: 3-4 часа