# План переработки claude-helpers для новой структуры Memory Bank

## Обзор
Переработка MCP-части утилиты `claude-helpers` для интеграции с новой структурой Memory Bank, основанной на инкрементах вместо эпиков/задач, с правильным использованием MCP Resources и Prompts.

## Ключевые изменения
1. **Инкременты вместо эпиков/задач** - атомарные единицы работы для итеративного воркфлоу
2. **MCP Resources** - для статичных данных (architecture, state, journal)
3. **MCP Prompts** - для команд воркфлоу (implement-component, ask)
4. **Claude Code SDK** - для генерации фокусов и интеллектуального поиска
5. **Упрощенная структура** - убраны лишние команды и сложность

## Последовательность выполнения

### Фаза 1: Подготовка (Tasks 1-2)
**Время: 10-12 часов**
- [Task 01](01-refactor-mcp-structure.md) - Рефакторинг структуры MCP серверов (4-5ч)
- [Task 02](02-implement-increments-logic.md) - Реализация логики инкрементов (6-7ч)

### Фаза 2: Core функциональность (Tasks 3-6)
**Время: 21-26 часов**
- [Task 03](03-implement-focus-generation.md) - Генерация фокусов для ролей (8-10ч)
- [Task 04](04-implement-mcp-resources.md) - Реализация MCP Resources (5-6ч)
- [Task 05](05-implement-mcp-prompts.md) - Реализация MCP Prompts (3-4ч)
- [Task 06](06-implement-ask-memory-bank.md) - Реализация ask-memory-bank (5-6ч)

### Фаза 3: Интеграция (Tasks 7-9)
**Время: 15-19 часов**
- [Task 07](07-update-cli-commands.md) - Обновление CLI команд (4-5ч)
- [Task 08](08-create-templates.md) - Создание и адаптация шаблонов (5-6ч)
- [Task 09](09-testing-integration.md) - Тестирование и интеграция (6-8ч)

### Фаза 4: Финализация (Task 10)
**Время: 3-4 часа**
- [Task 10](10-cleanup-migration.md) - Очистка и миграция (3-4ч)

## Общее время: 49-61 час

## Критические зависимости
- Task 1 блокирует все остальные (базовая структура)
- Task 2 блокирует Tasks 3-6 (инкременты нужны для фокусов)
- Tasks 7-8 можно делать параллельно после Task 2
- Task 9 требует завершения Tasks 1-8
- Task 10 - финальный этап после всех тестов

## Риски и митигация
1. **Claude Code SDK интеграция** - изучить документацию, тестировать на простых примерах
2. **Обратная совместимость** - создать миграционный скрипт
3. **Производительность с большими файлами** - использовать пагинацию
4. **Сложность тестирования MCP** - создать mock окружение

## Определение успеха
- ✅ Все MCP tools/resources/prompts работают в Claude Code
- ✅ Воркфлоу owner->PM->dev->tech-lead функционирует
- ✅ Генерация фокусов < 5 секунд
- ✅ Миграция существующих Memory Bank проходит без потерь
- ✅ Документация покрывает все use cases

## Примечания
- Следовать ТЗ из TZ-overview.md
- Использовать Kenoma как референс структуры
- Приоритет на упрощение и удаление лишней сложности
- Тестировать каждый этап перед переходом к следующему