# Критическая валидация плана переработки

## ✅ Соответствие ТЗ

### Структурные изменения
- ✅ Инкременты вместо эпиков/задач (Task 2)
- ✅ Новая структура папок increments/ (Task 2)
- ✅ initial-state.md + progress-state.md (Task 2)

### MCP архитектура
- ✅ MCP Resources для статичных данных (Task 4)
- ✅ MCP Prompts для команд (Task 5)
- ✅ MCP Tools только для активных операций (Tasks 1-3, 6)

### Воркфлоу
- ✅ owner -> PM -> dev -> tech-lead цикл (Task 3)
- ✅ Генерация фокусов для каждой роли (Task 3)
- ✅ implement-component промпт вместо /run (Task 5)

### Claude Code SDK
- ✅ Интеграция для генерации фокусов (Task 3)
- ✅ ask-memory-bank с AI анализом (Task 6)
- ✅ Генерация implementation overview (Task 2)

### CLI обновления
- ✅ spawn-templates вместо spawn-prompts (Task 7)
- ✅ Упрощенный init без слеш-команд (Task 7)
- ✅ Правильная структура spawn-structure (Task 7)

## ⚠️ Потенциальные проблемы

### 1. Сложность интеграции Claude Code SDK
**Риск**: Недостаточно документации, возможны проблемы с API
**Митигация**: 
- Выделить время на изучение в Task 3
- Создать fallback на hardcoded дистилляцию
- Тестировать на простых примерах первыми

### 2. Миграция существующих Memory Bank
**Риск**: Потеря данных при переходе от эпиков к инкрементам
**Митигация**:
- Task 10 включает миграционный скрипт
- Backup перед миграцией
- Возможность rollback

### 3. Производительность с большими файлами
**Риск**: Таймауты при генерации фокусов
**Митигация**:
- Пагинация уже предусмотрена
- Кеширование сгенерированных фокусов
- Оптимизация в Task 9

### 4. Обратная совместимость
**Риск**: Сломаем существующие интеграции
**Митигация**:
- Deprecation warnings в Task 10
- Семантическое версионирование
- Migration guide

## 📋 Чек-лист готовности

### Предварительные требования
- [x] Изучена структура Kenoma
- [x] Понятна работа MCP Resources/Prompts
- [x] Есть доступ к Claude Code SDK документации
- [x] Проанализирована текущая реализация

### План покрывает
- [x] Все новые MCP tools из ТЗ
- [x] Все MCP resources из ТЗ
- [x] Все MCP prompts из ТЗ
- [x] Обновление CLI команд
- [x] Создание шаблонов
- [x] Тестирование
- [x] Миграцию

## 🎯 Приоритеты

### Критически важное (must have)
1. Инкременты и новая структура (Task 2)
2. Базовые MCP tools для воркфлоу (Tasks 1, 3)
3. CLI команды для setup (Task 7)

### Важное (should have)
4. MCP Resources для данных (Task 4)
5. Генерация фокусов через SDK (Task 3)
6. Шаблоны (Task 8)

### Желательное (nice to have)
7. ask-memory-bank с AI (Task 6)
8. MCP Prompts (Task 5)
9. Полное тестирование (Task 9)

## 📊 Оценка времени

- **Минимальная**: 49 часов (если все идет по плану)
- **Реалистичная**: 55 часов (с учетом отладки)
- **Пессимистичная**: 61 час (с рисками и переделками)

## ✅ Вывод

План соответствует ТЗ и покрывает все требования. Основные риски идентифицированы и имеют митигацию. Последовательность задач логична и учитывает зависимости.

**Рекомендация**: Приступить к имплементации, начиная с Task 1 (рефакторинг MCP структуры).

## 🚀 Следующие шаги

1. Начать с Task 1 - создать чистую MCP структуру
2. После каждой задачи проводить валидацию результата
3. При блокерах - консультироваться по неясным моментам
4. Документировать все изменения и решения