from cmdbox.app import common, feature, mcp
from cmdbox.app.options import Options


class AgentBase(feature.ResultEdgeFeature):

    def get_option(self):
        """
        この機能のオプションを返します

        Returns:
            Dict[str, Any]: オプション
        """
        return dict(
            use_redis=self.USE_REDIS_FALSE, nouse_webmode=False, use_agent=True,
            description_ja="-",
            description_en="-",
            choice=[
                dict(opt="agent", type=Options.T_STR, default="no", required=False, multi=False, hide=False, choice=["no", "use"],
                     description_ja="エージェントを使用するかどうかを指定します。",
                     description_en="Specifies whether the agent is used.",
                     choice_show=dict(use=["agent_name", "agent_description", "agent_instruction", "agent_session_store", "llmprov",],)),
                dict(opt="agent_name", type=Options.T_STR, default=self.ver.__appid__, required=False, multi=False, hide=False, choice=None,
                     description_ja="エージェント名を指定します。",
                     description_en="Specifies the agent name."),
                dict(opt="agent_description", type=Options.T_STR, default=None, required=False, multi=False, hide=False, choice=None,
                     description_ja="エージェントの説明を指定します。",
                     description_en="Specify agent description."),
                dict(opt="agent_instruction", type=Options.T_TEXT, default=None, required=False, multi=False, hide=False, choice=None,
                     description_ja="エージェントのシステム指示を指定します。",
                     description_en="Specifies the agent's system instructions."),
                dict(opt="agent_session_store", type=Options.T_STR, default=None, required=False, multi=False, hide=False, choice=['memory', 'sqlite', 'postgresql'],
                     description_ja="エージェントのセッションを保存する方法を指定します。",
                     description_en="Specify how the agent's session is to be saved.",
                     choice_show=dict(postgresql=["agent_pg_host", "agent_pg_port", "agent_pg_user", "agent_pg_password", "agent_pg_dbname"]),),
                dict(opt="agent_pg_host", type=Options.T_STR, default='localhost', required=False, multi=False, hide=False, choice=None, web="mask",
                     description_ja="postgresqlホストを指定する。",
                     description_en="Specify the postgresql host."),
                dict(opt="agent_pg_port", type=Options.T_INT, default=5432, required=False, multi=False, hide=False, choice=None, web="mask",
                     description_ja="postgresqlのポートを指定する。",
                     description_en="Specify the postgresql port."),
                dict(opt="agent_pg_user", type=Options.T_STR, default='postgres', required=False, multi=False, hide=False, choice=None, web="mask",
                     description_ja="postgresqlのユーザー名を指定する。",
                     description_en="Specify the postgresql user name."),
                dict(opt="agent_pg_password", type=Options.T_STR, default='postgres', required=False, multi=False, hide=False, choice=None, web="mask",
                     description_ja="postgresqlのパスワードを指定する。",
                     description_en="Specify the postgresql password."),
                dict(opt="agent_pg_dbname", type=Options.T_STR, default='agent', required=False, multi=False, hide=False, choice=None,
                     description_ja="postgresqlデータベース名を指定します。",
                     description_en="Specify the postgresql database name."),
                dict(opt="llmprov", type=Options.T_STR, default=None, required=False, multi=False, hide=False,
                     choice=["", "azureopenai", "openai", "vertexai", "ollama"],
                     description_ja="llmのプロバイダを指定します。",
                     description_en="Specify llm provider.",
                     choice_show=dict(azureopenai=["llmapikey", "llmendpoint", "llmmodel", "llmapiversion"],
                                      openai=["llmapikey", "llmendpoint", "llmmodel"],
                                      vertexai=["llmprojectid", "llmsvaccountfile", "llmlocation", "llmmodel", "llmseed", "llmtemperature"],
                                      ollama=["llmendpoint", "llmmodel", "llmtemperature"],),
                     ),
                dict(opt="llmprojectid", type=Options.T_STR, default=None, required=False, multi=False, hide=False, choice=None,
                     description_ja="llmのプロバイダ接続のためのプロジェクトIDを指定します。",
                     description_en="Specify the project ID for llm's provider connection."),
                dict(opt="llmsvaccountfile", type=Options.T_FILE, default=None, required=False, multi=False, hide=False, choice=None,
                     description_ja="llmのプロバイダ接続のためのサービスアカウントファイルを指定します。",
                     description_en="Specifies the service account file for llm's provider connection."),
                dict(opt="llmlocation", type=Options.T_STR, default=None, required=False, multi=False, hide=False, choice=None,
                     description_ja="llmのプロバイダ接続のためのロケーションを指定します。",
                     description_en="Specifies the location for llm provider connections."),
                dict(opt="llmapikey", type=Options.T_STR, default=None, required=False, multi=False, hide=False, choice=None,
                     description_ja="llmのプロバイダ接続のためのAPIキーを指定します。",
                     description_en="Specify API key for llm provider connection."),
                dict(opt="llmapiversion", type=Options.T_STR, default=None, required=False, multi=False, hide=False, choice=None,
                     description_ja="llmのプロバイダ接続のためのAPIバージョンを指定します。",
                     description_en="Specifies the API version for llm provider connections."),
                dict(opt="llmendpoint", type=Options.T_STR, default=None, required=False, multi=False, hide=False, choice=None,
                     description_ja="llmのプロバイダ接続のためのエンドポイントを指定します。",
                     description_en="Specifies the endpoint for llm provider connections."),
                dict(opt="llmmodel", type=Options.T_STR, default="text-multilingual-embedding-002", required=False, multi=False, hide=False, choice=None,
                     description_ja="llmモデルを指定します。",
                     description_en="Specifies the llm model."),
                dict(opt="llmseed", type=Options.T_INT, default=13, required=False, multi=False, hide=False, choice=None,
                     description_ja="llmモデルを使用するときのシード値を指定します。",
                     description_en="Specifies the seed value when using llm model."),
                dict(opt="llmtemperature", type=Options.T_FLOAT, default=0.1, required=False, multi=False, hide=False, choice=None,
                     description_ja="llmのモデルを使用するときのtemperatureを指定します。",
                     description_en="Specifies the temperature when using llm model."),
            ])
