import os

from teleporter.core import Int
from teleporter.desktop import FileWriteDescriptor, create_local_key

LOCAL_ENCRYPT_SALT_SIZE = 32
AUTH_KEY_SIZE = 256

def generate_local_key(
    performance_mode: bool,
    passcode: bytes
) -> tuple[bytes, NotImplemented, bytes, NotImplemented]:
    if performance_mode and not passcode:
        local_key = (
            b'\xd8\x74\x59\x44\x51\x9e\x0d\x2d\x71\x30\x9d\x6c\x8d\x27\x2d\xc6\x49\x48\xf5\xe3\xeb\xa7\x68\x53\x24\xd5\xc6\x91\xad\x81\x0c\x20'
            b'\x3b\x31\xd1\x9d\x29\xae\xd6\xac\x33\xc0\x14\xbe\x6e\x09\x84\x32\x93\xf6\xfa\x32\xdb\xe4\x2b\x6a\x04\xe0\x04\x81\xfa\xe9\x95\x11'
            b'\x4c\xaf\x63\x42\xbd\x98\xe9\x6d\x29\x3d\xd0\x62\xc4\x58\x68\x9b\x3a\xbd\x23\xa5\xcf\x23\x0c\x75\x52\x7c\x05\xbf\x5f\x90\xf3\x8c'
            b'\xd9\x39\x52\xcf\x61\xaa\xac\x1c\xfe\xaa\xe4\x60\x85\x92\xe3\x63\xde\xd3\x5f\x8d\x8c\x45\x23\x4d\xef\x53\x23\x1d\xec\xb3\x55\x92'
            b'\xaf\xc4\x0d\x06\x01\xbb\xed\x11\x09\x09\x69\xf7\x4d\x9a\xb0\xcc\x97\x82\x75\x46\xf4\x41\x24\x2d\x2c\xfb\x8e\x05\xa0\x61\x0e\x97'
            b'\x66\x9c\x0d\xa1\xad\xcc\xb5\x6e\x39\xe1\x0c\x69\xe2\x94\x23\x87\xff\x49\x22\xf8\xc5\x5d\xcb\x88\x90\xe3\x45\xef\x31\x82\x66\xf4'
            b'\xb3\x83\x14\x30\xea\x21\x0c\x86\x3c\x17\x62\x4c\x04\x94\xcd\xea\xd8\x1f\x52\x34\x30\xb5\xf7\x4c\x15\xda\x32\x3d\x76\x6b\xd0\x1c'
            b'\xb5\xb8\x8b\x9d\x2a\x73\x1f\x6d\x85\x33\x80\xad\x30\x6a\x86\x47\xfa\x61\x4c\xc4\x01\x7f\x08\x90\x2c\x1e\x1f\x99\x7e\xe1\x2e\x3c'
        )
        passcode_key_salt = b'\xae\xd1\xe0\x82\x99\x42\x81\xd9\x75\x76\x0e\x72\x95\x60\xd2\xc8\xd0\x08\xf2\xa9\xdd\x3f\xf4\xd8\x32\x45\xe2\x2e\xed\xb6\x67\x16'
        passcode_key = (
            b'\x27\x3e\x64\x83\xb3\x13\xc9\xdb\xc4\xac\xd9\x17\x38\x64\xc0\x42\x2f\x17\x28\x81\xbf\xe1\xc6\x64\x9c\xa5\x53\x86\x54\xd0\xbd\x6e'
            b'\xbc\xfb\xcc\x8d\xab\xbb\x66\x97\x17\xce\x53\xb4\x1c\xa8\xaf\xbf\x9d\x15\xc2\x3f\xa2\xb0\x6a\x6e\x16\x6c\xc6\x1f\x62\xe9\x98\x05'
            b'\x58\xcd\x42\xcf\x10\x22\xe0\x5b\x46\x68\x11\xea\x29\xe9\x35\x9f\xc1\xf9\x46\x68\xe5\xc8\x51\x55\xbc\xe6\x38\xfe\x7a\xa4\x2a\xa8'
            b'\x80\xca\x83\xe0\xd2\xe5\x34\x19\x8a\x0a\x89\x01\x39\xc8\xf6\x79\xa5\x7d\x3b\xa0\x6d\x75\xfe\x5f\xaa\x6e\x25\x01\x01\xa5\x8b\xc6'
            b'\xe4\x2b\x96\x96\x60\x4d\xe1\xe3\x4a\xe4\x0f\x6b\xba\x14\x4a\x28\x4f\x3a\xd8\x84\x32\x53\xec\x9b\x39\x71\x86\x3a\x2c\x40\x92\x08'
            b'\xc2\x56\x39\x67\xb3\x58\x7e\x50\x9b\x42\xa4\x2a\x60\x40\xd2\x3f\xf6\x96\xad\x55\x2a\x24\x00\x84\xfa\x3f\x95\x02\x40\xf4\x99\xb2'
            b'\x3c\xd6\xd2\x7e\x70\x10\xcb\xde\x07\xda\xae\x06\x67\xa7\xdf\x8a\x51\x15\xa6\x0b\x26\x5c\x58\xf5\xd9\x29\x1f\x7a\x98\xfc\x3c\x60'
            b'\x1e\x2a\x4a\x32\xf1\x88\x1b\x82\x18\xc8\x55\x23\x9d\x7b\x53\x29\x59\x60\x9e\x6a\xb5\x2e\x48\xad\x69\x1c\x25\x83\xb5\x66\xc8\xf9'
        )
        passcode_key_encrypted = (
            b'\x97\xdf\x0c\xd2\xe3\x10\x91\x49\xb7\x7b\x52\x87\x99\x4d\x9c\x1c\xa2\x40\xc5\x1e\x87\x48\x8e\x79'
            b'\xdd\x02\x9b\xea\x65\xfb\x9d\x27\x89\xbb\x5a\xbc\xfe\x65\xe8\x71\xd7\x52\xbd\x93\x8d\x83\x31\x3c'
            b'\x79\x4c\x89\x93\xa7\x34\xce\x12\x16\xf2\xe6\x60\x47\x3f\x31\x43\xaf\x9a\x33\x36\x10\xa1\x79\x95'
            b'\x87\x6e\x17\x21\xce\x1f\x61\x1d\x1c\x69\xd8\xc1\xa2\xf5\x9f\x94\x93\x11\x97\x04\x27\x4e\x2c\xb5'
            b'\xf3\x6c\x20\xdf\x43\x9d\x15\x6d\xef\xf7\xa3\x43\x71\xdc\x44\xbc\x86\xf8\x73\x0c\xeb\xf9\xb0\x28'
            b'\xeb\x7a\x1e\xd6\x62\x1d\x99\xad\xb6\x2b\x3b\x2c\xf2\x29\x5d\xbb\xb2\x4b\xf1\x32\xd3\x7f\xff\xc1'
            b'\x7a\x0b\xdc\xcc\x84\xbb\xea\x6e\xa3\x47\x37\xa2\x36\xb5\x82\x48\xa7\xab\x4c\x14\x36\x3c\x20\x54'
            b'\x1c\xb4\x53\x38\x67\x7f\x33\x97\x82\xb2\x05\xe3\x55\x18\x96\x58\xdd\x45\xea\x3e\x80\x05\xf8\x51'
            b'\x14\x8e\x7e\x15\xf4\x31\x90\x4f\xa7\x9c\x68\x27\xee\x42\x6d\x3a\xb9\xcb\xa9\x36\xeb\x33\xd4\x85'
            b'\xdb\x88\xa6\xf0\xff\x97\x22\xa6\xd6\x2f\xf7\x88\x34\x7e\x27\xc8\x2e\x9e\x13\x9e\xb0\x3a\xe5\x21'
            b'\x53\x9b\xf3\xd3\x63\xb4\xba\xea\x76\xe5\xe8\x84\xcf\x66\xfe\x6b\xcd\x8a\x9e\x08\x9d\x36\x40\x5d'
            b'\xb9\x9d\x01\xdb\x20\x46\x4f\xb6\xca\xbb\xdc\xe4\xf6\x7e\x4e\xc3\x74\x2f\x91\x3a\x1d\xd2\xda\xc5'
        )
    else:
        passcode_key_salt = os.urandom(LOCAL_ENCRYPT_SALT_SIZE)
        passcode_key = create_local_key(passcode_key_salt, passcode)

        passcode_ = os.urandom(AUTH_KEY_SIZE)
        salt = os.urandom(LOCAL_ENCRYPT_SALT_SIZE)
        local_key = create_local_key(salt, passcode_)

        passcode_key_encrypted = FileWriteDescriptor()
        passcode_key_encrypted.encrypted(local_key, passcode_key)
        passcode_key_encrypted = passcode_key_encrypted.buffer.getvalue()[Int.SIZE:]

    assert len(passcode_key_encrypted) == LOCAL_ENCRYPT_SALT_SIZE + AUTH_KEY_SIZE
    return local_key, passcode_key_salt, passcode_key, passcode_key_encrypted
