# coding:utf-8
import sys
from tools_hjh import DBConn, HTTPTools
from tools_hjh import Log
from tools_hjh import ThreadPool
from tools_hjh import Tools
from bs4 import BeautifulSoup
from tools_hjh import ChromePool
import os

date = Tools.locatdate()
log = Log('U:/MyFiles/MyPy/log/woqukan/' + date + '.log')

host = 'http://www.woqukan.com'

chrome_path = r'U:\MyApps\CentBrowser\App\chrome.exe'
chromedriver_path = r'U:\MyApps\CentBrowser\chromedriver.exe'

try:
    sys_argv_1 = sys.argv[1]
except:
    sys_argv_1 = 'download'
try:
    sys_argv_2 = sys.argv[2]
except:
    sys_argv_2 = None
try:
    sys_argv_3 = sys.argv[3]
except:
    sys_argv_3 = 2
    

def main(): 
    db = DBConn('sqlite', db='U:/MyFiles/MyPy/data/woqukan.db')
    if sys_argv_1 == 'download':
        m_urls = None
        createDatabase(db, rebuild=False)
        chrome = ChromePool(sys_argv_3, chrome_path, chromedriver_path, is_display_picture=False, is_hidden=False)
        m_urls = get_main(HTTPTools, '/category/dongman.html', page_num='')  # page_num = '' 为最大值
        get_e(db, chrome, HTTPTools, m_urls=m_urls)
        print_need_download_url(db)
    else:
        rename(db, path=r'U:\Li')

    
def createDatabase(db, rebuild=False):
    if rebuild:
        db.run('drop table if exists t_m')
    
    # m_title,e_title 共同唯一
    # d_url相同，标题不同：d_url对应的m_title,e_title由最新的update_time决定
    # 标题相同，d_rul不同：大概率存在一个d_url过期失效，如果两个都有效，都下载，取名时候由于有源文件名后缀，不会冲突
    t_m = '''
        create table if not exists t_m(
            m_url text, 
            m_title text,
            e_url text,
            e_title text,
            d_url text,
            d_old_title text,
            d_new_title text,
            d_status text,
            c_主演 text,
            c_导演 text,
            c_类型 text,
            c_地区 text,
            c_年份 text,
            c_简介 text,
            update_time text
        )
    '''

    db.run(t_m)


# 循环主页，获取节目url列表返回
def get_main(request, firstPageUrl, page_num=''):
    
    def get_main_one(idx):
        if idx > 1:
            pageurl = host + firstPageUrl.replace('dongman.html', 'dongman_' + str(idx) + '.html')
        else:
            pageurl = host + firstPageUrl
        m_url = ''
        
        try:
            page = request.get(pageurl)
            bs = BeautifulSoup(page, features="lxml")
            lis = bs.find_all('li', class_='col-md-6 col-sm-4 col-xs-3')
            for li in lis:
                try:
                    m_url = li.find('a', class_='stui-vodlist__thumb lazyload')['href'].strip()
                    urls.append(m_url)
                except Exception as _:
                    print(_)
            
            log.info('get_main_one', str(idx), len(urls))
        except Exception as _:
            log.error('get_main_one', str(idx), len(urls), _)
            pass
    
    tp = ThreadPool(16)
    urls = []
    if page_num is None or len(page_num) == 0 or page_num == '':
        pageurl = host + firstPageUrl
        page = request.get(pageurl)
        bs = BeautifulSoup(page, features="lxml")
        href = bs.find('ul', class_='stui-page text-center cleafix').find_all('li')[-1].find('a')['href']
        page_num = int(href.split('_')[1].split('.html')[0])
    for idx in range(1, int(page_num) + 1):
        tp.run(get_main_one, (idx,))
    tp.wait()
    urls.sort(reverse=True)
    return urls

    
# 根据url，获取节目信息，如果是MP4类型的，获取每集下载链接，整体入库
def get_e(db, chrome, request, m_urls):

    def get_e_one(m_url, db, times=1):
        try:
            params = []
            status_code = request.get_status_code(host + m_url)
            page = request.get(host + m_url)
            # Tools.echo(page, 'test.txt', 'w')
            bs = BeautifulSoup(page, features="lxml")
            m_title = bs.find('div', class_='stui-content__detail').find('h1', class_='title').text.strip()
            c_主演 = bs.find('div', class_='stui-content__detail').find_all('p', class_='data')[0].text.replace('主演：', '').strip()
            c_导演 = bs.find('div', class_='stui-content__detail').find_all('p', class_='data')[1].text.replace('导演：', '').strip()
            if '/' in c_导演:
                c_导演 = c_导演.split('/')[0]
            c_类型 = bs.find('div', class_='stui-content__detail').find_all('p', class_='data')[2].find_all('a')[0].text.strip()
            c_地区 = bs.find('div', class_='stui-content__detail').find_all('p', class_='data')[2].find_all('a')[1].text.strip()
            c_年份 = bs.find('div', class_='stui-content__detail').find_all('p', class_='data')[2].find_all('a')[2].text.strip()
            c_简介 = bs.find('div', class_='stui-content__detail').find('p', class_='desc detail hidden-xs').find('span', class_='detail-content').text.strip()
            
            divs = bs.find_all('div', class_='stui-pannel stui-pannel-bg clearfix', id='playlist')
            for div in divs:
                m_type = div.find('h3', class_='title').text
                if m_type == 'MP4' or m_type == '云视频':
                    m_type = m_type.replace('云点播', 'm3u8').replace('MP4', 'mp4').replace('云视频', 'mp4')
                    lis = div.find('ul', class_='stui-content__playlist').find_all('li')
                    for li in lis:
                        e_title = li.find('a').text
                        e_url = li.find('a')['href']
                        if m_type == 'mp4':
                            # 根据标题去库里面查找是否存在一个下载地址，如果存在视为已拥有，不再处理
                            sql = "select count(1) from t_m t where t.m_title = ? and t.e_title = ?"
                            rs = int(db.run(sql, (m_title, e_title)).get_rows()[0][0])
                            if rs == 0:
                                d_url = get_download_url(e_url, chrome)
                                update_time = Tools.locatdate()
                                if d_url.endswith('.mp4'):
                                    d_old_title = d_url.split('/')[-1]
                                    d_new_title = m_title + '-' + e_title + '[' + c_导演 + ']' + '[' + c_年份 + '][' + d_old_title.replace('.mp4', '') + '].mp4'
                                    d_new_title = d_new_title.replace('/', ' ').replace('\\', ' ').replace(':', '：').replace('*', '·').replace('?', '？').replace('"', '\'').replace('<', '[').replace('>', ']').replace('|', ' ')
                                    d_new_title = d_new_title.replace('&amp;amp;', ' ')
                                    d_new_title = Tools.merge_spaces(d_new_title)
                                else:
                                    d_old_title = None
                                    d_new_title = None
                                d_status = '0'
                                param = (m_url, m_title, e_url, e_title, d_url, d_old_title, d_new_title, d_status, c_主演, c_导演, c_类型, c_地区, c_年份, c_简介, update_time, m_title, e_title, d_url)
                                params.append(param)
                
            insert_sql = '''
                insert into t_m(m_url,m_title,e_url,e_title,d_url,d_old_title,d_new_title,d_status,c_主演,c_导演,c_类型,c_地区,c_年份,c_简介,update_time)
                select ?,?,?,?,?,?,?,?,?,?,?,?,?,?,? where not exists(select 1 from t_m where m_title = ? and e_title = ? and d_url = ?)
            '''
            num = db.run(insert_sql, params, wait=True)
            m_urls.remove(m_url)
            log.info('get_e_one', m_url, num, len(params), len(m_urls), times)
        except Exception as _:
            if times <= 5:
                times = times + 1
                get_e_one(m_url, db, times)
            else:
                m_urls.remove(m_url)
                log.error('get_e_one', m_url, status_code, times, str(_))

    tp = ThreadPool(16)
    if m_urls is not None:
        for m_url in m_urls.copy():
            tp.run(get_e_one, (m_url, db))
                        
    # 如果没有urls传入，视为更新数据库已有节目信息
    else:
        m_urls = db.run("select distinct m_url from t_m order by cast(replace(replace(m_url,'/show/',''),'.html','') as integer) desc").get_rows()
        for m_url in m_urls:
            tp.run(get_e_one, (m_url[0], db))
    tp.wait()


def get_download_url(url, chrome):
    page = chrome.get(host + url)
    bs = BeautifulSoup(page, features="lxml")
    # Tools.echo(page, 'tmp.txt', 'w')
    script_ = bs.find('div', class_='stui-player__iframe').find('script')
    download_url = str(script_).split(';var now="')[1].split('";')[0]
    return download_url


def print_need_download_url(db):
    
    sql = '''
        select t.d_url from t_m t 
        where t.d_status = '0'
        and t.d_url like 'https://s1.xiahi.com/dm/%.mp4'
        
    '''
    try:
        rss = db.run(sql).get_rows()
        for rs in rss:
            print(rs[0])
    except:
        pass


def rename(db, path='U:/Li'):
    for file in os.listdir(path):
        try:
            old_path = path + '/' + file
            if file.endswith('].mp4'):
                d_name = file.split('][')[-1].replace(']', '')
            else:
                d_name = file
            sql = 'select d_new_title from t_m where d_old_title = ? order by update_time desc' 
            new_name = db.run(sql, (d_name,)).get_rows()[0][0]
            new_path = path + '/' + new_name
            os.rename(old_path, new_path)
            db.run("update t_m set d_status = '1' where d_old_title = ? and d_new_title = ?", (d_name, new_name))
            print('ok ' + file + ' -> ' + new_name)
        except Exception as _:
            pass


if __name__ == '__main__':
    main()
    
