# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

import types

__config__ = pulumi.Config('azuredevops')


class _ExportableConfig(types.ModuleType):
    @_builtins.property
    def auxiliary_tenant_ids(self) -> Optional[str]:
        """
        List of auxiliary Tenant IDs required for multi-tenancy and cross-tenant scenarios.
        """
        return __config__.get('auxiliaryTenantIds')

    @_builtins.property
    def client_certificate(self) -> Optional[str]:
        """
        Base64 encoded certificate to use to authenticate to the service principal.
        """
        return __config__.get('clientCertificate')

    @_builtins.property
    def client_certificate_password(self) -> Optional[str]:
        """
        Password for a client certificate password.
        """
        return __config__.get('clientCertificatePassword')

    @_builtins.property
    def client_certificate_path(self) -> Optional[str]:
        """
        Path to a certificate to use to authenticate to the service principal.
        """
        return __config__.get('clientCertificatePath')

    @_builtins.property
    def client_id(self) -> Optional[str]:
        """
        The service principal client id which should be used for AAD auth.
        """
        return __config__.get('clientId')

    @_builtins.property
    def client_id_file_path(self) -> Optional[str]:
        """
        The path to a file containing the Client ID which should be used.
        """
        return __config__.get('clientIdFilePath')

    @_builtins.property
    def client_secret(self) -> Optional[str]:
        """
        Client secret for authenticating to  a service principal.
        """
        return __config__.get('clientSecret')

    @_builtins.property
    def client_secret_path(self) -> Optional[str]:
        """
        Path to a file containing a client secret for authenticating to  a service principal.
        """
        return __config__.get('clientSecretPath')

    @_builtins.property
    def oidc_azure_service_connection_id(self) -> Optional[str]:
        """
        The Azure Pipelines Service Connection ID to use for authentication.
        """
        return __config__.get('oidcAzureServiceConnectionId')

    @_builtins.property
    def oidc_request_token(self) -> Optional[str]:
        """
        The bearer token for the request to the OIDC provider. For use when authenticating as a Service Principal using OpenID Connect.
        """
        return __config__.get('oidcRequestToken')

    @_builtins.property
    def oidc_request_url(self) -> Optional[str]:
        """
        The URL for the OIDC provider from which to request an ID token. For use when authenticating as a Service Principal using OpenID Connect.
        """
        return __config__.get('oidcRequestUrl')

    @_builtins.property
    def oidc_token(self) -> Optional[str]:
        """
        OIDC token to authenticate as a service principal.
        """
        return __config__.get('oidcToken')

    @_builtins.property
    def oidc_token_file_path(self) -> Optional[str]:
        """
        OIDC token from file to authenticate as a service principal.
        """
        return __config__.get('oidcTokenFilePath')

    @_builtins.property
    def org_service_url(self) -> Optional[str]:
        """
        The url of the Azure DevOps instance which should be used.
        """
        return __config__.get('orgServiceUrl') or _utilities.get_env('AZDO_ORG_SERVICE_URL')

    @_builtins.property
    def personal_access_token(self) -> Optional[str]:
        """
        The personal access token which should be used.
        """
        return __config__.get('personalAccessToken')

    @_builtins.property
    def tenant_id(self) -> Optional[str]:
        """
        The service principal tenant id which should be used for AAD auth.
        """
        return __config__.get('tenantId')

    @_builtins.property
    def use_cli(self) -> Optional[bool]:
        """
        Use Azure CLI to authenticate. Defaults to `true`.
        """
        return __config__.get_bool('useCli')

    @_builtins.property
    def use_msi(self) -> Optional[bool]:
        """
        Use an Azure Managed Service Identity. Defaults to `false`.
        """
        return __config__.get_bool('useMsi')

    @_builtins.property
    def use_oidc(self) -> Optional[bool]:
        """
        Use an OIDC token to authenticate to a service principal. Defaults to `false`.
        """
        return __config__.get_bool('useOidc')

