# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetDescriptorResult',
    'AwaitableGetDescriptorResult',
    'get_descriptor',
    'get_descriptor_output',
]

@pulumi.output_type
class GetDescriptorResult:
    """
    A collection of values returned by getDescriptor.
    """
    def __init__(__self__, descriptor=None, id=None, storage_key=None):
        if descriptor and not isinstance(descriptor, str):
            raise TypeError("Expected argument 'descriptor' to be a str")
        pulumi.set(__self__, "descriptor", descriptor)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if storage_key and not isinstance(storage_key, str):
            raise TypeError("Expected argument 'storage_key' to be a str")
        pulumi.set(__self__, "storage_key", storage_key)

    @_builtins.property
    @pulumi.getter
    def descriptor(self) -> _builtins.str:
        """
        The descriptor of the storage key.
        """
        return pulumi.get(self, "descriptor")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="storageKey")
    def storage_key(self) -> _builtins.str:
        return pulumi.get(self, "storage_key")


class AwaitableGetDescriptorResult(GetDescriptorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDescriptorResult(
            descriptor=self.descriptor,
            id=self.id,
            storage_key=self.storage_key)


def get_descriptor(storage_key: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDescriptorResult:
    """
    Use this data source to access information about an existing Descriptor.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_descriptor(storage_key="00000000-0000-0000-0000-000000000000")
    pulumi.export("id", example.id)
    ```

    ## Relevant Links

    - [Azure DevOps Service REST API 7.1 - Descriptors - Get](https://learn.microsoft.com/en-us/rest/api/azure/devops/graph/descriptors/get?view=azure-devops-rest-7.1)


    :param _builtins.str storage_key: The ID of the resource(`user`, `group`, `scope`, etc.) that will be resolved to a descriptor.
    """
    __args__ = dict()
    __args__['storageKey'] = storage_key
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azuredevops:index/getDescriptor:getDescriptor', __args__, opts=opts, typ=GetDescriptorResult).value

    return AwaitableGetDescriptorResult(
        descriptor=pulumi.get(__ret__, 'descriptor'),
        id=pulumi.get(__ret__, 'id'),
        storage_key=pulumi.get(__ret__, 'storage_key'))
def get_descriptor_output(storage_key: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDescriptorResult]:
    """
    Use this data source to access information about an existing Descriptor.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_descriptor(storage_key="00000000-0000-0000-0000-000000000000")
    pulumi.export("id", example.id)
    ```

    ## Relevant Links

    - [Azure DevOps Service REST API 7.1 - Descriptors - Get](https://learn.microsoft.com/en-us/rest/api/azure/devops/graph/descriptors/get?view=azure-devops-rest-7.1)


    :param _builtins.str storage_key: The ID of the resource(`user`, `group`, `scope`, etc.) that will be resolved to a descriptor.
    """
    __args__ = dict()
    __args__['storageKey'] = storage_key
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azuredevops:index/getDescriptor:getDescriptor', __args__, opts=opts, typ=GetDescriptorResult)
    return __ret__.apply(lambda __response__: GetDescriptorResult(
        descriptor=pulumi.get(__response__, 'descriptor'),
        id=pulumi.get(__response__, 'id'),
        storage_key=pulumi.get(__response__, 'storage_key')))
