# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 auxiliary_tenant_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_password: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_path: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id_file_path: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret_path: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_azure_service_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_request_token: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_request_url: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_token: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_token_file_path: Optional[pulumi.Input[_builtins.str]] = None,
                 org_service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 personal_access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 use_cli: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_msi: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_oidc: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] auxiliary_tenant_ids: List of auxiliary Tenant IDs required for multi-tenancy and cross-tenant scenarios.
        :param pulumi.Input[_builtins.str] client_certificate: Base64 encoded certificate to use to authenticate to the service principal.
        :param pulumi.Input[_builtins.str] client_certificate_password: Password for a client certificate password.
        :param pulumi.Input[_builtins.str] client_certificate_path: Path to a certificate to use to authenticate to the service principal.
        :param pulumi.Input[_builtins.str] client_id: The service principal client id which should be used for AAD auth.
        :param pulumi.Input[_builtins.str] client_id_file_path: The path to a file containing the Client ID which should be used.
        :param pulumi.Input[_builtins.str] client_secret: Client secret for authenticating to  a service principal.
        :param pulumi.Input[_builtins.str] client_secret_path: Path to a file containing a client secret for authenticating to  a service principal.
        :param pulumi.Input[_builtins.str] oidc_azure_service_connection_id: The Azure Pipelines Service Connection ID to use for authentication.
        :param pulumi.Input[_builtins.str] oidc_request_token: The bearer token for the request to the OIDC provider. For use when authenticating as a Service Principal using OpenID Connect.
        :param pulumi.Input[_builtins.str] oidc_request_url: The URL for the OIDC provider from which to request an ID token. For use when authenticating as a Service Principal using OpenID Connect.
        :param pulumi.Input[_builtins.str] oidc_token: OIDC token to authenticate as a service principal.
        :param pulumi.Input[_builtins.str] oidc_token_file_path: OIDC token from file to authenticate as a service principal.
        :param pulumi.Input[_builtins.str] org_service_url: The url of the Azure DevOps instance which should be used.
        :param pulumi.Input[_builtins.str] personal_access_token: The personal access token which should be used.
        :param pulumi.Input[_builtins.str] tenant_id: The service principal tenant id which should be used for AAD auth.
        :param pulumi.Input[_builtins.bool] use_cli: Use Azure CLI to authenticate. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] use_msi: Use an Azure Managed Service Identity. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] use_oidc: Use an OIDC token to authenticate to a service principal. Defaults to `false`.
        """
        if auxiliary_tenant_ids is not None:
            pulumi.set(__self__, "auxiliary_tenant_ids", auxiliary_tenant_ids)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_certificate_password is not None:
            pulumi.set(__self__, "client_certificate_password", client_certificate_password)
        if client_certificate_path is not None:
            pulumi.set(__self__, "client_certificate_path", client_certificate_path)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_id_file_path is not None:
            pulumi.set(__self__, "client_id_file_path", client_id_file_path)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if client_secret_path is not None:
            pulumi.set(__self__, "client_secret_path", client_secret_path)
        if oidc_azure_service_connection_id is not None:
            pulumi.set(__self__, "oidc_azure_service_connection_id", oidc_azure_service_connection_id)
        if oidc_request_token is not None:
            pulumi.set(__self__, "oidc_request_token", oidc_request_token)
        if oidc_request_url is not None:
            pulumi.set(__self__, "oidc_request_url", oidc_request_url)
        if oidc_token is not None:
            pulumi.set(__self__, "oidc_token", oidc_token)
        if oidc_token_file_path is not None:
            pulumi.set(__self__, "oidc_token_file_path", oidc_token_file_path)
        if org_service_url is None:
            org_service_url = _utilities.get_env('AZDO_ORG_SERVICE_URL')
        if org_service_url is not None:
            pulumi.set(__self__, "org_service_url", org_service_url)
        if personal_access_token is not None:
            pulumi.set(__self__, "personal_access_token", personal_access_token)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_cli is not None:
            pulumi.set(__self__, "use_cli", use_cli)
        if use_msi is not None:
            pulumi.set(__self__, "use_msi", use_msi)
        if use_oidc is not None:
            pulumi.set(__self__, "use_oidc", use_oidc)

    @_builtins.property
    @pulumi.getter(name="auxiliaryTenantIds")
    def auxiliary_tenant_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of auxiliary Tenant IDs required for multi-tenancy and cross-tenant scenarios.
        """
        return pulumi.get(self, "auxiliary_tenant_ids")

    @auxiliary_tenant_ids.setter
    def auxiliary_tenant_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "auxiliary_tenant_ids", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64 encoded certificate to use to authenticate to the service principal.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificatePassword")
    def client_certificate_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for a client certificate password.
        """
        return pulumi.get(self, "client_certificate_password")

    @client_certificate_password.setter
    def client_certificate_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate_password", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificatePath")
    def client_certificate_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to a certificate to use to authenticate to the service principal.
        """
        return pulumi.get(self, "client_certificate_path")

    @client_certificate_path.setter
    def client_certificate_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate_path", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service principal client id which should be used for AAD auth.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientIdFilePath")
    def client_id_file_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to a file containing the Client ID which should be used.
        """
        return pulumi.get(self, "client_id_file_path")

    @client_id_file_path.setter
    def client_id_file_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id_file_path", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client secret for authenticating to  a service principal.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="clientSecretPath")
    def client_secret_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to a file containing a client secret for authenticating to  a service principal.
        """
        return pulumi.get(self, "client_secret_path")

    @client_secret_path.setter
    def client_secret_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret_path", value)

    @_builtins.property
    @pulumi.getter(name="oidcAzureServiceConnectionId")
    def oidc_azure_service_connection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Pipelines Service Connection ID to use for authentication.
        """
        return pulumi.get(self, "oidc_azure_service_connection_id")

    @oidc_azure_service_connection_id.setter
    def oidc_azure_service_connection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oidc_azure_service_connection_id", value)

    @_builtins.property
    @pulumi.getter(name="oidcRequestToken")
    def oidc_request_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bearer token for the request to the OIDC provider. For use when authenticating as a Service Principal using OpenID Connect.
        """
        return pulumi.get(self, "oidc_request_token")

    @oidc_request_token.setter
    def oidc_request_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oidc_request_token", value)

    @_builtins.property
    @pulumi.getter(name="oidcRequestUrl")
    def oidc_request_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL for the OIDC provider from which to request an ID token. For use when authenticating as a Service Principal using OpenID Connect.
        """
        return pulumi.get(self, "oidc_request_url")

    @oidc_request_url.setter
    def oidc_request_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oidc_request_url", value)

    @_builtins.property
    @pulumi.getter(name="oidcToken")
    def oidc_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OIDC token to authenticate as a service principal.
        """
        return pulumi.get(self, "oidc_token")

    @oidc_token.setter
    def oidc_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oidc_token", value)

    @_builtins.property
    @pulumi.getter(name="oidcTokenFilePath")
    def oidc_token_file_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OIDC token from file to authenticate as a service principal.
        """
        return pulumi.get(self, "oidc_token_file_path")

    @oidc_token_file_path.setter
    def oidc_token_file_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oidc_token_file_path", value)

    @_builtins.property
    @pulumi.getter(name="orgServiceUrl")
    def org_service_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The url of the Azure DevOps instance which should be used.
        """
        return pulumi.get(self, "org_service_url")

    @org_service_url.setter
    def org_service_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_service_url", value)

    @_builtins.property
    @pulumi.getter(name="personalAccessToken")
    def personal_access_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The personal access token which should be used.
        """
        return pulumi.get(self, "personal_access_token")

    @personal_access_token.setter
    def personal_access_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "personal_access_token", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service principal tenant id which should be used for AAD auth.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="useCli")
    def use_cli(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use Azure CLI to authenticate. Defaults to `true`.
        """
        return pulumi.get(self, "use_cli")

    @use_cli.setter
    def use_cli(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_cli", value)

    @_builtins.property
    @pulumi.getter(name="useMsi")
    def use_msi(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use an Azure Managed Service Identity. Defaults to `false`.
        """
        return pulumi.get(self, "use_msi")

    @use_msi.setter
    def use_msi(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_msi", value)

    @_builtins.property
    @pulumi.getter(name="useOidc")
    def use_oidc(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use an OIDC token to authenticate to a service principal. Defaults to `false`.
        """
        return pulumi.get(self, "use_oidc")

    @use_oidc.setter
    def use_oidc(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_oidc", value)


@pulumi.type_token("pulumi:providers:azuredevops")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auxiliary_tenant_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_password: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_path: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id_file_path: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret_path: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_azure_service_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_request_token: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_request_url: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_token: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_token_file_path: Optional[pulumi.Input[_builtins.str]] = None,
                 org_service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 personal_access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 use_cli: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_msi: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_oidc: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        The provider type for the azuredevops package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] auxiliary_tenant_ids: List of auxiliary Tenant IDs required for multi-tenancy and cross-tenant scenarios.
        :param pulumi.Input[_builtins.str] client_certificate: Base64 encoded certificate to use to authenticate to the service principal.
        :param pulumi.Input[_builtins.str] client_certificate_password: Password for a client certificate password.
        :param pulumi.Input[_builtins.str] client_certificate_path: Path to a certificate to use to authenticate to the service principal.
        :param pulumi.Input[_builtins.str] client_id: The service principal client id which should be used for AAD auth.
        :param pulumi.Input[_builtins.str] client_id_file_path: The path to a file containing the Client ID which should be used.
        :param pulumi.Input[_builtins.str] client_secret: Client secret for authenticating to  a service principal.
        :param pulumi.Input[_builtins.str] client_secret_path: Path to a file containing a client secret for authenticating to  a service principal.
        :param pulumi.Input[_builtins.str] oidc_azure_service_connection_id: The Azure Pipelines Service Connection ID to use for authentication.
        :param pulumi.Input[_builtins.str] oidc_request_token: The bearer token for the request to the OIDC provider. For use when authenticating as a Service Principal using OpenID Connect.
        :param pulumi.Input[_builtins.str] oidc_request_url: The URL for the OIDC provider from which to request an ID token. For use when authenticating as a Service Principal using OpenID Connect.
        :param pulumi.Input[_builtins.str] oidc_token: OIDC token to authenticate as a service principal.
        :param pulumi.Input[_builtins.str] oidc_token_file_path: OIDC token from file to authenticate as a service principal.
        :param pulumi.Input[_builtins.str] org_service_url: The url of the Azure DevOps instance which should be used.
        :param pulumi.Input[_builtins.str] personal_access_token: The personal access token which should be used.
        :param pulumi.Input[_builtins.str] tenant_id: The service principal tenant id which should be used for AAD auth.
        :param pulumi.Input[_builtins.bool] use_cli: Use Azure CLI to authenticate. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] use_msi: Use an Azure Managed Service Identity. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] use_oidc: Use an OIDC token to authenticate to a service principal. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the azuredevops package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auxiliary_tenant_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_password: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_path: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id_file_path: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret_path: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_azure_service_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_request_token: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_request_url: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_token: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_token_file_path: Optional[pulumi.Input[_builtins.str]] = None,
                 org_service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 personal_access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 use_cli: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_msi: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_oidc: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["auxiliary_tenant_ids"] = pulumi.Output.from_input(auxiliary_tenant_ids).apply(pulumi.runtime.to_json) if auxiliary_tenant_ids is not None else None
            __props__.__dict__["client_certificate"] = None if client_certificate is None else pulumi.Output.secret(client_certificate)
            __props__.__dict__["client_certificate_password"] = None if client_certificate_password is None else pulumi.Output.secret(client_certificate_password)
            __props__.__dict__["client_certificate_path"] = client_certificate_path
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_id_file_path"] = client_id_file_path
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["client_secret_path"] = client_secret_path
            __props__.__dict__["oidc_azure_service_connection_id"] = oidc_azure_service_connection_id
            __props__.__dict__["oidc_request_token"] = oidc_request_token
            __props__.__dict__["oidc_request_url"] = oidc_request_url
            __props__.__dict__["oidc_token"] = None if oidc_token is None else pulumi.Output.secret(oidc_token)
            __props__.__dict__["oidc_token_file_path"] = oidc_token_file_path
            if org_service_url is None:
                org_service_url = _utilities.get_env('AZDO_ORG_SERVICE_URL')
            __props__.__dict__["org_service_url"] = org_service_url
            __props__.__dict__["personal_access_token"] = None if personal_access_token is None else pulumi.Output.secret(personal_access_token)
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["use_cli"] = pulumi.Output.from_input(use_cli).apply(pulumi.runtime.to_json) if use_cli is not None else None
            __props__.__dict__["use_msi"] = pulumi.Output.from_input(use_msi).apply(pulumi.runtime.to_json) if use_msi is not None else None
            __props__.__dict__["use_oidc"] = pulumi.Output.from_input(use_oidc).apply(pulumi.runtime.to_json) if use_oidc is not None else None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientCertificate", "clientCertificatePassword", "clientSecret", "oidcToken", "personalAccessToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'azuredevops',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Base64 encoded certificate to use to authenticate to the service principal.
        """
        return pulumi.get(self, "client_certificate")

    @_builtins.property
    @pulumi.getter(name="clientCertificatePassword")
    def client_certificate_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Password for a client certificate password.
        """
        return pulumi.get(self, "client_certificate_password")

    @_builtins.property
    @pulumi.getter(name="clientCertificatePath")
    def client_certificate_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path to a certificate to use to authenticate to the service principal.
        """
        return pulumi.get(self, "client_certificate_path")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The service principal client id which should be used for AAD auth.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientIdFilePath")
    def client_id_file_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path to a file containing the Client ID which should be used.
        """
        return pulumi.get(self, "client_id_file_path")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Client secret for authenticating to  a service principal.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter(name="clientSecretPath")
    def client_secret_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path to a file containing a client secret for authenticating to  a service principal.
        """
        return pulumi.get(self, "client_secret_path")

    @_builtins.property
    @pulumi.getter(name="oidcAzureServiceConnectionId")
    def oidc_azure_service_connection_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Azure Pipelines Service Connection ID to use for authentication.
        """
        return pulumi.get(self, "oidc_azure_service_connection_id")

    @_builtins.property
    @pulumi.getter(name="oidcRequestToken")
    def oidc_request_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The bearer token for the request to the OIDC provider. For use when authenticating as a Service Principal using OpenID Connect.
        """
        return pulumi.get(self, "oidc_request_token")

    @_builtins.property
    @pulumi.getter(name="oidcRequestUrl")
    def oidc_request_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URL for the OIDC provider from which to request an ID token. For use when authenticating as a Service Principal using OpenID Connect.
        """
        return pulumi.get(self, "oidc_request_url")

    @_builtins.property
    @pulumi.getter(name="oidcToken")
    def oidc_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        OIDC token to authenticate as a service principal.
        """
        return pulumi.get(self, "oidc_token")

    @_builtins.property
    @pulumi.getter(name="oidcTokenFilePath")
    def oidc_token_file_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        OIDC token from file to authenticate as a service principal.
        """
        return pulumi.get(self, "oidc_token_file_path")

    @_builtins.property
    @pulumi.getter(name="orgServiceUrl")
    def org_service_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The url of the Azure DevOps instance which should be used.
        """
        return pulumi.get(self, "org_service_url")

    @_builtins.property
    @pulumi.getter(name="personalAccessToken")
    def personal_access_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The personal access token which should be used.
        """
        return pulumi.get(self, "personal_access_token")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The service principal tenant id which should be used for AAD auth.
        """
        return pulumi.get(self, "tenant_id")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:azuredevops/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

