# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServiceEndpointGenericGitArgs', 'ServiceEndpointGenericGit']

@pulumi.input_type
class ServiceEndpointGenericGitArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.str],
                 repository_url: pulumi.Input[_builtins.str],
                 service_endpoint_name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_pipelines_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceEndpointGenericGit resource.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.str] repository_url: The URL of the repository associated with the service endpoint.
        :param pulumi.Input[_builtins.str] service_endpoint_name: The name of the service endpoint.
        :param pulumi.Input[_builtins.bool] enable_pipelines_access: A value indicating whether or not to attempt accessing this git server from Azure Pipelines.
        :param pulumi.Input[_builtins.str] password: The PAT or password used to authenticate to the git repository.
               
               > **Note** For AzureDevOps Git, PAT should be used as the password.
        :param pulumi.Input[_builtins.str] username: The username used to authenticate to the git repository.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "repository_url", repository_url)
        pulumi.set(__self__, "service_endpoint_name", service_endpoint_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_pipelines_access is not None:
            pulumi.set(__self__, "enable_pipelines_access", enable_pipelines_access)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> pulumi.Input[_builtins.str]:
        """
        The URL of the repository associated with the service endpoint.
        """
        return pulumi.get(self, "repository_url")

    @repository_url.setter
    def repository_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository_url", value)

    @_builtins.property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the service endpoint.
        """
        return pulumi.get(self, "service_endpoint_name")

    @service_endpoint_name.setter
    def service_endpoint_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_endpoint_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enablePipelinesAccess")
    def enable_pipelines_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A value indicating whether or not to attempt accessing this git server from Azure Pipelines.
        """
        return pulumi.get(self, "enable_pipelines_access")

    @enable_pipelines_access.setter
    def enable_pipelines_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_pipelines_access", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The PAT or password used to authenticate to the git repository.

        > **Note** For AzureDevOps Git, PAT should be used as the password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username used to authenticate to the git repository.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _ServiceEndpointGenericGitState:
    def __init__(__self__, *,
                 authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_pipelines_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_url: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceEndpointGenericGit resources.
        :param pulumi.Input[_builtins.bool] enable_pipelines_access: A value indicating whether or not to attempt accessing this git server from Azure Pipelines.
        :param pulumi.Input[_builtins.str] password: The PAT or password used to authenticate to the git repository.
               
               > **Note** For AzureDevOps Git, PAT should be used as the password.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.str] repository_url: The URL of the repository associated with the service endpoint.
        :param pulumi.Input[_builtins.str] service_endpoint_name: The name of the service endpoint.
        :param pulumi.Input[_builtins.str] username: The username used to authenticate to the git repository.
        """
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_pipelines_access is not None:
            pulumi.set(__self__, "enable_pipelines_access", enable_pipelines_access)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if repository_url is not None:
            pulumi.set(__self__, "repository_url", repository_url)
        if service_endpoint_name is not None:
            pulumi.set(__self__, "service_endpoint_name", service_endpoint_name)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorization", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enablePipelinesAccess")
    def enable_pipelines_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A value indicating whether or not to attempt accessing this git server from Azure Pipelines.
        """
        return pulumi.get(self, "enable_pipelines_access")

    @enable_pipelines_access.setter
    def enable_pipelines_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_pipelines_access", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The PAT or password used to authenticate to the git repository.

        > **Note** For AzureDevOps Git, PAT should be used as the password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the repository associated with the service endpoint.
        """
        return pulumi.get(self, "repository_url")

    @repository_url.setter
    def repository_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_url", value)

    @_builtins.property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service endpoint.
        """
        return pulumi.get(self, "service_endpoint_name")

    @service_endpoint_name.setter
    def service_endpoint_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_endpoint_name", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username used to authenticate to the git repository.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("azuredevops:index/serviceEndpointGenericGit:ServiceEndpointGenericGit")
class ServiceEndpointGenericGit(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_pipelines_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_url: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Other Git service endpoint within Azure DevOps, which can be used to authenticate to any external git service
        using basic authentication via a username and password. This is mostly useful for importing private git repositories.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_service_endpoint_generic_git = azuredevops.ServiceEndpointGenericGit("example",
            project_id=example.id,
            repository_url="https://dev.azure.com/org/project/_git/repository",
            username="username",
            password="password",
            service_endpoint_name="Example Generic Git",
            description="Managed by Pulumi")
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Agent Pools](https://docs.microsoft.com/en-us/rest/api/azure/devops/serviceendpoint/endpoints?view=azure-devops-rest-7.0)

        ## Import

        Azure DevOps Other Git Service Endpoint can be imported using **projectID/serviceEndpointID** or **projectName/serviceEndpointID**

        ```sh
        $ pulumi import azuredevops:index/serviceEndpointGenericGit:ServiceEndpointGenericGit example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enable_pipelines_access: A value indicating whether or not to attempt accessing this git server from Azure Pipelines.
        :param pulumi.Input[_builtins.str] password: The PAT or password used to authenticate to the git repository.
               
               > **Note** For AzureDevOps Git, PAT should be used as the password.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.str] repository_url: The URL of the repository associated with the service endpoint.
        :param pulumi.Input[_builtins.str] service_endpoint_name: The name of the service endpoint.
        :param pulumi.Input[_builtins.str] username: The username used to authenticate to the git repository.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceEndpointGenericGitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Other Git service endpoint within Azure DevOps, which can be used to authenticate to any external git service
        using basic authentication via a username and password. This is mostly useful for importing private git repositories.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_service_endpoint_generic_git = azuredevops.ServiceEndpointGenericGit("example",
            project_id=example.id,
            repository_url="https://dev.azure.com/org/project/_git/repository",
            username="username",
            password="password",
            service_endpoint_name="Example Generic Git",
            description="Managed by Pulumi")
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Agent Pools](https://docs.microsoft.com/en-us/rest/api/azure/devops/serviceendpoint/endpoints?view=azure-devops-rest-7.0)

        ## Import

        Azure DevOps Other Git Service Endpoint can be imported using **projectID/serviceEndpointID** or **projectName/serviceEndpointID**

        ```sh
        $ pulumi import azuredevops:index/serviceEndpointGenericGit:ServiceEndpointGenericGit example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param ServiceEndpointGenericGitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceEndpointGenericGitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_pipelines_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_url: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceEndpointGenericGitArgs.__new__(ServiceEndpointGenericGitArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enable_pipelines_access"] = enable_pipelines_access
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if repository_url is None and not opts.urn:
                raise TypeError("Missing required property 'repository_url'")
            __props__.__dict__["repository_url"] = repository_url
            if service_endpoint_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_endpoint_name'")
            __props__.__dict__["service_endpoint_name"] = service_endpoint_name
            __props__.__dict__["username"] = username
            __props__.__dict__["authorization"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServiceEndpointGenericGit, __self__).__init__(
            'azuredevops:index/serviceEndpointGenericGit:ServiceEndpointGenericGit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_pipelines_access: Optional[pulumi.Input[_builtins.bool]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            repository_url: Optional[pulumi.Input[_builtins.str]] = None,
            service_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceEndpointGenericGit':
        """
        Get an existing ServiceEndpointGenericGit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enable_pipelines_access: A value indicating whether or not to attempt accessing this git server from Azure Pipelines.
        :param pulumi.Input[_builtins.str] password: The PAT or password used to authenticate to the git repository.
               
               > **Note** For AzureDevOps Git, PAT should be used as the password.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.str] repository_url: The URL of the repository associated with the service endpoint.
        :param pulumi.Input[_builtins.str] service_endpoint_name: The name of the service endpoint.
        :param pulumi.Input[_builtins.str] username: The username used to authenticate to the git repository.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceEndpointGenericGitState.__new__(_ServiceEndpointGenericGitState)

        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_pipelines_access"] = enable_pipelines_access
        __props__.__dict__["password"] = password
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["repository_url"] = repository_url
        __props__.__dict__["service_endpoint_name"] = service_endpoint_name
        __props__.__dict__["username"] = username
        return ServiceEndpointGenericGit(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "authorization")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enablePipelinesAccess")
    def enable_pipelines_access(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A value indicating whether or not to attempt accessing this git server from Azure Pipelines.
        """
        return pulumi.get(self, "enable_pipelines_access")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The PAT or password used to authenticate to the git repository.

        > **Note** For AzureDevOps Git, PAT should be used as the password.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the repository associated with the service endpoint.
        """
        return pulumi.get(self, "repository_url")

    @_builtins.property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service endpoint.
        """
        return pulumi.get(self, "service_endpoint_name")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The username used to authenticate to the git repository.
        """
        return pulumi.get(self, "username")

