# coding: utf8
from __future__ import unicode_literals
from mock import Mock, patch, MagicMock

from clld.tests.util import TestWithEnv
from clld.db.models import common
from clld.interfaces import ILinkAttrs, IFrequencyMarker, IDownload
from clld.web.adapters.download import N3Dump


class Tests(TestWithEnv):
    def test_alt_representations(self):
        from clld.web.util.helpers import alt_representations

        alt_representations(self.env['request'], common.Parameter.first())

    def test_link(self):
        from clld.web.util.helpers import link

        link(self.env['request'], common.Language(id='id', name='Name'))
        link(self.env['request'], common.Value.first(), class_='right')

        with self.utility(Mock(return_value={}), ILinkAttrs):
            link(self.env['request'], common.Value.first())

    def test_text_citation(self):
        from clld.web.util.helpers import text_citation

        text_citation(self.env['request'], common.Contribution.first())

    def test_get_referents(self):
        from clld.web.util.helpers import get_referents

        get_referents(common.Source.first(), exclude=['language'])

    def test_data_uri(self):
        from clld.web.util.helpers import data_uri

        data_uri(__file__, 'text/plain')

    def test_gbs_link(self):
        from clld.web.util.helpers import gbs_link

        gbs_link(MagicMock(), pages='34')
        gbs_link(MagicMock(jsondata=dict(
            gbs=dict(accessInfo=dict(viewability='NO_PAGES')))))

    def test_map_marker_img(self):
        from clld.web.util.helpers import map_marker_img

        map_marker_img(self.env['request'], None, marker=Mock(return_value=None))

    def test_external_link(self):
        from clld.web.util.helpers import external_link

        self.assertTrue('http://wals.info' in external_link('http://wals.info'))

    def test_button(self):
        from clld.web.util.helpers import button

        self.assertTrue('click' in button('click'))

    def test_linked_contributors(self):
        from clld.web.util.helpers import linked_contributors

        linked_contributors(self.env['request'], common.Contribution.first())

    def test_urlescape(self):
        from clld.web.util.helpers import urlescape

        urlescape('a b c\\/ab')

    def test_coins(self):
        from clld.web.util.helpers import coins

        coins(self.env['request'], common.Contribution.first())
        coins(self.env['request'], None)

    def test_format_gbs_identifier(self):
        from clld.web.util.helpers import format_gbs_identifier

        format_gbs_identifier(common.Source.first())

    def test_linked_references(self):
        from clld.web.util.helpers import linked_references

        with patch('clld.web.util.helpers.link'):
            linked_references(
                self.env['request'], Mock(
                    references=[MagicMock(description=''), MagicMock(description='')]))

    def test_text2html(self):
        from clld.web.util.helpers import text2html

        self.assertTrue('<br' in text2html('abc\ndef'))

    def test_contactmail(self):
        from clld.web.util.helpers import contactmail

        contactmail(self.env['request'])

    def test_format_frequency(self):
        from clld.web.util.helpers import format_frequency

        format_frequency(self.env['request'], common.Value.first())
        format_frequency(self.env['request'], Mock(frequency=None))

        with self.utility(Mock(return_value='url'), IFrequencyMarker):
            format_frequency(self.env['request'], common.Value.first())

    def test_format_coordinates(self):
        from clld.web.util.helpers import format_coordinates

        r = unicode(format_coordinates(Mock(latitude=5.333333333333, longitude=-9.999)))
        assert "5°20" in r
        assert "10°W" in r
        format_coordinates(Mock(latitude=5.333, longitude=-9.99), no_seconds=False)
        assert format_coordinates(common.Language.get('l2')) == ''
        assert format_coordinates(common.Language.get('language')) != ''

    def test_get_downloads(self):
        from clld.web.util.helpers import get_rdf_dumps, get_downloads

        with self.utility(N3Dump(common.Language, 'clld'), IDownload):
            assert list(get_rdf_dumps(self.env['request'], common.Language))
            assert list(get_downloads(self.env['request']))

    def test_rendered_sentence(self):
        from clld.web.util.helpers import rendered_sentence

        rendered_sentence(MagicMock())
        rendered_sentence(common.Sentence.first())
        rendered_sentence(common.Sentence.first(), abbrs=dict(SG='singular'))

    def test_language_identifier(self):
        from clld.web.util.helpers import language_identifier

        assert language_identifier(None, None) == ''
        for identifier in common.Language.get('language').identifiers:
            language_identifier(self.env['request'], identifier)
