import enum


class YamlModelType(str, enum.Enum):
    FLUID = "FLUID"
    COMPRESSOR_CHART = "COMPRESSOR_CHART"
    TURBINE = "TURBINE"
    SIMPLIFIED_VARIABLE_SPEED_COMPRESSOR_TRAIN = "SIMPLIFIED_VARIABLE_SPEED_COMPRESSOR_TRAIN"
    SINGLE_SPEED_COMPRESSOR_TRAIN = "SINGLE_SPEED_COMPRESSOR_TRAIN"
    VARIABLE_SPEED_COMPRESSOR_TRAIN = "VARIABLE_SPEED_COMPRESSOR_TRAIN"
    VARIABLE_SPEED_COMPRESSOR_TRAIN_MULTIPLE_STREAMS_AND_PRESSURES = (
        "VARIABLE_SPEED_COMPRESSOR_TRAIN_MULTIPLE_STREAMS_AND_PRESSURES"
    )
    COMPRESSOR_WITH_TURBINE = "COMPRESSOR_WITH_TURBINE"


class YamlChartType(str, enum.Enum):
    SINGLE_SPEED = "SINGLE_SPEED"
    VARIABLE_SPEED = "VARIABLE_SPEED"
    GENERIC_FROM_INPUT = "GENERIC_FROM_INPUT"
    GENERIC_FROM_DESIGN_POINT = "GENERIC_FROM_DESIGN_POINT"


class YamlPressureControl(enum.Enum):
    DOWNSTREAM_CHOKE = "DOWNSTREAM_CHOKE"
    UPSTREAM_CHOKE = "UPSTREAM_CHOKE"
    INDIVIDUAL_ASV_PRESSURE = "INDIVIDUAL_ASV_PRESSURE"
    INDIVIDUAL_ASV_RATE = "INDIVIDUAL_ASV_RATE"
    COMMON_ASV = "COMMON_ASV"
