import os
import numpy as np
import typing


def mset_settings_default(mea_keys: typing.List[str]):
    settings = {
        'airfoils': {'label': 'Airfoil Order', 'widget_type': 'QLineEdit', 'text': ','.join(mea_keys),
                          },
        'grid_bounds': {'widget_type': 'GridBounds', 'values': [-5.0, 5.0, -5.0, 5.0]},
        'airfoil_side_points': {'label': 'Airfoil Side Points', 'widget_type': 'QSpinBox', 'value': 150,
                                'lower_bound': 1, 'upper_bound': int(2 ** 32 / 2 - 1)},
        'exp_side_points': {'label': 'Side Points Exponent', 'widget_type': 'QDoubleSpinBox', 'value': 0.9,
                            'lower_bound': 0.0, 'upper_bound': np.inf},
        'inlet_pts_left_stream': {'label': 'Inlet Points Left', 'widget_type': 'QSpinBox', 'value': 41,
                                  'lower_bound': 1, 'upper_bound': int(2 ** 32 / 2 - 1)},
        'outlet_pts_right_stream': {'label': 'Outlet Points Right', 'widget_type': 'QSpinBox', 'value': 41,
                                    'lower_bound': 1, 'upper_bound': int(2 ** 32 / 2 - 1)},
        'num_streams_top': {'label': 'Number Top Streamlines', 'widget_type': 'QSpinBox', 'value': 17,
                            'lower_bound': 1, 'upper_bound': int(2 ** 32 / 2 - 1)},
        'num_streams_bot': {'label': 'Number Bottom Streamlines', 'widget_type': 'QSpinBox', 'value': 23,
                            'lower_bound': 1, 'upper_bound': int(2 ** 32 / 2 - 1)},
        'max_streams_between': {'label': 'Max Streamlines Between', 'widget_type': 'QSpinBox', 'value': 15,
                                'lower_bound': 1, 'upper_bound': int(2 ** 32 / 2 - 1)},
        'elliptic_param': {'label': 'Elliptic Parameter', 'widget_type': 'QDoubleSpinBox', 'value': 1.3,
                           'lower_bound': 0.0, 'upper_bound': np.inf},
        'stag_pt_aspect_ratio': {'label': 'Stag. Pt. Aspect Ratio', 'widget_type': 'QDoubleSpinBox', 'value': 2.5,
                                 'lower_bound': 0.0, 'upper_bound': np.inf},
        'x_spacing_param': {'label': 'X-Spacing Parameter', 'widget_type': 'QDoubleSpinBox', 'value': 0.85,
                            'lower_bound': 0.0, 'upper_bound': np.inf},
        'alf0_stream_gen': {'label': 'Streamline Gen. Alpha', 'widget_type': 'QDoubleSpinBox', 'value': 0.0,
                            'lower_bound': -np.inf, 'upper_bound': np.inf},
        'timeout': {'label': 'Timeout', 'widget_type': 'QDoubleSpinBox', 'value': 10.0,
                    'lower_bound': 0.0, 'upper_bound': np.inf},
        'verbose': {'label': 'Verbose?', 'widget_type': 'QCheckBox', 'state': 0},
        'multi_grid_label': {'widget_type': 'QLabel', 'text': 'MEA Grid Settings',
                             'restart_grid_counter': True, 'col': 4, 'align': 'c'},
        'multi_airfoil_grid': {'widget_type': 'MSETMultiGridWidget',
                               'values': {'A0': {
                                            'dsLE_dsAvg': 0.35,
                                            'dsTE_dsAvg': 0.8,
                                            'curvature_exp': 1.3,
                                            'U_s_smax_min': 1,
                                            'U_s_smax_max': 1,
                                            'L_s_smax_min': 1,
                                            'L_s_smax_max': 1,
                                            'U_local_avg_spac_ratio': 0,
                                            'L_local_avg_spac_ratio': 0,
                                        }},
                               'col': 4, 'row_span': 7, 'col_span': 4},
        'airfoil_analysis_dir': {'label': 'Analysis Directory', 'widget_type': 'QLineEdit',
                                 'push_button': 'Choose folder',
                                 'push_button_action': 'select_directory_for_airfoil_analysis', 'text': '',
                                 'col': 5, 'label_col': 4},
        'airfoil_coord_file_name': {'label': 'Airfoil Coord. Filename', 'widget_type': 'QLineEdit',
                                    'text': 'default_airfoil', 'col': 5, 'label_col': 4},
    }
    return settings


def mses_settings_default():
    settings = {
        'viscous_flag': {'label': 'Viscosity On?', 'widget_type': 'QCheckBox', 'state': 1},
        'spec_Re': {'label': 'Specify Reynolds Number?', 'widget_type': 'QCheckBox', 'state': 0,
                    'checkbox_callback': 'change_Re_active_state'},
        'REYNIN': {'label': 'Reynolds Number', 'widget_type': 'QDoubleSpinBox', 'value': 1e6,
                   'lower_bound': 0.0, 'upper_bound': np.inf, 'setDecimals': 16, 'editable': False},
        'MACHIN': {'label': 'Mach Number', 'widget_type': 'QDoubleSpinBox', 'value': 0.7,
                   'lower_bound': 0.0, 'upper_bound': np.inf, 'setDecimals': 16},
        'spec_P_T_rho': {'label': 'Specify Flow Variables', 'widget_type': 'QComboBox',
                         'items': ['Specify Pressure, Temperature', 'Specify Pressure, Density',
                                   'Specify Temperature, Density'],
                         'current_text': 'Specify Pressure, Temperature',
                         'combo_callback': 'change_prescribed_flow_variables'},
        'P': {'label': 'Pressure (Pa)', 'widget_type': 'QDoubleSpinBox', 'value': 101325.0,
              'lower_bound': 0.0, 'upper_bound': np.inf, 'setDecimals': 16, 'editable': True},
        'T': {'label': 'Temperature (K)', 'widget_type': 'QDoubleSpinBox', 'value': 300,
              'lower_bound': 0.0, 'upper_bound': np.inf, 'setDecimals': 16, 'editable': True},
        'rho': {'label': 'Density (kg/m^3)', 'widget_type': 'QDoubleSpinBox', 'value': 101325.0 / (287 * 300),
                'lower_bound': 0.0, 'upper_bound': np.inf, 'setDecimals': 16, 'editable': False},
        'gam': {'label': 'Specific Heat Ratio', 'widget_type': 'QDoubleSpinBox', 'value': 1.4,
                'lower_bound': 0.0, 'upper_bound': np.inf, 'setDecimals': 16},
        'L': {'label': 'Length Scale (m)', 'widget_type': 'QDoubleSpinBox', 'value': 1.0,
              'lower_bound': 0.0, 'upper_bound': np.inf, 'setDecimals': 16},
        'R': {'label': 'Gas Constant (J/(kg*K))', 'widget_type': 'QDoubleSpinBox', 'value': 287.05,
              'lower_bound': 0.0, 'upper_bound': np.inf, 'setDecimals': 16},
        'spec_alfa_Cl': {'label': 'Specify Alpha/Cl', 'widget_type': 'QComboBox',
                         'items': ['Specify Angle of Attack', 'Specify Lift Coefficient'],
                         'current_text': 'Specify Angle of Attack',
                         'combo_callback': 'change_prescribed_aero_parameter'},
        'ALFAIN': {'label': 'Angle of Attack (deg)', 'widget_type': 'QDoubleSpinBox', 'value': 0.0,
                   'lower_bound': -np.inf, 'upper_bound': np.inf, 'setDecimals': 16, 'editable': True},
        'CLIFIN': {'label': 'Lift Coefficient', 'widget_type': 'QDoubleSpinBox', 'value': 0.0,
                   'lower_bound': -np.inf, 'upper_bound': np.inf, 'setDecimals': 16, 'editable': False},
        'ISMOM': {'label': 'Isentropic/Momentum', 'widget_type': 'QComboBox',
                  'items': ['S-momentum equation', 'isentropic condition',
                            'S-momentum equation, isentropic @ LE',
                            'isentropic condition, S-mom. where diss. active'],
                  'current_text': 'S-momentum equation, isentropic @ LE'},
        'IFFBC': {'label': 'Far-Field Boundary', 'widget_type': 'QComboBox',
                  'items': ['solid wall airfoil far-field BCs', 'vortex+source+doublet airfoil far-field BCs',
                            'freestream pressure airfoil far-field BCs', 'supersonic wave freestream BCs',
                            'supersonic solid wall far-field BCs'],
                  'current_text': 'vortex+source+doublet airfoil far-field BCs'},
        'ACRIT': {'label': 'Crit. Amp. Factor', 'widget_type': 'QDoubleSpinBox', 'value': 9.0,
                  'lower_bound': 0.0, 'upper_bound': np.inf, 'setDecimals': 4},
        'MCRIT': {'label': 'Critical Mach Number', 'widget_type': 'QDoubleSpinBox', 'value': 0.95,
                  'lower_bound': 0.0, 'upper_bound': 1.0, 'setDecimals': 4},
        'MUCON': {'label': 'Artificial Dissipation', 'widget_type': 'QDoubleSpinBox', 'value': 1.05,
                  'lower_bound': 1.0, 'upper_bound': np.inf, 'setDecimals': 4},
        'timeout': {'label': 'Timeout', 'widget_type': 'QDoubleSpinBox', 'value': 15.0,
                    'lower_bound': 0.0, 'upper_bound': np.inf, 'restart_grid_counter': True, 'col': 5, 'label_col': 4},
        'iter': {'label': 'Maximum Iterations', 'widget_type': 'QSpinBox', 'value': 100,
                 'lower_bound': 1, 'upper_bound': 1000000, 'col': 5, 'label_col': 4},
        'verbose': {'label': 'Verbose?', 'widget_type': 'QCheckBox', 'state': 0, 'label_col': 4, 'col': 5},
        'xtrs_label': {'widget_type': 'QLabel', 'text': 'Transition Location',
                       'col': 4, 'align': 'c'},
        'xtrs': {'widget_type': 'XTRSWidget',
                 'values': {'A0': {'XTRSupper': 1.0, 'XTRSlower': 1.0}}, 'col': 4, 'row_span': 3, 'col_span': 2},
        'AD_active': {'label': 'Actuator Disks Active?', 'widget_type': 'QCheckBox', 'state': 0, 'col': 5,
                      'label_col': 4},
        'AD_number': {'label': 'Num. Actuator Disks', 'widget_type': 'QSpinBox', 'value': 1,
                      'lower_bound': 1, 'upper_bound': 5, 'col': 5, 'label_col': 4},
        'AD_label': {'widget_type': 'QLabel', 'text': 'Actuator Disks',
                     'col': 4, 'align': 'c', 'col_span': 2},
        'AD': {'widget_type': 'ADWidget',
               'values': {'1': {'ISDELH': 1, 'XCDELH': 0.1, 'PTRHIN': 1.1, 'ETAH': 0.95}}, 'col': 4, 'row_span': 5,
               'col_span': 2},
    }
    return settings


def mplot_settings_default():
    settings = {
        'timeout': {'label': 'Timeout (sec)', 'widget_type': 'QDoubleSpinBox', 'value': 15.0,
                    'lower_bound': 0.0, 'upper_bound': np.inf, 'setDecimals': 4},
        'Mach': {'label': 'Output Mach Contours', 'widget_type': 'QCheckBox', 'state': 1},
        'Grid': {'label': 'Output Grid', 'widget_type': 'QCheckBox', 'state': 1},
        'Grid_Zoom': {'label': 'Output Zoomed-In Grid', 'widget_type': 'QCheckBox', 'state': 1},
        'Streamline_Grid': {'label': 'Output Streamline Grid', 'widget_type': 'QCheckBox', 'state': 1},
        'CPK': {'label': "Output CPK", "widget_type": "QCheckBox", "state": 0}
    }
    return settings


def opt_settings_default(mea_keys: typing.List[str]):
    settings = {
        'Warm Start/Batch Mode': {
            'warm_start_active': {'label': 'Warm Start Active?', 'state': 0, 'widget_type': 'QCheckBox',
                                  'widgets_to_enable': [['Warm Start/Batch Mode', 'warm_start_generation'],
                                                        ['Warm Start/Batch Mode', 'warm_start_dir']]},
            'warm_start_generation': {'label': 'Warm Start Generation', 'widget_type': 'QSpinBox',
                                      'value': -1, 'lower_bound': -int(2 ** 32 / 2 - 1),
                                      'upper_bound': int(2 ** 32 / 2 - 1), 'tool_tip':
                                      'Choose \'-1\' to start from the most recent generation'},
            'warm_start_dir': {'label': 'Warm Start Directory', 'widget_type': 'QLineEdit', 'text': '',
                               'push_button': 'Choose folder', 'push_button_action': 'select_directory'},
            'use_initial_settings': {'label': 'Use Initial Settings?', 'state': 1, 'widget_type': 'QCheckBox'},
            'use_current_mea': {'label': 'Use Current MEA?', 'state': 1, 'widget_type': 'QCheckBox',
                                'widgets_to_disable': [['Warm Start/Batch Mode', 'mea_file']]},
            'mea_file': {'label': 'MEA File', 'widget_type': 'QLineEdit',
                         'push_button': 'Choose file',
                         'push_button_action': 'select_existing_jmea_file', 'text': ''},
            'batch_mode_active': {'label': 'Batch Mode Active?', 'state': 0, 'widget_type': 'QCheckBox',
                                  'widgets_to_enable': [['Warm Start/Batch Mode', 'batch_mode_files']],
                                  'tool_tip': 'If this box is checked, all settings in this dialog will be\n'
                                              'overridden by the settings in the selected JSON settings files.'},
            'batch_mode_files': {'label': 'Batch Settings Files', 'widget_type': 'QPlainTextEdit',
                                 'texts': [''], 'push_button': 'Choose files',
                                 'push_button_action': 'select_multiple_json_files'},
        },
        'Genetic Algorithm': {
            'tool': {'label': 'CFD Tool:', 'widget_type': 'QComboBox', 'items': ['XFOIL', 'MSES'],
                     'current_text': 'XFOIL'},
            'J': {'label': 'Objective Functions:', 'widget_type': 'QLineEdit', 'text': '$Cd',
                  'tool_tip': 'Enter the objective functions to be minimized, separated by commas.\n'
                              'Variables can be started with the dollar sign ($).',
                  'text_changed_callback': 'objectives_changed'},
            'G': {'label': 'Constraints:', 'widget_type': 'QLineEdit', 'text': '',
                  'tool_tip': 'Enter the constraint functions to be applied, separated by commas.\n'
                              'Variables can be started with the dollar sign ($).',
                  'text_changed_callback': 'constraints_changed'},
            'additional_data': {'label': 'Additional Data', 'widget_type': 'QPlainTextEdit',
                                'texts': [''],
                                'tool_tip': 'Additional variables to feed to the\nobjective or constraint functions'},
            'pop_size': {'label': 'Population Size:', 'widget_type': 'QSpinBox', 'value': 50,
                         'lower_bound': 1, 'upper_bound': int(2 ** 32 / 2 - 1)},
            'n_offspring': {'label': 'Number of Offspring', 'widget_type': 'QSpinBox', 'value': 150,
                            'lower_bound': 50, 'upper_bound': int(2 ** 32 / 2 - 1),
                            'tool_tip': 'Number of offspring to generate to fill out the population.\n'
                                        'Offspring with converged objective functions become members of the\n'
                                        'current population until the population is full. Must be greater\n'
                                        'than or equal to the population size'},
            'eta_crossover': {'label': 'η (crossover)', 'widget_type': 'QDoubleSpinBox', 'value': 20.0,
                              'setDecimals': 3, 'lower_bound': 0.0, 'upper_bound': 1e5},
            'eta_mutation': {'label': 'η (mutation)', 'widget_type': 'QDoubleSpinBox', 'value': 15.0,
                             'setDecimals': 3, 'lower_bound': 0.0, 'upper_bound': 1e5},
            'random_seed': {'label': 'Random Seed', 'widget_type': 'QSpinBox', 'value': 1, 'lower_bound': 0,
                            'upper_bound': int(2 ** 32 / 2 - 1)},
            'num_processors': {'label': 'Number of Processors', 'widget_type': 'QSpinBox', 'value': os.cpu_count() - 1,
                               'lower_bound': 1, 'upper_bound': os.cpu_count()},
            'algorithm_save_frequency': {'label': 'State Save Frequency', 'widget_type': 'QSpinBox', 'value': 1,
                                         'lower_bound': 1, 'upper_bound': 1000,
                                         'tool_tip': 'How often to save the state of the genetic algorithm.\n'
                                                     'A value of \'1\' enforces a state save every generation'},
            'root_dir': {'label': 'Opt. Root Directory:', 'widget_type': 'QLineEdit',
                         'text': '', 'push_button': 'Choose folder',
                         'push_button_action': 'select_directory'},
            'opt_dir_name': {'label': 'Opt. Directory Name', 'widget_type': 'QLineEdit', 'text': 'ga_opt'},
            'temp_analysis_dir_name': {'label': 'Temp. Analysis Dir. Name', 'widget_type': 'QLineEdit',
                                       'text': 'analysis_temp'},
        },
        'Constraints/Validation': {
            'min_val_of_max_thickness': {'label': 'Minimum Thickness', 'widget_type': 'QDoubleSpinBox',
                                         'setDecimals': 16, 'lower_bound': 0.0, 'upper_bound': np.inf, 'value': 0.10,
                                         'active_checkbox': 0},
            'check_thickness_at_points': {'label': 'Check Thickness Dist.?', 'widget_type': 'QCheckBox', 'state': 0},
            'thickness_at_points': {'label': 'Thickness Dist. File', 'widget_type': 'QLineEdit',
                                    'text': '', 'push_button': 'Choose file',
                                    'push_button_action': 'select_thickness_file'},
            'min_area': {'label': 'Mininmum Area', 'widget_type': 'QDoubleSpinBox',
                         'setDecimals': 16, 'lower_bound': 0.0, 'upper_bound': np.inf, 'value': 0.04,
                         'active_checkbox': 0},
            'use_internal_geometry': {'label': 'Internal Geometry Check?', 'widget_type': 'QCheckBox', 'state': 0},
            'internal_geometry_timing': {'label': 'Int. Geometry Timing', 'widget_type': 'QComboBox',
                                         'items': ['Before Aerodynamic Evaluation', 'After Aerodynamic Evaluation'],
                                         'current_text': 'Before Aerodynamic Evaluation',
                                         'tool_tip': 'The timing of the internal geometry fit check can be important\n'
                                                     'depending on whether the internal geometry should be rotated\n'
                                                     'with the airfoil angle of attack. If the internal geometry\n'
                                                     'can move with the airfoil angle of attack, '
                                                     'choose \'Before Aerodynamic Evaluation\' (faster).\nOtherwise, '
                                                     'choose \'After Aerodynamic Evaluation\' (slower).'},
            'internal_geometry': {'label': 'Internal Geometry File', 'widget_type': 'QLineEdit',
                                  'text': '', 'push_button': 'Choose file',
                                  'push_button_action': 'select_coord_file'},
            'use_external_geometry': {'label': 'External Geometry Check?', 'widget_type': 'QCheckBox', 'state': 0},
            'external_geometry_timing': {'label': 'Ext. Geometry Timing', 'widget_type': 'QComboBox',
                                         'items': ['Before Aerodynamic Evaluation', 'After Aerodynamic Evaluation'],
                                         'current_text': 'Before Aerodynamic Evaluation',
                                         'tool_tip': 'The timing of the external geometry fit check can be important\n'
                                                     'depending on whether the internal geometry should be rotated\n'
                                                     'with the airfoil angle of attack. If the external geometry\n'
                                                     'can move with the airfoil angle of attack, '
                                                     'choose \'Before Aerodynamic Evaluation\' (faster).\nOtherwise, '
                                                     'choose \'After Aerodynamic Evaluation\' (slower).'},
            'external_geometry': {'label': 'External Geometry File', 'widget_type': 'QLineEdit',
                                  'text': '', 'push_button': 'Choose file',
                                  'push_button_action': 'select_coord_file'},
        },
        'Termination': {
            'f_tol': {'label': 'Function Tolerance', 'widget_type': 'ScientificDoubleSpinBox', 'value': 2.5e-3,
                      'lower_bound': 0.0, 'upper_bound': 1e5},
            'cv_tol': {'label': 'Constraint Violation Tol.', 'widget_type': 'ScientificDoubleSpinBox',
                       'value': 1e-6, 'lower_bound': 0.0, 'upper_bound': 1e5},
            'x_tol': {'label': 'Parameter Tolerance', 'widget_type': 'ScientificDoubleSpinBox', 'value': 1e-8,
                      'lower_bound': 0.0, 'upper_bound': 1e5},
            'nth_gen': {'label': 'Termination Calc. Frequency', 'widget_type': 'QSpinBox', 'value': 10,
                        'lower_bound': 1, 'upper_bound': 1000000},
            'n_last': {'label': 'Num. Prev. Gens. to Check', 'widget_type': 'QSpinBox', 'value': 30,
                       'lower_bound': 1, 'upper_bound': 1000000},
            'n_max_gen': {'label': 'Maximum Generations', 'widget_type': 'QSpinBox', 'value': 500,
                          'lower_bound': 1, 'upper_bound': 1000000},
            'n_max_evals': {'label': 'Maximum Function Calls', 'widget_type': 'QSpinBox', 'value': 100000,
                            'lower_bound': 1, 'upper_bound': 1000000},
        },
        'XFOIL': {
            'Re': {'label': 'Reynolds Number', 'widget_type': 'QDoubleSpinBox', 'value': 1e5,
                   'setDecimals': 16, 'lower_bound': 0.00001, 'upper_bound': np.inf},
            'Ma': {'label': 'Mach Number', 'widget_type': 'QDoubleSpinBox', 'value': 0.0,
                   'setDecimals': 16, 'lower_bound': 0.0, 'upper_bound': 1.3},
            'prescribe': {'label': 'Prescribe ɑ/Cl/CLI', 'widget_type': 'QComboBox',
                          'items': ['Angle of Attack (deg)', 'Viscous Cl', 'Inviscid Cl'],
                          'combo_callback': 'change_prescribed_aero_parameter_xfoil',
                          'current_text': 'Angle of Attack (deg)'},
            'alfa': {'label': 'Angle of Attack (deg)', 'widget_type': 'QDoubleSpinBox', 'value': 0.0,
                     'setDecimals': 16, 'lower_bound': -np.inf, 'upper_bound': np.inf, 'editable': True},
            'Cl': {'label': 'Viscous Cl', 'widget_type': 'QDoubleSpinBox', 'value': 0.0,
                   'setDecimals': 16, 'lower_bound': -np.inf, 'upper_bound': np.inf, 'editable': False},
            'CLI': {'label': 'Inviscid Cl', 'widget_type': 'QDoubleSpinBox', 'value': 0.0,
                    'setDecimals': 16, 'lower_bound': -np.inf, 'upper_bound': np.inf, 'editable': False},
            'xtr_upper': {'label': 'Transition x/c (upper)', 'widget_type': 'QDoubleSpinBox', 'value': 1.0,
                          'setDecimals': 16, 'lower_bound': 0.0, 'upper_bound': 1.0},
            'xtr_lower': {'label': 'Transition x/c (lower)', 'widget_type': 'QDoubleSpinBox', 'value': 1.0,
                          'setDecimals': 16, 'lower_bound': 0.0, 'upper_bound': 1.0},
            'N': {'label': 'Turbulence (NCrit)', 'widget_type': 'QDoubleSpinBox', 'value': 9.0,
                  'setDecimals': 16, 'lower_bound': 0.0, 'upper_bound': 20.0},
            'iter': {'label': 'Maximum Iterations', 'widget_type': 'QSpinBox', 'value': 150,
                     'lower_bound': 1, 'upper_bound': 10000},
            'timeout': {'label': 'Timeout (sec)', 'widget_type': 'QDoubleSpinBox', 'value': 8.0,
                        'lower_bound': 0.0, 'upper_bound': 10000.0},
        },
        'MSET': mset_settings_default(mea_keys),
        'MSES': mses_settings_default(),
        'MPLOT': mplot_settings_default(),
        'Save/Load Settings': {
            'settings_load_dir': {'label': 'Settings File (Load)', 'widget_type': 'QLineEdit',
                                  'push_button': 'Choose file',
                                  'push_button_action': 'select_existing_json_file', 'text': ''},
            'load_settings': {'label': 'Load Settings File', 'widget_type': 'QPushButton',
                              'click_connect': 'load_opt_settings', 'button_title': 'Load'},
            'settings_save_dir': {'label': 'Settings File (Save)', 'widget_type': 'QLineEdit',
                                  'push_button': 'Choose file',
                                  'push_button_action': 'select_any_json_file', 'text': ''},
            'save_settings': {'label': 'Save Settings File', 'widget_type': 'QPushButton',
                              'click_connect': 'save_opt_settings', 'button_title': 'Save'},
            'settings_saveas_dir': {'label': 'Settings Dir (Save As)', 'widget_type': 'QLineEdit',
                                    'push_button': 'Choose folder',
                                    'push_button_action': 'select_directory_for_json_file', 'text': ''},
            'settings_saveas_filename': {'label': 'Settings Filename (Save As)', 'widget_type': 'QLineEdit',
                                         'text': 'opt_settings.json'},
            'saveas_settings': {'label': 'Save Settings File As', 'widget_type': 'QPushButton',
                                'click_connect': 'saveas_opt_settings', 'button_title': 'Save As'},
        },
    }
    return settings


def xfoil_settings_default(mea_keys: list):
    settings = {
            'airfoil': {'label': 'Airfoil', 'widget_type': 'QComboBox', 'items': mea_keys, 'current_text': mea_keys[0]},
            'Re': {'label': 'Reynolds Number', 'widget_type': 'QDoubleSpinBox', 'value': 1e5,
                   'setDecimals': 16, 'lower_bound': 0.00001, 'upper_bound': np.inf},
            'Ma': {'label': 'Mach Number', 'widget_type': 'QDoubleSpinBox', 'value': 0.0,
                   'setDecimals': 16, 'lower_bound': 0.0, 'upper_bound': 1.3},
            'prescribe': {'label': 'Prescribe ɑ/Cl/CLI', 'widget_type': 'QComboBox',
                          'items': ['Angle of Attack (deg)', 'Viscous Cl', 'Inviscid Cl'],
                          'combo_callback': 'change_prescribed_aero_parameter_xfoil',
                          'current_text': 'Angle of Attack (deg)'},
            'alfa': {'label': 'Angle of Attack (deg)', 'widget_type': 'QDoubleSpinBox', 'value': 0.0,
                     'setDecimals': 16, 'lower_bound': -np.inf, 'upper_bound': np.inf, 'editable': True},
            'Cl': {'label': 'Viscous Cl', 'widget_type': 'QDoubleSpinBox', 'value': 0.0,
                   'setDecimals': 16, 'lower_bound': -np.inf, 'upper_bound': np.inf, 'editable': False},
            'CLI': {'label': 'Inviscid Cl', 'widget_type': 'QDoubleSpinBox', 'value': 0.0,
                    'setDecimals': 16, 'lower_bound': -np.inf, 'upper_bound': np.inf, 'editable': False},
            'xtr_upper': {'label': 'Transition x/c (upper)', 'widget_type': 'QDoubleSpinBox', 'value': 1.0,
                          'setDecimals': 16, 'lower_bound': 0.0, 'upper_bound': 1.0},
            'xtr_lower': {'label': 'Transition x/c (lower)', 'widget_type': 'QDoubleSpinBox', 'value': 1.0,
                          'setDecimals': 16, 'lower_bound': 0.0, 'upper_bound': 1.0},
            'N': {'label': 'Turbulence (NCrit)', 'widget_type': 'QDoubleSpinBox', 'value': 9.0,
                  'setDecimals': 16, 'lower_bound': 0.0, 'upper_bound': 20.0},
            'iter': {'label': 'Maximum Iterations', 'widget_type': 'QSpinBox', 'value': 150,
                     'lower_bound': 1, 'upper_bound': 10000},
            'timeout': {'label': 'Timeout (sec)', 'widget_type': 'QDoubleSpinBox', 'value': 8.0,
                        'lower_bound': 0.0, 'upper_bound': 10000.0},
            'body_fixed_csys': {'label': 'Body-fixed CSYS?', 'widget_type': 'QCheckBox', 'state': 0,
                                'tool_tip': 'Select if the airfoil should be analyzed with dx=dy=alf=0.0 and c=1'},
            'airfoil_analysis_dir': {'label': 'Analysis Directory', 'widget_type': 'QLineEdit',
                                     'push_button': 'Choose folder',
                                     'push_button_action': 'select_directory_for_airfoil_analysis', 'text': ''},
            'airfoil_coord_file_name': {'label': 'Airfoil Coord. Filename', 'widget_type': 'QLineEdit',
                                        'text': 'default_airfoil'},
        }
    return settings
