#
#   Copyright (c) 2021 eGauge Systems LLC
# 	1644 Conestoga St, Suite 2
# 	Boulder, CO 80301
# 	voice: 720-545-9767
# 	email: davidm@egauge.net
#
#   All rights reserved.
#
#   This code is the property of eGauge Systems LLC and may not be
#   copied, modified, or disclosed without any prior and written
#   permission from eGauge Systems LLC.
#
# pylint: disable=too-few-public-methods
"""This module provides constants and functions common to both the
Django-based server and code that uses the EPIC API (without Django).
In other words, this module may not have any Django imports or
dependencies.

"""


class Enum:
    MOUNTING_SMD = 0
    MOUNTING_THD = 1
    MOUNTING_CHASSIS = 2
    MOUNTING_FREE = 3
    MOUNTING_CHOICES = (
        (MOUNTING_SMD, "SMD"),
        (MOUNTING_THD, "THD"),
        (MOUNTING_CHASSIS, "chassis"),
        (MOUNTING_FREE, "free"),
    )
    STATUS_PREVIEW = 0
    STATUS_ACTIVE = 1
    STATUS_PREFERRED = 2
    STATUS_DEPRECATED = 3
    STATUS_OBSOLETE = 4
    STATUS_CHOICES = (
        (STATUS_PREVIEW, "preview"),
        (STATUS_ACTIVE, "active"),
        (STATUS_PREFERRED, "preferred"),
        (STATUS_DEPRECATED, "deprecated"),
        (STATUS_OBSOLETE, "obsolete"),
    )
    # deprecated parts are orderable, but preview or obsolete parts
    # are not:
    STATUS_ORDERABLE = (STATUS_ACTIVE, STATUS_PREFERRED, STATUS_DEPRECATED)

    # What modified a part's BOM (assembly-items list) last.  USER
    # means that the BOM was edited by an interactive user whereas
    # TOOL means it was generated by an automated tool (e.g.,
    # kicad-to-epic-bom).
    LAST_MOD_TYPE_USER = 0
    LAST_MOD_TYPE_TOOL = 1
    LAST_MOD_CHOICES = (
        (LAST_MOD_TYPE_USER, "user"),
        (LAST_MOD_TYPE_TOOL, "tool"),
    )

    TXTN_STATUS_OPEN = 0
    TXTN_STATUS_CLOSED = 1
    TXTN_STATUS_CHOICES = (
        (TXTN_STATUS_OPEN, "open"),
        (TXTN_STATUS_CLOSED, "closed"),
    )


def format_part_number(part):
    return "EP%05u" % part


def strchoice(choices, val):
    for key, name in choices:
        if key == val:
            return name
    return val
