"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accountupdaterinquirysummary import (
    AccountUpdaterInquirySummary,
    AccountUpdaterInquirySummaryTypedDict,
)
from datetime import datetime
from gr4vy.types import BaseModel
from gr4vy.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Optional
from typing_extensions import Annotated, TypedDict


class AccountUpdaterJobTypedDict(TypedDict):
    id: str
    r"""The ID for the account updater job."""
    merchant_account_id: str
    r"""The ID of the merchant account this job belongs to."""
    inquiries: List[AccountUpdaterInquirySummaryTypedDict]
    r"""A list of the payment methods that have been scheduled for an update."""
    created_at: datetime
    r"""The date and time when this payment method was first created in our system."""
    updated_at: datetime
    r"""The date and time when this payment method was last updated in our system."""
    type: Literal["account-updater-job"]
    r"""Always `account-updater-job`"""


class AccountUpdaterJob(BaseModel):
    id: str
    r"""The ID for the account updater job."""

    merchant_account_id: str
    r"""The ID of the merchant account this job belongs to."""

    inquiries: List[AccountUpdaterInquirySummary]
    r"""A list of the payment methods that have been scheduled for an update."""

    created_at: datetime
    r"""The date and time when this payment method was first created in our system."""

    updated_at: datetime
    r"""The date and time when this payment method was last updated in our system."""

    TYPE: Annotated[
        Annotated[
            Optional[Literal["account-updater-job"]],
            AfterValidator(validate_const("account-updater-job")),
        ],
        pydantic.Field(alias="type"),
    ] = "account-updater-job"
    r"""Always `account-updater-job`"""
