"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CheckoutSessionPaymentMethodCreateTypedDict(TypedDict):
    id: str
    r"""The ID for the checkout session."""
    method: Literal["checkout-session"]
    r"""Always `checkout-session`"""
    external_identifier: NotRequired[Nullable[str]]
    r"""The merchant reference that can be used to match the payment method against your own records."""
    buyer_id: NotRequired[Nullable[str]]
    r"""The `id` of a stored buyer to use Use this instead of the `buyer_external_identifier`."""
    buyer_external_identifier: NotRequired[Nullable[str]]
    r"""The `external_identifier` of a stored buyer to use. Use this instead of the `buyer_id`."""


class CheckoutSessionPaymentMethodCreate(BaseModel):
    id: str
    r"""The ID for the checkout session."""

    METHOD: Annotated[
        Annotated[
            Optional[Literal["checkout-session"]],
            AfterValidator(validate_const("checkout-session")),
        ],
        pydantic.Field(alias="method"),
    ] = "checkout-session"
    r"""Always `checkout-session`"""

    external_identifier: OptionalNullable[str] = UNSET
    r"""The merchant reference that can be used to match the payment method against your own records."""

    buyer_id: OptionalNullable[str] = UNSET
    r"""The `id` of a stored buyer to use Use this instead of the `buyer_external_identifier`."""

    buyer_external_identifier: OptionalNullable[str] = UNSET
    r"""The `external_identifier` of a stored buyer to use. Use this instead of the `buyer_id`."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "method",
            "external_identifier",
            "buyer_id",
            "buyer_external_identifier",
        ]
        nullable_fields = [
            "external_identifier",
            "buyer_id",
            "buyer_external_identifier",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
