"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PayoutPaymentServiceTypedDict(TypedDict):
    payment_service_definition_id: str
    r"""The ID of the connection used for this payout."""
    type: Literal["payment-service"]
    r"""Always `payment-service`."""
    id: NotRequired[Nullable[str]]
    r"""The ID for the payout service."""
    method: Literal["card"]
    r"""Always `card`."""
    display_name: NotRequired[Nullable[str]]
    r"""The display name of the connection used for this payout."""


class PayoutPaymentService(BaseModel):
    payment_service_definition_id: str
    r"""The ID of the connection used for this payout."""

    TYPE: Annotated[
        Annotated[
            Optional[Literal["payment-service"]],
            AfterValidator(validate_const("payment-service")),
        ],
        pydantic.Field(alias="type"),
    ] = "payment-service"
    r"""Always `payment-service`."""

    id: OptionalNullable[str] = UNSET
    r"""The ID for the payout service."""

    METHOD: Annotated[
        Annotated[Optional[Literal["card"]], AfterValidator(validate_const("card"))],
        pydantic.Field(alias="method"),
    ] = "card"
    r"""Always `card`."""

    display_name: OptionalNullable[str] = UNSET
    r"""The display name of the connection used for this payout."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["type", "id", "method", "display_name"]
        nullable_fields = ["id", "display_name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
