"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .reportcreatortype import ReportCreatorType
from .reportexecutionsummary import (
    ReportExecutionSummary,
    ReportExecutionSummaryTypedDict,
)
from .reportschedule import ReportSchedule
from .reportspec import ReportSpec, ReportSpecTypedDict
from datetime import datetime
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ReportTypedDict(TypedDict):
    id: str
    r"""The unique ID for the report."""
    merchant_account_id: str
    r"""The merchant account ID this report belongs to."""
    name: str
    r"""The name of the report."""
    created_at: datetime
    r"""The date this report was created at."""
    updated_at: datetime
    r"""The date this report was last updated."""
    schedule: ReportSchedule
    schedule_enabled: bool
    r"""Whether the report schedule is enabled."""
    schedule_timezone: str
    r"""The timezone for the report schedule."""
    spec: ReportSpecTypedDict
    type: Literal["report"]
    r"""Always `report`."""
    creator_id: NotRequired[Nullable[str]]
    r"""The ID of the user who created the report."""
    creator_display_name: NotRequired[Nullable[str]]
    r"""The display name of the report creator."""
    creator_type: NotRequired[Nullable[ReportCreatorType]]
    r"""The type of the report creator."""
    next_execution_at: NotRequired[Nullable[datetime]]
    r"""The next scheduled execution time for the report."""
    description: NotRequired[Nullable[str]]
    r"""A description of the report."""
    latest_execution: NotRequired[Nullable[ReportExecutionSummaryTypedDict]]
    r"""The latest execution summary for the report."""


class Report(BaseModel):
    id: str
    r"""The unique ID for the report."""

    merchant_account_id: str
    r"""The merchant account ID this report belongs to."""

    name: str
    r"""The name of the report."""

    created_at: datetime
    r"""The date this report was created at."""

    updated_at: datetime
    r"""The date this report was last updated."""

    schedule: Annotated[ReportSchedule, PlainValidator(validate_open_enum(False))]

    schedule_enabled: bool
    r"""Whether the report schedule is enabled."""

    schedule_timezone: str
    r"""The timezone for the report schedule."""

    spec: ReportSpec

    TYPE: Annotated[
        Annotated[
            Optional[Literal["report"]], AfterValidator(validate_const("report"))
        ],
        pydantic.Field(alias="type"),
    ] = "report"
    r"""Always `report`."""

    creator_id: OptionalNullable[str] = UNSET
    r"""The ID of the user who created the report."""

    creator_display_name: OptionalNullable[str] = UNSET
    r"""The display name of the report creator."""

    creator_type: Annotated[
        OptionalNullable[ReportCreatorType], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The type of the report creator."""

    next_execution_at: OptionalNullable[datetime] = UNSET
    r"""The next scheduled execution time for the report."""

    description: OptionalNullable[str] = UNSET
    r"""A description of the report."""

    latest_execution: OptionalNullable[ReportExecutionSummary] = UNSET
    r"""The latest execution summary for the report."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "type",
            "creator_id",
            "creator_display_name",
            "creator_type",
            "next_execution_at",
            "description",
            "latest_execution",
        ]
        nullable_fields = [
            "creator_id",
            "creator_display_name",
            "creator_type",
            "next_execution_at",
            "description",
            "latest_execution",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
