"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class StatementDescriptorTypedDict(TypedDict):
    r"""Information to show the user on their payments statement"""

    name: NotRequired[Nullable[str]]
    r"""Reflects your doing business as (DBA) name."""
    description: NotRequired[Nullable[str]]
    r"""A short description about the purchase."""
    city: NotRequired[Nullable[str]]
    r"""The merchant's city to be displayed in a statement descriptor."""
    country: NotRequired[Nullable[str]]
    r"""The 2-letter ISO country code of the merchant to be displayed in a statement descriptor."""
    phone_number: NotRequired[Nullable[str]]
    r"""The value in the phone number field of a customer's statement which should be formatted according to the E164 number standard."""
    url: NotRequired[Nullable[str]]
    r"""The merchant's URL to be displayed in a statement descriptor."""
    postal_code: NotRequired[Nullable[str]]
    r"""The merchant's postal code or zip code."""


class StatementDescriptor(BaseModel):
    r"""Information to show the user on their payments statement"""

    name: OptionalNullable[str] = UNSET
    r"""Reflects your doing business as (DBA) name."""

    description: OptionalNullable[str] = UNSET
    r"""A short description about the purchase."""

    city: OptionalNullable[str] = UNSET
    r"""The merchant's city to be displayed in a statement descriptor."""

    country: OptionalNullable[str] = UNSET
    r"""The 2-letter ISO country code of the merchant to be displayed in a statement descriptor."""

    phone_number: OptionalNullable[str] = UNSET
    r"""The value in the phone number field of a customer's statement which should be formatted according to the E164 number standard."""

    url: OptionalNullable[str] = UNSET
    r"""The merchant's URL to be displayed in a statement descriptor."""

    postal_code: OptionalNullable[str] = UNSET
    r"""The merchant's postal code or zip code."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "description",
            "city",
            "country",
            "phone_number",
            "url",
            "postal_code",
        ]
        nullable_fields = [
            "name",
            "description",
            "city",
            "country",
            "phone_number",
            "url",
            "postal_code",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
