"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from gr4vy.types import BaseModel, UnrecognizedStr
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Any, Dict, Literal, Optional, Union
from typing_extensions import Annotated, TypedDict


Name = Union[
    Literal[
        "transaction-updated-status",
        "transaction-sync-event",
        "transaction-sync-failed-event",
        "transaction-modified-event",
        "transaction-api-request",
        "transaction-api-response",
        "bin-lookup-request",
        "three-d-secure-success",
        "three-d-secure-request-error",
        "three-d-secure-preparation-request",
        "three-d-secure-authentication-request",
        "three-d-secure-result-request",
        "anti-fraud-decision",
        "anti-fraud-decision-error",
        "anti-fraud-decision-skipped",
        "anti-fraud-webhook",
        "anti-fraud-transaction-status-update",
        "anti-fraud-transaction-status-update-error",
        "anti-fraud-decision-update",
        "anti-fraud-decision-update-error",
        "gift-card-redemption-succeeded",
        "gift-card-redemption-failed",
        "gift-card-refund-succeeded",
        "gift-card-refund-failed",
        "gift-card-reversal-succeeded",
        "payment-connector-response-transaction-authorization-succeeded",
        "payment-connector-response-transaction-capture-succeeded",
        "payment-connector-response-transaction-authorization-failed",
        "payment-connector-response-transaction-declined",
        "payment-connector-response-transaction-capture-failed",
        "payment-connector-response-transaction-capture-declined",
        "payment-connector-response-transaction-cancel-succeeded",
        "payment-connector-response-transaction-cancel-pending",
        "payment-connector-response-transaction-cancel-failed",
        "payment-connector-response-transaction-void-succeeded",
        "payment-connector-response-transaction-void-declined",
        "payment-connector-response-transaction-void-failed",
        "payment-connector-external-transaction-request",
        "payment-connector-report-transaction-settled",
        "payment-connector-report-chargeback-posted",
        "payment-connector-report-chargeback-reversal-posted",
        "digital-wallet-apple-pay-token-decrypted",
        "digital-wallet-google-pay-token-decrypted",
        "digital-wallet-click-to-pay-token-decrypted",
        "network-token-provision-succeeded",
        "network-token-provision-failed",
        "network-token-cryptogram-provision-succeeded",
        "network-token-cryptogram-provision-failed",
        "the-giving-block-transaction-conversion-succeeded",
        "real-time-account-update",
    ],
    UnrecognizedStr,
]
r"""The specific event name."""


class TransactionEventTypedDict(TypedDict):
    id: str
    r"""The ID for the event."""
    name: Name
    r"""The specific event name."""
    created_at: datetime
    r"""The date this event was created at."""
    context: Dict[str, Any]
    type: Literal["transaction-event"]
    r"""Always `transaction-event`."""


class TransactionEvent(BaseModel):
    id: str
    r"""The ID for the event."""

    name: Annotated[Name, PlainValidator(validate_open_enum(False))]
    r"""The specific event name."""

    created_at: datetime
    r"""The date this event was created at."""

    context: Dict[str, Any]

    TYPE: Annotated[
        Annotated[
            Optional[Literal["transaction-event"]],
            AfterValidator(validate_const("transaction-event")),
        ],
        pydantic.Field(alias="type"),
    ] = "transaction-event"
    r"""Always `transaction-event`."""
