"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .transactionconnectionoptions import (
    TransactionConnectionOptions,
    TransactionConnectionOptionsTypedDict,
)
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Dict
from typing_extensions import NotRequired, TypedDict


class TransactionUpdateTypedDict(TypedDict):
    external_identifier: NotRequired[Nullable[str]]
    r"""An external identifier that can be used to match the transaction against your own records."""
    metadata: NotRequired[Nullable[Dict[str, str]]]
    r"""Additional information about the transaction stored as key-value pairs. If provided, the whole value will be overridden."""
    connection_options: NotRequired[Nullable[TransactionConnectionOptionsTypedDict]]
    r"""Allows for passing optional configuration per connection to take advantage of connection specific features. When provided, the data is only passed to the target connection type to prevent sharing configuration across connections. Please note that each of the keys this object are in kebab-case, for example `cybersource-anti-fraud` as they represent the ID of the connector. All the other keys will be snake case, for example `merchant_defined_data` or camel case to match an external API that the connector uses. If provided, the whole value will be overridden."""


class TransactionUpdate(BaseModel):
    external_identifier: OptionalNullable[str] = UNSET
    r"""An external identifier that can be used to match the transaction against your own records."""

    metadata: OptionalNullable[Dict[str, str]] = UNSET
    r"""Additional information about the transaction stored as key-value pairs. If provided, the whole value will be overridden."""

    connection_options: OptionalNullable[TransactionConnectionOptions] = UNSET
    r"""Allows for passing optional configuration per connection to take advantage of connection specific features. When provided, the data is only passed to the target connection type to prevent sharing configuration across connections. Please note that each of the keys this object are in kebab-case, for example `cybersource-anti-fraud` as they represent the ID of the connector. All the other keys will be snake case, for example `merchant_defined_data` or camel case to match an external API that the connector uses. If provided, the whole value will be overridden."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["external_identifier", "metadata", "connection_options"]
        nullable_fields = ["external_identifier", "metadata", "connection_options"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
