from setuptools import setup, find_packages

setup(
    name="batem",
    version="0.1.2",
    packages=find_packages(),
    install_requires=[
        "ipython",
        "ipywidgets",
        "nbformat",
        "joblib",
        "matplotlib",
        "networkx",
        "numpy",
        "openpyxl",
        "pandas",
        "plotly",
        "prettytable",
        "psychrochart",
        "PyExcelerate",
        "importlib-metadata",
        "pymor",
        "pytz",
        "Requests",
        "SALib",
        "hplib",
        "scipy",
        "SQLAlchemy",
        "tzlocal",
        "tomlkit",
        "timezonefinder",
        "windrose",
        "kaleido",
        "ipympl",
        "weasyprint",
        "CoolProp",
        "db-sqlite3"
    ],
    python_requires=">=3.8",
    author="Stephane Ploix",
    description="Batem energy modeling package",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown"
)
