import { IConstruct } from "constructs";
/**
 * @experimental
 */
export declare enum AnnotationMetadataEntryType {
    /**
     * @experimental
     */
    INFO = "@cdktf/info",
    /**
     * @experimental
     */
    WARN = "@cdktf/warn",
    /**
     * @experimental
     */
    ERROR = "@cdktf/error"
}
export declare const DISABLE_STACK_TRACE_IN_METADATA = "@cdktf/disable_stack_trace_in_metadata";
/**
 * (experimental) Includes API for attaching annotations such as warning messages to constructs.
 *
 * @experimental
 */
export declare class Annotations {
    private readonly scope;
    /**
     * (experimental) Returns the annotations API for a construct scope.
     *
     * @param scope The scope.
     * @experimental
     */
    static of(scope: IConstruct): Annotations;
    private readonly stackTraces;
    private constructor();
    /**
     * (experimental) Adds a warning metadata entry to this construct.
     *
     * The CLI will display the warning when an app is synthesized.
     * In a future release the CLI might introduce a --strict flag which
     * will then fail the synthesis if it encounters a warning.
     *
     * @param message The warning message.
     * @experimental
     */
    addWarning(message: string): void;
    /**
     * (experimental) Adds an info metadata entry to this construct.
     *
     * The CLI will display the info message when apps are synthesized.
     *
     * @param message The info message.
     * @experimental
     */
    addInfo(message: string): void;
    /**
     * (experimental) Adds an { "error": <message> } metadata entry to this construct.
     *
     * The toolkit will fail synthesis when errors are reported.
     *
     * @param message The error message.
     * @experimental
     */
    addError(message: string): void;
    /**
     * Adds a message metadata entry to the construct node, to be displayed by the CDK CLI.
     * @param level The message level
     * @param message The message itself
     */
    private addMessage;
}
