"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Annotations = exports.DISABLE_STACK_TRACE_IN_METADATA = exports.AnnotationMetadataEntryType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * @experimental
 */
var AnnotationMetadataEntryType;
(function (AnnotationMetadataEntryType) {
    AnnotationMetadataEntryType["INFO"] = "@cdktf/info";
    AnnotationMetadataEntryType["WARN"] = "@cdktf/warn";
    AnnotationMetadataEntryType["ERROR"] = "@cdktf/error";
})(AnnotationMetadataEntryType = exports.AnnotationMetadataEntryType || (exports.AnnotationMetadataEntryType = {}));
exports.DISABLE_STACK_TRACE_IN_METADATA = "@cdktf/disable_stack_trace_in_metadata";
/**
 * (experimental) Includes API for attaching annotations such as warning messages to constructs.
 *
 * @experimental
 */
class Annotations {
    constructor(scope) {
        this.scope = scope;
        const disableTrace = scope.node.tryGetContext(exports.DISABLE_STACK_TRACE_IN_METADATA) || false;
        this.stackTraces = !disableTrace;
    }
    /**
     * (experimental) Returns the annotations API for a construct scope.
     *
     * @param scope The scope.
     * @experimental
     */
    static of(scope) {
        return new Annotations(scope);
    }
    /**
     * (experimental) Adds a warning metadata entry to this construct.
     *
     * The CLI will display the warning when an app is synthesized.
     * In a future release the CLI might introduce a --strict flag which
     * will then fail the synthesis if it encounters a warning.
     *
     * @param message The warning message.
     * @experimental
     */
    addWarning(message) {
        this.addMessage(AnnotationMetadataEntryType.WARN, message);
    }
    /**
     * (experimental) Adds an info metadata entry to this construct.
     *
     * The CLI will display the info message when apps are synthesized.
     *
     * @param message The info message.
     * @experimental
     */
    addInfo(message) {
        this.addMessage(AnnotationMetadataEntryType.INFO, message);
    }
    /**
     * (experimental) Adds an { "error": <message> } metadata entry to this construct.
     *
     * The toolkit will fail synthesis when errors are reported.
     *
     * @param message The error message.
     * @experimental
     */
    addError(message) {
        this.addMessage(AnnotationMetadataEntryType.ERROR, message);
    }
    /**
     * Adds a message metadata entry to the construct node, to be displayed by the CDK CLI.
     * @param level The message level
     * @param message The message itself
     */
    addMessage(level, message) {
        this.scope.node.addMetadata(level, message, {
            stackTrace: this.stackTraces,
        });
    }
}
exports.Annotations = Annotations;
_a = JSII_RTTI_SYMBOL_1;
Annotations[_a] = { fqn: "cdktf.Annotations", version: "0.9.0-pre.6" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYW5ub3RhdGlvbnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJhbm5vdGF0aW9ucy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7OztBQUtBLElBQVksMkJBSVg7QUFKRCxXQUFZLDJCQUEyQjtJQUNyQyxtREFBb0IsQ0FBQTtJQUNwQixtREFBb0IsQ0FBQTtJQUNwQixxREFBc0IsQ0FBQTtBQUN4QixDQUFDLEVBSlcsMkJBQTJCLEdBQTNCLG1DQUEyQixLQUEzQixtQ0FBMkIsUUFJdEM7QUFFWSxRQUFBLCtCQUErQixHQUMxQyx3Q0FBd0MsQ0FBQzs7Ozs7O0FBRzNDLE1BQWEsV0FBVztJQVF0QixZQUFxQyxLQUFpQjtRQUFqQixVQUFLLEdBQUwsS0FBSyxDQUFZO1FBQ3BELE1BQU0sWUFBWSxHQUNoQixLQUFLLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyx1Q0FBK0IsQ0FBQyxJQUFJLEtBQUssQ0FBQztRQUVyRSxJQUFJLENBQUMsV0FBVyxHQUFHLENBQUMsWUFBWSxDQUFDO0lBQ25DLENBQUM7Ozs7Ozs7SUFYTSxNQUFNLENBQUMsRUFBRSxDQUFDLEtBQWlCO1FBQ2hDLE9BQU8sSUFBSSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDaEMsQ0FBQzs7Ozs7Ozs7Ozs7SUFZTSxVQUFVLENBQUMsT0FBZTtRQUMvQixJQUFJLENBQUMsVUFBVSxDQUFDLDJCQUEyQixDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsQ0FBQztJQUM3RCxDQUFDOzs7Ozs7Ozs7SUFHTSxPQUFPLENBQUMsT0FBZTtRQUM1QixJQUFJLENBQUMsVUFBVSxDQUFDLDJCQUEyQixDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsQ0FBQztJQUM3RCxDQUFDOzs7Ozs7Ozs7SUFHTSxRQUFRLENBQUMsT0FBZTtRQUM3QixJQUFJLENBQUMsVUFBVSxDQUFDLDJCQUEyQixDQUFDLEtBQUssRUFBRSxPQUFPLENBQUMsQ0FBQztJQUM5RCxDQUFDO0lBRUQ7Ozs7T0FJRztJQUNLLFVBQVUsQ0FBQyxLQUFrQyxFQUFFLE9BQWU7UUFDcEUsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssRUFBRSxPQUFPLEVBQUU7WUFDMUMsVUFBVSxFQUFFLElBQUksQ0FBQyxXQUFXO1NBQzdCLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBdkNILGtDQXdDQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIE9yaWdpbmFsbHkgZnJvbSBhd3MtY2RrIHYyIGJlY2F1c2Ugd2l0aCBjb25zdHJ1Y3RzIHYxMCBhZGRNZXNzYWdlIHdhcyByZW1vdmVkXG4vLyBpbiBmYXZvciBvZiBBbm5vdGF0aW9ucyBpbiB0aGUgQVdTIENES1xuLy8gaHR0cHM6Ly9naXRodWIuY29tL2F3cy9hd3MtY2RrL2Jsb2IvZGNhZTNlZWFkMGRiZjlhY2IxZWQ4MGJhOTViYjEwNGM2NGNiMWJkNy9wYWNrYWdlcy9AYXdzLWNkay9jb3JlL2xpYi9hbm5vdGF0aW9ucy50c1xuaW1wb3J0IHsgSUNvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5cbmV4cG9ydCBlbnVtIEFubm90YXRpb25NZXRhZGF0YUVudHJ5VHlwZSB7XG4gIElORk8gPSBcIkBjZGt0Zi9pbmZvXCIsXG4gIFdBUk4gPSBcIkBjZGt0Zi93YXJuXCIsXG4gIEVSUk9SID0gXCJAY2RrdGYvZXJyb3JcIixcbn1cblxuZXhwb3J0IGNvbnN0IERJU0FCTEVfU1RBQ0tfVFJBQ0VfSU5fTUVUQURBVEEgPVxuICBcIkBjZGt0Zi9kaXNhYmxlX3N0YWNrX3RyYWNlX2luX21ldGFkYXRhXCI7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgQW5ub3RhdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBvZihzY29wZTogSUNvbnN0cnVjdCkge1xuICAgIHJldHVybiBuZXcgQW5ub3RhdGlvbnMoc2NvcGUpO1xuICB9XG5cbiAgcHJpdmF0ZSByZWFkb25seSBzdGFja1RyYWNlczogYm9vbGVhbjtcblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgc2NvcGU6IElDb25zdHJ1Y3QpIHtcbiAgICBjb25zdCBkaXNhYmxlVHJhY2UgPVxuICAgICAgc2NvcGUubm9kZS50cnlHZXRDb250ZXh0KERJU0FCTEVfU1RBQ0tfVFJBQ0VfSU5fTUVUQURBVEEpIHx8IGZhbHNlO1xuXG4gICAgdGhpcy5zdGFja1RyYWNlcyA9ICFkaXNhYmxlVHJhY2U7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBhZGRXYXJuaW5nKG1lc3NhZ2U6IHN0cmluZykge1xuICAgIHRoaXMuYWRkTWVzc2FnZShBbm5vdGF0aW9uTWV0YWRhdGFFbnRyeVR5cGUuV0FSTiwgbWVzc2FnZSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYWRkSW5mbyhtZXNzYWdlOiBzdHJpbmcpOiB2b2lkIHtcbiAgICB0aGlzLmFkZE1lc3NhZ2UoQW5ub3RhdGlvbk1ldGFkYXRhRW50cnlUeXBlLklORk8sIG1lc3NhZ2UpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYWRkRXJyb3IobWVzc2FnZTogc3RyaW5nKSB7XG4gICAgdGhpcy5hZGRNZXNzYWdlKEFubm90YXRpb25NZXRhZGF0YUVudHJ5VHlwZS5FUlJPUiwgbWVzc2FnZSk7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIG1lc3NhZ2UgbWV0YWRhdGEgZW50cnkgdG8gdGhlIGNvbnN0cnVjdCBub2RlLCB0byBiZSBkaXNwbGF5ZWQgYnkgdGhlIENESyBDTEkuXG4gICAqIEBwYXJhbSBsZXZlbCBUaGUgbWVzc2FnZSBsZXZlbFxuICAgKiBAcGFyYW0gbWVzc2FnZSBUaGUgbWVzc2FnZSBpdHNlbGZcbiAgICovXG4gIHByaXZhdGUgYWRkTWVzc2FnZShsZXZlbDogQW5ub3RhdGlvbk1ldGFkYXRhRW50cnlUeXBlLCBtZXNzYWdlOiBzdHJpbmcpIHtcbiAgICB0aGlzLnNjb3BlLm5vZGUuYWRkTWV0YWRhdGEobGV2ZWwsIG1lc3NhZ2UsIHtcbiAgICAgIHN0YWNrVHJhY2U6IHRoaXMuc3RhY2tUcmFjZXMsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==