import { Construct } from "constructs";
import { Manifest } from "./manifest";
export declare const CONTEXT_ENV = "CDKTF_CONTEXT_JSON";
/**
 * @experimental
 */
export interface AppOptions {
    /**
     * (experimental) The directory to output Terraform resources.
     *
     * @default - CDKTF_OUTDIR if defined, otherwise "cdktf.out"
     * @experimental
     */
    readonly outdir?: string;
    /**
     * @experimental
     */
    readonly stackTraces?: boolean;
    /**
     * (experimental) Additional context values for the application.
     *
     * Context set by the CLI or the `context` key in `cdktf.json` has precedence.
     *
     * Context can be read from any construct using `node.getContext(key)`.
     *
     * @default - no additional context
     * @experimental
     */
    readonly context?: {
        [key: string]: any;
    };
    /**
     * (experimental) Whether to skip the validation during synthesis of the app.
     *
     * @default - false
     * @experimental
     */
    readonly skipValidation?: boolean;
}
/**
 * (experimental) Represents a cdktf application.
 *
 * @experimental
 */
export declare class App extends Construct {
    /**
     * (experimental) The output directory into which resources will be synthesized.
     *
     * @experimental
     */
    readonly outdir: string;
    /**
     * (experimental) The stack which will be synthesized.
     *
     * If not set, all stacks will be synthesized.
     *
     * @experimental
     */
    readonly targetStackId: string | undefined;
    /**
     * @experimental
     */
    readonly manifest: Manifest;
    /**
     * (experimental) Whether to skip the validation during synthesis of the app.
     *
     * @experimental
     */
    readonly skipValidation?: boolean;
    /**
     * (experimental) Defines an app.
     *
     * @param options configuration options.
     * @experimental
     */
    constructor(options?: AppOptions);
    /**
     * (experimental) Synthesizes all resources to the output directory.
     *
     * @experimental
     */
    synth(): void;
    private loadContext;
}
