"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.App = exports.CONTEXT_ENV = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const fs = require("fs");
const package_json_1 = require("../package.json");
const annotations_1 = require("./annotations");
const manifest_1 = require("./manifest");
const terraform_stack_1 = require("./terraform-stack");
exports.CONTEXT_ENV = "CDKTF_CONTEXT_JSON";
/**
 * (experimental) Represents a cdktf application.
 *
 * @experimental
 */
class App extends constructs_1.Construct {
    /**
     * (experimental) Defines an app.
     *
     * @param options configuration options.
     * @experimental
     */
    constructor(options = {}) {
        var _b, _c;
        super(undefined, "");
        this.outdir = (_c = (_b = process.env.CDKTF_OUTDIR) !== null && _b !== void 0 ? _b : options.outdir) !== null && _c !== void 0 ? _c : "cdktf.out";
        this.targetStackId = process.env.CDKTF_TARGET_STACK_ID;
        this.skipValidation = options.skipValidation;
        this.loadContext(options.context);
        const node = this.node;
        if (options.stackTraces === false) {
            node.setContext(annotations_1.DISABLE_STACK_TRACE_IN_METADATA, true);
        }
        node.setContext("cdktfVersion", package_json_1.version);
        if (!fs.existsSync(this.outdir)) {
            fs.mkdirSync(this.outdir);
        }
        this.manifest = new manifest_1.Manifest(package_json_1.version, this.outdir);
    }
    /**
     * (experimental) Synthesizes all resources to the output directory.
     *
     * @experimental
     */
    synth() {
        const session = {
            outdir: this.outdir,
            skipValidation: this.skipValidation,
            manifest: this.manifest,
        };
        const stacks = this.node
            .findAll()
            .filter((c) => c instanceof terraform_stack_1.TerraformStack);
        stacks.forEach((stack) => stack.synthesizer.synthesize(session));
        this.manifest.writeToFile();
    }
    loadContext(defaults = {}) {
        const node = this.node;
        // prime with defaults passed through constructor
        for (const [k, v] of Object.entries(defaults)) {
            node.setContext(k, v);
        }
        // read from environment
        const contextJson = process.env[exports.CONTEXT_ENV];
        const contextFromEnvironment = contextJson ? JSON.parse(contextJson) : {};
        for (const [k, v] of Object.entries(contextFromEnvironment)) {
            node.setContext(k, v);
        }
    }
}
exports.App = App;
_a = JSII_RTTI_SYMBOL_1;
App[_a] = { fqn: "cdktf.App", version: "0.9.0-pre.6" };
//# sourceMappingURL=data:application/json;base64,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