"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Aspects = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ASPECTS_SYMBOL = Symbol("cdktf-aspects");
/**
 * (experimental) Aspects can be applied to CDK tree scopes and can operate on the tree before synthesis.
 *
 * @experimental
 */
class Aspects {
    constructor() {
        this._aspects = [];
    }
    /**
     * (experimental) Returns the `Aspects` object associated with a construct scope.
     *
     * @param scope The scope for which these aspects will apply.
     * @experimental
     */
    static of(scope) {
        let aspects = scope[ASPECTS_SYMBOL];
        if (!aspects) {
            aspects = new Aspects();
            Object.defineProperty(scope, ASPECTS_SYMBOL, {
                value: aspects,
                configurable: false,
                enumerable: false,
            });
        }
        return aspects;
    }
    /**
     * (experimental) Adds an aspect to apply this scope before synthesis.
     *
     * @param aspect The aspect to add.
     * @experimental
     */
    add(aspect) {
        this._aspects.push(aspect);
    }
    /**
     * (experimental) The list of aspects which were directly applied on this scope.
     *
     * @experimental
     */
    get all() {
        return [...this._aspects];
    }
}
exports.Aspects = Aspects;
_a = JSII_RTTI_SYMBOL_1;
Aspects[_a] = { fqn: "cdktf.Aspects", version: "0.9.0-pre.6" };
//# sourceMappingURL=data:application/json;base64,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