import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
/**
 * @experimental
 */
export declare class OssBackend extends TerraformBackend {
    private readonly props;
    /**
     * @experimental
     */
    constructor(scope: Construct, props: OssBackendProps);
    /**
     * @experimental
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
/**
 * @experimental
 */
export declare class DataTerraformRemoteStateOss extends TerraformRemoteState {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateOssConfig);
}
/**
 * @experimental
 */
export interface OssBackendProps {
    /**
     * @experimental
     */
    readonly accessKey?: string;
    /**
     * @experimental
     */
    readonly secretKey?: string;
    /**
     * @experimental
     */
    readonly securityToken?: string;
    /**
     * @experimental
     */
    readonly ecsRoleName?: string;
    /**
     * @experimental
     */
    readonly region?: string;
    /**
     * @experimental
     */
    readonly endpoint?: string;
    /**
     * @experimental
     */
    readonly bucket: string;
    /**
     * @experimental
     */
    readonly prefix?: string;
    /**
     * @experimental
     */
    readonly key?: string;
    /**
     * @experimental
     */
    readonly tablestoreEndpoint?: string;
    /**
     * @experimental
     */
    readonly tablestoreTable?: string;
    /**
     * @experimental
     */
    readonly encrypt?: boolean;
    /**
     * @experimental
     */
    readonly acl?: string;
    /**
     * @experimental
     */
    readonly sharedCredentialsFile?: string;
    /**
     * @experimental
     */
    readonly profile?: string;
    /**
     * @experimental
     */
    readonly assumeRole?: OssAssumeRole;
}
/**
 * @experimental
 */
export interface OssAssumeRole {
    /**
     * @experimental
     */
    readonly roleArn: string;
    /**
     * @experimental
     */
    readonly policy?: string;
    /**
     * @experimental
     */
    readonly sessionName?: string;
    /**
     * @experimental
     */
    readonly sessionExpiration?: number;
}
/**
 * @experimental
 */
export interface DataTerraformRemoteStateOssConfig extends DataTerraformRemoteStateConfig, OssBackendProps {
}
