import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
/**
 * @experimental
 */
export declare class RemoteBackend extends TerraformBackend {
    private readonly props;
    /**
     * @experimental
     */
    constructor(scope: Construct, props: RemoteBackendProps);
    /**
     * @experimental
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
/**
 * @experimental
 */
export declare class DataTerraformRemoteState extends TerraformRemoteState {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateRemoteConfig);
}
/**
 * @experimental
 */
export interface RemoteBackendProps {
    /**
     * @experimental
     */
    readonly hostname?: string;
    /**
     * @experimental
     */
    readonly organization: string;
    /**
     * @experimental
     */
    readonly token?: string;
    /**
     * @experimental
     */
    readonly workspaces: IRemoteWorkspace;
}
/**
 * @experimental
 */
export interface IRemoteWorkspace {
}
/**
 * @experimental
 */
export declare class NamedRemoteWorkspace implements IRemoteWorkspace {
    name: string;
    /**
     * @experimental
     */
    constructor(name: string);
}
/**
 * @experimental
 */
export declare class PrefixedRemoteWorkspaces implements IRemoteWorkspace {
    prefix: string;
    /**
     * @experimental
     */
    constructor(prefix: string);
}
/**
 * @experimental
 */
export interface DataTerraformRemoteStateRemoteConfig extends DataTerraformRemoteStateConfig, RemoteBackendProps {
}
